/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SortedLists;
import com.google.common.testing.NullPointerTester;
import java.util.List;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class SortedListsTest
extends TestCase {
    private static final ImmutableList<Integer> LIST_WITH_DUPS = ImmutableList.of((Object)1, (Object)1, (Object)2, (Object)4, (Object)4, (Object)4, (Object)8);
    private static final ImmutableList<Integer> LIST_WITHOUT_DUPS = ImmutableList.of((Object)1, (Object)2, (Object)4, (Object)8);

    void assertModelAgrees(List<Integer> list, Integer key, int answer, SortedLists.KeyPresentBehavior presentBehavior, SortedLists.KeyAbsentBehavior absentBehavior) {
        switch (presentBehavior) {
            case FIRST_PRESENT: {
                if (!list.contains(key)) break;
                SortedListsTest.assertEquals((int)list.indexOf(key), (int)answer);
                return;
            }
            case LAST_PRESENT: {
                if (!list.contains(key)) break;
                SortedListsTest.assertEquals((int)list.lastIndexOf(key), (int)answer);
                return;
            }
            case ANY_PRESENT: {
                if (!list.contains(key)) break;
                SortedListsTest.assertEquals((Object)key, (Object)list.get(answer));
                return;
            }
            case FIRST_AFTER: {
                if (!list.contains(key)) break;
                SortedListsTest.assertEquals((int)(list.lastIndexOf(key) + 1), (int)answer);
                return;
            }
            case LAST_BEFORE: {
                if (!list.contains(key)) break;
                SortedListsTest.assertEquals((int)(list.indexOf(key) - 1), (int)answer);
                return;
            }
            default: {
                throw new AssertionError();
            }
        }
        int nextHigherIndex = list.size();
        int i = list.size() - 1;
        while (i >= 0 && list.get(i) > key) {
            nextHigherIndex = i--;
        }
        switch (absentBehavior) {
            case NEXT_LOWER: {
                SortedListsTest.assertEquals((int)(nextHigherIndex - 1), (int)answer);
                return;
            }
            case NEXT_HIGHER: {
                SortedListsTest.assertEquals((int)nextHigherIndex, (int)answer);
                return;
            }
            case INVERTED_INSERTION_INDEX: {
                SortedListsTest.assertEquals((int)(-1 - nextHigherIndex), (int)answer);
                return;
            }
        }
        throw new AssertionError();
    }

    public void testWithoutDups() {
        for (SortedLists.KeyPresentBehavior presentBehavior : SortedLists.KeyPresentBehavior.values()) {
            for (SortedLists.KeyAbsentBehavior absentBehavior : SortedLists.KeyAbsentBehavior.values()) {
                for (int key = 0; key <= 10; ++key) {
                    this.assertModelAgrees((List<Integer>)LIST_WITHOUT_DUPS, key, SortedLists.binarySearch(LIST_WITHOUT_DUPS, (Comparable)Integer.valueOf(key), (SortedLists.KeyPresentBehavior)presentBehavior, (SortedLists.KeyAbsentBehavior)absentBehavior), presentBehavior, absentBehavior);
                }
            }
        }
    }

    public void testWithDups() {
        for (SortedLists.KeyPresentBehavior presentBehavior : SortedLists.KeyPresentBehavior.values()) {
            for (SortedLists.KeyAbsentBehavior absentBehavior : SortedLists.KeyAbsentBehavior.values()) {
                for (int key = 0; key <= 10; ++key) {
                    this.assertModelAgrees((List<Integer>)LIST_WITH_DUPS, key, SortedLists.binarySearch(LIST_WITH_DUPS, (Comparable)Integer.valueOf(key), (SortedLists.KeyPresentBehavior)presentBehavior, (SortedLists.KeyAbsentBehavior)absentBehavior), presentBehavior, absentBehavior);
                }
            }
        }
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(SortedLists.class);
    }
}

