/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractMultimapAsMapImplementsMapTest;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public class SubMapMultimapAsMapImplementsMapTest
extends AbstractMultimapAsMapImplementsMapTest {
    public SubMapMultimapAsMapImplementsMapTest() {
        super(true, true, true);
    }

    private TreeMultimap<String, Integer> createMultimap() {
        TreeMultimap multimap = TreeMultimap.create((Comparator)Ordering.natural().nullsFirst(), (Comparator)Ordering.natural().nullsFirst());
        multimap.put((Object)"a", (Object)-1);
        multimap.put((Object)"a", (Object)-3);
        multimap.put((Object)"z", (Object)-2);
        return multimap;
    }

    protected Map<String, Collection<Integer>> makeEmptyMap() {
        return this.createMultimap().asMap().subMap("e", "p");
    }

    protected Map<String, Collection<Integer>> makePopulatedMap() {
        TreeMultimap<String, Integer> multimap = this.createMultimap();
        multimap.put((Object)"f", (Object)1);
        multimap.put((Object)"f", (Object)2);
        multimap.put((Object)"g", (Object)3);
        multimap.put((Object)"h", (Object)4);
        return multimap.asMap().subMap("e", "p");
    }

    @Override
    protected String getKeyNotInPopulatedMap() {
        return "a";
    }

    @Override
    protected Collection<Integer> getValueNotInPopulatedMap() {
        return Collections.singleton(-2);
    }

    public void testEntrySetRemoveAllNullFromEmpty() {
        try {
            super.testEntrySetRemoveAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testEntrySetRetainAllNullFromEmpty() {
        try {
            super.testEntrySetRetainAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testKeySetRemoveAllNullFromEmpty() {
        try {
            super.testKeySetRemoveAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testKeySetRetainAllNullFromEmpty() {
        try {
            super.testKeySetRetainAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testValuesRemoveAllNullFromEmpty() {
        try {
            super.testValuesRemoveAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testValuesRetainAllNullFromEmpty() {
        try {
            super.testValuesRemoveAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

