/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Synchronized;
import com.google.common.collect.SynchronizedMapTest;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.BiMapInverseTester;
import com.google.common.collect.testing.google.BiMapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestBiMapGenerator;
import com.google.common.collect.testing.google.TestStringBiMapGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedBiMapTest
extends SynchronizedMapTest {
    public static TestSuite suite() {
        TestSuite suite = new TestSuite(SynchronizedBiMapTest.class);
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new SynchTestingBiMapGenerator()).named("Synchronized.biMap[TestBiMap]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, MapFeature.REJECTS_DUPLICATES_AT_CREATION})).createTestSuite());
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new SynchronizedHashBiMapGenerator()).named("synchronizedBiMap[HashBiMap]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, MapFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.SERIALIZABLE})).suppressing((Collection)BiMapInverseTester.getInverseSameAfterSerializingMethods())).createTestSuite());
        return suite;
    }

    protected <K, V> BiMap<K, V> create() {
        TestBiMap inner = new TestBiMap(HashBiMap.create(), this.mutex);
        BiMap outer = Synchronized.biMap(inner, (Object)this.mutex);
        return outer;
    }

    public void testForcePut() {
        this.create().forcePut(null, null);
    }

    public void testInverse() {
        BiMap bimap = this.create();
        BiMap inverse = bimap.inverse();
        SynchronizedBiMapTest.assertSame(bimap, (Object)inverse.inverse());
        SynchronizedBiMapTest.assertTrue((boolean)(inverse instanceof Synchronized.SynchronizedBiMap));
        SynchronizedBiMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedBiMap)inverse).mutex);
    }

    @Override
    public void testValues() {
        BiMap map = this.create();
        Set values = map.values();
        SynchronizedBiMapTest.assertTrue((boolean)(values instanceof Synchronized.SynchronizedSet));
        SynchronizedBiMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedSet)values).mutex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestBiMap<K, V>
    extends SynchronizedMapTest.TestMap<K, V>
    implements BiMap<K, V> {
        private final BiMap<K, V> delegate;
        private static final long serialVersionUID = 0L;

        public TestBiMap(BiMap<K, V> delegate, Object mutex) {
            super(delegate, mutex);
            this.delegate = delegate;
        }

        public V forcePut(K key, V value) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return (V)this.delegate.forcePut(key, value);
        }

        public BiMap<V, K> inverse() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.inverse();
        }

        @Override
        public Set<V> values() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SynchTestingBiMapGenerator
    extends TestStringBiMapGenerator {
        protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
            Object mutex = new Object();
            TestBiMap backing = new TestBiMap(HashBiMap.create(), mutex);
            BiMap result = Synchronized.biMap(backing, (Object)mutex);
            for (Map.Entry<String, String> entry : entries) {
                Preconditions.checkArgument((!result.containsKey((Object)entry.getKey()) ? 1 : 0) != 0);
                result.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SynchronizedHashBiMapGenerator
    extends TestStringBiMapGenerator {
        protected BiMap<String, String> create(Map.Entry<String, String>[] entries) {
            Object mutex = new Object();
            HashBiMap result = HashBiMap.create();
            for (Map.Entry<String, String> entry : entries) {
                Preconditions.checkArgument((!result.containsKey((Object)entry.getKey()) ? 1 : 0) != 0);
                result.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return Maps.synchronizedBiMap((BiMap)result);
        }
    }
}

