/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingSetMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Synchronized;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.MultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.SetMultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestSetMultimapGenerator;
import com.google.common.collect.testing.google.TestStringSetMultimapGenerator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import javax.annotation.Nullable;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.truth0.Truth;

public class SynchronizedMultimapTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(SynchronizedMultimapTest.class);
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new TestStringSetMultimapGenerator(){

            protected SetMultimap<String, String> create(Map.Entry<String, String>[] entries) {
                TestMultimap inner = new TestMultimap();
                SetMultimap outer = Synchronized.setMultimap(inner, (Object)inner.mutex);
                for (Map.Entry<String, String> entry : entries) {
                    outer.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return outer;
            }
        }).named("Synchronized.setMultimap")).withFeatures(new Feature[]{MapFeature.GENERAL_PURPOSE, CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    public void testSynchronizedListMultimap() {
        ListMultimap multimap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
        multimap.putAll((Object)"foo", Arrays.asList(3, -1, 2, 4, 1));
        multimap.putAll((Object)"bar", Arrays.asList(1, 2, 3, 1));
        Truth.ASSERT.that(multimap.removeAll((Object)"foo")).has().exactly((Object)3, (Object)-1, (Object[])new Integer[]{2, 4, 1}).inOrder();
        SynchronizedMultimapTest.assertFalse((boolean)multimap.containsKey((Object)"foo"));
        Truth.ASSERT.that(multimap.replaceValues((Object)"bar", Arrays.asList(6, 5))).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3, 1}).inOrder();
        Truth.ASSERT.that(multimap.get((Object)"bar")).has().exactly((Object)6, (Object)5, (Object[])new Integer[0]).inOrder();
    }

    public void testSynchronizedSortedSetMultimap() {
        SortedSetMultimap multimap = Multimaps.synchronizedSortedSetMultimap((SortedSetMultimap)TreeMultimap.create());
        multimap.putAll((Object)"foo", Arrays.asList(3, -1, 2, 4, 1));
        multimap.putAll((Object)"bar", Arrays.asList(1, 2, 3, 1));
        Truth.ASSERT.that((Collection)multimap.removeAll((Object)"foo")).has().exactly((Object)-1, (Object)1, (Object[])new Integer[]{2, 3, 4}).inOrder();
        SynchronizedMultimapTest.assertFalse((boolean)multimap.containsKey((Object)"foo"));
        Truth.ASSERT.that((Collection)multimap.replaceValues((Object)"bar", Arrays.asList(6, 5))).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
        Truth.ASSERT.that((Collection)multimap.get((Object)"bar")).has().exactly((Object)5, (Object)6, (Object[])new Integer[0]).inOrder();
    }

    public void testSynchronizedArrayListMultimapRandomAccess() {
        ArrayListMultimap delegate = ArrayListMultimap.create();
        delegate.put((Object)"foo", (Object)1);
        delegate.put((Object)"foo", (Object)3);
        ListMultimap multimap = Multimaps.synchronizedListMultimap((ListMultimap)delegate);
        SynchronizedMultimapTest.assertTrue((boolean)(multimap.get((Object)"foo") instanceof RandomAccess));
        SynchronizedMultimapTest.assertTrue((boolean)(multimap.get((Object)"bar") instanceof RandomAccess));
    }

    public void testSynchronizedLinkedListMultimapRandomAccess() {
        LinkedListMultimap delegate = LinkedListMultimap.create();
        delegate.put((Object)"foo", (Object)1);
        delegate.put((Object)"foo", (Object)3);
        ListMultimap multimap = Multimaps.synchronizedListMultimap((ListMultimap)delegate);
        SynchronizedMultimapTest.assertFalse((boolean)(multimap.get((Object)"foo") instanceof RandomAccess));
        SynchronizedMultimapTest.assertFalse((boolean)(multimap.get((Object)"bar") instanceof RandomAccess));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TestMultimap<K, V>
    extends ForwardingSetMultimap<K, V>
    implements Serializable {
        final SetMultimap<K, V> delegate = HashMultimap.create();
        public final Object mutex = new Integer(1);
        private static final long serialVersionUID = 0L;

        private TestMultimap() {
        }

        protected SetMultimap<K, V> delegate() {
            return this.delegate;
        }

        public String toString() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.toString();
        }

        public boolean equals(@Nullable Object o) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.equals(o);
        }

        public int hashCode() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.hashCode();
        }

        public int size() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.size();
        }

        public boolean isEmpty() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.isEmpty();
        }

        public boolean containsKey(@Nullable Object key) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.containsKey(key);
        }

        public boolean containsValue(@Nullable Object value) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.containsValue(value);
        }

        public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.containsEntry(key, value);
        }

        public Set<V> get(@Nullable K key) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.get(key);
        }

        public boolean put(K key, V value) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.put(key, value);
        }

        public boolean putAll(@Nullable K key, Iterable<? extends V> values) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.putAll(key, values);
        }

        public boolean putAll(Multimap<? extends K, ? extends V> map) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.putAll(map);
        }

        public Set<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.replaceValues(key, values);
        }

        public boolean remove(@Nullable Object key, @Nullable Object value) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.remove(key, value);
        }

        public Set<V> removeAll(@Nullable Object key) {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.removeAll(key);
        }

        public void clear() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            super.clear();
        }

        public Set<K> keySet() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.keySet();
        }

        public Multiset<K> keys() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.keys();
        }

        public Collection<V> values() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.values();
        }

        public Set<Map.Entry<K, V>> entries() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.entries();
        }

        public Map<K, Collection<V>> asMap() {
            Assert.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.asMap();
        }
    }
}

