/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.StringCatcher;
import java.util.List;
import java.util.concurrent.Executor;
import junit.framework.TestCase;

public class AsyncEventBusTest
extends TestCase {
    private static final String EVENT = "Hello";
    private FakeExecutor executor;
    private AsyncEventBus bus;

    protected void setUp() throws Exception {
        super.setUp();
        this.executor = new FakeExecutor();
        this.bus = new AsyncEventBus((Executor)this.executor);
    }

    public void testBasicDistribution() {
        StringCatcher catcher = new StringCatcher();
        this.bus.register((Object)catcher);
        this.bus.post((Object)EVENT);
        List<String> events = catcher.getEvents();
        AsyncEventBusTest.assertTrue((String)"No events should be delivered synchronously.", (boolean)events.isEmpty());
        List<Runnable> tasks = this.executor.getTasks();
        AsyncEventBusTest.assertEquals((String)"One event dispatch task should be queued.", (int)1, (int)tasks.size());
        tasks.get(0).run();
        AsyncEventBusTest.assertEquals((String)"One event should be delivered.", (int)1, (int)events.size());
        AsyncEventBusTest.assertEquals((String)"Correct string should be delivered.", (String)EVENT, (String)events.get(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FakeExecutor
    implements Executor {
        List<Runnable> tasks = Lists.newArrayList();

        @Override
        public void execute(Runnable task) {
            this.tasks.add(task);
        }

        public List<Runnable> getTasks() {
            return this.tasks;
        }
    }
}

