/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus.outside;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import junit.framework.TestCase;
import org.truth0.Truth;

public class AnnotatedSubscriberFinderTests {
    private static final Object EVENT = new Object();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeepInterfaceTest
    extends AbstractEventBusTest<SubscriberClass> {
        public void testAnnotatedIn1() {
            Truth.ASSERT.that(((SubscriberClass)this.getSubscriber()).annotatedIn1Events).has().item(EVENT);
        }

        public void testAnnotatedIn2() {
            Truth.ASSERT.that(((SubscriberClass)this.getSubscriber()).annotatedIn2Events).has().item(EVENT);
        }

        public void testAnnotatedIn1And2() {
            Truth.ASSERT.that(((SubscriberClass)this.getSubscriber()).annotatedIn1And2Events).has().item(EVENT);
        }

        public void testAnnotatedIn1And2AndClass() {
            Truth.ASSERT.that(((SubscriberClass)this.getSubscriber()).annotatedIn1And2AndClassEvents).has().item(EVENT);
        }

        public void testDeclaredIn1AnnotatedIn2() {
            Truth.ASSERT.that(((SubscriberClass)this.getSubscriber()).declaredIn1AnnotatedIn2Events).has().item(EVENT);
        }

        public void testDeclaredIn1AnnotatedInClass() {
            Truth.ASSERT.that(((SubscriberClass)this.getSubscriber()).declaredIn1AnnotatedInClassEvents).has().item(EVENT);
        }

        public void testDeclaredIn2AnnotatedInClass() {
            Truth.ASSERT.that(((SubscriberClass)this.getSubscriber()).declaredIn2AnnotatedInClassEvents).has().item(EVENT);
        }

        public void testNowhereAnnotated() {
            Truth.ASSERT.that(((SubscriberClass)this.getSubscriber()).nowhereAnnotatedEvents).isEmpty();
        }

        @Override
        SubscriberClass createSubscriber() {
            return new SubscriberClass();
        }

        static class SubscriberClass
        implements Interface2 {
            final List<Object> annotatedIn1Events = Lists.newArrayList();
            final List<Object> annotatedIn1And2Events = Lists.newArrayList();
            final List<Object> annotatedIn1And2AndClassEvents = Lists.newArrayList();
            final List<Object> declaredIn1AnnotatedIn2Events = Lists.newArrayList();
            final List<Object> declaredIn1AnnotatedInClassEvents = Lists.newArrayList();
            final List<Object> declaredIn2AnnotatedInClassEvents = Lists.newArrayList();
            final List<Object> annotatedIn2Events = Lists.newArrayList();
            final List<Object> nowhereAnnotatedEvents = Lists.newArrayList();

            SubscriberClass() {
            }

            public void annotatedIn1(Object o) {
                this.annotatedIn1Events.add(o);
            }

            @Subscribe
            public void declaredIn1AnnotatedInClass(Object o) {
                this.declaredIn1AnnotatedInClassEvents.add(o);
            }

            public void declaredIn1AnnotatedIn2(Object o) {
                this.declaredIn1AnnotatedIn2Events.add(o);
            }

            public void annotatedIn1And2(Object o) {
                this.annotatedIn1And2Events.add(o);
            }

            @Subscribe
            public void annotatedIn1And2AndClass(Object o) {
                this.annotatedIn1And2AndClassEvents.add(o);
            }

            @Subscribe
            public void declaredIn2AnnotatedInClass(Object o) {
                this.declaredIn2AnnotatedInClassEvents.add(o);
            }

            public void annotatedIn2(Object o) {
                this.annotatedIn2Events.add(o);
            }

            public void nowhereAnnotated(Object o) {
                this.nowhereAnnotatedEvents.add(o);
            }
        }

        static interface Interface2
        extends Interface1 {
            @Subscribe
            public void declaredIn1AnnotatedIn2(Object var1);

            @Subscribe
            public void annotatedIn1And2(Object var1);

            @Subscribe
            public void annotatedIn1And2AndClass(Object var1);

            public void declaredIn2AnnotatedInClass(Object var1);

            @Subscribe
            public void annotatedIn2(Object var1);
        }

        static interface Interface1 {
            @Subscribe
            public void annotatedIn1(Object var1);

            @Subscribe
            public void annotatedIn1And2(Object var1);

            @Subscribe
            public void annotatedIn1And2AndClass(Object var1);

            public void declaredIn1AnnotatedIn2(Object var1);

            public void declaredIn1AnnotatedInClass(Object var1);

            public void nowhereAnnotated(Object var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NeitherAbstractNorAnnotatedInSuperclassTest
    extends AbstractEventBusTest<SubClass> {
        public void testNeitherOverriddenNorAnnotated() {
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).neitherOverriddenNorAnnotatedEvents).isEmpty();
        }

        public void testOverriddenInSubclassNowhereAnnotated() {
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).overriddenInSubclassNowhereAnnotatedEvents).isEmpty();
        }

        public void testOverriddenAndAnnotatedInSubclass() {
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).overriddenAndAnnotatedInSubclassEvents).has().item(EVENT);
        }

        @Override
        SubClass createSubscriber() {
            return new SubClass();
        }

        static class SubClass
        extends SuperClass {
            SubClass() {
            }

            public void overriddenInSubclassNowhereAnnotated(Object o) {
                super.overriddenInSubclassNowhereAnnotated(o);
            }

            @Subscribe
            public void overriddenAndAnnotatedInSubclass(Object o) {
                super.overriddenAndAnnotatedInSubclass(o);
            }
        }

        static class SuperClass {
            final List<Object> neitherOverriddenNorAnnotatedEvents = Lists.newArrayList();
            final List<Object> overriddenInSubclassNowhereAnnotatedEvents = Lists.newArrayList();
            final List<Object> overriddenAndAnnotatedInSubclassEvents = Lists.newArrayList();

            SuperClass() {
            }

            public void neitherOverriddenNorAnnotated(Object o) {
                this.neitherOverriddenNorAnnotatedEvents.add(o);
            }

            public void overriddenInSubclassNowhereAnnotated(Object o) {
                this.overriddenInSubclassNowhereAnnotatedEvents.add(o);
            }

            public void overriddenAndAnnotatedInSubclass(Object o) {
                this.overriddenAndAnnotatedInSubclassEvents.add(o);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AbstractNotAnnotatedInSuperclassTest
    extends AbstractEventBusTest<SubClass> {
        public void testOverriddenAndAnnotatedInSubclass() {
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).overriddenAndAnnotatedInSubclassEvents).has().item(EVENT);
        }

        public void testOverriddenInSubclassNowhereAnnotated() {
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).overriddenInSubclassNowhereAnnotatedEvents).isEmpty();
        }

        @Override
        SubClass createSubscriber() {
            return new SubClass();
        }

        static class SubClass
        extends SuperClass {
            final List<Object> overriddenInSubclassNowhereAnnotatedEvents = Lists.newArrayList();
            final List<Object> overriddenAndAnnotatedInSubclassEvents = Lists.newArrayList();

            SubClass() {
            }

            public void overriddenInSubclassNowhereAnnotated(Object o) {
                this.overriddenInSubclassNowhereAnnotatedEvents.add(o);
            }

            @Subscribe
            public void overriddenAndAnnotatedInSubclass(Object o) {
                this.overriddenAndAnnotatedInSubclassEvents.add(o);
            }
        }

        static abstract class SuperClass {
            SuperClass() {
            }

            public abstract void overriddenInSubclassNowhereAnnotated(Object var1);

            public abstract void overriddenAndAnnotatedInSubclass(Object var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedNotAbstractInSuperclassTest
    extends AbstractEventBusTest<SubClass> {
        public void testNotOverriddenInSubclass() {
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).notOverriddenInSubclassEvents).has().item(EVENT);
        }

        public void testOverriddenNotAnnotatedInSubclass() {
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).overriddenNotAnnotatedInSubclassEvents).has().item(EVENT);
        }

        public void testDifferentlyOverriddenNotAnnotatedInSubclass() {
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).differentlyOverriddenNotAnnotatedInSubclassGoodEvents).has().item(EVENT);
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).differentlyOverriddenNotAnnotatedInSubclassBadEvents).isEmpty();
        }

        public void testOverriddenAndAnnotatedInSubclass() {
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).overriddenAndAnnotatedInSubclassEvents).has().item(EVENT);
        }

        public void testDifferentlyOverriddenAndAnnotatedInSubclass() {
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).differentlyOverriddenAnnotatedInSubclassGoodEvents).has().item(EVENT);
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).differentlyOverriddenAnnotatedInSubclassBadEvents).isEmpty();
        }

        @Override
        SubClass createSubscriber() {
            return new SubClass();
        }

        static class SubClass
        extends SuperClass {
            final List<Object> differentlyOverriddenNotAnnotatedInSubclassGoodEvents = Lists.newArrayList();
            final List<Object> differentlyOverriddenAnnotatedInSubclassGoodEvents = Lists.newArrayList();

            SubClass() {
            }

            public void overriddenNotAnnotatedInSubclass(Object o) {
                super.overriddenNotAnnotatedInSubclass(o);
            }

            @Subscribe
            public void overriddenAndAnnotatedInSubclass(Object o) {
                super.overriddenAndAnnotatedInSubclass(o);
            }

            public void differentlyOverriddenNotAnnotatedInSubclass(Object o) {
                this.differentlyOverriddenNotAnnotatedInSubclassGoodEvents.add(o);
            }

            @Subscribe
            public void differentlyOverriddenAnnotatedInSubclass(Object o) {
                this.differentlyOverriddenAnnotatedInSubclassGoodEvents.add(o);
            }
        }

        static class SuperClass {
            final List<Object> notOverriddenInSubclassEvents = Lists.newArrayList();
            final List<Object> overriddenNotAnnotatedInSubclassEvents = Lists.newArrayList();
            final List<Object> overriddenAndAnnotatedInSubclassEvents = Lists.newArrayList();
            final List<Object> differentlyOverriddenNotAnnotatedInSubclassBadEvents = Lists.newArrayList();
            final List<Object> differentlyOverriddenAnnotatedInSubclassBadEvents = Lists.newArrayList();

            SuperClass() {
            }

            @Subscribe
            public void notOverriddenInSubclass(Object o) {
                this.notOverriddenInSubclassEvents.add(o);
            }

            @Subscribe
            public void overriddenNotAnnotatedInSubclass(Object o) {
                this.overriddenNotAnnotatedInSubclassEvents.add(o);
            }

            @Subscribe
            public void overriddenAndAnnotatedInSubclass(Object o) {
                this.overriddenAndAnnotatedInSubclassEvents.add(o);
            }

            @Subscribe
            public void differentlyOverriddenNotAnnotatedInSubclass(Object o) {
                this.differentlyOverriddenNotAnnotatedInSubclassBadEvents.add(o);
            }

            @Subscribe
            public void differentlyOverriddenAnnotatedInSubclass(Object o) {
                this.differentlyOverriddenAnnotatedInSubclassBadEvents.add(o);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedAndAbstractInSuperclassTest
    extends AbstractEventBusTest<SubClass> {
        public void testOverriddenAndAnnotatedInSubclass() {
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).overriddenAndAnnotatedInSubclassEvents).has().item(EVENT);
        }

        public void testOverriddenNotAnnotatedInSubclass() {
            Truth.ASSERT.that(((SubClass)this.getSubscriber()).overriddenInSubclassEvents).has().item(EVENT);
        }

        @Override
        SubClass createSubscriber() {
            return new SubClass();
        }

        static class SubClass
        extends SuperClass {
            final List<Object> overriddenAndAnnotatedInSubclassEvents = Lists.newArrayList();
            final List<Object> overriddenInSubclassEvents = Lists.newArrayList();

            SubClass() {
            }

            @Subscribe
            public void overriddenAndAnnotatedInSubclass(Object o) {
                this.overriddenAndAnnotatedInSubclassEvents.add(o);
            }

            public void overriddenInSubclass(Object o) {
                this.overriddenInSubclassEvents.add(o);
            }
        }

        static abstract class SuperClass {
            SuperClass() {
            }

            @Subscribe
            public abstract void overriddenAndAnnotatedInSubclass(Object var1);

            @Subscribe
            public abstract void overriddenInSubclass(Object var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BaseSubscriberFinderTest
    extends AbstractEventBusTest<Subscriber> {
        public void testNonSubscriber() {
            Truth.ASSERT.that(((Subscriber)this.getSubscriber()).nonSubscriberEvents).isEmpty();
        }

        public void testSubscriber() {
            Truth.ASSERT.that(((Subscriber)this.getSubscriber()).subscriberEvents).has().item(EVENT);
        }

        @Override
        Subscriber createSubscriber() {
            return new Subscriber();
        }

        static class Subscriber {
            final List<Object> nonSubscriberEvents = Lists.newArrayList();
            final List<Object> subscriberEvents = Lists.newArrayList();

            Subscriber() {
            }

            public void notASubscriber(Object o) {
                this.nonSubscriberEvents.add(o);
            }

            @Subscribe
            public void subscriber(Object o) {
                this.subscriberEvents.add(o);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractEventBusTest<H>
    extends TestCase {
        private H subscriber;

        AbstractEventBusTest() {
        }

        abstract H createSubscriber();

        H getSubscriber() {
            return this.subscriber;
        }

        protected void setUp() throws Exception {
            this.subscriber = this.createSubscriber();
            EventBus bus = new EventBus();
            bus.register(this.subscriber);
            bus.post(EVENT);
        }

        protected void tearDown() throws Exception {
            this.subscriber = null;
        }
    }
}

