/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashTestUtils;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import junit.framework.TestCase;

public class Murmur3Hash128Test
extends TestCase {
    public void testKnownValues() {
        Murmur3Hash128Test.assertHash(0, 7104782906933966951L, -7864679668162800825L, "hell");
        Murmur3Hash128Test.assertHash(1, -6373191651385504496L, 1335599791535554869L, "hello");
        Murmur3Hash128Test.assertHash(2, -8482412095988373466L, -476639641252432289L, "hello ");
        Murmur3Hash128Test.assertHash(3, 3361267821767814540L, -4174668582916814313L, "hello w");
        Murmur3Hash128Test.assertHash(4, 8788264886911915820L, 5057642356371863886L, "hello wo");
        Murmur3Hash128Test.assertHash(5, -4458109390007701067L, -6784423384162269763L, "hello wor");
        Murmur3Hash128Test.assertHash(0, -2068352364225029268L, 8809951995912426311L, "The quick brown fox jumps over the lazy dog");
        Murmur3Hash128Test.assertHash(0, 7317409797358560922L, 4899604041581878334L, "The quick brown fox jumps over the lazy cog");
        HashCode foxHash = Hashing.murmur3_128((int)0).hashString((CharSequence)"The quick brown fox jumps over the lazy dog", Charsets.UTF_8);
        Murmur3Hash128Test.assertEquals((String)"6c1b07bc7bbc4be347939ac4a93c437a", (String)foxHash.toString());
    }

    private static void assertHash(int seed, long expected1, long expected2, String stringInput) {
        HashCode expected = Murmur3Hash128Test.toHashCode(expected1, expected2);
        byte[] input = HashTestUtils.ascii(stringInput);
        Murmur3Hash128Test.assertEquals((Object)expected, (Object)Hashing.murmur3_128((int)seed).hashBytes(input));
        Murmur3Hash128Test.assertEquals((Object)expected, (Object)Hashing.murmur3_128((int)seed).newHasher().putBytes(input).hash());
    }

    private static HashCode toHashCode(long ... longs) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[longs.length * 8]).order(ByteOrder.LITTLE_ENDIAN);
        for (long x : longs) {
            bb.putLong(x);
        }
        return HashCode.fromBytes((byte[])bb.array());
    }

    public void testParanoid() {
        HashTestUtils.HashFn hf = new HashTestUtils.HashFn(){

            public byte[] hash(byte[] input, int seed) {
                Hasher hasher = Hashing.murmur3_128((int)seed).newHasher();
                Funnels.byteArrayFunnel().funnel((Object)input, (PrimitiveSink)hasher);
                return hasher.hash().asBytes();
            }
        };
        HashTestUtils.verifyHashFunction(hf, 128, 1669642857);
    }

    public void testInvariants() {
        HashTestUtils.assertInvariants(Hashing.murmur3_128());
    }
}

