/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashTestUtils;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import junit.framework.TestCase;

public class Murmur3Hash32Test
extends TestCase {
    public void testKnownIntegerInputs() {
        Murmur3Hash32Test.assertHash(593689054, Hashing.murmur3_32().hashInt(0));
        Murmur3Hash32Test.assertHash(-189366624, Hashing.murmur3_32().hashInt(-42));
        Murmur3Hash32Test.assertHash(-1134849565, Hashing.murmur3_32().hashInt(42));
        Murmur3Hash32Test.assertHash(-1718298732, Hashing.murmur3_32().hashInt(Integer.MIN_VALUE));
        Murmur3Hash32Test.assertHash(-1653689534, Hashing.murmur3_32().hashInt(Integer.MAX_VALUE));
    }

    public void testKnownLongInputs() {
        Murmur3Hash32Test.assertHash(1669671676, Hashing.murmur3_32().hashLong(0L));
        Murmur3Hash32Test.assertHash(-846261623, Hashing.murmur3_32().hashLong(-42L));
        Murmur3Hash32Test.assertHash(1871679806, Hashing.murmur3_32().hashLong(42L));
        Murmur3Hash32Test.assertHash(1366273829, Hashing.murmur3_32().hashLong(Long.MIN_VALUE));
        Murmur3Hash32Test.assertHash(-2106506049, Hashing.murmur3_32().hashLong(Long.MAX_VALUE));
    }

    public void testKnownStringInputs() {
        Murmur3Hash32Test.assertHash(0, Hashing.murmur3_32().hashUnencodedChars((CharSequence)""));
        Murmur3Hash32Test.assertHash(679745764, Hashing.murmur3_32().hashUnencodedChars((CharSequence)"k"));
        Murmur3Hash32Test.assertHash(1510782915, Hashing.murmur3_32().hashUnencodedChars((CharSequence)"hell"));
        Murmur3Hash32Test.assertHash(-675079799, Hashing.murmur3_32().hashUnencodedChars((CharSequence)"hello"));
        Murmur3Hash32Test.assertHash(1935035788, Hashing.murmur3_32().hashUnencodedChars((CharSequence)"http://www.google.com/"));
        Murmur3Hash32Test.assertHash(-528633700, Hashing.murmur3_32().hashUnencodedChars((CharSequence)"The quick brown fox jumps over the lazy dog"));
    }

    private static void assertHash(int expected, HashCode actual) {
        Murmur3Hash32Test.assertEquals((Object)HashCode.fromInt((int)expected), (Object)actual);
    }

    public void testParanoid() {
        HashTestUtils.HashFn hf = new HashTestUtils.HashFn(){

            public byte[] hash(byte[] input, int seed) {
                Hasher hasher = Hashing.murmur3_32((int)seed).newHasher();
                Funnels.byteArrayFunnel().funnel((Object)input, (PrimitiveSink)hasher);
                return hasher.hash().asBytes();
            }
        };
        HashTestUtils.verifyHashFunction(hf, 32, -1326088477);
    }

    public void testInvariants() {
        HashTestUtils.assertInvariants(Hashing.murmur3_32());
    }
}

