/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.io.CountingInputStream;
import com.google.common.io.IoTestCase;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingInputStreamTest
extends IoTestCase {
    private CountingInputStream counter;

    protected void setUp() throws Exception {
        super.setUp();
        this.counter = new CountingInputStream((InputStream)new ByteArrayInputStream(new byte[20]));
    }

    public void testReadSingleByte() throws IOException {
        CountingInputStreamTest.assertEquals((long)0L, (long)this.counter.getCount());
        CountingInputStreamTest.assertEquals((int)0, (int)this.counter.read());
        CountingInputStreamTest.assertEquals((long)1L, (long)this.counter.getCount());
    }

    public void testReadArray() throws IOException {
        CountingInputStreamTest.assertEquals((int)10, (int)this.counter.read(new byte[10]));
        CountingInputStreamTest.assertEquals((long)10L, (long)this.counter.getCount());
    }

    public void testReadArrayRange() throws IOException {
        CountingInputStreamTest.assertEquals((int)3, (int)this.counter.read(new byte[10], 1, 3));
        CountingInputStreamTest.assertEquals((long)3L, (long)this.counter.getCount());
    }

    public void testSkip() throws IOException {
        CountingInputStreamTest.assertEquals((long)10L, (long)this.counter.skip(10L));
        CountingInputStreamTest.assertEquals((long)10L, (long)this.counter.getCount());
    }

    public void testSkipEOF() throws IOException {
        CountingInputStreamTest.assertEquals((long)20L, (long)this.counter.skip(30L));
        CountingInputStreamTest.assertEquals((long)20L, (long)this.counter.getCount());
        CountingInputStreamTest.assertEquals((long)0L, (long)this.counter.skip(20L));
        CountingInputStreamTest.assertEquals((long)20L, (long)this.counter.getCount());
        CountingInputStreamTest.assertEquals((int)-1, (int)this.counter.read());
        CountingInputStreamTest.assertEquals((long)20L, (long)this.counter.getCount());
    }

    public void testReadArrayEOF() throws IOException {
        CountingInputStreamTest.assertEquals((int)20, (int)this.counter.read(new byte[30]));
        CountingInputStreamTest.assertEquals((long)20L, (long)this.counter.getCount());
        CountingInputStreamTest.assertEquals((int)-1, (int)this.counter.read(new byte[30]));
        CountingInputStreamTest.assertEquals((long)20L, (long)this.counter.getCount());
    }

    public void testMark() throws Exception {
        CountingInputStreamTest.assertTrue((boolean)this.counter.markSupported());
        CountingInputStreamTest.assertEquals((int)10, (int)this.counter.read(new byte[10]));
        CountingInputStreamTest.assertEquals((long)10L, (long)this.counter.getCount());
        this.counter.mark(5);
        this.counter.read();
        CountingInputStreamTest.assertEquals((long)11L, (long)this.counter.getCount());
        this.counter.reset();
        CountingInputStreamTest.assertEquals((long)10L, (long)this.counter.getCount());
        CountingInputStreamTest.assertEquals((long)10L, (long)this.counter.skip(100L));
        CountingInputStreamTest.assertEquals((long)20L, (long)this.counter.getCount());
    }

    public void testMarkNotSet() {
        try {
            this.counter.reset();
            CountingInputStreamTest.fail();
        }
        catch (IOException expected) {
            CountingInputStreamTest.assertEquals((String)"Mark not set", (String)expected.getMessage());
        }
    }

    public void testMarkNotSupported() {
        this.counter = new CountingInputStream((InputStream)new UnmarkableInputStream());
        try {
            this.counter.reset();
            CountingInputStreamTest.fail();
        }
        catch (IOException expected) {
            CountingInputStreamTest.assertEquals((String)"Mark not supported", (String)expected.getMessage());
        }
    }

    private static class UnmarkableInputStream
    extends InputStream {
        private UnmarkableInputStream() {
        }

        public int read() throws IOException {
            return 0;
        }

        public boolean markSupported() {
            return false;
        }
    }
}

