/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.io.CountingOutputStream;
import com.google.common.io.IoTestCase;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class CountingOutputStreamTest
extends IoTestCase {
    public void testCount() throws Exception {
        int written = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CountingOutputStream counter = new CountingOutputStream((OutputStream)out);
        CountingOutputStreamTest.assertEquals((int)written, (int)out.size());
        CountingOutputStreamTest.assertEquals((long)written, (long)counter.getCount());
        counter.write(0);
        CountingOutputStreamTest.assertEquals((int)(++written), (int)out.size());
        CountingOutputStreamTest.assertEquals((long)written, (long)counter.getCount());
        byte[] data = new byte[10];
        counter.write(data);
        CountingOutputStreamTest.assertEquals((int)(written += 10), (int)out.size());
        CountingOutputStreamTest.assertEquals((long)written, (long)counter.getCount());
        counter.write(data, 0, 5);
        CountingOutputStreamTest.assertEquals((int)(written += 5), (int)out.size());
        CountingOutputStreamTest.assertEquals((long)written, (long)counter.getCount());
        counter.write(data, 2, 5);
        CountingOutputStreamTest.assertEquals((int)(written += 5), (int)out.size());
        CountingOutputStreamTest.assertEquals((long)written, (long)counter.getCount());
        try {
            counter.write(data, 0, data.length + 1);
            CountingOutputStreamTest.fail((String)"expected exception");
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        CountingOutputStreamTest.assertEquals((int)written, (int)out.size());
        CountingOutputStreamTest.assertEquals((long)written, (long)counter.getCount());
    }
}

