/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import com.google.common.io.IoTestCase;
import com.google.common.testing.GcFinalization;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class FileBackedOutputStreamTest
extends IoTestCase {
    public void testThreshold() throws Exception {
        this.testThreshold(0, 100, true, false);
        this.testThreshold(10, 100, true, false);
        this.testThreshold(100, 100, true, false);
        this.testThreshold(1000, 100, true, false);
        this.testThreshold(0, 100, false, false);
        this.testThreshold(10, 100, false, false);
        this.testThreshold(100, 100, false, false);
        this.testThreshold(1000, 100, false, false);
    }

    public void testFinalizeDeletesFile() throws Exception {
        byte[] data = FileBackedOutputStreamTest.newPreFilledByteArray(100);
        FileBackedOutputStream out = new FileBackedOutputStream(0, true);
        FileBackedOutputStreamTest.write((OutputStream)out, data, 0, 100, true);
        final File file = out.getFile();
        FileBackedOutputStreamTest.assertEquals((long)100L, (long)file.length());
        FileBackedOutputStreamTest.assertTrue((boolean)file.exists());
        out.close();
        out = null;
        GcFinalization.awaitDone((GcFinalization.FinalizationPredicate)new GcFinalization.FinalizationPredicate(){

            public boolean isDone() {
                return !file.exists();
            }
        });
    }

    public void testThreshold_resetOnFinalize() throws Exception {
        this.testThreshold(0, 100, true, true);
        this.testThreshold(10, 100, true, true);
        this.testThreshold(100, 100, true, true);
        this.testThreshold(1000, 100, true, true);
        this.testThreshold(0, 100, false, true);
        this.testThreshold(10, 100, false, true);
        this.testThreshold(100, 100, false, true);
        this.testThreshold(1000, 100, false, true);
    }

    private void testThreshold(int fileThreshold, int dataSize, boolean singleByte, boolean resetOnFinalize) throws IOException {
        byte[] data = FileBackedOutputStreamTest.newPreFilledByteArray(dataSize);
        FileBackedOutputStream out = new FileBackedOutputStream(fileThreshold, resetOnFinalize);
        ByteSource source = out.asByteSource();
        int chunk1 = Math.min(dataSize, fileThreshold);
        int chunk2 = dataSize - chunk1;
        if (chunk1 > 0) {
            FileBackedOutputStreamTest.write((OutputStream)out, data, 0, chunk1, singleByte);
            FileBackedOutputStreamTest.assertTrue((boolean)ByteSource.wrap((byte[])data).slice(0L, (long)chunk1).contentEquals(source));
        }
        File file = out.getFile();
        FileBackedOutputStreamTest.assertNull((Object)file);
        if (chunk2 > 0) {
            FileBackedOutputStreamTest.write((OutputStream)out, data, chunk1, chunk2, singleByte);
            file = out.getFile();
            FileBackedOutputStreamTest.assertEquals((long)dataSize, (long)file.length());
            FileBackedOutputStreamTest.assertTrue((boolean)file.exists());
        }
        out.close();
        FileBackedOutputStreamTest.assertTrue((boolean)Arrays.equals(data, source.read()));
        out.reset();
        if (file != null) {
            FileBackedOutputStreamTest.assertFalse((boolean)file.exists());
        }
    }

    private static void write(OutputStream out, byte[] b, int off, int len, boolean singleByte) throws IOException {
        if (singleByte) {
            for (int i = off; i < off + len; ++i) {
                out.write(b[i]);
            }
        } else {
            out.write(b, off, len);
        }
        out.flush();
    }

    public void testWriteErrorAfterClose() throws Exception {
        byte[] data = FileBackedOutputStreamTest.newPreFilledByteArray(100);
        FileBackedOutputStream out = new FileBackedOutputStream(50);
        ByteSource source = out.asByteSource();
        out.write(data);
        FileBackedOutputStreamTest.assertTrue((boolean)Arrays.equals(data, source.read()));
        out.close();
        try {
            out.write(42);
            FileBackedOutputStreamTest.fail((String)"expected exception");
        }
        catch (IOException expected) {
            // empty catch block
        }
        FileBackedOutputStreamTest.assertTrue((boolean)Arrays.equals(data, source.read()));
        out.reset();
    }

    public void testReset() throws Exception {
        byte[] data = FileBackedOutputStreamTest.newPreFilledByteArray(100);
        FileBackedOutputStream out = new FileBackedOutputStream(Integer.MAX_VALUE);
        ByteSource source = out.asByteSource();
        out.write(data);
        FileBackedOutputStreamTest.assertTrue((boolean)Arrays.equals(data, source.read()));
        out.reset();
        FileBackedOutputStreamTest.assertTrue((boolean)Arrays.equals(new byte[0], source.read()));
        out.write(data);
        FileBackedOutputStreamTest.assertTrue((boolean)Arrays.equals(data, source.read()));
        out.close();
    }
}

