/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.common.io.SourceSinkFactory;
import com.google.common.jdk5backport.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class SourceSinkFactories {
    private SourceSinkFactories() {
    }

    public static SourceSinkFactory.CharSourceFactory stringCharSourceFactory() {
        return new StringSourceFactory();
    }

    public static SourceSinkFactory.ByteSourceFactory byteArraySourceFactory() {
        return new ByteArraySourceFactory();
    }

    public static SourceSinkFactory.ByteSourceFactory emptyByteSourceFactory() {
        return new EmptyByteSourceFactory();
    }

    public static SourceSinkFactory.CharSourceFactory emptyCharSourceFactory() {
        return new EmptyCharSourceFactory();
    }

    public static SourceSinkFactory.ByteSourceFactory fileByteSourceFactory() {
        return new FileByteSourceFactory();
    }

    public static SourceSinkFactory.ByteSinkFactory fileByteSinkFactory() {
        return new FileByteSinkFactory(null);
    }

    public static SourceSinkFactory.ByteSinkFactory appendingFileByteSinkFactory() {
        String initialString = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1";
        try {
            return new FileByteSinkFactory(initialString.getBytes(Charsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SourceSinkFactory.CharSourceFactory fileCharSourceFactory() {
        return new FileCharSourceFactory();
    }

    public static SourceSinkFactory.CharSinkFactory fileCharSinkFactory() {
        return new FileCharSinkFactory(null);
    }

    public static SourceSinkFactory.CharSinkFactory appendingFileCharSinkFactory() {
        String initialString = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u00ce\u00f1\u0163\u00e9r\u00f1\u00e5\u0163\u00ee\u00f6\u00f1\u00e5\u013c\u00ee\u017e\u00e5\u0163\u00ee\u00f6\u00f1";
        return new FileCharSinkFactory(initialString);
    }

    public static SourceSinkFactory.ByteSourceFactory urlByteSourceFactory() {
        return new UrlByteSourceFactory();
    }

    public static SourceSinkFactory.CharSourceFactory urlCharSourceFactory() {
        return new UrlCharSourceFactory();
    }

    public static SourceSinkFactory.CharSourceFactory asCharSourceFactory(final SourceSinkFactory.ByteSourceFactory factory) {
        Preconditions.checkNotNull((Object)factory);
        return new SourceSinkFactory.CharSourceFactory(){

            public CharSource createSource(String string) throws IOException {
                return ((ByteSource)factory.createSource(string.getBytes(Charsets.UTF_8.name()))).asCharSource(Charsets.UTF_8);
            }

            public String getExpected(String data) {
                try {
                    return new String(factory.getExpected(data.getBytes(Charsets.UTF_8.name())), Charsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError();
                }
            }

            public void tearDown() throws IOException {
                factory.tearDown();
            }
        };
    }

    public static SourceSinkFactory.CharSinkFactory asCharSinkFactory(final SourceSinkFactory.ByteSinkFactory factory) {
        Preconditions.checkNotNull((Object)factory);
        return new SourceSinkFactory.CharSinkFactory(){

            public CharSink createSink() throws IOException {
                return ((ByteSink)factory.createSink()).asCharSink(Charsets.UTF_8);
            }

            public String getSinkContents() throws IOException {
                return new String((byte[])factory.getSinkContents(), Charsets.UTF_8.name());
            }

            public String getExpected(String data) {
                byte[] factoryExpectedForNothing = factory.getExpected(new byte[0]);
                try {
                    return new String(factoryExpectedForNothing, Charsets.UTF_8.name()) + (String)Preconditions.checkNotNull((Object)data);
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError();
                }
            }

            public void tearDown() throws IOException {
                factory.tearDown();
            }
        };
    }

    public static SourceSinkFactory.ByteSourceFactory asSlicedByteSourceFactory(final SourceSinkFactory.ByteSourceFactory factory, final int off, final int len) {
        Preconditions.checkNotNull((Object)factory);
        return new SourceSinkFactory.ByteSourceFactory(){

            public ByteSource createSource(byte[] bytes) throws IOException {
                return ((ByteSource)factory.createSource(bytes)).slice((long)off, (long)len);
            }

            public byte[] getExpected(byte[] bytes) {
                byte[] baseExpected = factory.getExpected(bytes);
                return Arrays.copyOfRange(baseExpected, off, Math.min(baseExpected.length, off + len));
            }

            public void tearDown() throws IOException {
                factory.tearDown();
            }
        };
    }

    private static class UrlCharSourceFactory
    extends FileCharSourceFactory {
        private UrlCharSourceFactory() {
        }

        public CharSource createSource(String string) throws IOException {
            super.createSource(string);
            return Resources.asCharSource((URL)this.getFile().toURI().toURL(), (Charset)Charsets.UTF_8);
        }
    }

    private static class UrlByteSourceFactory
    extends FileByteSourceFactory {
        private UrlByteSourceFactory() {
        }

        public ByteSource createSource(byte[] bytes) throws IOException {
            super.createSource(bytes);
            return Resources.asByteSource((URL)this.getFile().toURI().toURL());
        }
    }

    private static class FileCharSinkFactory
    extends FileFactory
    implements SourceSinkFactory.CharSinkFactory {
        private final String initialString;

        private FileCharSinkFactory(@Nullable String initialString) {
            this.initialString = initialString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharSink createSink() throws IOException {
            File file = this.createFile();
            if (this.initialString != null) {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);
                try {
                    writer.write(this.initialString);
                }
                finally {
                    ((Writer)writer).close();
                }
                return Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
            }
            return Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);
        }

        public String getExpected(String string) {
            Preconditions.checkNotNull((Object)string);
            return this.initialString == null ? string : this.initialString + string;
        }

        public String getSinkContents() throws IOException {
            File file = this.getFile();
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8);
            StringBuilder builder = new StringBuilder();
            CharBuffer buffer = CharBuffer.allocate(100);
            while (((Reader)reader).read(buffer) != -1) {
                buffer.flip();
                builder.append(buffer);
                buffer.clear();
            }
            return builder.toString();
        }
    }

    private static class FileCharSourceFactory
    extends FileFactory
    implements SourceSinkFactory.CharSourceFactory {
        private FileCharSourceFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CharSource createSource(String string) throws IOException {
            Preconditions.checkNotNull((Object)string);
            File file = this.createFile();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);
            try {
                writer.write(string);
            }
            finally {
                ((Writer)writer).close();
            }
            return Files.asCharSource((File)file, (Charset)Charsets.UTF_8);
        }

        public String getExpected(String string) {
            return (String)Preconditions.checkNotNull((Object)string);
        }
    }

    private static class FileByteSinkFactory
    extends FileFactory
    implements SourceSinkFactory.ByteSinkFactory {
        private final byte[] initialBytes;

        private FileByteSinkFactory(@Nullable byte[] initialBytes) {
            this.initialBytes = initialBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteSink createSink() throws IOException {
            File file = this.createFile();
            if (this.initialBytes != null) {
                FileOutputStream out = new FileOutputStream(file);
                try {
                    out.write(this.initialBytes);
                }
                finally {
                    out.close();
                }
                return Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
            }
            return Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]);
        }

        public byte[] getExpected(byte[] bytes) {
            if (this.initialBytes == null) {
                return (byte[])Preconditions.checkNotNull((Object)bytes);
            }
            byte[] result = new byte[this.initialBytes.length + bytes.length];
            System.arraycopy(this.initialBytes, 0, result, 0, this.initialBytes.length);
            System.arraycopy(bytes, 0, result, this.initialBytes.length, bytes.length);
            return result;
        }

        public byte[] getSinkContents() throws IOException {
            int read;
            File file = this.getFile();
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[100];
            while ((read = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
            return out.toByteArray();
        }
    }

    private static class FileByteSourceFactory
    extends FileFactory
    implements SourceSinkFactory.ByteSourceFactory {
        private FileByteSourceFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteSource createSource(byte[] bytes) throws IOException {
            Preconditions.checkNotNull((Object)bytes);
            File file = this.createFile();
            FileOutputStream out = new FileOutputStream(file);
            try {
                ((OutputStream)out).write(bytes);
            }
            finally {
                ((OutputStream)out).close();
            }
            return Files.asByteSource((File)file);
        }

        public byte[] getExpected(byte[] bytes) {
            return (byte[])Preconditions.checkNotNull((Object)bytes);
        }
    }

    private static abstract class FileFactory {
        private static final Logger logger = Logger.getLogger(FileFactory.class.getName());
        private final ThreadLocal<File> fileThreadLocal = new ThreadLocal();

        private FileFactory() {
        }

        protected File createFile() throws IOException {
            File file = File.createTempFile("SinkSourceFile", "txt");
            this.fileThreadLocal.set(file);
            return file;
        }

        protected File getFile() {
            return this.fileThreadLocal.get();
        }

        public final void tearDown() throws IOException {
            if (!this.fileThreadLocal.get().delete()) {
                logger.warning("Unable to delete file: " + this.fileThreadLocal.get());
            }
            this.fileThreadLocal.remove();
        }
    }

    private static class EmptyByteSourceFactory
    implements SourceSinkFactory.ByteSourceFactory {
        private EmptyByteSourceFactory() {
        }

        public ByteSource createSource(byte[] bytes) throws IOException {
            return ByteSource.empty();
        }

        public byte[] getExpected(byte[] bytes) {
            return new byte[0];
        }

        public void tearDown() throws IOException {
        }
    }

    private static class EmptyCharSourceFactory
    implements SourceSinkFactory.CharSourceFactory {
        private EmptyCharSourceFactory() {
        }

        public CharSource createSource(String data) throws IOException {
            return CharSource.empty();
        }

        public String getExpected(String data) {
            return "";
        }

        public void tearDown() throws IOException {
        }
    }

    private static class ByteArraySourceFactory
    implements SourceSinkFactory.ByteSourceFactory {
        private ByteArraySourceFactory() {
        }

        public ByteSource createSource(byte[] bytes) throws IOException {
            return ByteSource.wrap((byte[])bytes);
        }

        public byte[] getExpected(byte[] bytes) {
            return bytes;
        }

        public void tearDown() throws IOException {
        }
    }

    private static class StringSourceFactory
    implements SourceSinkFactory.CharSourceFactory {
        private StringSourceFactory() {
        }

        public CharSource createSource(String data) throws IOException {
            return CharSource.wrap((CharSequence)data);
        }

        public String getExpected(String data) {
            return data;
        }

        public void tearDown() throws IOException {
        }
    }
}

