/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSink;
import com.google.common.io.TestOption;
import com.google.common.io.TestOutputStream;
import com.google.common.io.TestStreamSupplier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TestByteSink
extends ByteSink
implements TestStreamSupplier {
    private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    private final ImmutableSet<TestOption> options;
    private boolean outputStreamOpened;
    private boolean outputStreamClosed;

    public TestByteSink(TestOption ... options) {
        this.options = ImmutableSet.copyOf((Object[])options);
    }

    byte[] getBytes() {
        return this.bytes.toByteArray();
    }

    public boolean wasStreamOpened() {
        return this.outputStreamOpened;
    }

    public boolean wasStreamClosed() {
        return this.outputStreamClosed;
    }

    public OutputStream openStream() throws IOException {
        this.outputStreamOpened = true;
        this.bytes.reset();
        return new Out();
    }

    private final class Out
    extends TestOutputStream {
        public Out() throws IOException {
            super((OutputStream)TestByteSink.this.bytes, (Iterable<TestOption>)TestByteSink.this.options);
        }

        public void close() throws IOException {
            TestByteSink.this.outputStreamClosed = true;
            super.close();
        }
    }
}

