/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.io.RandomAmountInputStream;
import com.google.common.io.TestInputStream;
import com.google.common.io.TestOption;
import com.google.common.io.TestStreamSupplier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public final class TestByteSource
extends ByteSource
implements TestStreamSupplier {
    private final byte[] bytes;
    private final ImmutableSet<TestOption> options;
    private boolean inputStreamOpened;
    private boolean inputStreamClosed;

    TestByteSource(byte[] bytes, TestOption ... options) {
        this.bytes = (byte[])Preconditions.checkNotNull((Object)bytes);
        this.options = ImmutableSet.copyOf((Object[])options);
    }

    public boolean wasStreamOpened() {
        return this.inputStreamOpened;
    }

    public boolean wasStreamClosed() {
        return this.inputStreamClosed;
    }

    public InputStream openStream() throws IOException {
        this.inputStreamOpened = true;
        return new RandomAmountInputStream(new In(), new Random());
    }

    private final class In
    extends TestInputStream {
        public In() throws IOException {
            super((InputStream)new ByteArrayInputStream(TestByteSource.this.bytes), (Iterable<TestOption>)TestByteSource.this.options);
        }

        public void close() throws IOException {
            TestByteSource.this.inputStreamClosed = true;
            super.close();
        }
    }
}

