/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.TestByteSource;
import com.google.common.io.TestOption;
import com.google.common.io.TestStreamSupplier;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class TestCharSource
extends CharSource
implements TestStreamSupplier {
    private final TestByteSource byteSource;

    public TestCharSource(String content, TestOption ... options) {
        try {
            this.byteSource = new TestByteSource(content.getBytes(Charsets.UTF_8.name()), options);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean wasStreamOpened() {
        return this.byteSource.wasStreamOpened();
    }

    public boolean wasStreamClosed() {
        return this.byteSource.wasStreamClosed();
    }

    public Reader openStream() throws IOException {
        return new InputStreamReader(this.byteSource.openStream(), Charsets.UTF_8);
    }
}

