/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.TestOption;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestOutputStream
extends FilterOutputStream {
    private final ImmutableSet<TestOption> options;
    private boolean closed;

    public TestOutputStream(OutputStream out, TestOption ... options) throws IOException {
        this(out, Arrays.asList(options));
    }

    public TestOutputStream(OutputStream out, Iterable<TestOption> options) throws IOException {
        super((OutputStream)Preconditions.checkNotNull((Object)out));
        this.options = ImmutableSet.copyOf(options);
        this.throwIf(TestOption.OPEN_THROWS);
    }

    public boolean closed() {
        return this.closed;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        TestOutputStream.throwIf(this.closed);
        this.throwIf(TestOption.WRITE_THROWS);
        super.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        TestOutputStream.throwIf(this.closed);
        this.throwIf(TestOption.WRITE_THROWS);
        super.write(b);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        super.close();
        this.throwIf(TestOption.CLOSE_THROWS);
    }

    private void throwIf(TestOption option) throws IOException {
        TestOutputStream.throwIf(this.options.contains((Object)option));
    }

    private static void throwIf(boolean condition) throws IOException {
        if (condition) {
            throw new IOException();
        }
    }
}

