/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.TestOption;
import com.google.common.io.TestOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class TestWriter
extends FilterWriter {
    private final TestOutputStream out;

    public TestWriter(TestOption ... options) throws IOException {
        this(new TestOutputStream(ByteStreams.nullOutputStream(), options));
    }

    public TestWriter(TestOutputStream out) {
        super(new OutputStreamWriter((OutputStream)Preconditions.checkNotNull((Object)out), Charsets.UTF_8));
        this.out = out;
    }

    public void write(int c) throws IOException {
        super.write(c);
        this.flush();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        super.write(cbuf, off, len);
        this.flush();
    }

    public void write(String str, int off, int len) throws IOException {
        super.write(str, off, len);
        this.flush();
    }

    public boolean closed() {
        return this.out.closed();
    }
}

