/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import java.math.BigInteger;
import java.util.Random;

final class MathBenchmarking {
    static final int ARRAY_SIZE = 65536;
    static final int ARRAY_MASK = 65535;
    static final Random RANDOM_SOURCE = new Random(314159265358979L);
    static final int MAX_EXPONENT = 100;
    static final int[] biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 3810779, 121977, 16175, 4337, 1733, 887, 534, 361, 265, 206, 169, 143, 125, 111, 101, 94, 88, 83, 79, 76, 74, 72, 70, 69, 68, 67, 67, 66, 66, 66, 66};

    MathBenchmarking() {
    }

    static BigInteger randomPositiveBigInteger(int numBits) {
        int digits = RANDOM_SOURCE.nextInt(numBits) + 1;
        return new BigInteger(digits, RANDOM_SOURCE).add(BigInteger.ONE);
    }

    static BigInteger randomNonNegativeBigInteger(int numBits) {
        int digits = RANDOM_SOURCE.nextInt(numBits) + 1;
        return new BigInteger(digits, RANDOM_SOURCE);
    }

    static BigInteger randomNonZeroBigInteger(int numBits) {
        BigInteger result = MathBenchmarking.randomPositiveBigInteger(numBits);
        return RANDOM_SOURCE.nextBoolean() ? result : result.negate();
    }

    static BigInteger randomBigInteger(int numBits) {
        BigInteger result = MathBenchmarking.randomNonNegativeBigInteger(numBits);
        return RANDOM_SOURCE.nextBoolean() ? result : result.negate();
    }

    static double randomDouble(int maxExponent) {
        return RANDOM_SOURCE.nextDouble();
    }

    static int randomExponent() {
        return RANDOM_SOURCE.nextInt(101);
    }

    static double randomPositiveDouble() {
        return Math.exp(MathBenchmarking.randomDouble(6));
    }
}

