/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.primitives.Doubles;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class DoubleArrayAsListTest
extends TestCase {
    private static List<Double> asList(Double[] values) {
        double[] temp = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            temp[i] = (Double)Preconditions.checkNotNull((Object)values[i]);
        }
        return Doubles.asList((double[])temp);
    }

    @GwtIncompatible(value="suite")
    public static Test suite() {
        ImmutableList builders = ImmutableList.of((Object)ListTestSuiteBuilder.using((TestListGenerator)new DoublesAsListGenerator()).named("Doubles.asList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new DoublsAsListHeadSubListGenerator()).named("Doubles.asList, head subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new DoublesAsListTailSubListGenerator()).named("Doubles.asList, tail subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new DoublesAsListMiddleSubListGenerator()).named("Doubles.asList, middle subList"));
        TestSuite suite = new TestSuite();
        for (ListTestSuiteBuilder builder : builders) {
            suite.addTest((Test)((ListTestSuiteBuilder)builder.withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.RESTRICTS_ELEMENTS, ListFeature.SUPPORTS_SET})).createTestSuite());
        }
        return suite;
    }

    private static Double[] concat(Double[] left, Double[] right) {
        Double[] result = new Double[left.length + right.length];
        System.arraycopy(left, 0, result, 0, left.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SampleDoubles
    extends SampleElements<Double> {
        public SampleDoubles() {
            super((Object)0.0, (Object)1.0, (Object)2.0, (Object)3.0, (Object)4.0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TestDoubleListGenerator
    implements TestListGenerator<Double> {
        public SampleElements<Double> samples() {
            return new SampleDoubles();
        }

        public List<Double> create(Object ... elements) {
            Double[] array = new Double[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Double)e;
            }
            return this.create(array);
        }

        protected abstract List<Double> create(Double[] var1);

        public Double[] createArray(int length) {
            return new Double[length];
        }

        public List<Double> order(List<Double> insertionOrder) {
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoublesAsListMiddleSubListGenerator
    extends TestDoubleListGenerator {
        @Override
        protected List<Double> create(Double[] elements) {
            Double[] prefix = new Double[]{Double.MIN_VALUE, Double.MAX_VALUE};
            Double[] suffix = new Double[]{86.0, 99.0};
            Double[] all = DoubleArrayAsListTest.concat(DoubleArrayAsListTest.concat(prefix, elements), suffix);
            return DoubleArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoublesAsListTailSubListGenerator
    extends TestDoubleListGenerator {
        @Override
        protected List<Double> create(Double[] elements) {
            Double[] prefix = new Double[]{86.0, 99.0};
            Double[] all = DoubleArrayAsListTest.concat(prefix, elements);
            return DoubleArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoublsAsListHeadSubListGenerator
    extends TestDoubleListGenerator {
        @Override
        protected List<Double> create(Double[] elements) {
            Double[] suffix = new Double[]{Double.MIN_VALUE, Double.MAX_VALUE};
            Double[] all = DoubleArrayAsListTest.concat(elements, suffix);
            return DoubleArrayAsListTest.asList(all).subList(0, elements.length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoublesAsListGenerator
    extends TestDoubleListGenerator {
        @Override
        protected List<Double> create(Double[] elements) {
            return DoubleArrayAsListTest.asList(elements);
        }
    }
}

