/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.primitives.Longs;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public class LongArrayAsListTest
extends TestCase {
    private static List<Long> asList(Long[] values) {
        long[] temp = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            temp[i] = (Long)Preconditions.checkNotNull((Object)values[i]);
        }
        return Longs.asList((long[])temp);
    }

    @GwtIncompatible(value="suite")
    public static Test suite() {
        ImmutableList builders = ImmutableList.of((Object)ListTestSuiteBuilder.using((TestListGenerator)new LongsAsListGenerator()).named("Longs.asList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new LongsAsListHeadSubListGenerator()).named("Longs.asList, head subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new LongsAsListTailSubListGenerator()).named("Longs.asList, tail subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new LongsAsListMiddleSubListGenerator()).named("Longs.asList, middle subList"));
        TestSuite suite = new TestSuite();
        for (ListTestSuiteBuilder builder : builders) {
            suite.addTest((Test)((ListTestSuiteBuilder)builder.withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.RESTRICTS_ELEMENTS, ListFeature.SUPPORTS_SET})).createTestSuite());
        }
        return suite;
    }

    private static Long[] concat(Long[] left, Long[] right) {
        Long[] result = new Long[left.length + right.length];
        System.arraycopy(left, 0, result, 0, left.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SampleLongs
    extends SampleElements<Long> {
        public SampleLongs() {
            super((Object)0L, (Object)1L, (Object)2L, (Object)3L, (Object)4L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TestLongListGenerator
    implements TestListGenerator<Long> {
        public SampleElements<Long> samples() {
            return new SampleLongs();
        }

        public List<Long> create(Object ... elements) {
            Long[] array = new Long[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Long)e;
            }
            return this.create(array);
        }

        protected abstract List<Long> create(Long[] var1);

        public Long[] createArray(int length) {
            return new Long[length];
        }

        public List<Long> order(List<Long> insertionOrder) {
            return insertionOrder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LongsAsListMiddleSubListGenerator
    extends TestLongListGenerator {
        @Override
        protected List<Long> create(Long[] elements) {
            Long[] prefix = new Long[]{Long.MIN_VALUE, Long.MAX_VALUE};
            Long[] suffix = new Long[]{86L, 99L};
            Long[] all = LongArrayAsListTest.concat(LongArrayAsListTest.concat(prefix, elements), suffix);
            return LongArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LongsAsListTailSubListGenerator
    extends TestLongListGenerator {
        @Override
        protected List<Long> create(Long[] elements) {
            Long[] prefix = new Long[]{86L, 99L};
            Long[] all = LongArrayAsListTest.concat(prefix, elements);
            return LongArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LongsAsListHeadSubListGenerator
    extends TestLongListGenerator {
        @Override
        protected List<Long> create(Long[] elements) {
            Long[] suffix = new Long[]{Long.MIN_VALUE, Long.MAX_VALUE};
            Long[] all = LongArrayAsListTest.concat(elements, suffix);
            return LongArrayAsListTest.asList(all).subList(0, elements.length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LongsAsListGenerator
    extends TestLongListGenerator {
        @Override
        protected List<Long> create(Long[] elements) {
            return LongArrayAsListTest.asList(elements);
        }
    }
}

