/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Reflection;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractInvocationHandlerTest
extends TestCase {
    private static final ImmutableList<String> LIST1 = ImmutableList.of((Object)"one", (Object)"two");
    private static final ImmutableList<String> LIST2 = ImmutableList.of((Object)"three");

    public void testDelegate() {
        AbstractInvocationHandlerTest.assertEquals(LIST1, (Object)ImmutableList.copyOf(AbstractInvocationHandlerTest.newDelegatingList(LIST1)));
        AbstractInvocationHandlerTest.assertEquals(LIST1, (Object)ImmutableList.copyOf(AbstractInvocationHandlerTest.newDelegatingListWithEquals(LIST1)));
    }

    public void testToString() {
        List<String> proxy = AbstractInvocationHandlerTest.newDelegatingList(LIST1);
        AbstractInvocationHandlerTest.assertEquals((String)Proxy.getInvocationHandler(proxy).toString(), (String)proxy.toString());
    }

    public void testEquals() {
        class AB
        implements A,
        B {
            AB() {
            }
        }
        AB ab = new AB();
        class BA
        implements B,
        A {
            BA() {
            }
        }
        BA ba = new BA();
        new EqualsTester().addEqualityGroup(new Object[]{AbstractInvocationHandlerTest.newDelegatingList(LIST1)}).addEqualityGroup(new Object[]{AbstractInvocationHandlerTest.newDelegatingList(LIST1)}).addEqualityGroup(new Object[]{AbstractInvocationHandlerTest.newDelegatingList(LIST2)}).addEqualityGroup(new Object[]{AbstractInvocationHandlerTest.newProxyWithEqualsForInterfaces(List.class, Runnable.class), AbstractInvocationHandlerTest.newProxyWithEqualsForInterfaces(List.class, Runnable.class)}).addEqualityGroup(new Object[]{AbstractInvocationHandlerTest.newProxyWithEqualsForInterfaces(Runnable.class, List.class)}).addEqualityGroup(new Object[]{AbstractInvocationHandlerTest.newDelegatingListWithEquals(LIST1), AbstractInvocationHandlerTest.newDelegatingListWithEquals(LIST1), SerializableTester.reserialize(AbstractInvocationHandlerTest.newDelegatingListWithEquals(LIST1))}).addEqualityGroup(new Object[]{AbstractInvocationHandlerTest.newDelegatingListWithEquals(LIST2), AbstractInvocationHandlerTest.newProxyWithSubHandler1(LIST2), AbstractInvocationHandlerTest.newProxyWithSubHandler2(LIST2)}).addEqualityGroup(new Object[]{AbstractInvocationHandlerTest.newDelegatingIterableWithEquals(LIST2)}).testEquals();
    }

    private static List<String> newDelegatingList(List<String> delegate) {
        return (List)Reflection.newProxy(List.class, (InvocationHandler)((Object)new DelegatingInvocationHandler(delegate)));
    }

    private static List<String> newDelegatingListWithEquals(List<String> delegate) {
        return (List)Reflection.newProxy(List.class, (InvocationHandler)((Object)new DelegatingInvocationHandlerWithEquals(delegate)));
    }

    private static Iterable<String> newDelegatingIterableWithEquals(Iterable<String> delegate) {
        return (Iterable)Reflection.newProxy(Iterable.class, (InvocationHandler)((Object)new DelegatingInvocationHandlerWithEquals(delegate)));
    }

    private static List<String> newProxyWithSubHandler1(List<String> delegate) {
        return (List)Reflection.newProxy(List.class, (InvocationHandler)((Object)new SubHandler1(delegate)));
    }

    private static List<String> newProxyWithSubHandler2(List<String> delegate) {
        return (List)Reflection.newProxy(List.class, (InvocationHandler)((Object)new SubHandler2(delegate)));
    }

    private static Object newProxyWithEqualsForInterfaces(Class<?> ... interfaces) {
        return Proxy.newProxyInstance(AbstractInvocationHandlerTest.class.getClassLoader(), interfaces, (InvocationHandler)((Object)new DelegatingInvocationHandlerWithEquals("a string")));
    }

    private static class SubHandler2
    extends DelegatingInvocationHandlerWithEquals {
        SubHandler2(Object delegate) {
            super(delegate);
        }
    }

    private static class SubHandler1
    extends DelegatingInvocationHandlerWithEquals {
        SubHandler1(Object delegate) {
            super(delegate);
        }
    }

    private static class DelegatingInvocationHandlerWithEquals
    extends DelegatingInvocationHandler {
        DelegatingInvocationHandlerWithEquals(Object delegate) {
            super(delegate);
        }

        public boolean equals(Object obj) {
            if (obj instanceof DelegatingInvocationHandlerWithEquals) {
                DelegatingInvocationHandlerWithEquals that = (DelegatingInvocationHandlerWithEquals)obj;
                return this.delegate.equals(that.delegate);
            }
            return false;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return "another arbitrary string";
        }
    }

    private static class DelegatingInvocationHandler
    extends AbstractInvocationHandler
    implements Serializable {
        final Object delegate;

        DelegatingInvocationHandler(Object delegate) {
            this.delegate = Preconditions.checkNotNull((Object)delegate);
        }

        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(this.delegate, args);
        }

        public String toString() {
            return "some arbitrary string";
        }
    }

    static interface B {
    }

    static interface A {
    }
}

