/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractListeningExecutorService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AbstractListeningExecutorServiceTest
extends TestCase {
    public void testSubmit() throws Exception {
        TestListeningExecutorService e = new TestListeningExecutorService();
        TestRunnable runnable = new TestRunnable();
        ListenableFuture runnableFuture = e.submit(runnable);
        AbstractListeningExecutorServiceTest.assertTrue((boolean)(runnableFuture instanceof ListenableFutureTask));
        AbstractListeningExecutorServiceTest.assertTrue((boolean)runnableFuture.isDone());
        AbstractListeningExecutorServiceTest.assertTrue((boolean)runnable.run);
        ListenableFuture callableFuture = e.submit(new TestCallable());
        AbstractListeningExecutorServiceTest.assertTrue((boolean)(callableFuture instanceof ListenableFutureTask));
        AbstractListeningExecutorServiceTest.assertTrue((boolean)callableFuture.isDone());
        AbstractListeningExecutorServiceTest.assertEquals((String)"foo", (String)((String)callableFuture.get()));
        TestRunnable runnable2 = new TestRunnable();
        ListenableFuture runnableFuture2 = e.submit(runnable2, 3);
        AbstractListeningExecutorServiceTest.assertTrue((boolean)(runnableFuture2 instanceof ListenableFutureTask));
        AbstractListeningExecutorServiceTest.assertTrue((boolean)runnableFuture2.isDone());
        AbstractListeningExecutorServiceTest.assertTrue((boolean)runnable2.run);
        AbstractListeningExecutorServiceTest.assertEquals((Object)3, (Object)runnableFuture2.get());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestListeningExecutorService
    extends AbstractListeningExecutorService {
        private TestListeningExecutorService() {
        }

        public void execute(Runnable runnable) {
            Assert.assertTrue((boolean)(runnable instanceof ListenableFutureTask));
            runnable.run();
        }

        public void shutdown() {
        }

        public List<Runnable> shutdownNow() {
            return ImmutableList.of();
        }

        public boolean isShutdown() {
            return false;
        }

        public boolean isTerminated() {
            return false;
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestCallable
    implements Callable<String> {
        private TestCallable() {
        }

        @Override
        public String call() {
            return "foo";
        }
    }

    private static class TestRunnable
    implements Runnable {
        boolean run = false;

        private TestRunnable() {
        }

        public void run() {
            this.run = true;
        }
    }
}

