/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AbstractServiceTest
extends TestCase {
    private static final long LONG_TIMEOUT_MILLIS = 2500L;
    private Thread executionThread;
    private Throwable thrownByExecutionThread;
    private static final Exception EXCEPTION = new Exception();

    public void testNoOpServiceStartStop() throws Exception {
        NoOpService service = new NoOpService();
        RecordingListener listener = RecordingListener.record((Service)service);
        AbstractServiceTest.assertEquals((Object)Service.State.NEW, (Object)service.state());
        AbstractServiceTest.assertFalse((boolean)service.isRunning());
        AbstractServiceTest.assertFalse((boolean)service.running);
        service.startAsync();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        AbstractServiceTest.assertTrue((boolean)service.isRunning());
        AbstractServiceTest.assertTrue((boolean)service.running);
        service.stopAsync();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractServiceTest.assertFalse((boolean)service.isRunning());
        AbstractServiceTest.assertFalse((boolean)service.running);
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.RUNNING, (Object)Service.State.STOPPING, (Object)Service.State.TERMINATED), listener.getStateHistory());
    }

    public void testNoOpServiceStartAndWaitStopAndWait() throws Exception {
        NoOpService service = new NoOpService();
        service.startAsync().awaitRunning();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        service.stopAsync().awaitTerminated();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
    }

    public void testNoOpServiceStartAsyncAndAwaitStopAsyncAndAwait() throws Exception {
        NoOpService service = new NoOpService();
        service.startAsync().awaitRunning();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        service.stopAsync().awaitTerminated();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
    }

    public void testNoOpServiceStopIdempotence() throws Exception {
        NoOpService service = new NoOpService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.startAsync().awaitRunning();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        service.stopAsync();
        service.stopAsync();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.RUNNING, (Object)Service.State.STOPPING, (Object)Service.State.TERMINATED), listener.getStateHistory());
    }

    public void testNoOpServiceStopIdempotenceAfterWait() throws Exception {
        NoOpService service = new NoOpService();
        service.startAsync().awaitRunning();
        service.stopAsync().awaitTerminated();
        service.stopAsync();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
    }

    public void testNoOpServiceStopIdempotenceDoubleWait() throws Exception {
        NoOpService service = new NoOpService();
        service.startAsync().awaitRunning();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        service.stopAsync().awaitTerminated();
        service.stopAsync().awaitTerminated();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoOpServiceStartStopAndWaitUninterruptible() throws Exception {
        NoOpService service = new NoOpService();
        Thread.currentThread().interrupt();
        try {
            service.startAsync().awaitRunning();
            AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
            service.stopAsync().awaitTerminated();
            AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
            AbstractServiceTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    public void testManualServiceStartStop() throws Exception {
        ManualSwitchedService service = new ManualSwitchedService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.startAsync();
        AbstractServiceTest.assertEquals((Object)Service.State.STARTING, (Object)service.state());
        AbstractServiceTest.assertFalse((boolean)service.isRunning());
        AbstractServiceTest.assertTrue((boolean)service.doStartCalled);
        service.notifyStarted();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        AbstractServiceTest.assertTrue((boolean)service.isRunning());
        service.stopAsync();
        AbstractServiceTest.assertEquals((Object)Service.State.STOPPING, (Object)service.state());
        AbstractServiceTest.assertFalse((boolean)service.isRunning());
        AbstractServiceTest.assertTrue((boolean)service.doStopCalled);
        service.notifyStopped();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractServiceTest.assertFalse((boolean)service.isRunning());
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.RUNNING, (Object)Service.State.STOPPING, (Object)Service.State.TERMINATED), listener.getStateHistory());
    }

    public void testManualServiceNotifyStoppedWhileRunning() throws Exception {
        ManualSwitchedService service = new ManualSwitchedService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.startAsync();
        service.notifyStarted();
        service.notifyStopped();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractServiceTest.assertFalse((boolean)service.isRunning());
        AbstractServiceTest.assertFalse((boolean)service.doStopCalled);
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.RUNNING, (Object)Service.State.TERMINATED), listener.getStateHistory());
    }

    public void testManualServiceStopWhileStarting() throws Exception {
        ManualSwitchedService service = new ManualSwitchedService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.startAsync();
        AbstractServiceTest.assertEquals((Object)Service.State.STARTING, (Object)service.state());
        AbstractServiceTest.assertFalse((boolean)service.isRunning());
        AbstractServiceTest.assertTrue((boolean)service.doStartCalled);
        service.stopAsync();
        AbstractServiceTest.assertEquals((Object)Service.State.STOPPING, (Object)service.state());
        AbstractServiceTest.assertFalse((boolean)service.isRunning());
        AbstractServiceTest.assertFalse((boolean)service.doStopCalled);
        service.notifyStarted();
        AbstractServiceTest.assertEquals((Object)Service.State.STOPPING, (Object)service.state());
        AbstractServiceTest.assertFalse((boolean)service.isRunning());
        AbstractServiceTest.assertTrue((boolean)service.doStopCalled);
        service.notifyStopped();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractServiceTest.assertFalse((boolean)service.isRunning());
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.STOPPING, (Object)Service.State.TERMINATED), listener.getStateHistory());
    }

    public void testManualServiceStopMultipleTimesWhileStarting() throws Exception {
        ManualSwitchedService service = new ManualSwitchedService();
        final AtomicInteger stopppingCount = new AtomicInteger();
        service.addListener(new Service.Listener(){

            public void stopping(Service.State from) {
                stopppingCount.incrementAndGet();
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        service.startAsync();
        service.stopAsync();
        AbstractServiceTest.assertEquals((int)1, (int)stopppingCount.get());
        service.stopAsync();
        AbstractServiceTest.assertEquals((int)1, (int)stopppingCount.get());
    }

    public void testManualServiceStopWhileNew() throws Exception {
        ManualSwitchedService service = new ManualSwitchedService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.stopAsync();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractServiceTest.assertFalse((boolean)service.isRunning());
        AbstractServiceTest.assertFalse((boolean)service.doStartCalled);
        AbstractServiceTest.assertFalse((boolean)service.doStopCalled);
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.TERMINATED), listener.getStateHistory());
    }

    public void testManualServiceFailWhileStarting() throws Exception {
        ManualSwitchedService service = new ManualSwitchedService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.startAsync();
        service.notifyFailed(EXCEPTION);
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.FAILED), listener.getStateHistory());
    }

    public void testManualServiceFailWhileRunning() throws Exception {
        ManualSwitchedService service = new ManualSwitchedService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.startAsync();
        service.notifyStarted();
        service.notifyFailed(EXCEPTION);
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.RUNNING, (Object)Service.State.FAILED), listener.getStateHistory());
    }

    public void testManualServiceFailWhileStopping() throws Exception {
        ManualSwitchedService service = new ManualSwitchedService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.startAsync();
        service.notifyStarted();
        service.stopAsync();
        service.notifyFailed(EXCEPTION);
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.RUNNING, (Object)Service.State.STOPPING, (Object)Service.State.FAILED), listener.getStateHistory());
    }

    public void testManualServiceUnrequestedStop() {
        ManualSwitchedService service = new ManualSwitchedService();
        service.startAsync();
        service.notifyStarted();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        AbstractServiceTest.assertTrue((boolean)service.isRunning());
        AbstractServiceTest.assertFalse((boolean)service.doStopCalled);
        service.notifyStopped();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractServiceTest.assertFalse((boolean)service.isRunning());
        AbstractServiceTest.assertFalse((boolean)service.doStopCalled);
    }

    public void testAwaitTerminated() throws Exception {
        final NoOpService service = new NoOpService();
        Thread waiter = new Thread(){

            public void run() {
                service.awaitTerminated();
            }
        };
        waiter.start();
        service.startAsync().awaitRunning();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        service.stopAsync();
        waiter.join(2500L);
        AbstractServiceTest.assertFalse((boolean)waiter.isAlive());
    }

    public void testAwaitTerminated_FailedService() throws Exception {
        final ManualSwitchedService service = new ManualSwitchedService();
        final AtomicReference exception = Atomics.newReference();
        Thread waiter = new Thread(){

            public void run() {
                try {
                    service.awaitTerminated();
                    Assert.fail((String)"Expected an IllegalStateException");
                }
                catch (Throwable t) {
                    exception.set(t);
                }
            }
        };
        waiter.start();
        service.startAsync();
        service.notifyStarted();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        service.notifyFailed(EXCEPTION);
        AbstractServiceTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
        waiter.join(2500L);
        AbstractServiceTest.assertFalse((boolean)waiter.isAlive());
        AbstractServiceTest.assertTrue((boolean)(exception.get() instanceof IllegalStateException));
        AbstractServiceTest.assertEquals((Object)EXCEPTION, (Object)((Throwable)exception.get()).getCause());
    }

    public void testThreadedServiceStartAndWaitStopAndWait() throws Throwable {
        ThreadedService service = new ThreadedService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.startAsync().awaitRunning();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        service.awaitRunChecks();
        service.stopAsync().awaitTerminated();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractServiceTest.throwIfSet(this.thrownByExecutionThread);
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.RUNNING, (Object)Service.State.STOPPING, (Object)Service.State.TERMINATED), listener.getStateHistory());
    }

    public void testThreadedServiceStopIdempotence() throws Throwable {
        ThreadedService service = new ThreadedService();
        service.startAsync().awaitRunning();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        service.awaitRunChecks();
        service.stopAsync();
        service.stopAsync().awaitTerminated();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractServiceTest.throwIfSet(this.thrownByExecutionThread);
    }

    public void testThreadedServiceStopIdempotenceAfterWait() throws Throwable {
        ThreadedService service = new ThreadedService();
        service.startAsync().awaitRunning();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        service.awaitRunChecks();
        service.stopAsync().awaitTerminated();
        service.stopAsync();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        this.executionThread.join();
        AbstractServiceTest.throwIfSet(this.thrownByExecutionThread);
    }

    public void testThreadedServiceStopIdempotenceDoubleWait() throws Throwable {
        ThreadedService service = new ThreadedService();
        service.startAsync().awaitRunning();
        AbstractServiceTest.assertEquals((Object)Service.State.RUNNING, (Object)service.state());
        service.awaitRunChecks();
        service.stopAsync().awaitTerminated();
        service.stopAsync().awaitTerminated();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        AbstractServiceTest.throwIfSet(this.thrownByExecutionThread);
    }

    public void testManualServiceFailureIdempotence() {
        ManualSwitchedService service = new ManualSwitchedService();
        RecordingListener.record((Service)service);
        service.startAsync();
        service.notifyFailed(new Exception("1"));
        service.notifyFailed(new Exception("2"));
        AbstractServiceTest.assertEquals((String)"1", (String)service.failureCause().getMessage());
        try {
            service.awaitRunning();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException e) {
            AbstractServiceTest.assertEquals((String)"1", (String)e.getCause().getMessage());
        }
    }

    private void invokeOnExecutionThreadForTest(Runnable runnable) {
        this.executionThread = new Thread(runnable);
        this.executionThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread thread, Throwable e) {
                AbstractServiceTest.this.thrownByExecutionThread = e;
            }
        });
        this.executionThread.start();
    }

    private static void throwIfSet(Throwable t) throws Throwable {
        if (t != null) {
            throw t;
        }
    }

    public void testStopUnstartedService() throws Exception {
        NoOpService service = new NoOpService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.stopAsync();
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)service.state());
        try {
            service.startAsync();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        AbstractServiceTest.assertEquals((Object)Service.State.TERMINATED, (Object)Iterables.getOnlyElement(listener.getStateHistory()));
    }

    public void testFailingServiceStartAndWait() throws Exception {
        StartFailingService service = new StartFailingService();
        RecordingListener listener = RecordingListener.record((Service)service);
        try {
            service.startAsync().awaitRunning();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException e) {
            AbstractServiceTest.assertEquals((Object)EXCEPTION, (Object)service.failureCause());
            AbstractServiceTest.assertEquals((Object)EXCEPTION, (Object)e.getCause());
        }
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.FAILED), listener.getStateHistory());
    }

    public void testFailingServiceStopAndWait_stopFailing() throws Exception {
        StopFailingService service = new StopFailingService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.startAsync().awaitRunning();
        try {
            service.stopAsync().awaitTerminated();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException e) {
            AbstractServiceTest.assertEquals((Object)EXCEPTION, (Object)service.failureCause());
            AbstractServiceTest.assertEquals((Object)EXCEPTION, (Object)e.getCause());
        }
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.RUNNING, (Object)Service.State.STOPPING, (Object)Service.State.FAILED), listener.getStateHistory());
    }

    public void testFailingServiceStopAndWait_runFailing() throws Exception {
        RunFailingService service = new RunFailingService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.startAsync();
        try {
            service.awaitRunning();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException e) {
            AbstractServiceTest.assertEquals((Object)EXCEPTION, (Object)service.failureCause());
            AbstractServiceTest.assertEquals((Object)EXCEPTION, (Object)e.getCause());
        }
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.RUNNING, (Object)Service.State.FAILED), listener.getStateHistory());
    }

    public void testThrowingServiceStartAndWait() throws Exception {
        StartThrowingService service = new StartThrowingService();
        RecordingListener listener = RecordingListener.record((Service)service);
        try {
            service.startAsync().awaitRunning();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException e) {
            AbstractServiceTest.assertEquals((Object)service.exception, (Object)service.failureCause());
            AbstractServiceTest.assertEquals((Object)service.exception, (Object)e.getCause());
        }
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.FAILED), listener.getStateHistory());
    }

    public void testThrowingServiceStopAndWait_stopThrowing() throws Exception {
        StopThrowingService service = new StopThrowingService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.startAsync().awaitRunning();
        try {
            service.stopAsync().awaitTerminated();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException e) {
            AbstractServiceTest.assertEquals((Object)service.exception, (Object)service.failureCause());
            AbstractServiceTest.assertEquals((Object)service.exception, (Object)e.getCause());
        }
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.RUNNING, (Object)Service.State.STOPPING, (Object)Service.State.FAILED), listener.getStateHistory());
    }

    public void testThrowingServiceStopAndWait_runThrowing() throws Exception {
        RunThrowingService service = new RunThrowingService();
        RecordingListener listener = RecordingListener.record((Service)service);
        service.startAsync();
        try {
            service.awaitTerminated();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException e) {
            AbstractServiceTest.assertEquals((Object)service.exception, (Object)service.failureCause());
            AbstractServiceTest.assertEquals((Object)service.exception, (Object)e.getCause());
        }
        AbstractServiceTest.assertEquals((Object)ImmutableList.of((Object)Service.State.STARTING, (Object)Service.State.RUNNING, (Object)Service.State.FAILED), listener.getStateHistory());
    }

    public void testFailureCause_throwsIfNotFailed() {
        StopFailingService service = new StopFailingService();
        try {
            service.failureCause();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        service.startAsync().awaitRunning();
        try {
            service.failureCause();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            service.stopAsync().awaitTerminated();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException e) {
            AbstractServiceTest.assertEquals((Object)EXCEPTION, (Object)service.failureCause());
            AbstractServiceTest.assertEquals((Object)EXCEPTION, (Object)e.getCause());
        }
    }

    public void testAddListenerAfterFailureDoesntCauseDeadlock() throws InterruptedException {
        final StartFailingService service = new StartFailingService();
        service.startAsync();
        AbstractServiceTest.assertEquals((Object)Service.State.FAILED, (Object)service.state());
        service.addListener(new RecordingListener((Service)service), (Executor)MoreExecutors.sameThreadExecutor());
        Thread thread = new Thread(){

            public void run() {
                service.stopAsync();
            }
        };
        thread.start();
        thread.join(2500L);
        AbstractServiceTest.assertFalse((String)(thread + " is deadlocked"), (boolean)thread.isAlive());
    }

    public void testListenerDoesntDeadlockOnStartAndWaitFromRunning() throws Exception {
        final NoOpThreadedService service = new NoOpThreadedService();
        service.addListener(new Service.Listener(){

            public void running() {
                service.awaitRunning();
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        service.startAsync().awaitRunning(2500L, TimeUnit.MILLISECONDS);
        service.stopAsync();
    }

    public void testListenerDoesntDeadlockOnStopAndWaitFromTerminated() throws Exception {
        final NoOpThreadedService service = new NoOpThreadedService();
        service.addListener(new Service.Listener(){

            public void terminated(Service.State from) {
                service.stopAsync().awaitTerminated();
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        service.startAsync().awaitRunning();
        Thread thread = new Thread(){

            public void run() {
                service.stopAsync().awaitTerminated();
            }
        };
        thread.start();
        thread.join(2500L);
        AbstractServiceTest.assertFalse((String)(thread + " is deadlocked"), (boolean)thread.isAlive());
    }

    public void testNotifyStartedWhenNotStarting() {
        DefaultService service = new DefaultService();
        try {
            service.notifyStarted();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testNotifyStoppedWhenNotRunning() {
        DefaultService service = new DefaultService();
        try {
            service.notifyStopped();
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testNotifyFailedWhenNotStarted() {
        DefaultService service = new DefaultService();
        try {
            service.notifyFailed(new Exception());
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testNotifyFailedWhenTerminated() {
        NoOpService service = new NoOpService();
        service.startAsync().awaitRunning();
        service.stopAsync().awaitTerminated();
        try {
            service.notifyFailed(new Exception());
            AbstractServiceTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static class DefaultService
    extends AbstractService {
        private DefaultService() {
        }

        protected void doStart() {
        }

        protected void doStop() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecordingListener
    extends Service.Listener {
        final Service service;
        @GuardedBy(value="this")
        final List<Service.State> stateHistory = Lists.newArrayList();
        final CountDownLatch completionLatch = new CountDownLatch(1);

        static RecordingListener record(Service service) {
            RecordingListener listener = new RecordingListener(service);
            service.addListener((Service.Listener)listener, (Executor)MoreExecutors.sameThreadExecutor());
            return listener;
        }

        RecordingListener(Service service) {
            this.service = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ImmutableList<Service.State> getStateHistory() throws Exception {
            this.completionLatch.await();
            RecordingListener recordingListener = this;
            synchronized (recordingListener) {
                return ImmutableList.copyOf(this.stateHistory);
            }
        }

        public synchronized void starting() {
            Assert.assertTrue((boolean)this.stateHistory.isEmpty());
            Assert.assertNotSame((Object)Service.State.NEW, (Object)this.service.state());
            this.stateHistory.add(Service.State.STARTING);
        }

        public synchronized void running() {
            Assert.assertEquals((Object)Service.State.STARTING, (Object)Iterables.getOnlyElement(this.stateHistory));
            this.stateHistory.add(Service.State.RUNNING);
            this.service.awaitRunning();
            Assert.assertNotSame((Object)Service.State.STARTING, (Object)this.service.state());
        }

        public synchronized void stopping(Service.State from) {
            Assert.assertEquals((Object)from, (Object)Iterables.getLast(this.stateHistory));
            this.stateHistory.add(Service.State.STOPPING);
            if (from == Service.State.STARTING) {
                try {
                    this.service.awaitRunning();
                    Assert.fail();
                }
                catch (IllegalStateException expected) {
                    Assert.assertNull((Object)expected.getCause());
                    Assert.assertTrue((boolean)expected.getMessage().equals("Expected the service to be RUNNING, but was STOPPING"));
                }
            }
            Assert.assertNotSame((Object)from, (Object)this.service.state());
        }

        public synchronized void terminated(Service.State from) {
            Assert.assertEquals((Object)from, (Object)Iterables.getLast(this.stateHistory, (Object)Service.State.NEW));
            this.stateHistory.add(Service.State.TERMINATED);
            Assert.assertEquals((Object)Service.State.TERMINATED, (Object)this.service.state());
            if (from == Service.State.NEW) {
                try {
                    this.service.awaitRunning();
                    Assert.fail();
                }
                catch (IllegalStateException expected) {
                    Assert.assertNull((Object)expected.getCause());
                    Assert.assertTrue((boolean)expected.getMessage().equals("Expected the service to be RUNNING, but was TERMINATED"));
                }
            }
            this.completionLatch.countDown();
        }

        public synchronized void failed(Service.State from, Throwable failure) {
            Assert.assertEquals((Object)from, (Object)Iterables.getLast(this.stateHistory));
            this.stateHistory.add(Service.State.FAILED);
            Assert.assertEquals((Object)Service.State.FAILED, (Object)this.service.state());
            Assert.assertEquals((Object)failure, (Object)this.service.failureCause());
            if (from == Service.State.STARTING) {
                try {
                    this.service.awaitRunning();
                    Assert.fail();
                }
                catch (IllegalStateException e) {
                    Assert.assertEquals((Object)failure, (Object)e.getCause());
                }
            }
            try {
                this.service.awaitTerminated();
                Assert.fail();
            }
            catch (IllegalStateException e) {
                Assert.assertEquals((Object)failure, (Object)e.getCause());
            }
            this.completionLatch.countDown();
        }
    }

    private static class StopThrowingService
    extends AbstractService {
        final RuntimeException exception = new RuntimeException("deliberate");

        private StopThrowingService() {
        }

        protected void doStart() {
            this.notifyStarted();
        }

        protected void doStop() {
            throw this.exception;
        }
    }

    private static class RunThrowingService
    extends AbstractService {
        final RuntimeException exception = new RuntimeException("deliberate");

        private RunThrowingService() {
        }

        protected void doStart() {
            this.notifyStarted();
            throw this.exception;
        }

        protected void doStop() {
            Assert.fail();
        }
    }

    private static class StartThrowingService
    extends AbstractService {
        final RuntimeException exception = new RuntimeException("deliberate");

        private StartThrowingService() {
        }

        protected void doStart() {
            throw this.exception;
        }

        protected void doStop() {
            Assert.fail();
        }
    }

    private static class StopFailingService
    extends AbstractService {
        private StopFailingService() {
        }

        protected void doStart() {
            this.notifyStarted();
        }

        protected void doStop() {
            this.notifyFailed(EXCEPTION);
        }
    }

    private static class RunFailingService
    extends AbstractService {
        private RunFailingService() {
        }

        protected void doStart() {
            this.notifyStarted();
            this.notifyFailed(EXCEPTION);
        }

        protected void doStop() {
            Assert.fail();
        }
    }

    private static class StartFailingService
    extends AbstractService {
        private StartFailingService() {
        }

        protected void doStart() {
            this.notifyFailed(EXCEPTION);
        }

        protected void doStop() {
            Assert.fail();
        }
    }

    private static class NoOpThreadedService
    extends AbstractExecutionThreadService {
        final CountDownLatch latch = new CountDownLatch(1);

        private NoOpThreadedService() {
        }

        protected void run() throws Exception {
            this.latch.await();
        }

        protected void triggerShutdown() {
            this.latch.countDown();
        }
    }

    private class ThreadedService
    extends AbstractService {
        final CountDownLatch hasConfirmedIsRunning = new CountDownLatch(1);

        private ThreadedService() {
        }

        void awaitRunChecks() throws InterruptedException {
            Assert.assertTrue((String)("Service thread hasn't finished its checks. Exception status (possibly stale): " + AbstractServiceTest.this.thrownByExecutionThread), (boolean)this.hasConfirmedIsRunning.await(10L, TimeUnit.SECONDS));
        }

        protected void doStart() {
            Assert.assertEquals((Object)Service.State.STARTING, (Object)this.state());
            AbstractServiceTest.this.invokeOnExecutionThreadForTest(new Runnable(){

                public void run() {
                    Assert.assertEquals((Object)Service.State.STARTING, (Object)ThreadedService.this.state());
                    ThreadedService.this.notifyStarted();
                    Assert.assertEquals((Object)Service.State.RUNNING, (Object)ThreadedService.this.state());
                    ThreadedService.this.hasConfirmedIsRunning.countDown();
                }
            });
        }

        protected void doStop() {
            Assert.assertEquals((Object)Service.State.STOPPING, (Object)this.state());
            AbstractServiceTest.this.invokeOnExecutionThreadForTest(new Runnable(){

                public void run() {
                    Assert.assertEquals((Object)Service.State.STOPPING, (Object)ThreadedService.this.state());
                    ThreadedService.this.notifyStopped();
                    Assert.assertEquals((Object)Service.State.TERMINATED, (Object)ThreadedService.this.state());
                }
            });
        }
    }

    private static class ManualSwitchedService
    extends AbstractService {
        boolean doStartCalled = false;
        boolean doStopCalled = false;

        private ManualSwitchedService() {
        }

        protected void doStart() {
            Assert.assertFalse((boolean)this.doStartCalled);
            this.doStartCalled = true;
        }

        protected void doStop() {
            Assert.assertFalse((boolean)this.doStopCalled);
            this.doStopCalled = true;
        }
    }

    private static class NoOpService
    extends AbstractService {
        boolean running = false;

        private NoOpService() {
        }

        protected void doStart() {
            Assert.assertFalse((boolean)this.running);
            this.running = true;
            this.notifyStarted();
        }

        protected void doStop() {
            Assert.assertTrue((boolean)this.running);
            this.running = false;
            this.notifyStopped();
        }
    }
}

