/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncSettableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

public class AsyncSettableFutureTest
extends TestCase {
    public void testCreate() throws Exception {
        AsyncSettableFuture future = AsyncSettableFuture.create();
        AsyncSettableFutureTest.assertFalse((boolean)future.isSet());
        AsyncSettableFutureTest.assertFalse((boolean)future.isDone());
        AsyncSettableFutureTest.assertFalse((boolean)future.isCancelled());
    }

    public void testSetValue() throws Exception {
        AsyncSettableFuture future = AsyncSettableFuture.create();
        AsyncSettableFutureTest.assertTrue((boolean)future.setValue((Object)42));
        AsyncSettableFutureTest.assertTrue((boolean)future.isSet());
        AsyncSettableFutureTest.assertFalse((boolean)future.setValue((Object)23));
        AsyncSettableFutureTest.assertFalse((boolean)future.setException((Throwable)new Exception("bar")));
        AsyncSettableFutureTest.assertFalse((boolean)future.setFuture((ListenableFuture)SettableFuture.create()));
        AsyncSettableFutureTest.assertTrue((boolean)future.isDone());
        AsyncSettableFutureTest.assertFalse((boolean)future.isCancelled());
        AsyncSettableFutureTest.assertEquals((int)42, (int)((Integer)future.get()));
    }

    public void testSetException() throws Exception {
        AsyncSettableFuture future = AsyncSettableFuture.create();
        Exception e = new Exception("foobarbaz");
        AsyncSettableFutureTest.assertTrue((boolean)future.setException((Throwable)e));
        AsyncSettableFutureTest.assertTrue((boolean)future.isSet());
        AsyncSettableFutureTest.assertFalse((boolean)future.setValue((Object)23));
        AsyncSettableFutureTest.assertFalse((boolean)future.setException((Throwable)new Exception("quux")));
        AsyncSettableFutureTest.assertFalse((boolean)future.setFuture((ListenableFuture)SettableFuture.create()));
        AsyncSettableFutureTest.assertTrue((boolean)future.isDone());
        AsyncSettableFutureTest.assertFalse((boolean)future.isCancelled());
        try {
            future.get();
            AsyncSettableFutureTest.fail((String)"Expected ExecutionException");
        }
        catch (ExecutionException ee) {
            AsyncSettableFutureTest.assertSame((Object)e, (Object)ee.getCause());
        }
    }

    public void testSetFuture() throws Exception {
        AsyncSettableFuture future = AsyncSettableFuture.create();
        SettableFuture nested = SettableFuture.create();
        AsyncSettableFutureTest.assertTrue((boolean)future.setFuture((ListenableFuture)nested));
        AsyncSettableFutureTest.assertTrue((boolean)future.isSet());
        AsyncSettableFutureTest.assertFalse((boolean)future.setValue((Object)"x"));
        AsyncSettableFutureTest.assertFalse((boolean)future.setException((Throwable)new Exception("bar")));
        AsyncSettableFutureTest.assertFalse((boolean)future.setFuture((ListenableFuture)SettableFuture.create()));
        AsyncSettableFutureTest.assertFalse((boolean)future.isDone());
        AsyncSettableFutureTest.assertFalse((boolean)future.isCancelled());
        try {
            future.get(0L, TimeUnit.MILLISECONDS);
            AsyncSettableFutureTest.fail((String)"Expected TimeoutException");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        nested.set((Object)"foo");
        AsyncSettableFutureTest.assertTrue((boolean)future.isDone());
        AsyncSettableFutureTest.assertFalse((boolean)future.isCancelled());
        AsyncSettableFutureTest.assertEquals((String)"foo", (String)((String)future.get()));
    }

    public void testSetFuture_genericsHierarchy() throws Exception {
        AsyncSettableFuture future = AsyncSettableFuture.create();
        SettableFuture nested = SettableFuture.create();
        AsyncSettableFutureTest.assertTrue((boolean)future.setFuture((ListenableFuture)nested));
        AsyncSettableFutureTest.assertTrue((boolean)future.isSet());
        AsyncSettableFutureTest.assertFalse((boolean)future.setValue((Object)new Foo()));
        AsyncSettableFutureTest.assertFalse((boolean)future.setException((Throwable)new Exception("bar")));
        AsyncSettableFutureTest.assertFalse((boolean)future.setFuture((ListenableFuture)SettableFuture.create()));
        AsyncSettableFutureTest.assertFalse((boolean)future.isDone());
        AsyncSettableFutureTest.assertFalse((boolean)future.isCancelled());
        try {
            future.get(0L, TimeUnit.MILLISECONDS);
            AsyncSettableFutureTest.fail((String)"Expected TimeoutException");
        }
        catch (TimeoutException expected) {
            // empty catch block
        }
        FooChild value = new FooChild();
        nested.set((Object)value);
        AsyncSettableFutureTest.assertTrue((boolean)future.isDone());
        AsyncSettableFutureTest.assertFalse((boolean)future.isCancelled());
        AsyncSettableFutureTest.assertSame((Object)value, (Object)future.get());
    }

    public void testCancel_innerCancelsAsync() throws Exception {
        AsyncSettableFuture async = AsyncSettableFuture.create();
        SettableFuture inner = SettableFuture.create();
        async.setFuture((ListenableFuture)inner);
        inner.cancel(true);
        AsyncSettableFutureTest.assertTrue((boolean)async.isCancelled());
        try {
            async.get();
            AsyncSettableFutureTest.fail((String)"Expected CancellationException");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testCancel_resultCancelsInner_interrupted() throws Exception {
        AsyncSettableFuture async = AsyncSettableFuture.create();
        MyFuture inner = new MyFuture();
        async.setFuture(inner);
        async.cancel(true);
        AsyncSettableFutureTest.assertTrue((boolean)inner.isCancelled());
        AsyncSettableFutureTest.assertTrue((boolean)inner.myWasInterrupted());
        try {
            inner.get();
            AsyncSettableFutureTest.fail((String)"Expected CancellationException");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testCancel_resultCancelsInner() throws Exception {
        AsyncSettableFuture async = AsyncSettableFuture.create();
        MyFuture inner = new MyFuture();
        async.setFuture(inner);
        async.cancel(false);
        AsyncSettableFutureTest.assertTrue((boolean)inner.isCancelled());
        AsyncSettableFutureTest.assertFalse((boolean)inner.myWasInterrupted());
        try {
            inner.get();
            AsyncSettableFutureTest.fail((String)"Expected CancellationException");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testCancel_beforeSet() throws Exception {
        AsyncSettableFuture async = AsyncSettableFuture.create();
        async.cancel(true);
        AsyncSettableFutureTest.assertFalse((boolean)async.setValue((Object)42));
    }

    public void testCancel_multipleBeforeSetFuture_noInterruptFirst() throws Exception {
        AsyncSettableFuture async = AsyncSettableFuture.create();
        async.cancel(false);
        async.cancel(true);
        MyFuture inner = new MyFuture();
        AsyncSettableFutureTest.assertFalse((boolean)async.setFuture(inner));
        AsyncSettableFutureTest.assertTrue((boolean)inner.isCancelled());
        AsyncSettableFutureTest.assertFalse((boolean)inner.myWasInterrupted());
    }

    public void testCancel_multipleBeforeSetFuture_interruptFirst() throws Exception {
        AsyncSettableFuture async = AsyncSettableFuture.create();
        async.cancel(true);
        async.cancel(false);
        MyFuture inner = new MyFuture();
        AsyncSettableFutureTest.assertFalse((boolean)async.setFuture(inner));
        AsyncSettableFutureTest.assertTrue((boolean)inner.isCancelled());
        AsyncSettableFutureTest.assertTrue((boolean)inner.myWasInterrupted());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyFuture<V>
    extends AbstractFuture<V> {
        private MyFuture() {
        }

        boolean myWasInterrupted() {
            return this.wasInterrupted();
        }
    }

    private static class FooChild
    extends Foo {
        private FooChild() {
        }
    }

    private static class Foo {
        private Foo() {
        }
    }
}

