/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.JSR166TestCase;

public class AtomicDoubleTest
extends JSR166TestCase {
    private static final double[] VALUES = new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -9.223372036854776E18, -2.147483648E9, -Math.PI, -1.0, -4.9E-324, -0.0, 0.0, Double.MIN_VALUE, 1.0, Math.PI, 2.147483647E9, 9.223372036854776E18, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NaN, 3.4028234663852886E38};

    static boolean bitEquals(double x, double y) {
        return Double.doubleToRawLongBits(x) == Double.doubleToRawLongBits(y);
    }

    static void assertBitEquals(double x, double y) {
        AtomicDoubleTest.assertEquals((long)Double.doubleToRawLongBits(x), (long)Double.doubleToRawLongBits(y));
    }

    public void testConstructor() {
        for (double x : VALUES) {
            AtomicDouble a = new AtomicDouble(x);
            AtomicDoubleTest.assertBitEquals(x, a.get());
        }
    }

    public void testConstructor2() {
        AtomicDouble a = new AtomicDouble();
        AtomicDoubleTest.assertBitEquals(0.0, a.get());
    }

    public void testGetSet() {
        AtomicDouble at = new AtomicDouble(1.0);
        AtomicDoubleTest.assertBitEquals(1.0, at.get());
        for (double x : VALUES) {
            at.set(x);
            AtomicDoubleTest.assertBitEquals(x, at.get());
        }
    }

    public void testGetLazySet() {
        AtomicDouble at = new AtomicDouble(1.0);
        AtomicDoubleTest.assertBitEquals(1.0, at.get());
        for (double x : VALUES) {
            at.lazySet(x);
            AtomicDoubleTest.assertBitEquals(x, at.get());
        }
    }

    public void testCompareAndSet() {
        double prev = Math.E;
        double unused = 5.859874482048838;
        AtomicDouble at = new AtomicDouble(prev);
        for (double x : VALUES) {
            AtomicDoubleTest.assertBitEquals(prev, at.get());
            AtomicDoubleTest.assertFalse((boolean)at.compareAndSet(unused, x));
            AtomicDoubleTest.assertBitEquals(prev, at.get());
            AtomicDoubleTest.assertTrue((boolean)at.compareAndSet(prev, x));
            AtomicDoubleTest.assertBitEquals(x, at.get());
            prev = x;
        }
    }

    public void testCompareAndSetInMultipleThreads() throws Exception {
        final AtomicDouble at = new AtomicDouble(1.0);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            public void realRun() {
                while (!at.compareAndSet(2.0, 3.0)) {
                    Thread.yield();
                }
            }
        });
        AtomicDoubleTest.assertTrue((boolean)at.compareAndSet(1.0, 2.0));
        this.awaitTermination(t);
        AtomicDoubleTest.assertBitEquals(3.0, at.get());
    }

    public void testWeakCompareAndSet() {
        double prev = Math.E;
        double unused = 5.859874482048838;
        AtomicDouble at = new AtomicDouble(prev);
        for (double x : VALUES) {
            AtomicDoubleTest.assertBitEquals(prev, at.get());
            AtomicDoubleTest.assertFalse((boolean)at.weakCompareAndSet(unused, x));
            AtomicDoubleTest.assertBitEquals(prev, at.get());
            while (!at.weakCompareAndSet(prev, x)) {
            }
            AtomicDoubleTest.assertBitEquals(x, at.get());
            prev = x;
        }
    }

    public void testGetAndSet() {
        double prev = Math.E;
        AtomicDouble at = new AtomicDouble(prev);
        for (double x : VALUES) {
            AtomicDoubleTest.assertBitEquals(prev, at.getAndSet(x));
            prev = x;
        }
    }

    public void testGetAndAdd() {
        for (double x : VALUES) {
            for (double y : VALUES) {
                AtomicDouble a = new AtomicDouble(x);
                double z = a.getAndAdd(y);
                AtomicDoubleTest.assertBitEquals(x, z);
                AtomicDoubleTest.assertBitEquals(x + y, a.get());
            }
        }
    }

    public void testAddAndGet() {
        for (double x : VALUES) {
            for (double y : VALUES) {
                AtomicDouble a = new AtomicDouble(x);
                double z = a.addAndGet(y);
                AtomicDoubleTest.assertBitEquals(x + y, z);
                AtomicDoubleTest.assertBitEquals(x + y, a.get());
            }
        }
    }

    public void testSerialization() throws Exception {
        AtomicDouble a = new AtomicDouble();
        AtomicDouble b = this.serialClone(a);
        AtomicDoubleTest.assertNotSame((Object)a, (Object)b);
        a.set(-22.0);
        AtomicDouble c = this.serialClone(a);
        AtomicDoubleTest.assertNotSame((Object)b, (Object)c);
        AtomicDoubleTest.assertBitEquals(-22.0, a.get());
        AtomicDoubleTest.assertBitEquals(0.0, b.get());
        AtomicDoubleTest.assertBitEquals(-22.0, c.get());
        for (double x : VALUES) {
            AtomicDouble d = new AtomicDouble(x);
            AtomicDoubleTest.assertBitEquals(this.serialClone(d).get(), d.get());
        }
    }

    public void testToString() {
        AtomicDouble at = new AtomicDouble();
        AtomicDoubleTest.assertEquals((String)"0.0", (String)at.toString());
        for (double x : VALUES) {
            at.set(x);
            AtomicDoubleTest.assertEquals((String)Double.toString(x), (String)at.toString());
        }
    }

    public void testIntValue() {
        AtomicDouble at = new AtomicDouble();
        AtomicDoubleTest.assertEquals((int)0, (int)at.intValue());
        for (double x : VALUES) {
            at.set(x);
            AtomicDoubleTest.assertEquals((int)((int)x), (int)at.intValue());
        }
    }

    public void testLongValue() {
        AtomicDouble at = new AtomicDouble();
        AtomicDoubleTest.assertEquals((long)0L, (long)at.longValue());
        for (double x : VALUES) {
            at.set(x);
            AtomicDoubleTest.assertEquals((long)((long)x), (long)at.longValue());
        }
    }

    public void testFloatValue() {
        AtomicDouble at = new AtomicDouble();
        AtomicDoubleTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(at.floatValue()));
        for (double x : VALUES) {
            at.set(x);
            AtomicDoubleTest.assertEquals((Object)Float.valueOf((float)x), (Object)Float.valueOf(at.floatValue()));
        }
    }

    public void testDoubleValue() {
        AtomicDouble at = new AtomicDouble();
        AtomicDoubleTest.assertEquals((Object)0.0, (Object)at.doubleValue());
        for (double x : VALUES) {
            at.set(x);
            AtomicDoubleTest.assertBitEquals(x, at.doubleValue());
        }
    }

    public void testDistinctZeros() {
        AtomicDouble at = new AtomicDouble(0.0);
        AtomicDoubleTest.assertFalse((boolean)at.compareAndSet(-0.0, 7.0));
        AtomicDoubleTest.assertFalse((boolean)at.weakCompareAndSet(-0.0, 7.0));
        AtomicDoubleTest.assertBitEquals(0.0, at.get());
        AtomicDoubleTest.assertTrue((boolean)at.compareAndSet(0.0, -0.0));
        AtomicDoubleTest.assertBitEquals(-0.0, at.get());
        AtomicDoubleTest.assertFalse((boolean)at.compareAndSet(0.0, 7.0));
        AtomicDoubleTest.assertFalse((boolean)at.weakCompareAndSet(0.0, 7.0));
        AtomicDoubleTest.assertBitEquals(-0.0, at.get());
    }
}

