/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.testing.ClassSanityTester;
import com.google.common.testing.TestLogHandler;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.FutureFallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTester;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.truth0.Truth;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuturesTest
extends TestCase {
    private static final Logger combinedFutureLogger = Logger.getLogger("com.google.common.util.concurrent.Futures$CombinedFuture");
    private final TestLogHandler combinedFutureLogHandler = new TestLogHandler();
    private static final String DATA1 = "data";
    private static final String DATA2 = "more data";
    private static final String DATA3 = "most data";
    private IMocksControl mocksControl;
    private static final Function<Exception, TestException> mapper = new Function<Exception, TestException>(){

        public TestException apply(Exception from) {
            if (from instanceof ExecutionException) {
                return new TestException(from.getCause());
            }
            Assert.assertTrue((String)("got " + from.getClass()), (from instanceof InterruptedException || from instanceof CancellationException ? 1 : 0) != 0);
            return new TestException(from);
        }
    };
    private static final Exception CHECKED_EXCEPTION = new Exception("mymessage");
    private static final Future<String> FAILED_FUTURE_CHECKED_EXCEPTION = Futures.immediateFailedFuture((Throwable)CHECKED_EXCEPTION);
    private static final RuntimeException UNCHECKED_EXCEPTION = new RuntimeException("mymessage");
    private static final Future<String> FAILED_FUTURE_UNCHECKED_EXCEPTION = Futures.immediateFailedFuture((Throwable)UNCHECKED_EXCEPTION);
    private static final RuntimeException RUNTIME_EXCEPTION = new RuntimeException();
    private static final OtherThrowable OTHER_THROWABLE = new OtherThrowable();
    private static final Future<String> FAILED_FUTURE_OTHER_THROWABLE = Futures.immediateFailedFuture((Throwable)OTHER_THROWABLE);
    private static final Error ERROR = new Error("mymessage");
    private static final Future<String> FAILED_FUTURE_ERROR = Futures.immediateFailedFuture((Throwable)ERROR);
    private static final Future<String> RUNTIME_EXCEPTION_FUTURE = new ForwardingFuture.SimpleForwardingFuture<String>(FAILED_FUTURE_CHECKED_EXCEPTION){

        public String get() {
            throw RUNTIME_EXCEPTION;
        }

        public String get(long timeout, TimeUnit unit) {
            throw RUNTIME_EXCEPTION;
        }
    };

    protected void setUp() throws Exception {
        super.setUp();
        combinedFutureLogger.addHandler((Handler)this.combinedFutureLogHandler);
        this.mocksControl = EasyMock.createControl();
    }

    protected void tearDown() throws Exception {
        Thread.interrupted();
        combinedFutureLogger.removeHandler((Handler)this.combinedFutureLogHandler);
        super.tearDown();
    }

    public void testImmediateFuture() throws Exception {
        ListenableFuture future = Futures.immediateFuture((Object)DATA1);
        FuturesTest.assertSame((Object)DATA1, (Object)future.get(0L, TimeUnit.MILLISECONDS));
    }

    public void testMultipleImmediateFutures() throws Exception {
        ListenableFuture future1 = Futures.immediateFuture((Object)DATA1);
        ListenableFuture future2 = Futures.immediateFuture((Object)DATA2);
        FuturesTest.assertSame((Object)DATA1, (Object)future1.get(0L, TimeUnit.MILLISECONDS));
        FuturesTest.assertSame((Object)DATA2, (Object)future2.get(0L, TimeUnit.MILLISECONDS));
    }

    public void testImmediateFailedFuture() throws Exception {
        Exception exception = new Exception();
        ListenableFuture future = Futures.immediateFailedFuture((Throwable)exception);
        try {
            future.get(0L, TimeUnit.MILLISECONDS);
            FuturesTest.fail((String)"This call was supposed to throw an ExecutionException");
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
    }

    public void testImmediateFailedFuture_cancellationException() throws Exception {
        CancellationException exception = new CancellationException();
        ListenableFuture future = Futures.immediateFailedFuture((Throwable)exception);
        try {
            future.get(0L, TimeUnit.MILLISECONDS);
            FuturesTest.fail((String)"This call was supposed to throw an ExecutionException");
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
            FuturesTest.assertFalse((boolean)future.isCancelled());
        }
    }

    public void testImmediateCancelledFuture() throws Exception {
        ListenableFuture future = Futures.immediateCancelledFuture();
        FuturesTest.assertTrue((boolean)future.isCancelled());
    }

    public void testImmediateCheckedFuture() throws Exception {
        CheckedFuture future = Futures.immediateCheckedFuture((Object)DATA1);
        FuturesTest.assertSame((Object)DATA1, (Object)future.get(0L, TimeUnit.MILLISECONDS));
        FuturesTest.assertSame((Object)DATA1, (Object)future.checkedGet(0L, TimeUnit.MILLISECONDS));
    }

    public void testMultipleImmediateCheckedFutures() throws Exception {
        CheckedFuture future1 = Futures.immediateCheckedFuture((Object)DATA1);
        CheckedFuture future2 = Futures.immediateCheckedFuture((Object)DATA2);
        FuturesTest.assertSame((Object)DATA1, (Object)future1.get(0L, TimeUnit.MILLISECONDS));
        FuturesTest.assertSame((Object)DATA1, (Object)future1.checkedGet(0L, TimeUnit.MILLISECONDS));
        FuturesTest.assertSame((Object)DATA2, (Object)future2.get(0L, TimeUnit.MILLISECONDS));
        FuturesTest.assertSame((Object)DATA2, (Object)future2.checkedGet(0L, TimeUnit.MILLISECONDS));
    }

    public void testImmediateFailedCheckedFuture() throws Exception {
        MyException exception = new MyException();
        CheckedFuture future = Futures.immediateFailedCheckedFuture((Exception)exception);
        try {
            future.get(0L, TimeUnit.MILLISECONDS);
            FuturesTest.fail((String)"This call was supposed to throw an ExecutionException");
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
        try {
            future.checkedGet(0L, TimeUnit.MILLISECONDS);
            FuturesTest.fail((String)"This call was supposed to throw an MyException");
        }
        catch (MyException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected);
        }
    }

    public void testTransform_genericsNull() throws Exception {
        ListenableFuture nullFuture = Futures.immediateFuture(null);
        ListenableFuture transformedFuture = Futures.transform((ListenableFuture)nullFuture, (Function)Functions.constant(null));
        FuturesTest.assertNull((Object)transformedFuture.get());
    }

    public void testTransform_genericsHierarchy() throws Exception {
        ListenableFuture future = Futures.immediateFuture(null);
        final BarChild barChild = new BarChild();
        Function<Foo, BarChild> function = new Function<Foo, BarChild>(){

            public BarChild apply(Foo unused) {
                return barChild;
            }
        };
        Bar bar = (Bar)Futures.transform((ListenableFuture)future, (Function)function).get();
        FuturesTest.assertSame((Object)barChild, (Object)bar);
    }

    public void testTransform_cancelPropagatesToInput() throws Exception {
        SettableFuture input = SettableFuture.create();
        AsyncFunction<Foo, Bar> function = new AsyncFunction<Foo, Bar>(){

            public ListenableFuture<Bar> apply(Foo unused) {
                throw new AssertionFailedError("Unexpeted call to apply.");
            }
        };
        FuturesTest.assertTrue((boolean)Futures.transform((ListenableFuture)input, (AsyncFunction)function).cancel(false));
        FuturesTest.assertTrue((boolean)input.isCancelled());
        FuturesTest.assertFalse((boolean)input.wasInterrupted());
    }

    public void testTransform_interruptPropagatesToInput() throws Exception {
        SettableFuture input = SettableFuture.create();
        AsyncFunction<Foo, Bar> function = new AsyncFunction<Foo, Bar>(){

            public ListenableFuture<Bar> apply(Foo unused) {
                throw new AssertionFailedError("Unexpeted call to apply.");
            }
        };
        FuturesTest.assertTrue((boolean)Futures.transform((ListenableFuture)input, (AsyncFunction)function).cancel(true));
        FuturesTest.assertTrue((boolean)input.isCancelled());
        FuturesTest.assertTrue((boolean)input.wasInterrupted());
    }

    public void testTransform_cancelPropagatesToAsyncOutput() throws Exception {
        ListenableFuture immediate = Futures.immediateFuture((Object)new Foo());
        final SettableFuture secondary = SettableFuture.create();
        AsyncFunction<Foo, Bar> function = new AsyncFunction<Foo, Bar>(){

            public ListenableFuture<Bar> apply(Foo unused) {
                return secondary;
            }
        };
        FuturesTest.assertTrue((boolean)Futures.transform((ListenableFuture)immediate, (AsyncFunction)function).cancel(false));
        FuturesTest.assertTrue((boolean)secondary.isCancelled());
        FuturesTest.assertFalse((boolean)secondary.wasInterrupted());
    }

    public void testTransform_interruptPropagatesToAsyncOutput() throws Exception {
        ListenableFuture immediate = Futures.immediateFuture((Object)new Foo());
        final SettableFuture secondary = SettableFuture.create();
        AsyncFunction<Foo, Bar> function = new AsyncFunction<Foo, Bar>(){

            public ListenableFuture<Bar> apply(Foo unused) {
                return secondary;
            }
        };
        FuturesTest.assertTrue((boolean)Futures.transform((ListenableFuture)immediate, (AsyncFunction)function).cancel(true));
        FuturesTest.assertTrue((boolean)secondary.isCancelled());
        FuturesTest.assertTrue((boolean)secondary.wasInterrupted());
    }

    public void testTransformValueRemainsMemoized() throws Exception {
        class Holder {
            int value = 2;

            Holder() {
            }
        }
        final Holder holder = new Holder();
        Function<Integer, Integer> adder = new Function<Integer, Integer>(){
            {
            }

            public Integer apply(Integer from) {
                return from + holder.value;
            }
        };
        FuturesTest.assertEquals((int)6, (int)((Integer)adder.apply((Object)4)));
        ListenableFuture immediateFuture = Futures.immediateFuture((Object)4);
        ListenableFuture transformedFuture = Futures.transform((ListenableFuture)immediateFuture, (Function)adder);
        FuturesTest.assertEquals((int)6, (int)((Integer)transformedFuture.get()));
        holder.value = 3;
        FuturesTest.assertEquals((int)6, (int)((Integer)transformedFuture.get()));
        FuturesTest.assertEquals((int)7, (int)((Integer)adder.apply((Object)4)));
        holder.value = 4;
        FuturesTest.assertEquals((int)6, (int)((Integer)transformedFuture.get()));
        FuturesTest.assertEquals((int)8, (int)((Integer)adder.apply((Object)4)));
        FuturesTest.assertEquals((int)6, (int)((Integer)transformedFuture.get(1000L, TimeUnit.SECONDS)));
        FuturesTest.assertEquals((int)8, (int)((Integer)Futures.transform((ListenableFuture)immediateFuture, (Function)adder).get()));
        FuturesTest.assertEquals((int)8, (int)((Integer)Futures.transform((ListenableFuture)immediateFuture, (Function)adder).get(1000L, TimeUnit.SECONDS)));
    }

    public void testTransformExceptionRemainsMemoized() throws Throwable {
        SettableFuture exceptionInput = SettableFuture.create();
        ListenableFuture exceptionComposedFuture = Futures.transform((ListenableFuture)exceptionInput, FuturesTest.newOneTimeExceptionThrower());
        exceptionInput.set((Object)0);
        FuturesTest.runGetIdempotencyTest((Future<Integer>)exceptionComposedFuture, MyRuntimeException.class);
        SettableFuture errorInput = SettableFuture.create();
        ListenableFuture errorComposedFuture = Futures.transform((ListenableFuture)errorInput, FuturesTest.newOneTimeErrorThrower());
        errorInput.set((Object)0);
        FuturesTest.runGetIdempotencyTest((Future<Integer>)errorComposedFuture, MyError.class);
        exceptionComposedFuture = Futures.transform((ListenableFuture)exceptionInput, FuturesTest.newOneTimeExceptionThrower());
        FuturesTest.runGetIdempotencyTest((Future<Integer>)exceptionComposedFuture, MyRuntimeException.class);
        FuturesTest.runGetIdempotencyTest((Future<Integer>)Futures.transform((ListenableFuture)errorInput, FuturesTest.newOneTimeErrorThrower()), MyError.class);
        FuturesTest.runGetIdempotencyTest((Future<Integer>)errorComposedFuture, MyError.class);
    }

    private static void runGetIdempotencyTest(Future<Integer> transformedFuture, Class<? extends Throwable> expectedExceptionClass) throws Throwable {
        for (int i = 0; i < 5; ++i) {
            try {
                transformedFuture.get();
                FuturesTest.fail();
                continue;
            }
            catch (ExecutionException expected) {
                if (expectedExceptionClass.isInstance(expected.getCause())) continue;
                throw expected.getCause();
            }
        }
    }

    private static Function<Integer, Integer> newOneTimeExceptionThrower() {
        return new Function<Integer, Integer>(){
            int calls = 0;

            public Integer apply(Integer from) {
                if (++this.calls > 1) {
                    Assert.fail();
                }
                throw new MyRuntimeException();
            }
        };
    }

    private static Function<Integer, Integer> newOneTimeErrorThrower() {
        return new Function<Integer, Integer>(){
            int calls = 0;

            public Integer apply(Integer from) {
                if (++this.calls > 1) {
                    Assert.fail();
                }
                throw new MyError();
            }
        };
    }

    public void testTransform_Executor() throws Exception {
        Object value = new Object();
        ExecutorSpy spy = new ExecutorSpy((Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertFalse((boolean)spy.wasExecuted);
        ListenableFuture future = Futures.transform((ListenableFuture)Futures.immediateFuture((Object)value), (Function)Functions.identity(), (Executor)spy);
        FuturesTest.assertSame((Object)value, (Object)future.get());
        FuturesTest.assertTrue((boolean)spy.wasExecuted);
    }

    public void testLazyTransform() throws Exception {
        FunctionSpy spy = new FunctionSpy(Functions.constant((Object)"bar"));
        ListenableFuture input = Futures.immediateFuture((Object)"foo");
        Future transformed = Futures.lazyTransform((Future)input, spy);
        FuturesTest.assertEquals((int)0, (int)spy.getApplyCount());
        FuturesTest.assertEquals((String)"bar", (String)((String)transformed.get()));
        FuturesTest.assertEquals((int)1, (int)spy.getApplyCount());
        FuturesTest.assertEquals((String)"bar", (String)((String)transformed.get()));
        FuturesTest.assertEquals((int)2, (int)spy.getApplyCount());
    }

    public void testLazyTransform_exception() throws Exception {
        final RuntimeException exception = new RuntimeException("deliberate");
        Function<Integer, String> function = new Function<Integer, String>(){

            public String apply(Integer input) {
                throw exception;
            }
        };
        Future transformed = Futures.lazyTransform((Future)Futures.immediateFuture((Object)1), (Function)function);
        try {
            transformed.get();
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
        try {
            transformed.get(1L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)exception, (Object)expected.getCause());
        }
    }

    public void testWithFallback_inputDoesNotRaiseException() throws Exception {
        FutureFallback fallback = (FutureFallback)this.mocksControl.createMock(FutureFallback.class);
        ListenableFuture originalFuture = Futures.immediateFuture((Object)7);
        this.mocksControl.replay();
        ListenableFuture faultToleranteFuture = Futures.withFallback((ListenableFuture)originalFuture, (FutureFallback)fallback);
        FuturesTest.assertEquals((int)7, (int)((Integer)faultToleranteFuture.get()));
        this.mocksControl.verify();
    }

    public void testWithFallback_inputRaisesException() throws Exception {
        FutureFallback fallback = (FutureFallback)this.mocksControl.createMock(FutureFallback.class);
        RuntimeException raisedException = new RuntimeException();
        EasyMock.expect((Object)fallback.create((Throwable)raisedException)).andReturn((Object)Futures.immediateFuture((Object)20));
        ListenableFuture failingFuture = Futures.immediateFailedFuture((Throwable)raisedException);
        this.mocksControl.replay();
        ListenableFuture faultToleranteFuture = Futures.withFallback((ListenableFuture)failingFuture, (FutureFallback)fallback);
        FuturesTest.assertEquals((int)20, (int)((Integer)faultToleranteFuture.get()));
        this.mocksControl.verify();
    }

    public void testWithFallback_fallbackGeneratesRuntimeException() throws Exception {
        RuntimeException expectedException = new RuntimeException();
        this.runExpectedExceptionFallbackTest(expectedException, false);
    }

    public void testWithFallback_fallbackGeneratesCheckedException() throws Exception {
        Exception expectedException = new Exception(){};
        this.runExpectedExceptionFallbackTest(expectedException, false);
    }

    public void testWithFallback_fallbackGeneratesError() throws Exception {
        final Error error = new Error("deliberate");
        FutureFallback<Integer> fallback = new FutureFallback<Integer>(){

            public ListenableFuture<Integer> create(Throwable t) throws Exception {
                throw error;
            }
        };
        ListenableFuture failingFuture = Futures.immediateFailedFuture((Throwable)new RuntimeException());
        try {
            Futures.withFallback((ListenableFuture)failingFuture, (FutureFallback)fallback).get();
            FuturesTest.fail((String)"An Exception should have been thrown!");
        }
        catch (ExecutionException expected) {
            FuturesTest.assertSame((Object)error, (Object)expected.getCause());
        }
    }

    public void testWithFallback_fallbackReturnsRuntimeException() throws Exception {
        RuntimeException expectedException = new RuntimeException();
        this.runExpectedExceptionFallbackTest(expectedException, true);
    }

    public void testWithFallback_fallbackReturnsCheckedException() throws Exception {
        Exception expectedException = new Exception(){};
        this.runExpectedExceptionFallbackTest(expectedException, true);
    }

    private void runExpectedExceptionFallbackTest(Throwable expectedException, boolean wrapInFuture) throws Exception {
        FutureFallback fallback = (FutureFallback)this.mocksControl.createMock(FutureFallback.class);
        RuntimeException raisedException = new RuntimeException();
        if (!wrapInFuture) {
            EasyMock.expect((Object)fallback.create((Throwable)raisedException)).andThrow(expectedException);
        } else {
            EasyMock.expect((Object)fallback.create((Throwable)raisedException)).andReturn((Object)Futures.immediateFailedFuture((Throwable)expectedException));
        }
        ListenableFuture failingFuture = Futures.immediateFailedFuture((Throwable)raisedException);
        this.mocksControl.replay();
        ListenableFuture faultToleranteFuture = Futures.withFallback((ListenableFuture)failingFuture, (FutureFallback)fallback);
        try {
            faultToleranteFuture.get();
            FuturesTest.fail((String)"An Exception should have been thrown!");
        }
        catch (ExecutionException ee) {
            FuturesTest.assertSame((Object)expectedException, (Object)ee.getCause());
        }
        this.mocksControl.verify();
    }

    public void testWithFallback_fallbackNotReady() throws Exception {
        ListenableFuture primary = Futures.immediateFailedFuture((Throwable)new Exception());
        final SettableFuture secondary = SettableFuture.create();
        FutureFallback<Integer> fallback = new FutureFallback<Integer>(){

            public ListenableFuture<Integer> create(Throwable t) {
                return secondary;
            }
        };
        ListenableFuture derived = Futures.withFallback((ListenableFuture)primary, (FutureFallback)fallback);
        secondary.set((Object)1);
        FuturesTest.assertEquals((int)1, (int)((Integer)derived.get()));
    }

    public void testWithFallback_resultInterruptedBeforeFallback() throws Exception {
        SettableFuture primary = SettableFuture.create();
        FutureFallback fallback = (FutureFallback)this.mocksControl.createMock(FutureFallback.class);
        this.mocksControl.replay();
        ListenableFuture derived = Futures.withFallback((ListenableFuture)primary, (FutureFallback)fallback);
        derived.cancel(true);
        FuturesTest.assertTrue((boolean)primary.isCancelled());
        FuturesTest.assertTrue((boolean)primary.wasInterrupted());
        this.mocksControl.verify();
    }

    public void testWithFallback_resultCancelledBeforeFallback() throws Exception {
        SettableFuture primary = SettableFuture.create();
        FutureFallback fallback = (FutureFallback)this.mocksControl.createMock(FutureFallback.class);
        this.mocksControl.replay();
        ListenableFuture derived = Futures.withFallback((ListenableFuture)primary, (FutureFallback)fallback);
        derived.cancel(false);
        FuturesTest.assertTrue((boolean)primary.isCancelled());
        FuturesTest.assertFalse((boolean)primary.wasInterrupted());
        this.mocksControl.verify();
    }

    public void testWithFallback_resultCancelledAfterFallback() throws Exception {
        SettableFuture secondary = SettableFuture.create();
        FutureFallback fallback = (FutureFallback)this.mocksControl.createMock(FutureFallback.class);
        RuntimeException raisedException = new RuntimeException();
        EasyMock.expect((Object)fallback.create((Throwable)raisedException)).andReturn((Object)secondary);
        ListenableFuture failingFuture = Futures.immediateFailedFuture((Throwable)raisedException);
        this.mocksControl.replay();
        ListenableFuture derived = Futures.withFallback((ListenableFuture)failingFuture, (FutureFallback)fallback);
        derived.cancel(false);
        FuturesTest.assertTrue((boolean)secondary.isCancelled());
        FuturesTest.assertFalse((boolean)secondary.wasInterrupted());
        this.mocksControl.verify();
    }

    public void testTransform_genericsWildcard_AsyncFunction() throws Exception {
        ListenableFuture nullFuture = Futures.immediateFuture(null);
        ListenableFuture chainedFuture = Futures.transform((ListenableFuture)nullFuture, FuturesTest.constantAsyncFunction(nullFuture));
        FuturesTest.assertNull((Object)chainedFuture.get());
    }

    private static <I, O> AsyncFunction<I, O> constantAsyncFunction(final ListenableFuture<O> output) {
        return new AsyncFunction<I, O>(){

            public ListenableFuture<O> apply(I input) {
                return output;
            }
        };
    }

    public void testTransform_genericsHierarchy_AsyncFunction() throws Exception {
        ListenableFuture future = Futures.immediateFuture(null);
        final BarChild barChild = new BarChild();
        AsyncFunction<Foo, BarChild> function = new AsyncFunction<Foo, BarChild>(){

            public AbstractFuture<BarChild> apply(Foo unused) {
                AbstractFuture<BarChild> future = new AbstractFuture<BarChild>(){};
                future.set((Object)barChild);
                return future;
            }
        };
        Bar bar = (Bar)Futures.transform((ListenableFuture)future, (AsyncFunction)function).get();
        FuturesTest.assertSame((Object)barChild, (Object)bar);
    }

    public void testTransform_asyncFunction_timeout() throws InterruptedException, ExecutionException {
        AsyncFunction function = FuturesTest.constantAsyncFunction(Futures.immediateFuture((Object)1));
        ListenableFuture future = Futures.transform((ListenableFuture)SettableFuture.create(), function);
        try {
            future.get(1L, TimeUnit.MILLISECONDS);
            FuturesTest.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void testTransform_asyncFunction_error() throws InterruptedException {
        final Error error = new Error("deliberate");
        AsyncFunction<String, Integer> function = new AsyncFunction<String, Integer>(){

            public ListenableFuture<Integer> apply(String input) {
                throw error;
            }
        };
        SettableFuture inputFuture = SettableFuture.create();
        ListenableFuture outputFuture = Futures.transform((ListenableFuture)inputFuture, (AsyncFunction)function);
        inputFuture.set((Object)"value");
        try {
            outputFuture.get();
            FuturesTest.fail((String)"should have thrown error");
        }
        catch (ExecutionException e) {
            FuturesTest.assertSame((Object)error, (Object)e.getCause());
        }
    }

    public void testTransform_asyncFunction_cancelledWhileApplyingFunction() throws InterruptedException, ExecutionException {
        final CountDownLatch inFunction = new CountDownLatch(1);
        final CountDownLatch functionDone = new CountDownLatch(1);
        final SettableFuture resultFuture = SettableFuture.create();
        AsyncFunction<String, Integer> function = new AsyncFunction<String, Integer>(){

            public ListenableFuture<Integer> apply(String input) throws Exception {
                inFunction.countDown();
                functionDone.await();
                return resultFuture;
            }
        };
        SettableFuture inputFuture = SettableFuture.create();
        ListenableFuture future = Futures.transform((ListenableFuture)inputFuture, (AsyncFunction)function, (Executor)Executors.newSingleThreadExecutor());
        inputFuture.set((Object)"value");
        inFunction.await();
        future.cancel(false);
        functionDone.countDown();
        try {
            future.get();
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
        try {
            resultFuture.get();
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
    }

    public void testDereference_genericsWildcard() throws Exception {
        ListenableFuture inner = Futures.immediateFuture(null);
        ListenableFuture outer = Futures.immediateFuture((Object)inner);
        ListenableFuture dereferenced = Futures.dereference((ListenableFuture)outer);
        FuturesTest.assertNull((Object)dereferenced.get());
    }

    public void testDereference_genericsHierarchy() throws Exception {
        FooChild fooChild = new FooChild();
        ListenableFuture inner = Futures.immediateFuture((Object)fooChild);
        ListenableFuture outer = Futures.immediateFuture((Object)inner);
        ListenableFuture dereferenced = Futures.dereference((ListenableFuture)outer);
        FuturesTest.assertSame((Object)fooChild, (Object)dereferenced.get());
    }

    public void testDereference_resultCancelsOuter() throws Exception {
        SettableFuture outer = SettableFuture.create();
        ListenableFuture dereferenced = Futures.dereference((ListenableFuture)outer);
        dereferenced.cancel(true);
        FuturesTest.assertTrue((boolean)outer.isCancelled());
    }

    public void testDereference_resultCancelsInner() throws Exception {
        SettableFuture inner = SettableFuture.create();
        ListenableFuture outer = Futures.immediateFuture((Object)inner);
        ListenableFuture dereferenced = Futures.dereference((ListenableFuture)outer);
        dereferenced.cancel(true);
        FuturesTest.assertTrue((boolean)inner.isCancelled());
    }

    public void testDereference_outerCancelsResult() throws Exception {
        SettableFuture outer = SettableFuture.create();
        ListenableFuture dereferenced = Futures.dereference((ListenableFuture)outer);
        outer.cancel(true);
        FuturesTest.assertTrue((boolean)dereferenced.isCancelled());
    }

    public void testDereference_innerCancelsResult() throws Exception {
        SettableFuture inner = SettableFuture.create();
        ListenableFuture outer = Futures.immediateFuture((Object)inner);
        ListenableFuture dereferenced = Futures.dereference((ListenableFuture)outer);
        inner.cancel(true);
        FuturesTest.assertTrue((boolean)dereferenced.isCancelled());
    }

    public void testAllAsList() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2, future3});
        SingleCallListener listener = new SingleCallListener();
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertFalse((boolean)compound.isDone());
        future1.set((Object)DATA1);
        FuturesTest.assertFalse((boolean)compound.isDone());
        future2.set((Object)DATA2);
        FuturesTest.assertFalse((boolean)compound.isDone());
        listener.expectCall();
        future3.set((Object)DATA3);
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)compound.get();
        Truth.ASSERT.that(results).has().exactly((Object)DATA1, (Object)DATA2, (Object[])new String[]{DATA3}).inOrder();
    }

    public void testAllAsList_emptyList() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        listener.expectCall();
        ImmutableList futures = ImmutableList.of();
        ListenableFuture compound = Futures.allAsList((Iterable)futures);
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)((List)compound.get()).isEmpty());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
    }

    public void testAllAsList_emptyArray() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        listener.expectCall();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[0]);
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)((List)compound.get()).isEmpty());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
    }

    public void testAllAsList_failure() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        listener.expectCall();
        Throwable exception = new Throwable("failed1");
        future1.setException(exception);
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        future2.set((Object)"result2");
        try {
            compound.get();
            FuturesTest.fail((String)"Expected exception not thrown");
        }
        catch (ExecutionException e) {
            FuturesTest.assertSame((Object)exception, (Object)e.getCause());
        }
    }

    public void testAllAsList_singleFailure() throws Exception {
        Throwable exception = new Throwable("failed");
        ListenableFuture future = Futures.immediateFailedFuture((Throwable)exception);
        ListenableFuture compound = Futures.allAsList((Iterable)ImmutableList.of((Object)future));
        try {
            compound.get();
            FuturesTest.fail((String)"Expected exception not thrown");
        }
        catch (ExecutionException e) {
            FuturesTest.assertSame((Object)exception, (Object)e.getCause());
        }
    }

    public void testAllAsList_immediateFailure() throws Exception {
        Throwable exception = new Throwable("failed");
        ListenableFuture future1 = Futures.immediateFailedFuture((Throwable)exception);
        ListenableFuture future2 = Futures.immediateFuture((Object)"results");
        ListenableFuture compound = Futures.allAsList((Iterable)ImmutableList.of((Object)future1, (Object)future2));
        try {
            compound.get();
            FuturesTest.fail((String)"Expected exception not thrown");
        }
        catch (ExecutionException e) {
            FuturesTest.assertSame((Object)exception, (Object)e.getCause());
        }
    }

    public void testAllAsList_error() throws Exception {
        Error error = new Error("deliberate");
        SettableFuture future1 = SettableFuture.create();
        ListenableFuture future2 = Futures.immediateFuture((Object)"results");
        ListenableFuture compound = Futures.allAsList((Iterable)ImmutableList.of((Object)future1, (Object)future2));
        future1.setException((Throwable)error);
        try {
            compound.get();
            FuturesTest.fail((String)"Expected error not set in compound future.");
        }
        catch (ExecutionException ee) {
            FuturesTest.assertSame((Object)error, (Object)ee.getCause());
        }
    }

    public void testAllAsList_cancelled() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        listener.expectCall();
        future1.cancel(true);
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        future2.setException(new Throwable("failed2"));
        try {
            compound.get();
            FuturesTest.fail((String)"Expected exception not thrown");
        }
        catch (CancellationException e) {
            // empty catch block
        }
    }

    public void testAllAsList_resultCancelled() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        future2.set((Object)DATA2);
        FuturesTest.assertFalse((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)compound.cancel(false));
        FuturesTest.assertTrue((boolean)compound.isCancelled());
        FuturesTest.assertTrue((boolean)future1.isCancelled());
        FuturesTest.assertFalse((boolean)future1.wasInterrupted());
    }

    public void testAllAsList_resultInterrupted() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        future2.set((Object)DATA2);
        FuturesTest.assertFalse((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)compound.cancel(true));
        FuturesTest.assertTrue((boolean)compound.isCancelled());
        FuturesTest.assertTrue((boolean)future1.isCancelled());
        FuturesTest.assertTrue((boolean)future1.wasInterrupted());
    }

    public void testAllAsList_doneFutures() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        future1.set((Object)DATA1);
        future2.set((Object)DATA2);
        future3.set((Object)DATA3);
        ListenableFuture compound = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{future1, future2, future3});
        SingleCallListener listener = new SingleCallListener();
        listener.expectCall();
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)compound.get();
        Truth.ASSERT.that(results).has().exactly((Object)DATA1, (Object)DATA2, (Object[])new String[]{DATA3}).inOrder();
    }

    public void testAllAsList_logging_exception() throws Exception {
        try {
            Futures.allAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)new MyException())}).get();
            FuturesTest.fail();
        }
        catch (ExecutionException e) {
            FuturesTest.assertTrue((boolean)(e.getCause() instanceof MyException));
            FuturesTest.assertEquals((String)"Nothing should be logged", (int)0, (int)this.combinedFutureLogHandler.getStoredLogRecords().size());
        }
    }

    public void testAllAsList_logging_error() throws Exception {
        try {
            Futures.allAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)new MyError())}).get();
            FuturesTest.fail();
        }
        catch (ExecutionException e) {
            FuturesTest.assertTrue((boolean)(e.getCause() instanceof MyError));
            List logged = this.combinedFutureLogHandler.getStoredLogRecords();
            FuturesTest.assertEquals((int)1, (int)logged.size());
            FuturesTest.assertTrue((boolean)(((LogRecord)logged.get(0)).getThrown() instanceof MyError));
        }
    }

    public void testAllAsList_logging_multipleExceptions() throws Exception {
        try {
            Futures.allAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)new MyException()), Futures.immediateFailedFuture((Throwable)new MyException())}).get();
            FuturesTest.fail();
        }
        catch (ExecutionException e) {
            FuturesTest.assertTrue((boolean)(e.getCause() instanceof MyException));
            List logged = this.combinedFutureLogHandler.getStoredLogRecords();
            FuturesTest.assertEquals((int)1, (int)logged.size());
            FuturesTest.assertTrue((boolean)(((LogRecord)logged.get(0)).getThrown() instanceof MyException));
        }
    }

    private static String createCombinedResult(Integer i, Boolean b) {
        return "-" + i + "-" + b;
    }

    private static <V> V pseudoTimedGet(final Future<V> input, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future waiter = executor.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return input.get();
            }
        });
        try {
            Object t = waiter.get(timeout, unit);
            return (V)t;
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), ExecutionException.class);
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), CancellationException.class);
            AssertionFailedError error = new AssertionFailedError("Unexpected exception");
            error.initCause((Throwable)e);
            throw error;
        }
        finally {
            executor.shutdownNow();
            FuturesTest.assertTrue((boolean)executor.awaitTermination(10L, TimeUnit.SECONDS));
        }
    }

    private static void runExtensiveMergerTest(Merger merger) throws InterruptedException {
        int inputCount = new TestFutureBatch().allFutures.size();
        for (int i = 0; i < inputCount; ++i) {
            for (int j = 0; j < inputCount; ++j) {
                for (boolean iBeforeJ : new boolean[]{true, false}) {
                    List result;
                    TestFutureBatch inputs = new TestFutureBatch();
                    ListenableFuture<String> iFuture = ((TestFuture)inputs.allFutures.get((int)i)).future;
                    ListenableFuture<String> jFuture = ((TestFuture)inputs.allFutures.get((int)j)).future;
                    ListenableFuture<List<String>> future = merger.merged(iFuture, jFuture);
                    try {
                        result = (List)future.get(0L, TimeUnit.MILLISECONDS);
                        FuturesTest.assertTrue((String)("Got " + result), (boolean)Arrays.asList("a", null).containsAll(result));
                    }
                    catch (CancellationException e) {
                        FuturesTest.assertTrue((merger == Merger.allMerger ? 1 : 0) != 0);
                        inputs.assertHasImmediateCancel(iFuture, jFuture, e);
                    }
                    catch (ExecutionException e) {
                        FuturesTest.assertTrue((merger == Merger.allMerger ? 1 : 0) != 0);
                        inputs.assertHasImmediateFailure(iFuture, jFuture, e);
                    }
                    catch (TimeoutException e) {
                        inputs.assertHasDelayed(iFuture, jFuture, e);
                    }
                    try {
                        result = FuturesTest.conditionalPseudoTimedGet(inputs, iFuture, jFuture, future, 20, TimeUnit.MILLISECONDS);
                        FuturesTest.assertTrue((String)("Got " + result), (boolean)Arrays.asList("a", null).containsAll(result));
                    }
                    catch (CancellationException e) {
                        FuturesTest.assertTrue((merger == Merger.allMerger ? 1 : 0) != 0);
                        inputs.assertHasImmediateCancel(iFuture, jFuture, e);
                    }
                    catch (ExecutionException e) {
                        FuturesTest.assertTrue((merger == Merger.allMerger ? 1 : 0) != 0);
                        inputs.assertHasImmediateFailure(iFuture, jFuture, e);
                    }
                    catch (TimeoutException e) {
                        inputs.assertHasDelayed(iFuture, jFuture, e);
                    }
                    ((TestFuture)inputs.allFutures.get((int)(iBeforeJ ? i : j))).finisher.run();
                    ((TestFuture)inputs.allFutures.get((int)(iBeforeJ ? j : i))).finisher.run();
                    try {
                        result = (List)future.get();
                        FuturesTest.assertTrue((String)("Got " + result), (boolean)Arrays.asList("a", "b", null).containsAll(result));
                    }
                    catch (CancellationException e) {
                        FuturesTest.assertTrue((merger == Merger.allMerger ? 1 : 0) != 0);
                        inputs.assertHasCancel(iFuture, jFuture, e);
                    }
                    catch (ExecutionException e) {
                        FuturesTest.assertTrue((merger == Merger.allMerger ? 1 : 0) != 0);
                        inputs.assertHasFailure(iFuture, jFuture, e);
                    }
                }
            }
        }
    }

    private static List<String> conditionalPseudoTimedGet(TestFutureBatch inputs, ListenableFuture<String> iFuture, ListenableFuture<String> jFuture, ListenableFuture<List<String>> future, int timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return inputs.hasDelayed(iFuture, jFuture) ? FuturesTest.pseudoTimedGet(future, timeout, unit) : FuturesTest.pseudoTimedGet(future, 2500L, TimeUnit.MILLISECONDS);
    }

    public void testAllAsList_extensive() throws InterruptedException {
        FuturesTest.runExtensiveMergerTest(Merger.allMerger);
    }

    public void testSuccessfulAsList_extensive() throws InterruptedException {
        FuturesTest.runExtensiveMergerTest(Merger.successMerger);
    }

    public void testSuccessfulAsList() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2, future3});
        SingleCallListener listener = new SingleCallListener();
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertFalse((boolean)compound.isDone());
        future1.set((Object)DATA1);
        FuturesTest.assertFalse((boolean)compound.isDone());
        future2.set((Object)DATA2);
        FuturesTest.assertFalse((boolean)compound.isDone());
        listener.expectCall();
        future3.set((Object)DATA3);
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)compound.get();
        Truth.ASSERT.that(results).has().exactly((Object)DATA1, (Object)DATA2, (Object[])new String[]{DATA3}).inOrder();
    }

    public void testSuccessfulAsList_emptyList() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        listener.expectCall();
        ImmutableList futures = ImmutableList.of();
        ListenableFuture compound = Futures.successfulAsList((Iterable)futures);
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)((List)compound.get()).isEmpty());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
    }

    public void testSuccessfulAsList_emptyArray() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        listener.expectCall();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[0]);
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)((List)compound.get()).isEmpty());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
    }

    public void testSuccessfulAsList_partialFailure() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertFalse((boolean)compound.isDone());
        future1.setException(new Throwable("failed1"));
        FuturesTest.assertFalse((boolean)compound.isDone());
        listener.expectCall();
        future2.set((Object)DATA2);
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)compound.get();
        Truth.ASSERT.that(results).has().exactly(null, (Object)DATA2, (Object[])new String[0]).inOrder();
    }

    public void testSuccessfulAsList_totalFailure() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertFalse((boolean)compound.isDone());
        future1.setException(new Throwable("failed1"));
        FuturesTest.assertFalse((boolean)compound.isDone());
        listener.expectCall();
        future2.setException(new Throwable("failed2"));
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)compound.get();
        Truth.ASSERT.that(results).has().exactly(null, null, (Object[])new String[0]).inOrder();
    }

    public void testSuccessfulAsList_cancelled() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertFalse((boolean)compound.isDone());
        future1.cancel(true);
        FuturesTest.assertFalse((boolean)compound.isDone());
        listener.expectCall();
        future2.set((Object)DATA2);
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)compound.get();
        Truth.ASSERT.that(results).has().exactly(null, (Object)DATA2, (Object[])new String[0]).inOrder();
    }

    public void testSuccessfulAsList_resultCancelled() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        future2.set((Object)DATA2);
        FuturesTest.assertFalse((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)compound.cancel(false));
        FuturesTest.assertTrue((boolean)compound.isCancelled());
        FuturesTest.assertTrue((boolean)future1.isCancelled());
        FuturesTest.assertFalse((boolean)future1.wasInterrupted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSuccessfulAsList_resultCancelledRacingInputDone() throws Exception {
        Handler throwingHandler = new Handler(){

            public void publish(@Nullable LogRecord record) {
                AssertionFailedError error = new AssertionFailedError();
                error.initCause(record.getThrown());
                throw error;
            }

            public void flush() {
            }

            public void close() {
            }
        };
        ExecutionList.log.addHandler(throwingHandler);
        try {
            FuturesTest.doTestSuccessfulAsList_resultCancelledRacingInputDone();
        }
        finally {
            ExecutionList.log.removeHandler(throwingHandler);
        }
    }

    private static void doTestSuccessfulAsList_resultCancelledRacingInputDone() throws Exception {
        Futures.successfulAsList((Iterable)ImmutableList.of((Object)SettableFuture.create())).cancel(true);
        final SettableFuture future1 = SettableFuture.create();
        final SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        future1.addListener(new Runnable(){

            public void run() {
                Assert.assertTrue((boolean)future1.isCancelled());
                Assert.assertFalse((boolean)future2.isCancelled());
                future2.set((Object)FuturesTest.DATA2);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertTrue((boolean)compound.cancel(false));
        FuturesTest.assertTrue((boolean)compound.isCancelled());
        FuturesTest.assertTrue((boolean)future1.isCancelled());
        FuturesTest.assertFalse((boolean)future2.isCancelled());
        try {
            compound.get();
            FuturesTest.fail((String)"Expected exception not thrown");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testSuccessfulAsList_resultInterrupted() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2});
        future2.set((Object)DATA2);
        FuturesTest.assertFalse((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)compound.cancel(true));
        FuturesTest.assertTrue((boolean)compound.isCancelled());
        FuturesTest.assertTrue((boolean)future1.isCancelled());
        FuturesTest.assertTrue((boolean)future1.wasInterrupted());
    }

    public void testSuccessfulAsList_mixed() throws Exception {
        SingleCallListener listener = new SingleCallListener();
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        ListenableFuture compound = Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{future1, future2, future3});
        compound.addListener((Runnable)listener, (Executor)MoreExecutors.sameThreadExecutor());
        FuturesTest.assertFalse((boolean)compound.isDone());
        future1.cancel(true);
        FuturesTest.assertFalse((boolean)compound.isDone());
        future2.setException(new Throwable("failed2"));
        FuturesTest.assertFalse((boolean)compound.isDone());
        listener.expectCall();
        future3.set((Object)DATA3);
        FuturesTest.assertTrue((boolean)compound.isDone());
        FuturesTest.assertTrue((boolean)listener.wasCalled());
        List results = (List)compound.get();
        Truth.ASSERT.that(results).has().exactly(null, null, (Object[])new String[]{DATA3}).inOrder();
    }

    public void testSuccessfulAsList_logging_exception() throws Exception {
        FuturesTest.assertEquals((Object)Lists.newArrayList((Object[])new Object[]{null}), (Object)Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)new MyException())}).get());
        FuturesTest.assertEquals((String)"Nothing should be logged", (int)0, (int)this.combinedFutureLogHandler.getStoredLogRecords().size());
        FuturesTest.assertEquals((Object)Lists.newArrayList((Object[])new Object[]{null, null, null}), (Object)Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)new MyException()), Futures.immediateFailedFuture((Throwable)new MyException()), Futures.immediateFailedFuture((Throwable)new MyException())}).get());
        FuturesTest.assertEquals((String)"Nothing should be logged", (int)0, (int)this.combinedFutureLogHandler.getStoredLogRecords().size());
    }

    public void testSuccessfulAsList_logging_error() throws Exception {
        FuturesTest.assertEquals((Object)Lists.newArrayList((Object[])new Object[]{null}), (Object)Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{Futures.immediateFailedFuture((Throwable)new MyError())}).get());
        List logged = this.combinedFutureLogHandler.getStoredLogRecords();
        FuturesTest.assertEquals((int)1, (int)logged.size());
        FuturesTest.assertTrue((boolean)(((LogRecord)logged.get(0)).getThrown() instanceof MyError));
    }

    public void testNonCancellationPropagating_successful() throws Exception {
        SettableFuture input = SettableFuture.create();
        ListenableFuture wrapper = Futures.nonCancellationPropagating((ListenableFuture)input);
        Foo foo = new Foo();
        FuturesTest.assertFalse((boolean)wrapper.isDone());
        input.set((Object)foo);
        FuturesTest.assertTrue((boolean)wrapper.isDone());
        FuturesTest.assertSame((Object)foo, (Object)wrapper.get());
    }

    public void testNonCancellationPropagating_failure() throws Exception {
        SettableFuture input = SettableFuture.create();
        ListenableFuture wrapper = Futures.nonCancellationPropagating((ListenableFuture)input);
        Throwable failure = new Throwable("thrown");
        FuturesTest.assertFalse((boolean)wrapper.isDone());
        input.setException(failure);
        FuturesTest.assertTrue((boolean)wrapper.isDone());
        try {
            wrapper.get();
            FuturesTest.fail((String)"Expected ExecutionException");
        }
        catch (ExecutionException e) {
            FuturesTest.assertSame((Object)failure, (Object)e.getCause());
        }
    }

    public void testNonCancellationPropagating_delegateCancelled() throws Exception {
        SettableFuture input = SettableFuture.create();
        ListenableFuture wrapper = Futures.nonCancellationPropagating((ListenableFuture)input);
        FuturesTest.assertFalse((boolean)wrapper.isDone());
        FuturesTest.assertTrue((boolean)input.cancel(false));
        FuturesTest.assertTrue((boolean)wrapper.isCancelled());
    }

    public void testNonCancellationPropagating_doesNotPropagate() throws Exception {
        SettableFuture input = SettableFuture.create();
        ListenableFuture wrapper = Futures.nonCancellationPropagating((ListenableFuture)input);
        FuturesTest.assertTrue((boolean)wrapper.cancel(true));
        FuturesTest.assertTrue((boolean)wrapper.isCancelled());
        FuturesTest.assertTrue((boolean)wrapper.isDone());
        FuturesTest.assertFalse((boolean)input.isCancelled());
        FuturesTest.assertFalse((boolean)input.isDone());
    }

    public void testMakeChecked_mapsExecutionExceptions() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, mapper);
        future.setException((Throwable)new IOException("checked"));
        FuturesTest.assertTrue((boolean)checked.isDone());
        FuturesTest.assertFalse((boolean)checked.isCancelled());
        try {
            checked.get();
            FuturesTest.fail();
        }
        catch (ExecutionException e) {
            FuturesTest.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
        try {
            checked.get(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (ExecutionException e) {
            FuturesTest.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
        try {
            checked.checkedGet();
            FuturesTest.fail();
        }
        catch (TestException e) {
            FuturesTest.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
        try {
            checked.checkedGet(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (TestException e) {
            FuturesTest.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }

    public void testMakeChecked_mapsInterruption() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, mapper);
        Thread.currentThread().interrupt();
        try {
            checked.get();
            FuturesTest.fail();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Thread.currentThread().interrupt();
        try {
            checked.get(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Thread.currentThread().interrupt();
        try {
            checked.checkedGet();
            FuturesTest.fail();
        }
        catch (TestException e) {
            FuturesTest.assertTrue((boolean)(e.getCause() instanceof InterruptedException));
        }
        Thread.currentThread().interrupt();
        try {
            checked.checkedGet(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (TestException e) {
            FuturesTest.assertTrue((boolean)(e.getCause() instanceof InterruptedException));
        }
    }

    public void testMakeChecked_mapsCancellation() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, mapper);
        FuturesTest.assertTrue((boolean)future.cancel(true));
        try {
            checked.get();
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
        try {
            checked.get(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
        try {
            checked.checkedGet();
            FuturesTest.fail();
        }
        catch (TestException expected) {
            FuturesTest.assertTrue((boolean)(expected.getCause() instanceof CancellationException));
        }
        try {
            checked.checkedGet(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (TestException expected) {
            FuturesTest.assertTrue((boolean)(expected.getCause() instanceof CancellationException));
        }
    }

    public void testMakeChecked_propagatesFailedMappers() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, (Function)new Function<Exception, TestException>(){

            public TestException apply(Exception from) {
                throw new NullPointerException();
            }
        });
        future.setException((Throwable)new Exception("failed"));
        try {
            checked.checkedGet();
            FuturesTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            checked.checkedGet(5L, TimeUnit.SECONDS);
            FuturesTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testMakeChecked_listenersRunOnceCompleted() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, (Function)new Function<Exception, TestException>(){

            public TestException apply(Exception from) {
                throw new NullPointerException();
            }
        });
        ListenableFutureTester tester = new ListenableFutureTester((ListenableFuture<?>)checked);
        tester.setUp();
        future.set((Object)DATA1);
        tester.testCompletedFuture(DATA1);
        tester.tearDown();
    }

    public void testMakeChecked_listenersRunOnCancel() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, (Function)new Function<Exception, TestException>(){

            public TestException apply(Exception from) {
                throw new NullPointerException();
            }
        });
        ListenableFutureTester tester = new ListenableFutureTester((ListenableFuture<?>)checked);
        tester.setUp();
        future.cancel(true);
        tester.testCancelledFuture();
        tester.tearDown();
    }

    public void testMakeChecked_listenersRunOnFailure() throws Exception {
        SettableFuture future = SettableFuture.create();
        CheckedFuture checked = Futures.makeChecked((ListenableFuture)future, (Function)new Function<Exception, TestException>(){

            public TestException apply(Exception from) {
                throw new NullPointerException();
            }
        });
        ListenableFutureTester tester = new ListenableFutureTester((ListenableFuture<?>)checked);
        tester.setUp();
        future.setException((Throwable)new Exception("failed"));
        tester.testFailedFuture("failed");
        tester.tearDown();
    }

    public void testGetUntimed_success() throws TwoArgConstructorException {
        FuturesTest.assertEquals((String)"foo", (String)((String)Futures.get((Future)Futures.immediateFuture((Object)"foo"), TwoArgConstructorException.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetUntimed_interrupted() {
        SettableFuture future = SettableFuture.create();
        Thread.currentThread().interrupt();
        try {
            Futures.get((Future)future, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (TwoArgConstructorException expected) {
            FuturesTest.assertTrue((boolean)(expected.getCause() instanceof InterruptedException));
            FuturesTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    public void testGetUntimed_cancelled() throws TwoArgConstructorException {
        SettableFuture future = SettableFuture.create();
        future.cancel(true);
        try {
            Futures.get((Future)future, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testGetUntimed_ExecutionExceptionChecked() {
        try {
            Futures.get(FAILED_FUTURE_CHECKED_EXCEPTION, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (TwoArgConstructorException expected) {
            FuturesTest.assertEquals((Object)CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetUntimed_ExecutionExceptionUnchecked() throws TwoArgConstructorException {
        try {
            Futures.get(FAILED_FUTURE_UNCHECKED_EXCEPTION, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            FuturesTest.assertEquals((Object)UNCHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetUntimed_ExecutionExceptionError() throws TwoArgConstructorException {
        try {
            Futures.get(FAILED_FUTURE_ERROR, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (ExecutionError expected) {
            FuturesTest.assertEquals((Object)ERROR, (Object)expected.getCause());
        }
    }

    public void testGetUntimed_ExecutionExceptionOtherThrowable() {
        try {
            Futures.get(FAILED_FUTURE_OTHER_THROWABLE, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (TwoArgConstructorException expected) {
            FuturesTest.assertEquals((Object)OTHER_THROWABLE, (Object)expected.getCause());
        }
    }

    public void testGetUntimed_RuntimeException() throws TwoArgConstructorException {
        try {
            Futures.get(RUNTIME_EXCEPTION_FUTURE, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (RuntimeException expected) {
            FuturesTest.assertEquals((Object)RUNTIME_EXCEPTION, (Object)expected);
        }
    }

    public void testGetUntimed_badExceptionConstructor_wrapsOriginalChecked() throws Exception {
        try {
            Futures.get(FAILED_FUTURE_CHECKED_EXCEPTION, ExceptionWithBadConstructor.class);
            FuturesTest.fail();
        }
        catch (IllegalArgumentException expected) {
            FuturesTest.assertSame((Object)CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetUntimed_withGoodAndBadExceptionConstructor() throws Exception {
        try {
            Futures.get(FAILED_FUTURE_CHECKED_EXCEPTION, ExceptionWithGoodAndBadConstructor.class);
            FuturesTest.fail();
        }
        catch (ExceptionWithGoodAndBadConstructor expected) {
            FuturesTest.assertSame((Object)CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetTimed_success() throws TwoArgConstructorException {
        FuturesTest.assertEquals((String)"foo", (String)((String)Futures.get((Future)Futures.immediateFuture((Object)"foo"), (long)0L, (TimeUnit)TimeUnit.SECONDS, TwoArgConstructorException.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetTimed_interrupted() {
        SettableFuture future = SettableFuture.create();
        Thread.currentThread().interrupt();
        try {
            Futures.get((Future)future, (long)0L, (TimeUnit)TimeUnit.SECONDS, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (TwoArgConstructorException expected) {
            FuturesTest.assertTrue((boolean)(expected.getCause() instanceof InterruptedException));
            FuturesTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    public void testGetTimed_cancelled() throws TwoArgConstructorException {
        SettableFuture future = SettableFuture.create();
        future.cancel(true);
        try {
            Futures.get((Future)future, (long)0L, (TimeUnit)TimeUnit.SECONDS, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testGetTimed_ExecutionExceptionChecked() {
        try {
            Futures.get(FAILED_FUTURE_CHECKED_EXCEPTION, (long)0L, (TimeUnit)TimeUnit.SECONDS, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (TwoArgConstructorException expected) {
            FuturesTest.assertEquals((Object)CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetTimed_ExecutionExceptionUnchecked() throws TwoArgConstructorException {
        try {
            Futures.get(FAILED_FUTURE_UNCHECKED_EXCEPTION, (long)0L, (TimeUnit)TimeUnit.SECONDS, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            FuturesTest.assertEquals((Object)UNCHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetTimed_ExecutionExceptionError() throws TwoArgConstructorException {
        try {
            Futures.get(FAILED_FUTURE_ERROR, (long)0L, (TimeUnit)TimeUnit.SECONDS, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (ExecutionError expected) {
            FuturesTest.assertEquals((Object)ERROR, (Object)expected.getCause());
        }
    }

    public void testGetTimed_ExecutionExceptionOtherThrowable() {
        try {
            Futures.get(FAILED_FUTURE_OTHER_THROWABLE, (long)0L, (TimeUnit)TimeUnit.SECONDS, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (TwoArgConstructorException expected) {
            FuturesTest.assertEquals((Object)OTHER_THROWABLE, (Object)expected.getCause());
        }
    }

    public void testGetTimed_RuntimeException() throws TwoArgConstructorException {
        try {
            Futures.get(RUNTIME_EXCEPTION_FUTURE, (long)0L, (TimeUnit)TimeUnit.SECONDS, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (RuntimeException expected) {
            FuturesTest.assertEquals((Object)RUNTIME_EXCEPTION, (Object)expected);
        }
    }

    public void testGetTimed_TimeoutException() {
        SettableFuture future = SettableFuture.create();
        try {
            Futures.get((Future)future, (long)0L, (TimeUnit)TimeUnit.SECONDS, TwoArgConstructorException.class);
            FuturesTest.fail();
        }
        catch (TwoArgConstructorException expected) {
            FuturesTest.assertTrue((boolean)(expected.getCause() instanceof TimeoutException));
        }
    }

    public void testGetTimed_badExceptionConstructor_wrapsOriginalChecked() throws Exception {
        try {
            Futures.get(FAILED_FUTURE_CHECKED_EXCEPTION, (long)1L, (TimeUnit)TimeUnit.SECONDS, ExceptionWithBadConstructor.class);
            FuturesTest.fail();
        }
        catch (IllegalArgumentException expected) {
            FuturesTest.assertSame((Object)CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetTimed_withGoodAndBadExceptionConstructor() throws Exception {
        try {
            Futures.get(FAILED_FUTURE_CHECKED_EXCEPTION, (long)1L, (TimeUnit)TimeUnit.SECONDS, ExceptionWithGoodAndBadConstructor.class);
            FuturesTest.fail();
        }
        catch (ExceptionWithGoodAndBadConstructor expected) {
            FuturesTest.assertSame((Object)CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetUnchecked_success() {
        FuturesTest.assertEquals((String)"foo", (String)((String)Futures.getUnchecked((Future)Futures.immediateFuture((Object)"foo"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetUnchecked_interrupted() {
        Thread.currentThread().interrupt();
        try {
            FuturesTest.assertEquals((String)"foo", (String)((String)Futures.getUnchecked((Future)Futures.immediateFuture((Object)"foo"))));
            FuturesTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    public void testGetUnchecked_cancelled() {
        SettableFuture future = SettableFuture.create();
        future.cancel(true);
        try {
            Futures.getUnchecked((Future)future);
            FuturesTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testGetUnchecked_ExecutionExceptionChecked() {
        try {
            Futures.getUnchecked(FAILED_FUTURE_CHECKED_EXCEPTION);
            FuturesTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            FuturesTest.assertEquals((Object)CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetUnchecked_ExecutionExceptionUnchecked() {
        try {
            Futures.getUnchecked(FAILED_FUTURE_UNCHECKED_EXCEPTION);
            FuturesTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            FuturesTest.assertEquals((Object)UNCHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetUnchecked_ExecutionExceptionError() {
        try {
            Futures.getUnchecked(FAILED_FUTURE_ERROR);
            FuturesTest.fail();
        }
        catch (ExecutionError expected) {
            FuturesTest.assertEquals((Object)ERROR, (Object)expected.getCause());
        }
    }

    public void testGetUnchecked_ExecutionExceptionOtherThrowable() {
        try {
            Futures.getUnchecked(FAILED_FUTURE_OTHER_THROWABLE);
            FuturesTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            FuturesTest.assertEquals((Object)OTHER_THROWABLE, (Object)expected.getCause());
        }
    }

    public void testGetUnchecked_RuntimeException() {
        try {
            Futures.getUnchecked(RUNTIME_EXCEPTION_FUTURE);
            FuturesTest.fail();
        }
        catch (RuntimeException expected) {
            FuturesTest.assertEquals((Object)RUNTIME_EXCEPTION, (Object)expected);
        }
    }

    public void testGetUntimed_exceptionClassIsRuntimeException() {
        try {
            Futures.get(FAILED_FUTURE_CHECKED_EXCEPTION, TwoArgConstructorRuntimeException.class);
            FuturesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetUntimed_exceptionClassSomePublicConstructors() {
        try {
            Futures.get(FAILED_FUTURE_CHECKED_EXCEPTION, ExceptionWithSomePrivateConstructors.class);
            FuturesTest.fail();
        }
        catch (ExceptionWithSomePrivateConstructors exceptionWithSomePrivateConstructors) {
            // empty catch block
        }
    }

    public void testGetUntimed_exceptionClassNoPublicConstructor() throws ExceptionWithPrivateConstructor {
        try {
            Futures.get(FAILED_FUTURE_CHECKED_EXCEPTION, ExceptionWithPrivateConstructor.class);
            FuturesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetUntimed_exceptionClassPublicConstructorWrongType() throws ExceptionWithWrongTypesConstructor {
        try {
            Futures.get(FAILED_FUTURE_CHECKED_EXCEPTION, ExceptionWithWrongTypesConstructor.class);
            FuturesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetUntimed_exceptionClassPrefersStringConstructor() {
        try {
            Futures.get(FAILED_FUTURE_CHECKED_EXCEPTION, ExceptionWithManyConstructors.class);
            FuturesTest.fail();
        }
        catch (ExceptionWithManyConstructors expected) {
            FuturesTest.assertTrue((boolean)expected.usedExpectedConstructor);
        }
    }

    public void testGetUntimed_exceptionClassUsedInitCause() {
        try {
            Futures.get(FAILED_FUTURE_CHECKED_EXCEPTION, ExceptionWithoutThrowableConstructor.class);
            FuturesTest.fail();
        }
        catch (ExceptionWithoutThrowableConstructor expected) {
            Truth.ASSERT.that(expected.getMessage()).contains("mymessage");
            FuturesTest.assertEquals((Object)CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testCompletionOrder() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        SettableFuture future4 = SettableFuture.create();
        SettableFuture future5 = SettableFuture.create();
        ImmutableList futures = Futures.inCompletionOrder((Iterable)ImmutableList.of((Object)future1, (Object)future2, (Object)future3, (Object)future4, (Object)future5));
        future2.set((Object)1L);
        future5.set((Object)2L);
        future1.set((Object)3L);
        future3.set((Object)4L);
        future4.set((Object)5L);
        long expected = 1L;
        for (ListenableFuture future : futures) {
            FuturesTest.assertEquals((Object)expected, (Object)future.get());
            ++expected;
        }
    }

    public void testCompletionOrderExceptionThrown() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        SettableFuture future4 = SettableFuture.create();
        SettableFuture future5 = SettableFuture.create();
        ImmutableList futures = Futures.inCompletionOrder((Iterable)ImmutableList.of((Object)future1, (Object)future2, (Object)future3, (Object)future4, (Object)future5));
        future2.set((Object)1L);
        future5.setException((Throwable)new IllegalStateException("2L"));
        future1.set((Object)3L);
        future3.set((Object)4L);
        future4.set((Object)5L);
        long expected = 1L;
        for (ListenableFuture future : futures) {
            if (expected != 2L) {
                FuturesTest.assertEquals((Object)expected, (Object)future.get());
            } else {
                try {
                    future.get();
                    FuturesTest.fail();
                }
                catch (ExecutionException e) {
                    FuturesTest.assertEquals((String)"2L", (String)e.getCause().getMessage());
                }
            }
            ++expected;
        }
    }

    public void testCompletionOrderFutureCancelled() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        SettableFuture future4 = SettableFuture.create();
        SettableFuture future5 = SettableFuture.create();
        ImmutableList futures = Futures.inCompletionOrder((Iterable)ImmutableList.of((Object)future1, (Object)future2, (Object)future3, (Object)future4, (Object)future5));
        future2.set((Object)1L);
        future5.set((Object)2L);
        future1.set((Object)3L);
        future3.cancel(true);
        future4.set((Object)5L);
        long expected = 1L;
        for (ListenableFuture future : futures) {
            if (expected != 4L) {
                FuturesTest.assertEquals((Object)expected, (Object)future.get());
            } else {
                try {
                    future.get();
                    FuturesTest.fail();
                }
                catch (CancellationException e) {
                    // empty catch block
                }
            }
            ++expected;
        }
    }

    public void testCancellingADelegateDoesNotPropagate() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        ImmutableList delegates = Futures.inCompletionOrder((Iterable)ImmutableList.of((Object)future1, (Object)future2));
        future1.set((Object)1L);
        FuturesTest.assertFalse((boolean)((ListenableFuture)delegates.get(0)).cancel(true));
        FuturesTest.assertTrue((boolean)((ListenableFuture)delegates.get(1)).cancel(true));
        FuturesTest.assertTrue((boolean)future2.set((Object)2L));
        FuturesTest.assertEquals((Object)2L, (Object)future2.get());
    }

    public void testCompletionOrderMixedBagOTypes() throws Exception {
        SettableFuture future1 = SettableFuture.create();
        SettableFuture future2 = SettableFuture.create();
        SettableFuture future3 = SettableFuture.create();
        ImmutableList inputs = ImmutableList.of((Object)future1, (Object)future2, (Object)future3);
        ImmutableList futures = Futures.inCompletionOrder((Iterable)inputs);
        future2.set((Object)"1L");
        future1.set((Object)2L);
        future3.set((Object)3);
        ImmutableList expected = ImmutableList.of((Object)"1L", (Object)2L, (Object)3);
        for (int i = 0; i < expected.size(); ++i) {
            FuturesTest.assertEquals((Object)expected.get(i), (Object)((ListenableFuture)futures.get(i)).get());
        }
    }

    public void testFutures_nullChecks() throws Exception {
        new ClassSanityTester().forAllPublicStaticMethods(Futures.class).thatReturn(Future.class).testNulls();
    }

    private static void failWithCause(Throwable cause, String message) {
        AssertionFailedError failure = new AssertionFailedError(message);
        failure.initCause(cause);
        throw failure;
    }

    private static final class ExceptionWithBadConstructor
    extends Exception {
        public ExceptionWithBadConstructor(String message, Throwable cause) {
            throw new RuntimeException("bad constructor");
        }
    }

    private static final class ExceptionWithGoodAndBadConstructor
    extends Exception {
        public ExceptionWithGoodAndBadConstructor(String message, Throwable cause) {
            throw new RuntimeException("bad constructor");
        }

        public ExceptionWithGoodAndBadConstructor(Throwable cause) {
            super(cause);
        }
    }

    public static final class ExceptionWithWrongTypesConstructor
    extends Exception {
        public ExceptionWithWrongTypesConstructor(Integer i, String s) {
            super(s);
        }
    }

    public static final class ExceptionWithoutThrowableConstructor
    extends Exception {
        public ExceptionWithoutThrowableConstructor(String s) {
            super(s);
        }
    }

    public static final class ExceptionWithManyConstructors
    extends Exception {
        boolean usedExpectedConstructor;

        public ExceptionWithManyConstructors() {
        }

        public ExceptionWithManyConstructors(Integer i) {
        }

        public ExceptionWithManyConstructors(Throwable a) {
        }

        public ExceptionWithManyConstructors(Throwable a, Throwable b) {
        }

        public ExceptionWithManyConstructors(String s, Throwable b) {
            this.usedExpectedConstructor = true;
        }

        public ExceptionWithManyConstructors(Throwable a, Throwable b, Throwable c) {
        }

        public ExceptionWithManyConstructors(Throwable a, Throwable b, Throwable c, Throwable d) {
        }

        public ExceptionWithManyConstructors(Throwable a, Throwable b, Throwable c, Throwable d, Throwable e) {
        }

        public ExceptionWithManyConstructors(Throwable a, Throwable b, Throwable c, Throwable d, Throwable e, String s, Integer i) {
        }
    }

    public static final class ExceptionWithSomePrivateConstructors
    extends Exception {
        private ExceptionWithSomePrivateConstructors(String a) {
        }

        private ExceptionWithSomePrivateConstructors(String a, String b) {
        }

        public ExceptionWithSomePrivateConstructors(String a, String b, String c) {
        }

        private ExceptionWithSomePrivateConstructors(String a, String b, String c, String d) {
        }

        private ExceptionWithSomePrivateConstructors(String a, String b, String c, String d, String e) {
        }
    }

    public static final class ExceptionWithPrivateConstructor
    extends Exception {
        private ExceptionWithPrivateConstructor(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class TwoArgConstructorRuntimeException
    extends RuntimeException {
        public TwoArgConstructorRuntimeException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class TwoArgConstructorException
    extends Exception {
        public TwoArgConstructorException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class OtherThrowable
    extends Throwable {
        private OtherThrowable() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MapperFunction
    extends Function<Throwable, Exception> {
    }

    private static class TestException
    extends Exception {
        TestException(@Nullable Throwable cause) {
            super(cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Merger {
        public static final Merger allMerger = new Merger(){

            @Override
            public ListenableFuture<List<String>> merged(ListenableFuture<String> a, ListenableFuture<String> b) {
                return Futures.allAsList((Iterable)ImmutableSet.of(a, b));
            }
        };
        public static final Merger successMerger = new Merger(){

            @Override
            public ListenableFuture<List<String>> merged(ListenableFuture<String> a, ListenableFuture<String> b) {
                return Futures.successfulAsList((Iterable)ImmutableSet.of(a, b));
            }
        };

        public ListenableFuture<List<String>> merged(ListenableFuture<String> var1, ListenableFuture<String> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TestFutureBatch {
        final ListenableFuture<String> doneSuccess = Futures.immediateFuture((Object)"a");
        final ListenableFuture<String> doneFailed = Futures.immediateFailedFuture((Throwable)new Exception());
        final SettableFuture<String> doneCancelled = SettableFuture.create();
        final ListenableFuture<String> doneRuntimeException;
        final SettableFuture<String> delayedSuccess;
        final SettableFuture<String> delayedFailed;
        final SettableFuture<String> delayedCancelled;
        final SettableFuture<String> delegateForDelayedRuntimeException;
        final ListenableFuture<String> delayedRuntimeException;
        final Runnable doNothing;
        final Runnable finishSuccess;
        final Runnable finishFailure;
        final Runnable finishCancelled;
        final Runnable finishRuntimeException;
        final ImmutableList<TestFuture> allFutures;
        final Function<ListenableFuture<String>, String> nameGetter;

        private TestFutureBatch() {
            this.doneCancelled.cancel(true);
            this.doneRuntimeException = new ForwardingListenableFuture<String>(){
                final ListenableFuture<String> delegate = Futures.immediateFuture((Object)"Should never be seen");

                protected ListenableFuture<String> delegate() {
                    return this.delegate;
                }

                public String get() {
                    throw new RuntimeException();
                }

                public String get(long timeout, TimeUnit unit) {
                    throw new RuntimeException();
                }
            };
            this.delayedSuccess = SettableFuture.create();
            this.delayedFailed = SettableFuture.create();
            this.delayedCancelled = SettableFuture.create();
            this.delegateForDelayedRuntimeException = SettableFuture.create();
            this.delayedRuntimeException = new ForwardingListenableFuture<String>(){

                protected ListenableFuture<String> delegate() {
                    return TestFutureBatch.this.delegateForDelayedRuntimeException;
                }

                public String get() throws ExecutionException, InterruptedException {
                    TestFutureBatch.this.delegateForDelayedRuntimeException.get();
                    throw new RuntimeException();
                }

                public String get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
                    TestFutureBatch.this.delegateForDelayedRuntimeException.get(timeout, unit);
                    throw new RuntimeException();
                }
            };
            this.doNothing = new Runnable(){

                public void run() {
                }
            };
            this.finishSuccess = new Runnable(){

                public void run() {
                    TestFutureBatch.this.delayedSuccess.set((Object)"b");
                }
            };
            this.finishFailure = new Runnable(){

                public void run() {
                    TestFutureBatch.this.delayedFailed.setException((Throwable)new Exception());
                }
            };
            this.finishCancelled = new Runnable(){

                public void run() {
                    TestFutureBatch.this.delayedCancelled.cancel(true);
                }
            };
            this.finishRuntimeException = new Runnable(){

                public void run() {
                    TestFutureBatch.this.delegateForDelayedRuntimeException.set((Object)"Should never be seen");
                }
            };
            this.allFutures = ImmutableList.of((Object)new TestFuture(this.doneSuccess, "doneSuccess", this.doNothing), (Object)new TestFuture(this.doneFailed, "doneFailed", this.doNothing), (Object)new TestFuture((ListenableFuture<String>)this.doneCancelled, "doneCancelled", this.doNothing), (Object)new TestFuture(this.doneRuntimeException, "doneRuntimeException", this.doNothing), (Object)new TestFuture((ListenableFuture<String>)this.delayedSuccess, "delayedSuccess", this.finishSuccess), (Object)new TestFuture((ListenableFuture<String>)this.delayedFailed, "delayedFailed", this.finishFailure), (Object)new TestFuture((ListenableFuture<String>)this.delayedCancelled, "delayedCancelled", this.finishCancelled), (Object)new TestFuture(this.delayedRuntimeException, "delayedRuntimeException", this.finishRuntimeException));
            this.nameGetter = new Function<ListenableFuture<String>, String>(){

                public String apply(ListenableFuture<String> input) {
                    for (TestFuture future : TestFutureBatch.this.allFutures) {
                        if (future.future != input) continue;
                        return future.name;
                    }
                    throw new IllegalArgumentException(input.toString());
                }
            };
        }

        static boolean intersect(Set<?> a, Set<?> b) {
            return !Sets.intersection(a, b).isEmpty();
        }

        String smartToString(ImmutableSet<ListenableFuture<String>> inputs) {
            Iterable inputNames = Iterables.transform(inputs, this.nameGetter);
            return Joiner.on((String)", ").join(inputNames);
        }

        void smartAssertTrue(ImmutableSet<ListenableFuture<String>> inputs, Exception cause, boolean expression) {
            if (!expression) {
                FuturesTest.failWithCause(cause, this.smartToString(inputs));
            }
        }

        boolean hasDelayed(ListenableFuture<String> a, ListenableFuture<String> b) {
            ImmutableSet inputs = ImmutableSet.of(a, b);
            return TestFutureBatch.intersect(inputs, ImmutableSet.of(this.delayedSuccess, this.delayedFailed, this.delayedCancelled, this.delayedRuntimeException));
        }

        void assertHasDelayed(ListenableFuture<String> a, ListenableFuture<String> b, Exception e) {
            ImmutableSet inputs = ImmutableSet.of(a, b);
            this.smartAssertTrue((ImmutableSet<ListenableFuture<String>>)inputs, e, this.hasDelayed(a, b));
        }

        void assertHasFailure(ListenableFuture<String> a, ListenableFuture<String> b, Exception e) {
            ImmutableSet inputs = ImmutableSet.of(a, b);
            this.smartAssertTrue((ImmutableSet<ListenableFuture<String>>)inputs, e, TestFutureBatch.intersect(inputs, ImmutableSet.of(this.doneFailed, this.doneRuntimeException, this.delayedFailed, this.delayedRuntimeException)));
        }

        void assertHasCancel(ListenableFuture<String> a, ListenableFuture<String> b, Exception e) {
            ImmutableSet inputs = ImmutableSet.of(a, b);
            this.smartAssertTrue((ImmutableSet<ListenableFuture<String>>)inputs, e, TestFutureBatch.intersect(inputs, ImmutableSet.of(this.doneCancelled, this.delayedCancelled)));
        }

        void assertHasImmediateFailure(ListenableFuture<String> a, ListenableFuture<String> b, Exception e) {
            ImmutableSet inputs = ImmutableSet.of(a, b);
            this.smartAssertTrue((ImmutableSet<ListenableFuture<String>>)inputs, e, TestFutureBatch.intersect(inputs, ImmutableSet.of(this.doneFailed, this.doneRuntimeException)));
        }

        void assertHasImmediateCancel(ListenableFuture<String> a, ListenableFuture<String> b, Exception e) {
            ImmutableSet inputs = ImmutableSet.of(a, b);
            this.smartAssertTrue((ImmutableSet<ListenableFuture<String>>)inputs, e, TestFutureBatch.intersect(inputs, ImmutableSet.of(this.doneCancelled)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TestFuture {
        final ListenableFuture<String> future;
        final String name;
        final Runnable finisher;

        TestFuture(ListenableFuture<String> future, String name, Runnable finisher) {
            this.future = future;
            this.name = name;
            this.finisher = finisher;
        }
    }

    static class SingleCallListener
    implements Runnable {
        private boolean expectCall = false;
        private final CountDownLatch calledCountDown = new CountDownLatch(1);

        SingleCallListener() {
        }

        public void run() {
            Assert.assertTrue((String)"Listener called before it was expected", (boolean)this.expectCall);
            Assert.assertFalse((String)"Listener called more than once", (boolean)this.wasCalled());
            this.calledCountDown.countDown();
        }

        public void expectCall() {
            Assert.assertFalse((String)"expectCall is already true", (boolean)this.expectCall);
            this.expectCall = true;
        }

        public boolean wasCalled() {
            return this.calledCountDown.getCount() == 0L;
        }

        public void waitForCall() throws InterruptedException {
            Assert.assertTrue((String)"expectCall is false", (boolean)this.expectCall);
            this.calledCountDown.await();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionSpy<I, O>
    implements Function<I, O> {
        private int applyCount;
        private final Function<I, O> delegate;

        public FunctionSpy(Function<I, O> delegate) {
            this.delegate = delegate;
        }

        public O apply(I input) {
            ++this.applyCount;
            return (O)this.delegate.apply(input);
        }

        public int getApplyCount() {
            return this.applyCount;
        }
    }

    static class ExecutorSpy
    implements Executor {
        Executor delegate;
        boolean wasExecuted;

        public ExecutorSpy(Executor delegate) {
            this.delegate = delegate;
        }

        public void execute(Runnable command) {
            this.delegate.execute(command);
            this.wasExecuted = true;
        }
    }

    static class MyRuntimeException
    extends RuntimeException {
        MyRuntimeException() {
        }
    }

    static class MyError
    extends Error {
        MyError() {
        }
    }

    private static class BarChild
    extends Bar {
        private BarChild() {
        }
    }

    private static class Bar {
        private Bar() {
        }
    }

    private static class FooChild
    extends Foo {
        private FooChild() {
        }
    }

    private static class Foo {
        private Foo() {
        }
    }

    private static class MyException
    extends Exception {
        private MyException() {
        }
    }
}

