/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AbstractChainedListenableFutureTest;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.UndeclaredThrowableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuturesTransformTest
extends AbstractChainedListenableFutureTest<String> {
    private static final String RESULT_DATA = "SUCCESS";

    @Override
    protected ListenableFuture<String> buildChainingFuture(ListenableFuture<Integer> inputFuture) {
        return Futures.transform(inputFuture, (Function)new ComposeFunction());
    }

    @Override
    protected String getSuccessfulResult() {
        return RESULT_DATA;
    }

    public void testFutureGetThrowsFunctionException() throws Exception {
        this.inputFuture.set((Object)-1);
        this.listener.assertException((Throwable)EXCEPTION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComposeFunction
    implements Function<Integer, String> {
        private ComposeFunction() {
        }

        public String apply(Integer input) {
            if (input == 1) {
                return FuturesTransformTest.RESULT_DATA;
            }
            throw new UndeclaredThrowableException(AbstractChainedListenableFutureTest.EXCEPTION);
        }
    }
}

