/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenableFutureTester {
    private final ExecutorService exec = Executors.newCachedThreadPool();
    private final ListenableFuture<?> future;
    private final CountDownLatch latch;

    public ListenableFutureTester(ListenableFuture<?> future) {
        this.future = (ListenableFuture)Preconditions.checkNotNull(future);
        this.latch = new CountDownLatch(1);
    }

    public void setUp() {
        this.future.addListener(new Runnable(){

            public void run() {
                ListenableFutureTester.this.latch.countDown();
            }
        }, (Executor)this.exec);
        Assert.assertEquals((long)1L, (long)this.latch.getCount());
        Assert.assertFalse((boolean)this.future.isDone());
        Assert.assertFalse((boolean)this.future.isCancelled());
    }

    public void tearDown() {
        this.exec.shutdown();
    }

    public void testCompletedFuture(@Nullable Object expectedValue) throws InterruptedException, ExecutionException {
        Assert.assertTrue((boolean)this.future.isDone());
        Assert.assertFalse((boolean)this.future.isCancelled());
        Assert.assertTrue((boolean)this.latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.future.isDone());
        Assert.assertFalse((boolean)this.future.isCancelled());
        Assert.assertEquals((Object)expectedValue, (Object)this.future.get());
    }

    public void testCancelledFuture() throws InterruptedException, ExecutionException {
        Assert.assertTrue((boolean)this.future.isDone());
        Assert.assertTrue((boolean)this.future.isCancelled());
        Assert.assertTrue((boolean)this.latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.future.isDone());
        Assert.assertTrue((boolean)this.future.isCancelled());
        try {
            this.future.get();
            Assert.fail((String)"Future should throw CancellationException on cancel.");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testFailedFuture(@Nullable String message) throws InterruptedException {
        Assert.assertTrue((boolean)this.future.isDone());
        Assert.assertFalse((boolean)this.future.isCancelled());
        Assert.assertTrue((boolean)this.latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.future.isDone());
        Assert.assertFalse((boolean)this.future.isCancelled());
        try {
            this.future.get();
            Assert.fail((String)"Future should rethrow the exception.");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((String)message, (String)e.getCause().getMessage());
        }
    }
}

