/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.ListenerCallQueue;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerCallQueueTest
extends TestCase {
    private static final ListenerCallQueue.Callback<Object> THROWING_CALLBACK = new ListenerCallQueue.Callback<Object>("throwing()"){

        public void call(Object object) {
            throw new RuntimeException();
        }
    };

    public void testAddAndExecute() {
        Object listenerInstance = new Object();
        ListenerCallQueue queue = new ListenerCallQueue(listenerInstance, (Executor)MoreExecutors.sameThreadExecutor());
        AtomicInteger counter = new AtomicInteger();
        queue.add(this.incrementingCallback(counter, 1));
        queue.add(this.incrementingCallback(counter, 2));
        queue.add(this.incrementingCallback(counter, 3));
        queue.add(this.incrementingCallback(counter, 4));
        ListenerCallQueueTest.assertEquals((int)0, (int)counter.get());
        queue.execute();
        ListenerCallQueueTest.assertEquals((int)4, (int)counter.get());
    }

    public void testAddAndExecute_withExceptions() {
        Object listenerInstance = new Object();
        ListenerCallQueue queue = new ListenerCallQueue(listenerInstance, (Executor)MoreExecutors.sameThreadExecutor());
        AtomicInteger counter = new AtomicInteger();
        queue.add(this.incrementingCallback(counter, 1));
        queue.add(THROWING_CALLBACK);
        queue.add(this.incrementingCallback(counter, 2));
        queue.add(THROWING_CALLBACK);
        queue.add(this.incrementingCallback(counter, 3));
        queue.add(THROWING_CALLBACK);
        queue.add(this.incrementingCallback(counter, 4));
        queue.add(THROWING_CALLBACK);
        ListenerCallQueueTest.assertEquals((int)0, (int)counter.get());
        queue.execute();
        ListenerCallQueueTest.assertEquals((int)4, (int)counter.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddAndExecute_multithreaded() throws InterruptedException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        try {
            ListenerCallQueue queue = new ListenerCallQueue(new Object(), (Executor)service);
            CountDownLatch latch = new CountDownLatch(1);
            AtomicInteger counter = new AtomicInteger();
            queue.add(this.incrementingCallback(counter, 1));
            queue.add(this.incrementingCallback(counter, 2));
            queue.add(this.incrementingCallback(counter, 3));
            queue.add(this.incrementingCallback(counter, 4));
            queue.add(this.countDownCallback(latch));
            ListenerCallQueueTest.assertEquals((int)0, (int)counter.get());
            queue.execute();
            latch.await();
            ListenerCallQueueTest.assertEquals((int)4, (int)counter.get());
        }
        finally {
            service.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddAndExecute_multithreaded_withThrowingRunnable() throws InterruptedException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        try {
            ListenerCallQueue queue = new ListenerCallQueue(new Object(), (Executor)service);
            CountDownLatch latch = new CountDownLatch(1);
            AtomicInteger counter = new AtomicInteger();
            queue.add(this.incrementingCallback(counter, 1));
            queue.add(THROWING_CALLBACK);
            queue.add(this.incrementingCallback(counter, 2));
            queue.add(THROWING_CALLBACK);
            queue.add(this.incrementingCallback(counter, 3));
            queue.add(THROWING_CALLBACK);
            queue.add(this.incrementingCallback(counter, 4));
            queue.add(THROWING_CALLBACK);
            queue.add(this.countDownCallback(latch));
            ListenerCallQueueTest.assertEquals((int)0, (int)counter.get());
            queue.execute();
            latch.await();
            ListenerCallQueueTest.assertEquals((int)4, (int)counter.get());
        }
        finally {
            service.shutdown();
        }
    }

    private ListenerCallQueue.Callback<Object> incrementingCallback(final AtomicInteger counter, final int expected) {
        return new ListenerCallQueue.Callback<Object>("incrementing"){

            void call(Object listener) {
                Assert.assertEquals((int)expected, (int)counter.incrementAndGet());
            }
        };
    }

    private ListenerCallQueue.Callback<Object> countDownCallback(final CountDownLatch latch) {
        return new ListenerCallQueue.Callback<Object>("countDown"){

            void call(Object listener) {
                latch.countDown();
            }
        };
    }
}

