/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTester;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

public class SettableFutureTest
extends TestCase {
    private SettableFuture<String> future;
    private ListenableFutureTester tester;

    protected void setUp() throws Exception {
        super.setUp();
        this.future = SettableFuture.create();
        this.tester = new ListenableFutureTester((ListenableFuture<?>)this.future);
        this.tester.setUp();
    }

    public void testDefaultState() throws Exception {
        try {
            this.future.get(5L, TimeUnit.MILLISECONDS);
            SettableFutureTest.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void testSetValue() throws Exception {
        SettableFutureTest.assertTrue((boolean)this.future.set((Object)"value"));
        this.tester.testCompletedFuture("value");
    }

    public void testSetFailure() throws Exception {
        SettableFutureTest.assertTrue((boolean)this.future.setException((Throwable)new Exception("failure")));
        this.tester.testFailedFuture("failure");
    }

    public void testSetFailureNull() throws Exception {
        try {
            this.future.setException(null);
            SettableFutureTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        SettableFutureTest.assertFalse((boolean)this.future.isDone());
        SettableFutureTest.assertTrue((boolean)this.future.setException((Throwable)new Exception("failure")));
        this.tester.testFailedFuture("failure");
    }

    public void testCancel() throws Exception {
        SettableFutureTest.assertTrue((boolean)this.future.cancel(true));
        this.tester.testCancelledFuture();
    }
}

