/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.testing.GcFinalization;
import com.google.common.testing.NullPointerTester;
import com.google.common.util.concurrent.Striped;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StripedTest
extends TestCase {
    private static final Supplier<ReadWriteLock> READ_WRITE_LOCK_SUPPLIER = new Supplier<ReadWriteLock>(){

        public ReadWriteLock get() {
            return new ReentrantReadWriteLock();
        }
    };
    private static final Supplier<Lock> LOCK_SUPPLER = new Supplier<Lock>(){

        public Lock get() {
            return new ReentrantLock();
        }
    };
    private static final Supplier<Semaphore> SEMAPHORE_SUPPLER = new Supplier<Semaphore>(){

        public Semaphore get() {
            return new Semaphore(1, false);
        }
    };

    private static List<Striped<?>> strongImplementations() {
        return ImmutableList.of((Object)Striped.readWriteLock((int)100), (Object)Striped.readWriteLock((int)256), (Object)Striped.lock((int)100), (Object)Striped.lock((int)256), (Object)Striped.semaphore((int)100, (int)1), (Object)Striped.semaphore((int)256, (int)1));
    }

    private static List<Striped<?>> weakImplementations() {
        return ImmutableList.builder().add((Object)new Striped.SmallLazyStriped(50, READ_WRITE_LOCK_SUPPLIER)).add((Object)new Striped.SmallLazyStriped(64, READ_WRITE_LOCK_SUPPLIER)).add((Object)new Striped.LargeLazyStriped(50, READ_WRITE_LOCK_SUPPLIER)).add((Object)new Striped.LargeLazyStriped(64, READ_WRITE_LOCK_SUPPLIER)).add((Object)new Striped.SmallLazyStriped(50, LOCK_SUPPLER)).add((Object)new Striped.SmallLazyStriped(64, LOCK_SUPPLER)).add((Object)new Striped.LargeLazyStriped(50, LOCK_SUPPLER)).add((Object)new Striped.LargeLazyStriped(64, LOCK_SUPPLER)).add((Object)new Striped.SmallLazyStriped(50, SEMAPHORE_SUPPLER)).add((Object)new Striped.SmallLazyStriped(64, SEMAPHORE_SUPPLER)).add((Object)new Striped.LargeLazyStriped(50, SEMAPHORE_SUPPLER)).add((Object)new Striped.LargeLazyStriped(64, SEMAPHORE_SUPPLER)).build();
    }

    private static Iterable<Striped<?>> allImplementations() {
        return Iterables.concat(StripedTest.strongImplementations(), StripedTest.weakImplementations());
    }

    public void testNull() throws Exception {
        for (Striped<?> striped : StripedTest.allImplementations()) {
            new NullPointerTester().testAllPublicInstanceMethods(striped);
        }
    }

    public void testSizes() {
        StripedTest.assertTrue((Striped.lock((int)100).size() >= 100 ? 1 : 0) != 0);
        StripedTest.assertTrue((Striped.lock((int)256).size() == 256 ? 1 : 0) != 0);
        StripedTest.assertTrue((Striped.lazyWeakLock((int)100).size() >= 100 ? 1 : 0) != 0);
        StripedTest.assertTrue((Striped.lazyWeakLock((int)256).size() == 256 ? 1 : 0) != 0);
    }

    public void testWeakImplementations() {
        for (Striped<?> striped : StripedTest.weakImplementations()) {
            WeakReference<Object> weakRef = new WeakReference<Object>(striped.get(new Object()));
            GcFinalization.awaitClear(weakRef);
        }
    }

    public void testStrongImplementations() {
        for (Striped<?> striped : StripedTest.strongImplementations()) {
            WeakReference<Object> weakRef = new WeakReference<Object>(striped.get(new Object()));
            WeakReference<Object> garbage = new WeakReference<Object>(new Object());
            GcFinalization.awaitClear(garbage);
            StripedTest.assertNotNull(weakRef.get());
        }
    }

    public void testMaximalWeakStripedLock() {
        Striped stripedLock = Striped.lazyWeakLock((int)Integer.MAX_VALUE);
        for (int i = 0; i < 10000; ++i) {
            ((Lock)stripedLock.get(new Object())).lock();
        }
    }

    public void testBulkGetReturnsSorted() {
        for (Striped<?> striped : StripedTest.allImplementations()) {
            HashMap indexByLock = Maps.newHashMap();
            for (int i = 0; i < striped.size(); ++i) {
                indexByLock.put(striped.getAt(i), i);
            }
            for (int objectsNum = 1; objectsNum <= striped.size() * 2; ++objectsNum) {
                HashSet objects = Sets.newHashSetWithExpectedSize((int)objectsNum);
                for (int i = 0; i < objectsNum; ++i) {
                    objects.add(new Object());
                }
                Iterable locks = striped.bulkGet((Iterable)objects);
                StripedTest.assertTrue((boolean)Ordering.natural().onResultOf(Functions.forMap((Map)indexByLock)).isOrdered(locks));
                Iterable locks2 = striped.bulkGet((Iterable)objects);
                StripedTest.assertEquals((Object)Lists.newArrayList((Iterable)locks), (Object)Lists.newArrayList((Iterable)locks2));
            }
        }
    }

    public void testBasicInvariants() {
        for (Striped<?> striped : StripedTest.allImplementations()) {
            StripedTest.assertBasicInvariants(striped);
        }
    }

    private static void assertBasicInvariants(Striped<?> striped) {
        int i;
        Set observed = Sets.newIdentityHashSet();
        for (i = 0; i < striped.size(); ++i) {
            Object object = striped.getAt(i);
            StripedTest.assertNotNull((Object)object);
            StripedTest.assertSame((Object)object, (Object)striped.getAt(i));
            observed.add(object);
        }
        StripedTest.assertTrue((String)"All stripes observed", (observed.size() == striped.size() ? 1 : 0) != 0);
        for (i = 0; i < striped.size() * 100; ++i) {
            StripedTest.assertTrue((boolean)observed.contains(striped.get(new Object())));
        }
        try {
            striped.getAt(-1);
            StripedTest.fail();
        }
        catch (RuntimeException expected) {
            // empty catch block
        }
        try {
            striped.getAt(striped.size());
            StripedTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testMaxSize() {
        for (Striped striped : ImmutableList.of((Object)Striped.lazyWeakLock((int)Integer.MAX_VALUE), (Object)Striped.lazyWeakSemaphore((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE), (Object)Striped.lazyWeakReadWriteLock((int)Integer.MAX_VALUE))) {
            for (int i = 0; i < 3; ++i) {
                striped.getAt(Integer.MAX_VALUE - i);
            }
        }
    }
}

