/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.xml;

import com.google.common.annotations.GwtCompatible;
import com.google.common.escape.CharEscaper;
import com.google.common.escape.testing.EscaperAsserts;
import com.google.common.xml.XmlEscapers;
import junit.framework.TestCase;

@GwtCompatible
public class XmlEscapersTest
extends TestCase {
    public void testXmlContentEscaper() throws Exception {
        CharEscaper xmlContentEscaper = (CharEscaper)XmlEscapers.xmlContentEscaper();
        this.assertBasicXmlEscaper(xmlContentEscaper, false, false);
        XmlEscapersTest.assertEquals((String)"\"test\"", (String)xmlContentEscaper.escape("\"test\""));
        XmlEscapersTest.assertEquals((String)"'test'", (String)xmlContentEscaper.escape("'test'"));
    }

    public void testXmlAttributeEscaper() throws Exception {
        CharEscaper xmlAttributeEscaper = (CharEscaper)XmlEscapers.xmlAttributeEscaper();
        this.assertBasicXmlEscaper(xmlAttributeEscaper, true, true);
        XmlEscapersTest.assertEquals((String)"&quot;test&quot;", (String)xmlAttributeEscaper.escape("\"test\""));
        XmlEscapersTest.assertEquals((String)"&apos;test&apos;", (String)xmlAttributeEscaper.escape("'test'"));
        XmlEscapersTest.assertEquals((String)"a&quot;b&lt;c&gt;d&amp;e&quot;f&apos;", (String)xmlAttributeEscaper.escape("a\"b<c>d&e\"f'"));
        XmlEscapersTest.assertEquals((String)"a&#x9;b&#xA;c&#xD;d", (String)xmlAttributeEscaper.escape("a\tb\nc\rd"));
    }

    private void assertBasicXmlEscaper(CharEscaper xmlEscaper, boolean shouldEscapeQuotes, boolean shouldEscapeWhitespaceChars) {
        char ch;
        XmlEscapersTest.assertEquals((String)"xxx", (String)xmlEscaper.escape("xxx"));
        XmlEscapersTest.assertEquals((String)"test &amp; test &amp; test", (String)xmlEscaper.escape("test & test & test"));
        XmlEscapersTest.assertEquals((String)"test &lt;&lt; 1", (String)xmlEscaper.escape("test << 1"));
        XmlEscapersTest.assertEquals((String)"test &gt;&gt; 1", (String)xmlEscaper.escape("test >> 1"));
        XmlEscapersTest.assertEquals((String)"&lt;tab&gt;", (String)xmlEscaper.escape("<tab>"));
        String s = "!@#$%^*()_+=-/?\\|]}[{,.;:abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        XmlEscapersTest.assertEquals((String)s, (String)xmlEscaper.escape(s));
        for (ch = '\u0000'; ch < ' '; ch = (char)(ch + '\u0001')) {
            if (ch == '\t' || ch == '\n' || ch == '\r') {
                if (shouldEscapeWhitespaceChars) {
                    EscaperAsserts.assertEscaping((CharEscaper)xmlEscaper, (String)("&#x" + Integer.toHexString(ch).toUpperCase() + ";"), (char)ch);
                    continue;
                }
                EscaperAsserts.assertUnescaped((CharEscaper)xmlEscaper, (char)ch);
                continue;
            }
            EscaperAsserts.assertEscaping((CharEscaper)xmlEscaper, (String)"", (char)ch);
        }
        for (ch = ' '; ch <= '\ufffd'; ch = (char)(ch + '\u0001')) {
            if (ch == '&') {
                EscaperAsserts.assertEscaping((CharEscaper)xmlEscaper, (String)"&amp;", (char)ch);
                continue;
            }
            if (ch == '<') {
                EscaperAsserts.assertEscaping((CharEscaper)xmlEscaper, (String)"&lt;", (char)ch);
                continue;
            }
            if (ch == '>') {
                EscaperAsserts.assertEscaping((CharEscaper)xmlEscaper, (String)"&gt;", (char)ch);
                continue;
            }
            if (shouldEscapeQuotes && ch == '\'') {
                EscaperAsserts.assertEscaping((CharEscaper)xmlEscaper, (String)"&apos;", (char)ch);
                continue;
            }
            if (shouldEscapeQuotes && ch == '\"') {
                EscaperAsserts.assertEscaping((CharEscaper)xmlEscaper, (String)"&quot;", (char)ch);
                continue;
            }
            String input = String.valueOf(ch);
            String escaped = xmlEscaper.escape(input);
            XmlEscapersTest.assertEquals((String)("char 0x" + Integer.toString(ch, 16) + " should not be escaped"), (String)input, (String)escaped);
        }
        EscaperAsserts.assertUnescaped((CharEscaper)xmlEscaper, (char)'\ufffe');
        EscaperAsserts.assertUnescaped((CharEscaper)xmlEscaper, (char)'\uffff');
    }
}

