/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.SmallCharMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.testing.NullPointerTester;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class CharMatcherTest
extends TestCase {
    private static final CharMatcher WHATEVER = new CharMatcher(){

        public boolean matches(char c) {
            throw new AssertionFailedError("You weren't supposed to actually invoke me!");
        }
    };

    @GwtIncompatible(value="NullPointerTester")
    public void testStaticNullPointers() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(CharMatcher.class);
        tester.testAllPublicInstanceMethods((Object)CharMatcher.ANY);
        tester.testAllPublicInstanceMethods((Object)CharMatcher.anyOf((CharSequence)"abc"));
    }

    public void testAnyAndNone_logicalOps() throws Exception {
        CharMatcherTest.assertSame((Object)CharMatcher.ANY, (Object)CharMatcher.NONE.negate());
        CharMatcherTest.assertSame((Object)CharMatcher.NONE, (Object)CharMatcher.ANY.negate());
        CharMatcherTest.assertSame((Object)WHATEVER, (Object)CharMatcher.ANY.and(WHATEVER));
        CharMatcherTest.assertSame((Object)CharMatcher.ANY, (Object)CharMatcher.ANY.or(WHATEVER));
        CharMatcherTest.assertSame((Object)CharMatcher.NONE, (Object)CharMatcher.NONE.and(WHATEVER));
        CharMatcherTest.assertSame((Object)WHATEVER, (Object)CharMatcher.NONE.or(WHATEVER));
    }

    public void testWhitespaceBreakingWhitespaceSubset() throws Exception {
        for (int c = 0; c <= 65535; ++c) {
            if (!CharMatcher.BREAKING_WHITESPACE.apply(Character.valueOf((char)c))) continue;
            CharMatcherTest.assertTrue((String)Integer.toHexString(c), (boolean)CharMatcher.WHITESPACE.apply(Character.valueOf((char)c)));
        }
    }

    @GwtIncompatible(value="Character.isISOControl")
    public void testJavaIsoControl() {
        for (int c = 0; c <= 65535; ++c) {
            CharMatcherTest.assertEquals((String)("" + c), (boolean)Character.isISOControl(c), (boolean)CharMatcher.JAVA_ISO_CONTROL.matches((char)c));
        }
    }

    @GwtIncompatible(value="java.util.BitSet")
    public void testSetBits() {
        this.doTestSetBits(CharMatcher.ANY);
        this.doTestSetBits(CharMatcher.NONE);
        this.doTestSetBits(CharMatcher.is((char)'a'));
        this.doTestSetBits(CharMatcher.isNot((char)'a'));
        this.doTestSetBits(CharMatcher.anyOf((CharSequence)""));
        this.doTestSetBits(CharMatcher.anyOf((CharSequence)"x"));
        this.doTestSetBits(CharMatcher.anyOf((CharSequence)"xy"));
        this.doTestSetBits(CharMatcher.anyOf((CharSequence)"CharMatcher"));
        this.doTestSetBits(CharMatcher.noneOf((CharSequence)"CharMatcher"));
        this.doTestSetBits(CharMatcher.inRange((char)'n', (char)'q'));
        this.doTestSetBits(CharMatcher.forPredicate((Predicate)Predicates.equalTo((Object)Character.valueOf('c'))));
        this.doTestSetBits(CharMatcher.ASCII);
        this.doTestSetBits(CharMatcher.DIGIT);
        this.doTestSetBits(CharMatcher.INVISIBLE);
        this.doTestSetBits(CharMatcher.WHITESPACE);
        this.doTestSetBits(CharMatcher.inRange((char)'A', (char)'Z').and(CharMatcher.inRange((char)'F', (char)'K').negate()));
    }

    @GwtIncompatible(value="java.util.BitSet")
    private void doTestSetBits(CharMatcher matcher) {
        BitSet bitset = new BitSet();
        matcher.setBits(bitset);
        for (int i = 0; i <= 65535; ++i) {
            CharMatcherTest.assertEquals((boolean)matcher.matches((char)i), (boolean)bitset.get(i));
        }
    }

    public void testEmpty() throws Exception {
        this.doTestEmpty(CharMatcher.ANY);
        this.doTestEmpty(CharMatcher.NONE);
        this.doTestEmpty(CharMatcher.is((char)'a'));
        this.doTestEmpty(CharMatcher.isNot((char)'a'));
        this.doTestEmpty(CharMatcher.anyOf((CharSequence)""));
        this.doTestEmpty(CharMatcher.anyOf((CharSequence)"x"));
        this.doTestEmpty(CharMatcher.anyOf((CharSequence)"xy"));
        this.doTestEmpty(CharMatcher.anyOf((CharSequence)"CharMatcher"));
        this.doTestEmpty(CharMatcher.noneOf((CharSequence)"CharMatcher"));
        this.doTestEmpty(CharMatcher.inRange((char)'n', (char)'q'));
        this.doTestEmpty(CharMatcher.forPredicate((Predicate)Predicates.equalTo((Object)Character.valueOf('c'))));
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNull() throws Exception {
        this.doTestNull(CharMatcher.ANY);
        this.doTestNull(CharMatcher.NONE);
        this.doTestNull(CharMatcher.is((char)'a'));
        this.doTestNull(CharMatcher.isNot((char)'a'));
        this.doTestNull(CharMatcher.anyOf((CharSequence)""));
        this.doTestNull(CharMatcher.anyOf((CharSequence)"x"));
        this.doTestNull(CharMatcher.anyOf((CharSequence)"xy"));
        this.doTestNull(CharMatcher.anyOf((CharSequence)"CharMatcher"));
        this.doTestNull(CharMatcher.noneOf((CharSequence)"CharMatcher"));
        this.doTestNull(CharMatcher.inRange((char)'n', (char)'q'));
        this.doTestNull(CharMatcher.forPredicate((Predicate)Predicates.equalTo((Object)Character.valueOf('c'))));
    }

    private void doTestEmpty(CharMatcher matcher) throws Exception {
        this.reallyTestEmpty(matcher);
        this.reallyTestEmpty(matcher.negate());
        this.reallyTestEmpty(matcher.precomputed());
    }

    private void reallyTestEmpty(CharMatcher matcher) throws Exception {
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn((CharSequence)""));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn((CharSequence)"", 0));
        try {
            matcher.indexIn((CharSequence)"", 1);
            CharMatcherTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            matcher.indexIn((CharSequence)"", -1);
            CharMatcherTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        CharMatcherTest.assertEquals((int)-1, (int)matcher.lastIndexIn((CharSequence)""));
        CharMatcherTest.assertFalse((boolean)matcher.matchesAnyOf((CharSequence)""));
        CharMatcherTest.assertTrue((boolean)matcher.matchesAllOf((CharSequence)""));
        CharMatcherTest.assertTrue((boolean)matcher.matchesNoneOf((CharSequence)""));
        CharMatcherTest.assertEquals((String)"", (String)matcher.removeFrom((CharSequence)""));
        CharMatcherTest.assertEquals((String)"", (String)matcher.replaceFrom((CharSequence)"", 'z'));
        CharMatcherTest.assertEquals((String)"", (String)matcher.replaceFrom((CharSequence)"", (CharSequence)"ZZ"));
        CharMatcherTest.assertEquals((String)"", (String)matcher.trimFrom((CharSequence)""));
        CharMatcherTest.assertEquals((int)0, (int)matcher.countIn((CharSequence)""));
    }

    @GwtIncompatible(value="NullPointerTester")
    private void doTestNull(CharMatcher matcher) throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)matcher);
    }

    public void testNoMatches() {
        this.doTestNoMatches(CharMatcher.NONE, "blah");
        this.doTestNoMatches(CharMatcher.is((char)'a'), "bcde");
        this.doTestNoMatches(CharMatcher.isNot((char)'a'), "aaaa");
        this.doTestNoMatches(CharMatcher.anyOf((CharSequence)""), "abcd");
        this.doTestNoMatches(CharMatcher.anyOf((CharSequence)"x"), "abcd");
        this.doTestNoMatches(CharMatcher.anyOf((CharSequence)"xy"), "abcd");
        this.doTestNoMatches(CharMatcher.anyOf((CharSequence)"CharMatcher"), "zxqy");
        this.doTestNoMatches(CharMatcher.noneOf((CharSequence)"CharMatcher"), "ChMa");
        this.doTestNoMatches(CharMatcher.inRange((char)'p', (char)'x'), "mom");
        this.doTestNoMatches(CharMatcher.forPredicate((Predicate)Predicates.equalTo((Object)Character.valueOf('c'))), "abe");
        this.doTestNoMatches(CharMatcher.inRange((char)'A', (char)'Z').and(CharMatcher.inRange((char)'F', (char)'K').negate()), "F1a");
        this.doTestNoMatches(CharMatcher.DIGIT, "\tAz()");
        this.doTestNoMatches(CharMatcher.JAVA_DIGIT, "\tAz()");
        this.doTestNoMatches(CharMatcher.DIGIT.and(CharMatcher.ASCII), "\tAz()");
        this.doTestNoMatches(CharMatcher.SINGLE_WIDTH, "\u05bf\u3000");
    }

    private void doTestNoMatches(CharMatcher matcher, String s) {
        this.reallyTestNoMatches(matcher, s);
        this.reallyTestAllMatches(matcher.negate(), s);
        this.reallyTestNoMatches(matcher.precomputed(), s);
        this.reallyTestAllMatches(matcher.negate().precomputed(), s);
        this.reallyTestAllMatches(matcher.precomputed().negate(), s);
        this.reallyTestNoMatches(CharMatcher.forPredicate((Predicate)matcher), s);
        this.reallyTestNoMatches(matcher, new StringBuilder(s));
    }

    public void testAllMatches() {
        this.doTestAllMatches(CharMatcher.ANY, "blah");
        this.doTestAllMatches(CharMatcher.isNot((char)'a'), "bcde");
        this.doTestAllMatches(CharMatcher.is((char)'a'), "aaaa");
        this.doTestAllMatches(CharMatcher.noneOf((CharSequence)"CharMatcher"), "zxqy");
        this.doTestAllMatches(CharMatcher.anyOf((CharSequence)"x"), "xxxx");
        this.doTestAllMatches(CharMatcher.anyOf((CharSequence)"xy"), "xyyx");
        this.doTestAllMatches(CharMatcher.anyOf((CharSequence)"CharMatcher"), "ChMa");
        this.doTestAllMatches(CharMatcher.inRange((char)'m', (char)'p'), "mom");
        this.doTestAllMatches(CharMatcher.forPredicate((Predicate)Predicates.equalTo((Object)Character.valueOf('c'))), "ccc");
        this.doTestAllMatches(CharMatcher.DIGIT, "0123456789\u0ed0\u1b59");
        this.doTestAllMatches(CharMatcher.JAVA_DIGIT, "0123456789");
        this.doTestAllMatches(CharMatcher.DIGIT.and(CharMatcher.ASCII), "0123456789");
        this.doTestAllMatches(CharMatcher.SINGLE_WIDTH, "\t0123ABCdef~\u00a0\u2111");
    }

    private void doTestAllMatches(CharMatcher matcher, String s) {
        this.reallyTestAllMatches(matcher, s);
        this.reallyTestNoMatches(matcher.negate(), s);
        this.reallyTestAllMatches(matcher.precomputed(), s);
        this.reallyTestNoMatches(matcher.negate().precomputed(), s);
        this.reallyTestNoMatches(matcher.precomputed().negate(), s);
        this.reallyTestAllMatches(CharMatcher.forPredicate((Predicate)matcher), s);
        this.reallyTestAllMatches(matcher, new StringBuilder(s));
    }

    private void reallyTestNoMatches(CharMatcher matcher, CharSequence s) {
        CharMatcherTest.assertFalse((boolean)matcher.matches(s.charAt(0)));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn(s));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn(s, 0));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn(s, 1));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn(s, s.length()));
        try {
            matcher.indexIn(s, s.length() + 1);
            CharMatcherTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            matcher.indexIn(s, -1);
            CharMatcherTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        CharMatcherTest.assertEquals((int)-1, (int)matcher.lastIndexIn(s));
        CharMatcherTest.assertFalse((boolean)matcher.matchesAnyOf(s));
        CharMatcherTest.assertFalse((boolean)matcher.matchesAllOf(s));
        CharMatcherTest.assertTrue((boolean)matcher.matchesNoneOf(s));
        CharMatcherTest.assertEquals((String)s.toString(), (String)matcher.removeFrom(s));
        CharMatcherTest.assertEquals((String)s.toString(), (String)matcher.replaceFrom(s, 'z'));
        CharMatcherTest.assertEquals((String)s.toString(), (String)matcher.replaceFrom(s, (CharSequence)"ZZ"));
        CharMatcherTest.assertEquals((String)s.toString(), (String)matcher.trimFrom(s));
        CharMatcherTest.assertEquals((int)0, (int)matcher.countIn(s));
    }

    private void reallyTestAllMatches(CharMatcher matcher, CharSequence s) {
        CharMatcherTest.assertTrue((boolean)matcher.matches(s.charAt(0)));
        CharMatcherTest.assertEquals((int)0, (int)matcher.indexIn(s));
        CharMatcherTest.assertEquals((int)0, (int)matcher.indexIn(s, 0));
        CharMatcherTest.assertEquals((int)1, (int)matcher.indexIn(s, 1));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn(s, s.length()));
        CharMatcherTest.assertEquals((int)(s.length() - 1), (int)matcher.lastIndexIn(s));
        CharMatcherTest.assertTrue((boolean)matcher.matchesAnyOf(s));
        CharMatcherTest.assertTrue((boolean)matcher.matchesAllOf(s));
        CharMatcherTest.assertFalse((boolean)matcher.matchesNoneOf(s));
        CharMatcherTest.assertEquals((String)"", (String)matcher.removeFrom(s));
        CharMatcherTest.assertEquals((String)Strings.repeat((String)"z", (int)s.length()), (String)matcher.replaceFrom(s, 'z'));
        CharMatcherTest.assertEquals((String)Strings.repeat((String)"ZZ", (int)s.length()), (String)matcher.replaceFrom(s, (CharSequence)"ZZ"));
        CharMatcherTest.assertEquals((String)"", (String)matcher.trimFrom(s));
        CharMatcherTest.assertEquals((int)s.length(), (int)matcher.countIn(s));
    }

    public void testGeneral() {
        this.doTestGeneral(CharMatcher.is((char)'a'), 'a', 'b');
        this.doTestGeneral(CharMatcher.isNot((char)'a'), 'b', 'a');
        this.doTestGeneral(CharMatcher.anyOf((CharSequence)"x"), 'x', 'z');
        this.doTestGeneral(CharMatcher.anyOf((CharSequence)"xy"), 'y', 'z');
        this.doTestGeneral(CharMatcher.anyOf((CharSequence)"CharMatcher"), 'C', 'z');
        this.doTestGeneral(CharMatcher.noneOf((CharSequence)"CharMatcher"), 'z', 'C');
        this.doTestGeneral(CharMatcher.inRange((char)'p', (char)'x'), 'q', 'z');
    }

    private void doTestGeneral(CharMatcher matcher, char match, char noMatch) {
        this.doTestOneCharMatch(matcher, "" + match);
        this.doTestOneCharNoMatch(matcher, "" + noMatch);
        this.doTestMatchThenNoMatch(matcher, "" + match + noMatch);
        this.doTestNoMatchThenMatch(matcher, "" + noMatch + match);
    }

    private void doTestOneCharMatch(CharMatcher matcher, String s) {
        this.reallyTestOneCharMatch(matcher, s);
        this.reallyTestOneCharNoMatch(matcher.negate(), s);
        this.reallyTestOneCharMatch(matcher.precomputed(), s);
        this.reallyTestOneCharNoMatch(matcher.negate().precomputed(), s);
        this.reallyTestOneCharNoMatch(matcher.precomputed().negate(), s);
    }

    private void doTestOneCharNoMatch(CharMatcher matcher, String s) {
        this.reallyTestOneCharNoMatch(matcher, s);
        this.reallyTestOneCharMatch(matcher.negate(), s);
        this.reallyTestOneCharNoMatch(matcher.precomputed(), s);
        this.reallyTestOneCharMatch(matcher.negate().precomputed(), s);
        this.reallyTestOneCharMatch(matcher.precomputed().negate(), s);
    }

    private void doTestMatchThenNoMatch(CharMatcher matcher, String s) {
        this.reallyTestMatchThenNoMatch(matcher, s);
        this.reallyTestNoMatchThenMatch(matcher.negate(), s);
        this.reallyTestMatchThenNoMatch(matcher.precomputed(), s);
        this.reallyTestNoMatchThenMatch(matcher.negate().precomputed(), s);
        this.reallyTestNoMatchThenMatch(matcher.precomputed().negate(), s);
    }

    private void doTestNoMatchThenMatch(CharMatcher matcher, String s) {
        this.reallyTestNoMatchThenMatch(matcher, s);
        this.reallyTestMatchThenNoMatch(matcher.negate(), s);
        this.reallyTestNoMatchThenMatch(matcher.precomputed(), s);
        this.reallyTestMatchThenNoMatch(matcher.negate().precomputed(), s);
        this.reallyTestMatchThenNoMatch(matcher.precomputed().negate(), s);
    }

    private void reallyTestOneCharMatch(CharMatcher matcher, String s) {
        CharMatcherTest.assertTrue((boolean)matcher.matches(s.charAt(0)));
        CharMatcherTest.assertTrue((boolean)matcher.apply(Character.valueOf(s.charAt(0))));
        CharMatcherTest.assertEquals((int)0, (int)matcher.indexIn((CharSequence)s));
        CharMatcherTest.assertEquals((int)0, (int)matcher.indexIn((CharSequence)s, 0));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn((CharSequence)s, 1));
        CharMatcherTest.assertEquals((int)0, (int)matcher.lastIndexIn((CharSequence)s));
        CharMatcherTest.assertTrue((boolean)matcher.matchesAnyOf((CharSequence)s));
        CharMatcherTest.assertTrue((boolean)matcher.matchesAllOf((CharSequence)s));
        CharMatcherTest.assertFalse((boolean)matcher.matchesNoneOf((CharSequence)s));
        CharMatcherTest.assertEquals((String)"", (String)matcher.removeFrom((CharSequence)s));
        CharMatcherTest.assertEquals((String)"z", (String)matcher.replaceFrom((CharSequence)s, 'z'));
        CharMatcherTest.assertEquals((String)"ZZ", (String)matcher.replaceFrom((CharSequence)s, (CharSequence)"ZZ"));
        CharMatcherTest.assertEquals((String)"", (String)matcher.trimFrom((CharSequence)s));
        CharMatcherTest.assertEquals((int)1, (int)matcher.countIn((CharSequence)s));
    }

    private void reallyTestOneCharNoMatch(CharMatcher matcher, String s) {
        CharMatcherTest.assertFalse((boolean)matcher.matches(s.charAt(0)));
        CharMatcherTest.assertFalse((boolean)matcher.apply(Character.valueOf(s.charAt(0))));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn((CharSequence)s));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn((CharSequence)s, 0));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn((CharSequence)s, 1));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.lastIndexIn((CharSequence)s));
        CharMatcherTest.assertFalse((boolean)matcher.matchesAnyOf((CharSequence)s));
        CharMatcherTest.assertFalse((boolean)matcher.matchesAllOf((CharSequence)s));
        CharMatcherTest.assertTrue((boolean)matcher.matchesNoneOf((CharSequence)s));
        CharMatcherTest.assertSame((Object)s, (Object)matcher.removeFrom((CharSequence)s));
        CharMatcherTest.assertSame((Object)s, (Object)matcher.replaceFrom((CharSequence)s, 'z'));
        CharMatcherTest.assertSame((Object)s, (Object)matcher.replaceFrom((CharSequence)s, (CharSequence)"ZZ"));
        CharMatcherTest.assertSame((Object)s, (Object)matcher.trimFrom((CharSequence)s));
        CharMatcherTest.assertSame((Object)0, (Object)matcher.countIn((CharSequence)s));
    }

    private void reallyTestMatchThenNoMatch(CharMatcher matcher, String s) {
        CharMatcherTest.assertEquals((int)0, (int)matcher.indexIn((CharSequence)s));
        CharMatcherTest.assertEquals((int)0, (int)matcher.indexIn((CharSequence)s, 0));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn((CharSequence)s, 1));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn((CharSequence)s, 2));
        CharMatcherTest.assertEquals((int)0, (int)matcher.lastIndexIn((CharSequence)s));
        CharMatcherTest.assertTrue((boolean)matcher.matchesAnyOf((CharSequence)s));
        CharMatcherTest.assertFalse((boolean)matcher.matchesAllOf((CharSequence)s));
        CharMatcherTest.assertFalse((boolean)matcher.matchesNoneOf((CharSequence)s));
        CharMatcherTest.assertEquals((String)s.substring(1), (String)matcher.removeFrom((CharSequence)s));
        CharMatcherTest.assertEquals((String)("z" + s.substring(1)), (String)matcher.replaceFrom((CharSequence)s, 'z'));
        CharMatcherTest.assertEquals((String)("ZZ" + s.substring(1)), (String)matcher.replaceFrom((CharSequence)s, (CharSequence)"ZZ"));
        CharMatcherTest.assertEquals((String)s.substring(1), (String)matcher.trimFrom((CharSequence)s));
        CharMatcherTest.assertEquals((int)1, (int)matcher.countIn((CharSequence)s));
    }

    private void reallyTestNoMatchThenMatch(CharMatcher matcher, String s) {
        CharMatcherTest.assertEquals((int)1, (int)matcher.indexIn((CharSequence)s));
        CharMatcherTest.assertEquals((int)1, (int)matcher.indexIn((CharSequence)s, 0));
        CharMatcherTest.assertEquals((int)1, (int)matcher.indexIn((CharSequence)s, 1));
        CharMatcherTest.assertEquals((int)-1, (int)matcher.indexIn((CharSequence)s, 2));
        CharMatcherTest.assertEquals((int)1, (int)matcher.lastIndexIn((CharSequence)s));
        CharMatcherTest.assertTrue((boolean)matcher.matchesAnyOf((CharSequence)s));
        CharMatcherTest.assertFalse((boolean)matcher.matchesAllOf((CharSequence)s));
        CharMatcherTest.assertFalse((boolean)matcher.matchesNoneOf((CharSequence)s));
        CharMatcherTest.assertEquals((String)s.substring(0, 1), (String)matcher.removeFrom((CharSequence)s));
        CharMatcherTest.assertEquals((String)(s.substring(0, 1) + "z"), (String)matcher.replaceFrom((CharSequence)s, 'z'));
        CharMatcherTest.assertEquals((String)(s.substring(0, 1) + "ZZ"), (String)matcher.replaceFrom((CharSequence)s, (CharSequence)"ZZ"));
        CharMatcherTest.assertEquals((String)s.substring(0, 1), (String)matcher.trimFrom((CharSequence)s));
        CharMatcherTest.assertEquals((int)1, (int)matcher.countIn((CharSequence)s));
    }

    private void assertEqualsSame(String expected, String in, String out) {
        if (expected.equals(in)) {
            CharMatcherTest.assertSame((Object)in, (Object)out);
        } else {
            CharMatcherTest.assertEquals((String)expected, (String)out);
        }
    }

    public void testCollapse() {
        this.doTestCollapse("-", "_");
        this.doTestCollapse("x-", "x_");
        this.doTestCollapse("-x", "_x");
        this.doTestCollapse("--", "_");
        this.doTestCollapse("x--", "x_");
        this.doTestCollapse("--x", "_x");
        this.doTestCollapse("-x-", "_x_");
        this.doTestCollapse("x-x", "x_x");
        this.doTestCollapse("---", "_");
        this.doTestCollapse("--x-", "_x_");
        this.doTestCollapse("--xx", "_xx");
        this.doTestCollapse("-x--", "_x_");
        this.doTestCollapse("-x-x", "_x_x");
        this.doTestCollapse("-xx-", "_xx_");
        this.doTestCollapse("x--x", "x_x");
        this.doTestCollapse("x-x-", "x_x_");
        this.doTestCollapse("x-xx", "x_xx");
        this.doTestCollapse("x-x--xx---x----x", "x_x_xx_x_x");
        this.doTestCollapseWithNoChange("");
        this.doTestCollapseWithNoChange("x");
        this.doTestCollapseWithNoChange("xx");
    }

    private void doTestCollapse(String in, String out) {
        for (char replacement : new char[]{'_', '-'}) {
            String expected = out.replace('_', replacement);
            this.assertEqualsSame(expected, in, CharMatcher.is((char)'-').collapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.is((char)'-').collapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.is((char)'-').or(CharMatcher.is((char)'#')).collapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.isNot((char)'x').collapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.is((char)'x').negate().collapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.anyOf((CharSequence)"-").collapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.anyOf((CharSequence)"-#").collapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.anyOf((CharSequence)"-#123").collapseFrom((CharSequence)in, replacement));
        }
    }

    private void doTestCollapseWithNoChange(String inout) {
        CharMatcherTest.assertSame((Object)inout, (Object)CharMatcher.is((char)'-').collapseFrom((CharSequence)inout, '_'));
        CharMatcherTest.assertSame((Object)inout, (Object)CharMatcher.is((char)'-').or(CharMatcher.is((char)'#')).collapseFrom((CharSequence)inout, '_'));
        CharMatcherTest.assertSame((Object)inout, (Object)CharMatcher.isNot((char)'x').collapseFrom((CharSequence)inout, '_'));
        CharMatcherTest.assertSame((Object)inout, (Object)CharMatcher.is((char)'x').negate().collapseFrom((CharSequence)inout, '_'));
        CharMatcherTest.assertSame((Object)inout, (Object)CharMatcher.anyOf((CharSequence)"-").collapseFrom((CharSequence)inout, '_'));
        CharMatcherTest.assertSame((Object)inout, (Object)CharMatcher.anyOf((CharSequence)"-#").collapseFrom((CharSequence)inout, '_'));
        CharMatcherTest.assertSame((Object)inout, (Object)CharMatcher.anyOf((CharSequence)"-#123").collapseFrom((CharSequence)inout, '_'));
        CharMatcherTest.assertSame((Object)inout, (Object)CharMatcher.NONE.collapseFrom((CharSequence)inout, '_'));
    }

    public void testCollapse_any() {
        CharMatcherTest.assertEquals((String)"", (String)CharMatcher.ANY.collapseFrom((CharSequence)"", '_'));
        CharMatcherTest.assertEquals((String)"_", (String)CharMatcher.ANY.collapseFrom((CharSequence)"a", '_'));
        CharMatcherTest.assertEquals((String)"_", (String)CharMatcher.ANY.collapseFrom((CharSequence)"ab", '_'));
        CharMatcherTest.assertEquals((String)"_", (String)CharMatcher.ANY.collapseFrom((CharSequence)"abcd", '_'));
    }

    public void testTrimFrom() {
        this.doTestTrimFrom("-", "");
        this.doTestTrimFrom("x-", "x");
        this.doTestTrimFrom("-x", "x");
        this.doTestTrimFrom("--", "");
        this.doTestTrimFrom("x--", "x");
        this.doTestTrimFrom("--x", "x");
        this.doTestTrimFrom("-x-", "x");
        this.doTestTrimFrom("x-x", "x-x");
        this.doTestTrimFrom("---", "");
        this.doTestTrimFrom("--x-", "x");
        this.doTestTrimFrom("--xx", "xx");
        this.doTestTrimFrom("-x--", "x");
        this.doTestTrimFrom("-x-x", "x-x");
        this.doTestTrimFrom("-xx-", "xx");
        this.doTestTrimFrom("x--x", "x--x");
        this.doTestTrimFrom("x-x-", "x-x");
        this.doTestTrimFrom("x-xx", "x-xx");
        this.doTestTrimFrom("x-x--xx---x----x", "x-x--xx---x----x");
        CharMatcherTest.assertEquals((String)"cat", (String)CharMatcher.anyOf((CharSequence)"ab").trimFrom((CharSequence)"abacatbab"));
    }

    private void doTestTrimFrom(String in, String out) {
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.is((char)'-').trimFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.is((char)'-').or(CharMatcher.is((char)'#')).trimFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.isNot((char)'x').trimFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.is((char)'x').negate().trimFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.anyOf((CharSequence)"-").trimFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.anyOf((CharSequence)"-#").trimFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.anyOf((CharSequence)"-#123").trimFrom((CharSequence)in));
    }

    public void testTrimLeadingFrom() {
        this.doTestTrimLeadingFrom("-", "");
        this.doTestTrimLeadingFrom("x-", "x-");
        this.doTestTrimLeadingFrom("-x", "x");
        this.doTestTrimLeadingFrom("--", "");
        this.doTestTrimLeadingFrom("x--", "x--");
        this.doTestTrimLeadingFrom("--x", "x");
        this.doTestTrimLeadingFrom("-x-", "x-");
        this.doTestTrimLeadingFrom("x-x", "x-x");
        this.doTestTrimLeadingFrom("---", "");
        this.doTestTrimLeadingFrom("--x-", "x-");
        this.doTestTrimLeadingFrom("--xx", "xx");
        this.doTestTrimLeadingFrom("-x--", "x--");
        this.doTestTrimLeadingFrom("-x-x", "x-x");
        this.doTestTrimLeadingFrom("-xx-", "xx-");
        this.doTestTrimLeadingFrom("x--x", "x--x");
        this.doTestTrimLeadingFrom("x-x-", "x-x-");
        this.doTestTrimLeadingFrom("x-xx", "x-xx");
        this.doTestTrimLeadingFrom("x-x--xx---x----x", "x-x--xx---x----x");
        CharMatcherTest.assertEquals((String)"catbab", (String)CharMatcher.anyOf((CharSequence)"ab").trimLeadingFrom((CharSequence)"abacatbab"));
    }

    private void doTestTrimLeadingFrom(String in, String out) {
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.is((char)'-').trimLeadingFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.is((char)'-').or(CharMatcher.is((char)'#')).trimLeadingFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.isNot((char)'x').trimLeadingFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.is((char)'x').negate().trimLeadingFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.anyOf((CharSequence)"-#").trimLeadingFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.anyOf((CharSequence)"-#123").trimLeadingFrom((CharSequence)in));
    }

    public void testTrimTrailingFrom() {
        this.doTestTrimTrailingFrom("-", "");
        this.doTestTrimTrailingFrom("x-", "x");
        this.doTestTrimTrailingFrom("-x", "-x");
        this.doTestTrimTrailingFrom("--", "");
        this.doTestTrimTrailingFrom("x--", "x");
        this.doTestTrimTrailingFrom("--x", "--x");
        this.doTestTrimTrailingFrom("-x-", "-x");
        this.doTestTrimTrailingFrom("x-x", "x-x");
        this.doTestTrimTrailingFrom("---", "");
        this.doTestTrimTrailingFrom("--x-", "--x");
        this.doTestTrimTrailingFrom("--xx", "--xx");
        this.doTestTrimTrailingFrom("-x--", "-x");
        this.doTestTrimTrailingFrom("-x-x", "-x-x");
        this.doTestTrimTrailingFrom("-xx-", "-xx");
        this.doTestTrimTrailingFrom("x--x", "x--x");
        this.doTestTrimTrailingFrom("x-x-", "x-x");
        this.doTestTrimTrailingFrom("x-xx", "x-xx");
        this.doTestTrimTrailingFrom("x-x--xx---x----x", "x-x--xx---x----x");
        CharMatcherTest.assertEquals((String)"abacat", (String)CharMatcher.anyOf((CharSequence)"ab").trimTrailingFrom((CharSequence)"abacatbab"));
    }

    private void doTestTrimTrailingFrom(String in, String out) {
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.is((char)'-').trimTrailingFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.is((char)'-').or(CharMatcher.is((char)'#')).trimTrailingFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.isNot((char)'x').trimTrailingFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.is((char)'x').negate().trimTrailingFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.anyOf((CharSequence)"-#").trimTrailingFrom((CharSequence)in));
        CharMatcherTest.assertEquals((String)out, (String)CharMatcher.anyOf((CharSequence)"-#123").trimTrailingFrom((CharSequence)in));
    }

    public void testTrimAndCollapse() {
        this.doTestTrimAndCollapse("", "");
        this.doTestTrimAndCollapse("x", "x");
        this.doTestTrimAndCollapse("-", "");
        this.doTestTrimAndCollapse("x-", "x");
        this.doTestTrimAndCollapse("-x", "x");
        this.doTestTrimAndCollapse("--", "");
        this.doTestTrimAndCollapse("x--", "x");
        this.doTestTrimAndCollapse("--x", "x");
        this.doTestTrimAndCollapse("-x-", "x");
        this.doTestTrimAndCollapse("x-x", "x_x");
        this.doTestTrimAndCollapse("---", "");
        this.doTestTrimAndCollapse("--x-", "x");
        this.doTestTrimAndCollapse("--xx", "xx");
        this.doTestTrimAndCollapse("-x--", "x");
        this.doTestTrimAndCollapse("-x-x", "x_x");
        this.doTestTrimAndCollapse("-xx-", "xx");
        this.doTestTrimAndCollapse("x--x", "x_x");
        this.doTestTrimAndCollapse("x-x-", "x_x");
        this.doTestTrimAndCollapse("x-xx", "x_xx");
        this.doTestTrimAndCollapse("x-x--xx---x----x", "x_x_xx_x_x");
    }

    private void doTestTrimAndCollapse(String in, String out) {
        for (char replacement : new char[]{'_', '-'}) {
            String expected = out.replace('_', replacement);
            this.assertEqualsSame(expected, in, CharMatcher.is((char)'-').trimAndCollapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.is((char)'-').or(CharMatcher.is((char)'#')).trimAndCollapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.isNot((char)'x').trimAndCollapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.is((char)'x').negate().trimAndCollapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.anyOf((CharSequence)"-").trimAndCollapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.anyOf((CharSequence)"-#").trimAndCollapseFrom((CharSequence)in, replacement));
            this.assertEqualsSame(expected, in, CharMatcher.anyOf((CharSequence)"-#123").trimAndCollapseFrom((CharSequence)in, replacement));
        }
    }

    public void testReplaceFrom() {
        CharMatcherTest.assertEquals((String)"yoho", (String)CharMatcher.is((char)'a').replaceFrom((CharSequence)"yaha", 'o'));
        CharMatcherTest.assertEquals((String)"yh", (String)CharMatcher.is((char)'a').replaceFrom((CharSequence)"yaha", (CharSequence)""));
        CharMatcherTest.assertEquals((String)"yoho", (String)CharMatcher.is((char)'a').replaceFrom((CharSequence)"yaha", (CharSequence)"o"));
        CharMatcherTest.assertEquals((String)"yoohoo", (String)CharMatcher.is((char)'a').replaceFrom((CharSequence)"yaha", (CharSequence)"oo"));
        CharMatcherTest.assertEquals((String)"12 &gt; 5", (String)CharMatcher.is((char)'>').replaceFrom((CharSequence)"12 > 5", (CharSequence)"&gt;"));
    }

    public void testPrecomputedOptimizations() {
        CharMatcher m1 = CharMatcher.is((char)'x');
        CharMatcherTest.assertSame((Object)m1, (Object)m1.precomputed());
        CharMatcherTest.assertSame((Object)m1.toString(), (Object)m1.precomputed().toString());
        CharMatcher m2 = CharMatcher.anyOf((CharSequence)"Az");
        CharMatcherTest.assertSame((Object)m2, (Object)m2.precomputed());
        CharMatcherTest.assertSame((Object)m2.toString(), (Object)m2.precomputed().toString());
        CharMatcher m3 = CharMatcher.inRange((char)'A', (char)'Z');
        CharMatcherTest.assertSame((Object)m3, (Object)m3.precomputed());
        CharMatcherTest.assertSame((Object)m3.toString(), (Object)m3.precomputed().toString());
        CharMatcherTest.assertSame((Object)CharMatcher.NONE, (Object)CharMatcher.NONE.precomputed());
        CharMatcherTest.assertSame((Object)CharMatcher.ANY, (Object)CharMatcher.ANY.precomputed());
    }

    @GwtIncompatible(value="java.util.BitSet")
    private static BitSet bitSet(String chars) {
        return CharMatcherTest.bitSet(chars.toCharArray());
    }

    @GwtIncompatible(value="java.util.BitSet")
    private static BitSet bitSet(char[] chars) {
        BitSet tmp = new BitSet();
        for (int i = 0; i < chars.length; ++i) {
            tmp.set(chars[i]);
        }
        return tmp;
    }

    @GwtIncompatible(value="java.util.Random, java.util.BitSet")
    public void testSmallCharMatcher() {
        char c;
        CharMatcher len1 = SmallCharMatcher.from((BitSet)CharMatcherTest.bitSet("#"), (String)"#");
        CharMatcher len2 = SmallCharMatcher.from((BitSet)CharMatcherTest.bitSet("ab"), (String)"ab");
        CharMatcher len3 = SmallCharMatcher.from((BitSet)CharMatcherTest.bitSet("abc"), (String)"abc");
        CharMatcher len4 = SmallCharMatcher.from((BitSet)CharMatcherTest.bitSet("abcd"), (String)"abcd");
        CharMatcherTest.assertTrue((boolean)len1.matches('#'));
        CharMatcherTest.assertFalse((boolean)len1.matches('!'));
        CharMatcherTest.assertTrue((boolean)len2.matches('a'));
        CharMatcherTest.assertTrue((boolean)len2.matches('b'));
        for (c = 'c'; c < 'z'; c = (char)(c + '\u0001')) {
            CharMatcherTest.assertFalse((boolean)len2.matches(c));
        }
        CharMatcherTest.assertTrue((boolean)len3.matches('a'));
        CharMatcherTest.assertTrue((boolean)len3.matches('b'));
        CharMatcherTest.assertTrue((boolean)len3.matches('c'));
        for (c = 'd'; c < 'z'; c = (char)(c + '\u0001')) {
            CharMatcherTest.assertFalse((boolean)len3.matches(c));
        }
        CharMatcherTest.assertTrue((boolean)len4.matches('a'));
        CharMatcherTest.assertTrue((boolean)len4.matches('b'));
        CharMatcherTest.assertTrue((boolean)len4.matches('c'));
        CharMatcherTest.assertTrue((boolean)len4.matches('d'));
        for (c = 'e'; c < 'z'; c = (char)(c + '\u0001')) {
            CharMatcherTest.assertFalse((boolean)len4.matches(c));
        }
        Random rand = new Random(1234L);
        for (int testCase = 0; testCase < 100; ++testCase) {
            char[] chars = CharMatcherTest.randomChars(rand, rand.nextInt(63) + 1);
            CharMatcher m = SmallCharMatcher.from((BitSet)CharMatcherTest.bitSet(chars), (String)new String(chars));
            CharMatcherTest.checkExactMatches(m, chars);
        }
    }

    static void checkExactMatches(CharMatcher m, char[] chars) {
        HashSet positive = Sets.newHashSetWithExpectedSize((int)chars.length);
        for (int i = 0; i < chars.length; ++i) {
            positive.add(Character.valueOf(chars[i]));
        }
        for (int c = 0; c <= 65535; ++c) {
            CharMatcherTest.assertFalse((boolean)(positive.contains(new Character((char)c)) ^ m.matches((char)c)));
        }
    }

    static char[] randomChars(Random rand, int size) {
        HashSet<Character> chars = new HashSet<Character>(size);
        for (int i = 0; i < size; ++i) {
            char c;
            while (chars.contains(Character.valueOf(c = (char)rand.nextInt(65536)))) {
            }
            chars.add(Character.valueOf(c));
        }
        char[] retValue = new char[chars.size()];
        int i = 0;
        Iterator i$ = chars.iterator();
        while (i$.hasNext()) {
            char c = ((Character)i$.next()).charValue();
            retValue[i++] = c;
        }
        Arrays.sort(retValue);
        return retValue;
    }

    public void testToString() {
        CharMatcherTest.assertToStringWorks("CharMatcher.NONE", CharMatcher.anyOf((CharSequence)""));
        CharMatcherTest.assertToStringWorks("CharMatcher.is('\\u0031')", CharMatcher.anyOf((CharSequence)"1"));
        CharMatcherTest.assertToStringWorks("CharMatcher.isNot('\\u0031')", CharMatcher.isNot((char)'1'));
        CharMatcherTest.assertToStringWorks("CharMatcher.anyOf(\"\\u0031\\u0032\")", CharMatcher.anyOf((CharSequence)"12"));
        CharMatcherTest.assertToStringWorks("CharMatcher.anyOf(\"\\u0031\\u0032\\u0033\")", CharMatcher.anyOf((CharSequence)"321"));
        CharMatcherTest.assertToStringWorks("CharMatcher.inRange('\\u0031', '\\u0033')", CharMatcher.inRange((char)'1', (char)'3'));
    }

    private static void assertToStringWorks(String expected, CharMatcher matcher) {
        CharMatcherTest.assertEquals((String)expected, (String)matcher.toString());
        CharMatcherTest.assertEquals((String)expected, (String)matcher.precomputed().toString());
        CharMatcherTest.assertEquals((String)expected, (String)matcher.negate().negate().toString());
        CharMatcherTest.assertEquals((String)expected, (String)matcher.negate().precomputed().negate().toString());
        CharMatcherTest.assertEquals((String)expected, (String)matcher.negate().precomputed().negate().precomputed().toString());
    }
}

