/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.GcFinalization;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.util.HashSet;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class EnumsTest
extends TestCase {
    public void testValueOfFunction() {
        Function function = Enums.valueOfFunction(TestEnum.class);
        EnumsTest.assertEquals((Object)((Object)TestEnum.CHEETO), (Object)function.apply((Object)"CHEETO"));
        EnumsTest.assertEquals((Object)((Object)TestEnum.HONDA), (Object)function.apply((Object)"HONDA"));
        EnumsTest.assertEquals((Object)((Object)TestEnum.POODLE), (Object)function.apply((Object)"POODLE"));
    }

    public void testValueOfFunction_caseSensitive() {
        Function function = Enums.valueOfFunction(TestEnum.class);
        EnumsTest.assertNull((Object)function.apply((Object)"cHEETO"));
        EnumsTest.assertNull((Object)function.apply((Object)"Honda"));
        EnumsTest.assertNull((Object)function.apply((Object)"poodlE"));
    }

    public void testValueOfFunction_nullWhenNoMatchingConstant() {
        Function function = Enums.valueOfFunction(TestEnum.class);
        EnumsTest.assertNull((Object)function.apply((Object)"WOMBAT"));
    }

    public void testValueOfFunction_equals() {
        new EqualsTester().addEqualityGroup(new Object[]{Enums.valueOfFunction(TestEnum.class), Enums.valueOfFunction(TestEnum.class)}).addEqualityGroup(new Object[]{Enums.valueOfFunction(OtherEnum.class)}).testEquals();
    }

    @GwtIncompatible(value="SerializableTester")
    public void testValueOfFunction_serialization() {
        Function function = Enums.valueOfFunction(TestEnum.class);
        SerializableTester.reserializeAndAssert((Object)function);
    }

    public void testGetIfPresent() {
        EnumsTest.assertEquals((Object)Optional.of((Object)((Object)TestEnum.CHEETO)), (Object)Enums.getIfPresent(TestEnum.class, (String)"CHEETO"));
        EnumsTest.assertEquals((Object)Optional.of((Object)((Object)TestEnum.HONDA)), (Object)Enums.getIfPresent(TestEnum.class, (String)"HONDA"));
        EnumsTest.assertEquals((Object)Optional.of((Object)((Object)TestEnum.POODLE)), (Object)Enums.getIfPresent(TestEnum.class, (String)"POODLE"));
        EnumsTest.assertTrue((boolean)Enums.getIfPresent(TestEnum.class, (String)"CHEETO").isPresent());
        EnumsTest.assertTrue((boolean)Enums.getIfPresent(TestEnum.class, (String)"HONDA").isPresent());
        EnumsTest.assertTrue((boolean)Enums.getIfPresent(TestEnum.class, (String)"POODLE").isPresent());
        EnumsTest.assertEquals((Object)((Object)TestEnum.CHEETO), (Object)Enums.getIfPresent(TestEnum.class, (String)"CHEETO").get());
        EnumsTest.assertEquals((Object)((Object)TestEnum.HONDA), (Object)Enums.getIfPresent(TestEnum.class, (String)"HONDA").get());
        EnumsTest.assertEquals((Object)((Object)TestEnum.POODLE), (Object)Enums.getIfPresent(TestEnum.class, (String)"POODLE").get());
    }

    public void testGetIfPresent_caseSensitive() {
        EnumsTest.assertFalse((boolean)Enums.getIfPresent(TestEnum.class, (String)"cHEETO").isPresent());
        EnumsTest.assertFalse((boolean)Enums.getIfPresent(TestEnum.class, (String)"Honda").isPresent());
        EnumsTest.assertFalse((boolean)Enums.getIfPresent(TestEnum.class, (String)"poodlE").isPresent());
    }

    public void testGetIfPresent_whenNoMatchingConstant() {
        EnumsTest.assertEquals((Object)Optional.absent(), (Object)Enums.getIfPresent(TestEnum.class, (String)"WOMBAT"));
    }

    @GwtIncompatible(value="weak references")
    public void testGetIfPresent_doesNotPreventClassUnloading() throws Exception {
        WeakReference<?> shadowLoaderReference = this.doTestClassUnloading();
        GcFinalization.awaitClear(shadowLoaderReference);
    }

    @GwtIncompatible(value="weak references")
    private WeakReference<?> doTestClassUnloading() throws Exception {
        URLClassLoader myLoader = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        URLClassLoader shadowLoader = new URLClassLoader(myLoader.getURLs(), null);
        Class<?> shadowTestEnum = Class.forName(TestEnum.class.getName(), false, shadowLoader);
        EnumsTest.assertNotSame(shadowTestEnum, TestEnum.class);
        HashSet<Object> shadowConstants = new HashSet<Object>();
        for (TestEnum constant : TestEnum.values()) {
            Optional result = Enums.getIfPresent(shadowTestEnum, (String)constant.name());
            EnumsTest.assertTrue((boolean)result.isPresent());
            shadowConstants.add(result.get());
        }
        EnumsTest.assertEquals((Object)ImmutableSet.copyOf((Object[])shadowTestEnum.getEnumConstants()), shadowConstants);
        Optional result = Enums.getIfPresent(shadowTestEnum, (String)"blibby");
        EnumsTest.assertFalse((boolean)result.isPresent());
        return new WeakReference<URLClassLoader>(shadowLoader);
    }

    public void testStringConverter_convert() {
        Converter converter = Enums.stringConverter(TestEnum.class);
        EnumsTest.assertEquals((Object)((Object)TestEnum.CHEETO), (Object)converter.convert((Object)"CHEETO"));
        EnumsTest.assertEquals((Object)((Object)TestEnum.HONDA), (Object)converter.convert((Object)"HONDA"));
        EnumsTest.assertEquals((Object)((Object)TestEnum.POODLE), (Object)converter.convert((Object)"POODLE"));
        EnumsTest.assertNull((Object)converter.convert(null));
        EnumsTest.assertNull((Object)converter.reverse().convert(null));
    }

    public void testStringConverter_convertError() {
        Converter converter = Enums.stringConverter(TestEnum.class);
        try {
            converter.convert((Object)"xxx");
            EnumsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testStringConverter_reverse() {
        Converter converter = Enums.stringConverter(TestEnum.class);
        EnumsTest.assertEquals((String)"CHEETO", (String)((String)converter.reverse().convert((Object)TestEnum.CHEETO)));
        EnumsTest.assertEquals((String)"HONDA", (String)((String)converter.reverse().convert((Object)TestEnum.HONDA)));
        EnumsTest.assertEquals((String)"POODLE", (String)((String)converter.reverse().convert((Object)TestEnum.POODLE)));
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testStringConverter_nullPointerTester() throws Exception {
        Converter converter = Enums.stringConverter(TestEnum.class);
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)converter);
    }

    public void testStringConverter_nullConversions() {
        Converter converter = Enums.stringConverter(TestEnum.class);
        EnumsTest.assertNull((Object)converter.convert(null));
        EnumsTest.assertNull((Object)converter.reverse().convert(null));
    }

    @GwtIncompatible(value="Class.getName()")
    public void testStringConverter_toString() {
        EnumsTest.assertEquals((String)"Enums.stringConverter(com.google.common.base.EnumsTest$TestEnum.class)", (String)Enums.stringConverter(TestEnum.class).toString());
    }

    public void testStringConverter_serialization() {
        SerializableTester.reserializeAndAssert((Object)Enums.stringConverter(TestEnum.class));
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Enums.class);
    }

    @GwtIncompatible(value="reflection")
    public void testGetField() {
        Field foo = Enums.getField((Enum)AnEnum.FOO);
        EnumsTest.assertEquals((String)"FOO", (String)foo.getName());
        EnumsTest.assertTrue((boolean)foo.isAnnotationPresent(ExampleAnnotation.class));
        Field bar = Enums.getField((Enum)AnEnum.BAR);
        EnumsTest.assertEquals((String)"BAR", (String)bar.getName());
        EnumsTest.assertFalse((boolean)bar.isAnnotationPresent(ExampleAnnotation.class));
    }

    private static enum AnEnum {
        FOO,
        BAR;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface ExampleAnnotation {
    }

    private static enum OtherEnum {

    }

    private static enum TestEnum {
        CHEETO,
        HONDA,
        POODLE;

    }
}

