/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.Collections;
import java.util.Set;
import junit.framework.TestCase;
import org.truth0.Truth;

@GwtCompatible(emulated=true)
public final class OptionalTest
extends TestCase {
    public void testAbsent() {
        Optional optionalName = Optional.absent();
        OptionalTest.assertFalse((boolean)optionalName.isPresent());
    }

    public void testOf() {
        OptionalTest.assertEquals((String)"training", (String)((String)Optional.of((Object)"training").get()));
    }

    public void testOf_null() {
        try {
            Optional.of(null);
            OptionalTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFromNullable() {
        Optional optionalName = Optional.fromNullable((Object)"bob");
        OptionalTest.assertEquals((String)"bob", (String)((String)optionalName.get()));
    }

    public void testFromNullable_null() {
        OptionalTest.assertSame((Object)Optional.absent(), (Object)Optional.fromNullable(null));
    }

    public void testIsPresent_no() {
        OptionalTest.assertFalse((boolean)Optional.absent().isPresent());
    }

    public void testIsPresent_yes() {
        OptionalTest.assertTrue((boolean)Optional.of((Object)"training").isPresent());
    }

    public void testGet_absent() {
        Optional optional = Optional.absent();
        try {
            optional.get();
            OptionalTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGet_present() {
        OptionalTest.assertEquals((String)"training", (String)((String)Optional.of((Object)"training").get()));
    }

    public void testOr_T_present() {
        OptionalTest.assertEquals((String)"a", (String)((String)Optional.of((Object)"a").or((Object)"default")));
    }

    public void testOr_T_absent() {
        OptionalTest.assertEquals((Object)"default", (Object)Optional.absent().or((Object)"default"));
    }

    public void testOr_supplier_present() {
        OptionalTest.assertEquals((String)"a", (String)((String)Optional.of((Object)"a").or(Suppliers.ofInstance((Object)"fallback"))));
    }

    public void testOr_supplier_absent() {
        OptionalTest.assertEquals((Object)"fallback", (Object)Optional.absent().or(Suppliers.ofInstance((Object)"fallback")));
    }

    public void testOr_nullSupplier_absent() {
        Supplier nullSupplier = Suppliers.ofInstance(null);
        Optional absentOptional = Optional.absent();
        try {
            absentOptional.or(nullSupplier);
            OptionalTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOr_nullSupplier_present() {
        Supplier nullSupplier = Suppliers.ofInstance(null);
        OptionalTest.assertEquals((String)"a", (String)((String)Optional.of((Object)"a").or(nullSupplier)));
    }

    public void testOr_Optional_present() {
        OptionalTest.assertEquals((Object)Optional.of((Object)"a"), (Object)Optional.of((Object)"a").or(Optional.of((Object)"fallback")));
    }

    public void testOr_Optional_absent() {
        OptionalTest.assertEquals((Object)Optional.of((Object)"fallback"), (Object)Optional.absent().or(Optional.of((Object)"fallback")));
    }

    public void testOrNull_present() {
        OptionalTest.assertEquals((String)"a", (String)((String)Optional.of((Object)"a").orNull()));
    }

    public void testOrNull_absent() {
        OptionalTest.assertNull((Object)Optional.absent().orNull());
    }

    public void testAsSet_present() {
        Set<String> expected = Collections.singleton("a");
        OptionalTest.assertEquals(expected, (Object)Optional.of((Object)"a").asSet());
    }

    public void testAsSet_absent() {
        OptionalTest.assertTrue((String)"Returned set should be empty", (boolean)Optional.absent().asSet().isEmpty());
    }

    public void testAsSet_presentIsImmutable() {
        Set presentAsSet = Optional.of((Object)"a").asSet();
        try {
            presentAsSet.add("b");
            OptionalTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAsSet_absentIsImmutable() {
        Set absentAsSet = Optional.absent().asSet();
        try {
            absentAsSet.add("foo");
            OptionalTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testTransform_absent() {
        OptionalTest.assertEquals((Object)Optional.absent(), (Object)Optional.absent().transform(Functions.identity()));
        OptionalTest.assertEquals((Object)Optional.absent(), (Object)Optional.absent().transform(Functions.toStringFunction()));
    }

    public void testTransform_presentIdentity() {
        OptionalTest.assertEquals((Object)Optional.of((Object)"a"), (Object)Optional.of((Object)"a").transform(Functions.identity()));
    }

    public void testTransform_presentToString() {
        OptionalTest.assertEquals((Object)Optional.of((Object)"42"), (Object)Optional.of((Object)42).transform(Functions.toStringFunction()));
    }

    public void testTransform_present_functionReturnsNull() {
        try {
            Optional.of((Object)"a").transform((Function)new Function<String, String>(){

                public String apply(String input) {
                    return null;
                }
            });
            OptionalTest.fail((String)"Should throw if Function returns null.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testTransform_abssent_functionReturnsNull() {
        OptionalTest.assertEquals((Object)Optional.absent(), (Object)Optional.absent().transform((Function)new Function<Object, Object>(){

            public Object apply(Object input) {
                return null;
            }
        }));
    }

    public void testEqualsAndHashCode_absent() {
        OptionalTest.assertEquals((Object)Optional.absent(), (Object)Optional.absent());
        OptionalTest.assertEquals((int)Optional.absent().hashCode(), (int)Optional.absent().hashCode());
    }

    public void testEqualsAndHashCode_present() {
        OptionalTest.assertEquals((Object)Optional.of((Object)"training"), (Object)Optional.of((Object)"training"));
        OptionalTest.assertFalse((boolean)Optional.of((Object)"a").equals((Object)Optional.of((Object)"b")));
        OptionalTest.assertFalse((boolean)Optional.of((Object)"a").equals((Object)Optional.absent()));
        OptionalTest.assertEquals((int)Optional.of((Object)"training").hashCode(), (int)Optional.of((Object)"training").hashCode());
    }

    public void testToString_absent() {
        OptionalTest.assertEquals((String)"Optional.absent()", (String)Optional.absent().toString());
    }

    public void testToString_present() {
        OptionalTest.assertEquals((String)"Optional.of(training)", (String)Optional.of((Object)"training").toString());
    }

    public void testPresentInstances_allPresent() {
        ImmutableList optionals = ImmutableList.of((Object)Optional.of((Object)"a"), (Object)Optional.of((Object)"b"), (Object)Optional.of((Object)"c"));
        Truth.ASSERT.that(Optional.presentInstances((Iterable)optionals)).iteratesOverSequence((Object[])new String[]{"a", "b", "c"});
    }

    public void testPresentInstances_allAbsent() {
        ImmutableList optionals = ImmutableList.of((Object)Optional.absent(), (Object)Optional.absent());
        Truth.ASSERT.that(Optional.presentInstances((Iterable)optionals)).isEmpty();
    }

    public void testPresentInstances_somePresent() {
        ImmutableList optionals = ImmutableList.of((Object)Optional.of((Object)"a"), (Object)Optional.absent(), (Object)Optional.of((Object)"c"));
        Truth.ASSERT.that(Optional.presentInstances((Iterable)optionals)).iteratesOverSequence((Object[])new String[]{"a", "c"});
    }

    public void testPresentInstances_callingIteratorTwice() {
        ImmutableList optionals = ImmutableList.of((Object)Optional.of((Object)"a"), (Object)Optional.absent(), (Object)Optional.of((Object)"c"));
        Iterable onlyPresent = Optional.presentInstances((Iterable)optionals);
        Truth.ASSERT.that(onlyPresent).iteratesOverSequence((Object[])new String[]{"a", "c"});
        Truth.ASSERT.that(onlyPresent).iteratesOverSequence((Object[])new String[]{"a", "c"});
    }

    public void testPresentInstances_wildcards() {
        ImmutableList optionals = ImmutableList.of((Object)Optional.absent(), (Object)Optional.of((Object)2));
        Iterable onlyPresent = Optional.presentInstances((Iterable)optionals);
        Truth.ASSERT.that(onlyPresent).iteratesOverSequence((Object[])new Number[]{2});
    }

    private static Optional<Integer> getSomeOptionalInt() {
        return Optional.of((Object)1);
    }

    private static FluentIterable<? extends Number> getSomeNumbers() {
        return FluentIterable.from((Iterable)ImmutableList.of());
    }

    public void testSampleCodeError1() {
        Optional<Integer> optionalInt = OptionalTest.getSomeOptionalInt();
    }

    public void testSampleCodeError2() {
        FluentIterable<? extends Number> numbers = OptionalTest.getSomeNumbers();
        Optional first = numbers.first();
    }

    public void testSampleCodeFine1() {
        Optional optionalInt = Optional.of((Object)1);
        Number value = (Number)optionalInt.or((Object)0.5);
    }

    public void testSampleCodeFine2() {
        FluentIterable<? extends Number> numbers = OptionalTest.getSomeNumbers();
        Optional first = numbers.first();
        Number value = (Number)first.or((Object)0.5);
    }

    @GwtIncompatible(value="SerializableTester")
    public void testSerialization() {
        SerializableTester.reserializeAndAssert((Object)Optional.absent());
        SerializableTester.reserializeAndAssert((Object)Optional.of((Object)"foo"));
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointers() {
        NullPointerTester npTester = new NullPointerTester();
        npTester.testAllPublicConstructors(Optional.class);
        npTester.testAllPublicStaticMethods(Optional.class);
        npTester.testAllPublicInstanceMethods((Object)Optional.absent());
        npTester.testAllPublicInstanceMethods((Object)Optional.of((Object)"training"));
    }
}

