/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.testing.NullPointerTester;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.truth0.Truth;

@GwtCompatible(emulated=true)
public class SplitterTest
extends TestCase {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');

    public void testSplitNullString() {
        try {
            COMMA_SPLITTER.split(null);
            SplitterTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCharacterSimpleSplit() {
        String simple = "a,b,c";
        Iterable letters = COMMA_SPLITTER.split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c"});
    }

    public void testCharacterSimpleSplitToList() {
        String simple = "a,b,c";
        List letters = COMMA_SPLITTER.splitToList((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c"});
    }

    public void testToString() {
        SplitterTest.assertEquals((String)"[]", (String)Splitter.on((char)',').split((CharSequence)"").toString());
        SplitterTest.assertEquals((String)"[a, b, c]", (String)Splitter.on((char)',').split((CharSequence)"a,b,c").toString());
        SplitterTest.assertEquals((String)"[yam, bam, jam, ham]", (String)Splitter.on((String)", ").split((CharSequence)"yam, bam, jam, ham").toString());
    }

    public void testCharacterSimpleSplitWithNoDelimiter() {
        String simple = "a,b,c";
        Iterable letters = Splitter.on((char)'.').split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a,b,c"});
    }

    public void testCharacterSplitWithDoubleDelimiter() {
        String doubled = "a,,b,c";
        Iterable letters = COMMA_SPLITTER.split((CharSequence)doubled);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "", "b", "c"});
    }

    public void testCharacterSplitWithDoubleDelimiterAndSpace() {
        String doubled = "a,, b,c";
        Iterable letters = COMMA_SPLITTER.split((CharSequence)doubled);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "", " b", "c"});
    }

    public void testCharacterSplitWithTrailingDelimiter() {
        String trailing = "a,b,c,";
        Iterable letters = COMMA_SPLITTER.split((CharSequence)trailing);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c", ""});
    }

    public void testCharacterSplitWithLeadingDelimiter() {
        String leading = ",a,b,c";
        Iterable letters = COMMA_SPLITTER.split((CharSequence)leading);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"", "a", "b", "c"});
    }

    public void testCharacterSplitWithMulitpleLetters() {
        Iterable testCharacteringMotto = Splitter.on((char)'-').split((CharSequence)"Testing-rocks-Debugging-sucks");
        Truth.ASSERT.that(testCharacteringMotto).iteratesOverSequence((Object[])new String[]{"Testing", "rocks", "Debugging", "sucks"});
    }

    public void testCharacterSplitWithMatcherDelimiter() {
        Iterable testCharacteringMotto = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).split((CharSequence)"Testing\nrocks\tDebugging sucks");
        Truth.ASSERT.that(testCharacteringMotto).iteratesOverSequence((Object[])new String[]{"Testing", "rocks", "Debugging", "sucks"});
    }

    public void testCharacterSplitWithDoubleDelimiterOmitEmptyStrings() {
        String doubled = "a..b.c";
        Iterable letters = Splitter.on((char)'.').omitEmptyStrings().split((CharSequence)doubled);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c"});
    }

    public void testCharacterSplitEmptyToken() {
        String emptyToken = "a. .c";
        Iterable letters = Splitter.on((char)'.').trimResults().split((CharSequence)emptyToken);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "", "c"});
    }

    public void testCharacterSplitEmptyTokenOmitEmptyStrings() {
        String emptyToken = "a. .c";
        Iterable letters = Splitter.on((char)'.').omitEmptyStrings().trimResults().split((CharSequence)emptyToken);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "c"});
    }

    public void testCharacterSplitOnEmptyString() {
        Iterable nothing = Splitter.on((char)'.').split((CharSequence)"");
        Truth.ASSERT.that(nothing).iteratesOverSequence((Object[])new String[]{""});
    }

    public void testCharacterSplitOnEmptyStringOmitEmptyStrings() {
        Truth.ASSERT.that(Splitter.on((char)'.').omitEmptyStrings().split((CharSequence)"")).isEmpty();
    }

    public void testCharacterSplitOnOnlyDelimiter() {
        Iterable blankblank = Splitter.on((char)'.').split((CharSequence)".");
        Truth.ASSERT.that(blankblank).iteratesOverSequence((Object[])new String[]{"", ""});
    }

    public void testCharacterSplitOnOnlyDelimitersOmitEmptyStrings() {
        Iterable empty = Splitter.on((char)'.').omitEmptyStrings().split((CharSequence)"...");
        Truth.ASSERT.that(empty).isEmpty();
    }

    public void testCharacterSplitWithTrim() {
        String jacksons = "arfo(Marlon)aorf, (Michael)orfa, afro(Jackie)orfa, ofar(Jemaine), aff(Tito)";
        Iterable family = COMMA_SPLITTER.trimResults(CharMatcher.anyOf((CharSequence)"afro").or(CharMatcher.WHITESPACE)).split((CharSequence)jacksons);
        Truth.ASSERT.that(family).iteratesOverSequence((Object[])new String[]{"(Marlon)", "(Michael)", "(Jackie)", "(Jemaine)", "(Tito)"});
    }

    public void testStringSimpleSplit() {
        String simple = "a,b,c";
        Iterable letters = Splitter.on((char)',').split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c"});
    }

    public void testStringSimpleSplitWithNoDelimiter() {
        String simple = "a,b,c";
        Iterable letters = Splitter.on((char)'.').split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a,b,c"});
    }

    public void testStringSplitWithDoubleDelimiter() {
        String doubled = "a,,b,c";
        Iterable letters = Splitter.on((char)',').split((CharSequence)doubled);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "", "b", "c"});
    }

    public void testStringSplitWithDoubleDelimiterAndSpace() {
        String doubled = "a,, b,c";
        Iterable letters = Splitter.on((char)',').split((CharSequence)doubled);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "", " b", "c"});
    }

    public void testStringSplitWithTrailingDelimiter() {
        String trailing = "a,b,c,";
        Iterable letters = Splitter.on((char)',').split((CharSequence)trailing);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c", ""});
    }

    public void testStringSplitWithLeadingDelimiter() {
        String leading = ",a,b,c";
        Iterable letters = Splitter.on((char)',').split((CharSequence)leading);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"", "a", "b", "c"});
    }

    public void testStringSplitWithMultipleLetters() {
        Iterable testStringingMotto = Splitter.on((char)'-').split((CharSequence)"Testing-rocks-Debugging-sucks");
        Truth.ASSERT.that(testStringingMotto).iteratesOverSequence((Object[])new String[]{"Testing", "rocks", "Debugging", "sucks"});
    }

    public void testStringSplitWithDoubleDelimiterOmitEmptyStrings() {
        String doubled = "a..b.c";
        Iterable letters = Splitter.on((char)'.').omitEmptyStrings().split((CharSequence)doubled);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c"});
    }

    public void testStringSplitEmptyToken() {
        String emptyToken = "a. .c";
        Iterable letters = Splitter.on((char)'.').trimResults().split((CharSequence)emptyToken);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "", "c"});
    }

    public void testStringSplitEmptyTokenOmitEmptyStrings() {
        String emptyToken = "a. .c";
        Iterable letters = Splitter.on((char)'.').omitEmptyStrings().trimResults().split((CharSequence)emptyToken);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "c"});
    }

    public void testStringSplitWithLongDelimiter() {
        String longDelimiter = "a, b, c";
        Iterable letters = Splitter.on((String)", ").split((CharSequence)longDelimiter);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c"});
    }

    public void testStringSplitWithLongLeadingDelimiter() {
        String longDelimiter = ", a, b, c";
        Iterable letters = Splitter.on((String)", ").split((CharSequence)longDelimiter);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"", "a", "b", "c"});
    }

    public void testStringSplitWithLongTrailingDelimiter() {
        String longDelimiter = "a, b, c, ";
        Iterable letters = Splitter.on((String)", ").split((CharSequence)longDelimiter);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c", ""});
    }

    public void testStringSplitWithDelimiterSubstringInValue() {
        String fourCommasAndFourSpaces = ",,,,    ";
        Iterable threeCommasThenThreeSpaces = Splitter.on((String)", ").split((CharSequence)fourCommasAndFourSpaces);
        Truth.ASSERT.that(threeCommasThenThreeSpaces).iteratesOverSequence((Object[])new String[]{",,,", "   "});
    }

    public void testStringSplitWithEmptyString() {
        try {
            Splitter.on((String)"");
            SplitterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testStringSplitOnEmptyString() {
        Iterable notMuch = Splitter.on((char)'.').split((CharSequence)"");
        Truth.ASSERT.that(notMuch).iteratesOverSequence((Object[])new String[]{""});
    }

    public void testStringSplitOnEmptyStringOmitEmptyString() {
        Truth.ASSERT.that(Splitter.on((char)'.').omitEmptyStrings().split((CharSequence)"")).isEmpty();
    }

    public void testStringSplitOnOnlyDelimiter() {
        Iterable blankblank = Splitter.on((char)'.').split((CharSequence)".");
        Truth.ASSERT.that(blankblank).iteratesOverSequence((Object[])new String[]{"", ""});
    }

    public void testStringSplitOnOnlyDelimitersOmitEmptyStrings() {
        Iterable empty = Splitter.on((char)'.').omitEmptyStrings().split((CharSequence)"...");
        Truth.ASSERT.that(empty).isEmpty();
    }

    public void testStringSplitWithTrim() {
        String jacksons = "arfo(Marlon)aorf, (Michael)orfa, afro(Jackie)orfa, ofar(Jemaine), aff(Tito)";
        Iterable family = Splitter.on((char)',').trimResults(CharMatcher.anyOf((CharSequence)"afro").or(CharMatcher.WHITESPACE)).split((CharSequence)jacksons);
        Truth.ASSERT.that(family).iteratesOverSequence((Object[])new String[]{"(Marlon)", "(Michael)", "(Jackie)", "(Jemaine)", "(Tito)"});
    }

    @GwtIncompatible(value="Splitter.onPattern")
    public void testPatternSimpleSplit() {
        String simple = "a,b,c";
        Iterable letters = Splitter.onPattern((String)",").split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c"});
    }

    @GwtIncompatible(value="Splitter.onPattern")
    public void testPatternSimpleSplitWithNoDelimiter() {
        String simple = "a,b,c";
        Iterable letters = Splitter.onPattern((String)"foo").split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a,b,c"});
    }

    @GwtIncompatible(value="Splitter.onPattern")
    public void testPatternSplitWithDoubleDelimiter() {
        String doubled = "a,,b,c";
        Iterable letters = Splitter.onPattern((String)",").split((CharSequence)doubled);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "", "b", "c"});
    }

    @GwtIncompatible(value="Splitter.onPattern")
    public void testPatternSplitWithDoubleDelimiterAndSpace() {
        String doubled = "a,, b,c";
        Iterable letters = Splitter.onPattern((String)",").split((CharSequence)doubled);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "", " b", "c"});
    }

    @GwtIncompatible(value="Splitter.onPattern")
    public void testPatternSplitWithTrailingDelimiter() {
        String trailing = "a,b,c,";
        Iterable letters = Splitter.onPattern((String)",").split((CharSequence)trailing);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c", ""});
    }

    @GwtIncompatible(value="Splitter.onPattern")
    public void testPatternSplitWithLeadingDelimiter() {
        String leading = ",a,b,c";
        Iterable letters = Splitter.onPattern((String)",").split((CharSequence)leading);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"", "a", "b", "c"});
    }

    @GwtIncompatible(value="Splitter.onPattern")
    public void testPatternSplitWithMultipleLetters() {
        Iterable testPatterningMotto = Splitter.onPattern((String)"-").split((CharSequence)"Testing-rocks-Debugging-sucks");
        Truth.ASSERT.that(testPatterningMotto).iteratesOverSequence((Object[])new String[]{"Testing", "rocks", "Debugging", "sucks"});
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    private static Pattern literalDotPattern() {
        return Pattern.compile("\\.");
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testPatternSplitWithDoubleDelimiterOmitEmptyStrings() {
        String doubled = "a..b.c";
        Iterable letters = Splitter.on((Pattern)SplitterTest.literalDotPattern()).omitEmptyStrings().split((CharSequence)doubled);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c"});
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testPatternSplitLookBehind() {
        String toSplit = ":foo::barbaz:";
        String regexPattern = "(?<=:)";
        Iterable split = Splitter.onPattern((String)regexPattern).split((CharSequence)toSplit);
        Truth.ASSERT.that(split).iteratesOverSequence((Object[])new String[]{":", "foo:", ":", "barbaz:"});
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testPatternSplitWordBoundary() {
        String string = "foo<bar>bletch";
        Iterable words = Splitter.on((Pattern)Pattern.compile("\\b")).split((CharSequence)string);
        Truth.ASSERT.that(words).iteratesOverSequence((Object[])new String[]{"foo", "<", "bar", ">", "bletch"});
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testPatternSplitEmptyToken() {
        String emptyToken = "a. .c";
        Iterable letters = Splitter.on((Pattern)SplitterTest.literalDotPattern()).trimResults().split((CharSequence)emptyToken);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "", "c"});
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testPatternSplitEmptyTokenOmitEmptyStrings() {
        String emptyToken = "a. .c";
        Iterable letters = Splitter.on((Pattern)SplitterTest.literalDotPattern()).omitEmptyStrings().trimResults().split((CharSequence)emptyToken);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "c"});
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testPatternSplitOnOnlyDelimiter() {
        Iterable blankblank = Splitter.on((Pattern)SplitterTest.literalDotPattern()).split((CharSequence)".");
        Truth.ASSERT.that(blankblank).iteratesOverSequence((Object[])new String[]{"", ""});
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testPatternSplitOnOnlyDelimitersOmitEmptyStrings() {
        Iterable empty = Splitter.on((Pattern)SplitterTest.literalDotPattern()).omitEmptyStrings().split((CharSequence)"...");
        Truth.ASSERT.that(empty).isEmpty();
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testPatternSplitMatchingIsGreedy() {
        String longDelimiter = "a, b,   c";
        Iterable letters = Splitter.on((Pattern)Pattern.compile(",\\s*")).split((CharSequence)longDelimiter);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c"});
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testPatternSplitWithLongLeadingDelimiter() {
        String longDelimiter = ", a, b, c";
        Iterable letters = Splitter.on((Pattern)Pattern.compile(", ")).split((CharSequence)longDelimiter);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"", "a", "b", "c"});
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testPatternSplitWithLongTrailingDelimiter() {
        String longDelimiter = "a, b, c/ ";
        Iterable letters = Splitter.on((Pattern)Pattern.compile("[,/]\\s")).split((CharSequence)longDelimiter);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c", ""});
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testPatternSplitInvalidPattern() {
        try {
            Splitter.on((Pattern)Pattern.compile("a*"));
            SplitterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testPatternSplitWithTrim() {
        String jacksons = "arfo(Marlon)aorf, (Michael)orfa, afro(Jackie)orfa, ofar(Jemaine), aff(Tito)";
        Iterable family = Splitter.on((Pattern)Pattern.compile(",")).trimResults(CharMatcher.anyOf((CharSequence)"afro").or(CharMatcher.WHITESPACE)).split((CharSequence)jacksons);
        Truth.ASSERT.that(family).iteratesOverSequence((Object[])new String[]{"(Marlon)", "(Michael)", "(Jackie)", "(Jemaine)", "(Tito)"});
    }

    public void testSplitterIterableIsUnmodifiable_char() {
        this.assertIteratorIsUnmodifiable(COMMA_SPLITTER.split((CharSequence)"a,b").iterator());
    }

    public void testSplitterIterableIsUnmodifiable_string() {
        this.assertIteratorIsUnmodifiable(Splitter.on((char)',').split((CharSequence)"a,b").iterator());
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testSplitterIterableIsUnmodifiable_pattern() {
        this.assertIteratorIsUnmodifiable(Splitter.on((Pattern)Pattern.compile(",")).split((CharSequence)"a,b").iterator());
    }

    private void assertIteratorIsUnmodifiable(Iterator<?> iterator) {
        iterator.next();
        try {
            iterator.remove();
            SplitterTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testSplitterIterableIsLazy_char() {
        this.assertSplitterIterableIsLazy(COMMA_SPLITTER);
    }

    public void testSplitterIterableIsLazy_string() {
        this.assertSplitterIterableIsLazy(Splitter.on((char)','));
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void testSplitterIterableIsLazy_pattern() {
        this.assertSplitterIterableIsLazy(Splitter.onPattern((String)","));
    }

    private void assertSplitterIterableIsLazy(Splitter splitter) {
        StringBuilder builder = new StringBuilder();
        Iterator iterator = splitter.split((CharSequence)builder).iterator();
        builder.append("A,");
        SplitterTest.assertEquals((String)"A", (String)((String)iterator.next()));
        builder.append("B,");
        SplitterTest.assertEquals((String)"B", (String)((String)iterator.next()));
        builder.append("C");
        SplitterTest.assertEquals((String)"C", (String)((String)iterator.next()));
        SplitterTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testFixedLengthSimpleSplit() {
        String simple = "abcde";
        Iterable letters = Splitter.fixedLength((int)2).split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"ab", "cd", "e"});
    }

    public void testFixedLengthSplitEqualChunkLength() {
        String simple = "abcdef";
        Iterable letters = Splitter.fixedLength((int)2).split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"ab", "cd", "ef"});
    }

    public void testFixedLengthSplitOnlyOneChunk() {
        String simple = "abc";
        Iterable letters = Splitter.fixedLength((int)3).split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"abc"});
    }

    public void testFixedLengthSplitSmallerString() {
        String simple = "ab";
        Iterable letters = Splitter.fixedLength((int)3).split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"ab"});
    }

    public void testFixedLengthSplitEmptyString() {
        String simple = "";
        Iterable letters = Splitter.fixedLength((int)3).split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{""});
    }

    public void testFixedLengthSplitEmptyStringWithOmitEmptyStrings() {
        Truth.ASSERT.that(Splitter.fixedLength((int)3).omitEmptyStrings().split((CharSequence)"")).isEmpty();
    }

    public void testFixedLengthSplitIntoChars() {
        String simple = "abcd";
        Iterable letters = Splitter.fixedLength((int)1).split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c", "d"});
    }

    public void testFixedLengthSplitZeroChunkLen() {
        try {
            Splitter.fixedLength((int)0);
            SplitterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFixedLengthSplitNegativeChunkLen() {
        try {
            Splitter.fixedLength((int)-1);
            SplitterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLimitLarge() {
        String simple = "abcd";
        Iterable letters = Splitter.fixedLength((int)1).limit(100).split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "b", "c", "d"});
    }

    public void testLimitOne() {
        String simple = "abcd";
        Iterable letters = Splitter.fixedLength((int)1).limit(1).split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"abcd"});
    }

    public void testLimitFixedLength() {
        String simple = "abcd";
        Iterable letters = Splitter.fixedLength((int)1).limit(2).split((CharSequence)simple);
        Truth.ASSERT.that(letters).iteratesOverSequence((Object[])new String[]{"a", "bcd"});
    }

    public void testLimitSeparator() {
        String simple = "a,b,c,d";
        Iterable items = COMMA_SPLITTER.limit(2).split((CharSequence)simple);
        Truth.ASSERT.that(items).iteratesOverSequence((Object[])new String[]{"a", "b,c,d"});
    }

    public void testLimitExtraSeparators() {
        String text = "a,,,b,,c,d";
        Iterable items = COMMA_SPLITTER.limit(2).split((CharSequence)text);
        Truth.ASSERT.that(items).iteratesOverSequence((Object[])new String[]{"a", ",,b,,c,d"});
    }

    public void testLimitExtraSeparatorsOmitEmpty() {
        String text = "a,,,b,,c,d";
        Iterable items = COMMA_SPLITTER.limit(2).omitEmptyStrings().split((CharSequence)text);
        Truth.ASSERT.that(items).iteratesOverSequence((Object[])new String[]{"a", "b,,c,d"});
    }

    public void testLimitExtraSeparatorsOmitEmpty3() {
        String text = "a,,,b,,c,d";
        Iterable items = COMMA_SPLITTER.limit(3).omitEmptyStrings().split((CharSequence)text);
        Truth.ASSERT.that(items).iteratesOverSequence((Object[])new String[]{"a", "b", "c,d"});
    }

    public void testLimitExtraSeparatorsTrim() {
        String text = ",,a,,  , b ,, c,d ";
        Iterable items = COMMA_SPLITTER.limit(2).omitEmptyStrings().trimResults().split((CharSequence)text);
        Truth.ASSERT.that(items).iteratesOverSequence((Object[])new String[]{"a", "b ,, c,d"});
    }

    public void testLimitExtraSeparatorsTrim3() {
        String text = ",,a,,  , b ,, c,d ";
        Iterable items = COMMA_SPLITTER.limit(3).omitEmptyStrings().trimResults().split((CharSequence)text);
        Truth.ASSERT.that(items).iteratesOverSequence((Object[])new String[]{"a", "b", "c,d"});
    }

    public void testLimitExtraSeparatorsTrim1() {
        String text = ",,a,,  , b ,, c,d ";
        Iterable items = COMMA_SPLITTER.limit(1).omitEmptyStrings().trimResults().split((CharSequence)text);
        Truth.ASSERT.that(items).iteratesOverSequence((Object[])new String[]{"a,,  , b ,, c,d"});
    }

    public void testLimitExtraSeparatorsTrim1NoOmit() {
        String text = ",,a,,  , b ,, c,d ";
        Iterable items = COMMA_SPLITTER.limit(1).trimResults().split((CharSequence)text);
        Truth.ASSERT.that(items).iteratesOverSequence((Object[])new String[]{",,a,,  , b ,, c,d"});
    }

    public void testLimitExtraSeparatorsTrim1Empty() {
        String text = "";
        Iterable items = COMMA_SPLITTER.limit(1).split((CharSequence)text);
        Truth.ASSERT.that(items).iteratesOverSequence((Object[])new String[]{""});
    }

    public void testLimitExtraSeparatorsTrim1EmptyOmit() {
        String text = "";
        Iterable items = COMMA_SPLITTER.omitEmptyStrings().limit(1).split((CharSequence)text);
        Truth.ASSERT.that(items).isEmpty();
    }

    public void testInvalidZeroLimit() {
        try {
            COMMA_SPLITTER.limit(0);
            SplitterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Splitter.class);
        tester.testAllPublicInstanceMethods((Object)Splitter.on((char)','));
        tester.testAllPublicInstanceMethods((Object)Splitter.on((char)',').trimResults());
    }

    private static <E> List<E> asList(Collection<E> collection) {
        return ImmutableList.copyOf(collection);
    }

    public void testMapSplitter_trimmedBoth() {
        Map m = COMMA_SPLITTER.trimResults().withKeyValueSeparator(Splitter.on((char)':').trimResults()).split((CharSequence)"boy  : tom , girl: tina , cat  : kitty , dog: tommy ");
        ImmutableMap expected = ImmutableMap.of((Object)"boy", (Object)"tom", (Object)"girl", (Object)"tina", (Object)"cat", (Object)"kitty", (Object)"dog", (Object)"tommy");
        Truth.ASSERT.that(m).isEqualTo((Object)expected);
        Truth.ASSERT.that(SplitterTest.asList(m.entrySet())).is(SplitterTest.asList(expected.entrySet()));
    }

    public void testMapSplitter_trimmedEntries() {
        Map m = COMMA_SPLITTER.trimResults().withKeyValueSeparator(":").split((CharSequence)"boy  : tom , girl: tina , cat  : kitty , dog: tommy ");
        ImmutableMap expected = ImmutableMap.of((Object)"boy  ", (Object)" tom", (Object)"girl", (Object)" tina", (Object)"cat  ", (Object)" kitty", (Object)"dog", (Object)" tommy");
        Truth.ASSERT.that(m).isEqualTo((Object)expected);
        Truth.ASSERT.that(SplitterTest.asList(m.entrySet())).is(SplitterTest.asList(expected.entrySet()));
    }

    public void testMapSplitter_trimmedKeyValue() {
        Map m = COMMA_SPLITTER.withKeyValueSeparator(Splitter.on((char)':').trimResults()).split((CharSequence)"boy  : tom , girl: tina , cat  : kitty , dog: tommy ");
        ImmutableMap expected = ImmutableMap.of((Object)"boy", (Object)"tom", (Object)"girl", (Object)"tina", (Object)"cat", (Object)"kitty", (Object)"dog", (Object)"tommy");
        Truth.ASSERT.that(m).isEqualTo((Object)expected);
        Truth.ASSERT.that(SplitterTest.asList(m.entrySet())).is(SplitterTest.asList(expected.entrySet()));
    }

    public void testMapSplitter_notTrimmed() {
        Map m = COMMA_SPLITTER.withKeyValueSeparator(":").split((CharSequence)" boy:tom , girl: tina , cat :kitty , dog:  tommy ");
        ImmutableMap expected = ImmutableMap.of((Object)" boy", (Object)"tom ", (Object)" girl", (Object)" tina ", (Object)" cat ", (Object)"kitty ", (Object)" dog", (Object)"  tommy ");
        Truth.ASSERT.that(m).isEqualTo((Object)expected);
        Truth.ASSERT.that(SplitterTest.asList(m.entrySet())).is(SplitterTest.asList(expected.entrySet()));
    }

    public void testMapSplitter_CharacterSeparator() {
        Map m = Splitter.on((String)",").withKeyValueSeparator(':').split((CharSequence)"boy:tom,girl:tina,cat:kitty,dog:tommy");
        ImmutableMap expected = ImmutableMap.of((Object)"boy", (Object)"tom", (Object)"girl", (Object)"tina", (Object)"cat", (Object)"kitty", (Object)"dog", (Object)"tommy");
        Truth.ASSERT.that(m).isEqualTo((Object)expected);
        Truth.ASSERT.that(SplitterTest.asList(m.entrySet())).is(SplitterTest.asList(expected.entrySet()));
    }

    public void testMapSplitter_multiCharacterSeparator() {
        Map m = Splitter.on((String)",").withKeyValueSeparator(":^&").split((CharSequence)"boy:^&tom,girl:^&tina,cat:^&kitty,dog:^&tommy");
        ImmutableMap expected = ImmutableMap.of((Object)"boy", (Object)"tom", (Object)"girl", (Object)"tina", (Object)"cat", (Object)"kitty", (Object)"dog", (Object)"tommy");
        Truth.ASSERT.that(m).isEqualTo((Object)expected);
        Truth.ASSERT.that(SplitterTest.asList(m.entrySet())).is(SplitterTest.asList(expected.entrySet()));
    }

    public void testMapSplitter_emptySeparator() {
        try {
            COMMA_SPLITTER.withKeyValueSeparator("");
            SplitterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMapSplitter_malformedEntry() {
        try {
            COMMA_SPLITTER.withKeyValueSeparator("=").split((CharSequence)"a=1,b,c=2");
            SplitterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMapSplitter_orderedResults() {
        Map m = Splitter.on((char)',').withKeyValueSeparator(":").split((CharSequence)"boy:tom,girl:tina,cat:kitty,dog:tommy");
        Truth.ASSERT.that(m.keySet()).iteratesOverSequence((Object[])new String[]{"boy", "girl", "cat", "dog"});
        Truth.ASSERT.that(m).isEqualTo((Object)ImmutableMap.of((Object)"boy", (Object)"tom", (Object)"girl", (Object)"tina", (Object)"cat", (Object)"kitty", (Object)"dog", (Object)"tommy"));
        m = Splitter.on((char)',').withKeyValueSeparator(":").split((CharSequence)"girl:tina,boy:tom,dog:tommy,cat:kitty");
        Truth.ASSERT.that(m.keySet()).iteratesOverSequence((Object[])new String[]{"girl", "boy", "dog", "cat"});
        Truth.ASSERT.that(m).isEqualTo((Object)ImmutableMap.of((Object)"boy", (Object)"tom", (Object)"girl", (Object)"tina", (Object)"cat", (Object)"kitty", (Object)"dog", (Object)"tommy"));
    }

    public void testMapSplitter_duplicateKeys() {
        try {
            Splitter.on((char)',').withKeyValueSeparator(":").split((CharSequence)"a:1,b:2,a:3");
            SplitterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

