/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.EmptyContiguousSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeTest;
import com.google.common.collect.RegularContiguousSet;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.NavigableSetTestSuiteBuilder;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.SetGenerators;
import com.google.common.collect.testing.testers.NavigableSetNavigationTester;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import java.util.Collection;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.truth0.Truth;

@GwtCompatible(emulated=true)
public class ContiguousSetTest
extends TestCase {
    private static DiscreteDomain<Integer> NOT_EQUAL_TO_INTEGERS = new DiscreteDomain<Integer>(){

        public Integer next(Integer value) {
            return (Integer)1.integers().next((Comparable)value);
        }

        public Integer previous(Integer value) {
            return (Integer)1.integers().previous((Comparable)value);
        }

        public long distance(Integer start, Integer end) {
            return 1.integers().distance((Comparable)start, (Comparable)end);
        }

        public Integer minValue() {
            return (Integer)1.integers().minValue();
        }

        public Integer maxValue() {
            return (Integer)1.integers().maxValue();
        }
    };

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()), ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()), ContiguousSet.create((Range)Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()), ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()), ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), NOT_EQUAL_TO_INTEGERS), ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)), NOT_EQUAL_TO_INTEGERS), ContiguousSet.create((Range)Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3)), NOT_EQUAL_TO_INTEGERS), ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), NOT_EQUAL_TO_INTEGERS), ImmutableSortedSet.of((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3))}).testEquals();
        ContiguousSetTest.assertEquals((Object)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), (DiscreteDomain)DiscreteDomain.integers()), (Object)ContiguousSet.create((Range)Range.all(), (DiscreteDomain)DiscreteDomain.integers()));
        ContiguousSetTest.assertEquals((Object)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), (DiscreteDomain)DiscreteDomain.integers()), (Object)ContiguousSet.create((Range)Range.atLeast((Comparable)Integer.valueOf(Integer.MIN_VALUE)), (DiscreteDomain)DiscreteDomain.integers()));
        ContiguousSetTest.assertEquals((Object)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), (DiscreteDomain)DiscreteDomain.integers()), (Object)ContiguousSet.create((Range)Range.atMost((Comparable)Integer.valueOf(Integer.MAX_VALUE)), (DiscreteDomain)DiscreteDomain.integers()));
    }

    @GwtIncompatible(value="SerializableTester")
    public void testSerialization() {
        ContiguousSet empty = ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(1)), (DiscreteDomain)DiscreteDomain.integers());
        ContiguousSetTest.assertTrue((boolean)(empty instanceof EmptyContiguousSet));
        SerializableTester.reserializeAndAssert((Object)empty);
        ContiguousSet regular = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers());
        ContiguousSetTest.assertTrue((boolean)(regular instanceof RegularContiguousSet));
        SerializableTester.reserializeAndAssert((Object)regular);
        ContiguousSet enormous = ContiguousSet.create((Range)Range.all(), (DiscreteDomain)DiscreteDomain.integers());
        ContiguousSetTest.assertTrue((boolean)(enormous instanceof RegularContiguousSet));
        ContiguousSet enormousReserialized = (ContiguousSet)SerializableTester.reserialize((Object)enormous);
        ContiguousSetTest.assertEquals((Object)enormous, (Object)enormousReserialized);
    }

    public void testCreate_noMin() {
        Range range = Range.lessThan((Comparable)Integer.valueOf(0));
        try {
            ContiguousSet.create((Range)range, RangeTest.UNBOUNDED_DOMAIN);
            ContiguousSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreate_noMax() {
        Range range = Range.greaterThan((Comparable)Integer.valueOf(0));
        try {
            ContiguousSet.create((Range)range, RangeTest.UNBOUNDED_DOMAIN);
            ContiguousSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreate_empty() {
        ContiguousSetTest.assertEquals((Object)ImmutableSet.of(), (Object)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(1)), (DiscreteDomain)DiscreteDomain.integers()));
        ContiguousSetTest.assertEquals((Object)ImmutableSet.of(), (Object)ContiguousSet.create((Range)Range.openClosed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(5)), (DiscreteDomain)DiscreteDomain.integers()));
        ContiguousSetTest.assertEquals((Object)ImmutableSet.of(), (Object)ContiguousSet.create((Range)Range.lessThan((Comparable)Integer.valueOf(Integer.MIN_VALUE)), (DiscreteDomain)DiscreteDomain.integers()));
        ContiguousSetTest.assertEquals((Object)ImmutableSet.of(), (Object)ContiguousSet.create((Range)Range.greaterThan((Comparable)Integer.valueOf(Integer.MAX_VALUE)), (DiscreteDomain)DiscreteDomain.integers()));
    }

    public void testHeadSet() {
        ContiguousSet set = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers());
        Truth.ASSERT.that((Collection)set.headSet((Object)1)).isEmpty();
        Truth.ASSERT.that((Collection)set.headSet((Object)2)).has().item((Object)1);
        Truth.ASSERT.that((Collection)set.headSet((Object)3)).has().exactly((Object)1, (Object)2, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that((Collection)set.headSet((Object)4)).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
        Truth.ASSERT.that((Collection)set.headSet((Object)Integer.MAX_VALUE)).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
        Truth.ASSERT.that((Collection)set.headSet((Object)1, true)).has().item((Object)1);
        Truth.ASSERT.that((Collection)set.headSet((Object)2, true)).has().exactly((Object)1, (Object)2, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that((Collection)set.headSet((Object)3, true)).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
        Truth.ASSERT.that((Collection)set.headSet((Object)4, true)).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
        Truth.ASSERT.that((Collection)set.headSet((Object)Integer.MAX_VALUE, true)).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
    }

    public void testHeadSet_tooSmall() {
        Truth.ASSERT.that((Collection)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).headSet((Comparable)Integer.valueOf(0))).isEmpty();
    }

    public void testTailSet() {
        ContiguousSet set = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers());
        Truth.ASSERT.that((Collection)set.tailSet((Object)Integer.MIN_VALUE)).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
        Truth.ASSERT.that((Collection)set.tailSet((Object)1)).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
        Truth.ASSERT.that((Collection)set.tailSet((Object)2)).has().exactly((Object)2, (Object)3, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that((Collection)set.tailSet((Object)3)).has().item((Object)3);
        Truth.ASSERT.that((Collection)set.tailSet((Object)Integer.MIN_VALUE, false)).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
        Truth.ASSERT.that((Collection)set.tailSet((Object)1, false)).has().exactly((Object)2, (Object)3, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that((Collection)set.tailSet((Object)2, false)).has().item((Object)3);
        Truth.ASSERT.that((Collection)set.tailSet((Object)3, false)).isEmpty();
    }

    public void testTailSet_tooLarge() {
        Truth.ASSERT.that((Collection)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).tailSet((Comparable)Integer.valueOf(4))).isEmpty();
    }

    public void testSubSet() {
        ContiguousSet set = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers());
        Truth.ASSERT.that((Collection)set.subSet((Object)1, (Object)4)).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
        Truth.ASSERT.that((Collection)set.subSet((Object)2, (Object)4)).has().exactly((Object)2, (Object)3, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that((Collection)set.subSet((Object)3, (Object)4)).has().item((Object)3);
        Truth.ASSERT.that((Collection)set.subSet((Object)3, (Object)3)).isEmpty();
        Truth.ASSERT.that((Collection)set.subSet((Object)2, (Object)3)).has().item((Object)2);
        Truth.ASSERT.that((Collection)set.subSet((Object)1, (Object)3)).has().exactly((Object)1, (Object)2, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that((Collection)set.subSet((Object)1, (Object)2)).has().item((Object)1);
        Truth.ASSERT.that((Collection)set.subSet((Object)2, (Object)2)).isEmpty();
        Truth.ASSERT.that((Collection)set.subSet((Object)Integer.MIN_VALUE, (Object)Integer.MAX_VALUE)).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
        Truth.ASSERT.that((Collection)set.subSet((Object)1, true, (Object)3, true)).has().exactly((Object)1, (Object)2, (Object[])new Integer[]{3}).inOrder();
        Truth.ASSERT.that((Collection)set.subSet((Object)1, false, (Object)3, true)).has().exactly((Object)2, (Object)3, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that((Collection)set.subSet((Object)1, true, (Object)3, false)).has().exactly((Object)1, (Object)2, (Object[])new Integer[0]).inOrder();
        Truth.ASSERT.that((Collection)set.subSet((Object)1, false, (Object)3, false)).has().item((Object)2);
    }

    public void testSubSet_outOfOrder() {
        ContiguousSet set = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers());
        try {
            set.subSet((Object)3, (Object)2);
            ContiguousSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSubSet_tooLarge() {
        Truth.ASSERT.that((Collection)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).subSet((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(6))).isEmpty();
    }

    public void testSubSet_tooSmall() {
        Truth.ASSERT.that((Collection)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).subSet((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(0))).isEmpty();
    }

    public void testFirst() {
        ContiguousSetTest.assertEquals((int)1, (int)((Integer)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).first()));
        ContiguousSetTest.assertEquals((int)1, (int)((Integer)ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()).first()));
        ContiguousSetTest.assertEquals((int)Integer.MIN_VALUE, (int)((Integer)ContiguousSet.create((Range)Range.all(), (DiscreteDomain)DiscreteDomain.integers()).first()));
    }

    public void testLast() {
        ContiguousSetTest.assertEquals((int)3, (int)((Integer)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).last()));
        ContiguousSetTest.assertEquals((int)3, (int)((Integer)ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()).last()));
        ContiguousSetTest.assertEquals((int)Integer.MAX_VALUE, (int)((Integer)ContiguousSet.create((Range)Range.all(), (DiscreteDomain)DiscreteDomain.integers()).last()));
    }

    public void testContains() {
        ContiguousSet set = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers());
        ContiguousSetTest.assertFalse((boolean)set.contains((Object)0));
        ContiguousSetTest.assertTrue((boolean)set.contains((Object)1));
        ContiguousSetTest.assertTrue((boolean)set.contains((Object)2));
        ContiguousSetTest.assertTrue((boolean)set.contains((Object)3));
        ContiguousSetTest.assertFalse((boolean)set.contains((Object)4));
        set = ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers());
        ContiguousSetTest.assertFalse((boolean)set.contains((Object)0));
        ContiguousSetTest.assertTrue((boolean)set.contains((Object)1));
        ContiguousSetTest.assertTrue((boolean)set.contains((Object)2));
        ContiguousSetTest.assertTrue((boolean)set.contains((Object)3));
        ContiguousSetTest.assertFalse((boolean)set.contains((Object)4));
        ContiguousSetTest.assertFalse((boolean)set.contains((Object)"blah"));
    }

    public void testContainsAll() {
        ContiguousSet set = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers());
        for (Set subset : Sets.powerSet((Set)ImmutableSet.of((Object)1, (Object)2, (Object)3))) {
            ContiguousSetTest.assertTrue((boolean)set.containsAll((Collection)subset));
        }
        for (Set subset : Sets.powerSet((Set)ImmutableSet.of((Object)1, (Object)2, (Object)3))) {
            ContiguousSetTest.assertFalse((boolean)set.containsAll((Collection)Sets.union((Set)subset, (Set)ImmutableSet.of((Object)9))));
        }
        ContiguousSetTest.assertFalse((boolean)set.containsAll((Collection)ImmutableSet.of((Object)"blah")));
    }

    public void testRange() {
        ContiguousSetTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (Object)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).range());
        ContiguousSetTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (Object)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()).range());
        ContiguousSetTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (Object)ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()).range());
        ContiguousSetTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (Object)ContiguousSet.create((Range)Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).range());
        ContiguousSetTest.assertEquals((Object)Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3)), (Object)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.OPEN, BoundType.CLOSED));
        ContiguousSetTest.assertEquals((Object)Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3)), (Object)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.OPEN, BoundType.CLOSED));
        ContiguousSetTest.assertEquals((Object)Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3)), (Object)ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.OPEN, BoundType.CLOSED));
        ContiguousSetTest.assertEquals((Object)Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3)), (Object)ContiguousSet.create((Range)Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.OPEN, BoundType.CLOSED));
        ContiguousSetTest.assertEquals((Object)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), (Object)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.OPEN, BoundType.OPEN));
        ContiguousSetTest.assertEquals((Object)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), (Object)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.OPEN, BoundType.OPEN));
        ContiguousSetTest.assertEquals((Object)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), (Object)ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.OPEN, BoundType.OPEN));
        ContiguousSetTest.assertEquals((Object)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), (Object)ContiguousSet.create((Range)Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.OPEN, BoundType.OPEN));
        ContiguousSetTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)), (Object)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.CLOSED, BoundType.OPEN));
        ContiguousSetTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)), (Object)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.CLOSED, BoundType.OPEN));
        ContiguousSetTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)), (Object)ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.CLOSED, BoundType.OPEN));
        ContiguousSetTest.assertEquals((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4)), (Object)ContiguousSet.create((Range)Range.openClosed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.CLOSED, BoundType.OPEN));
    }

    public void testRange_unboundedRange() {
        ContiguousSetTest.assertEquals((Object)Range.closed((Comparable)Integer.valueOf(Integer.MIN_VALUE), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), (Object)ContiguousSet.create((Range)Range.all(), (DiscreteDomain)DiscreteDomain.integers()).range());
        ContiguousSetTest.assertEquals((Object)Range.atLeast((Comparable)Integer.valueOf(Integer.MIN_VALUE)), (Object)ContiguousSet.create((Range)Range.all(), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.CLOSED, BoundType.OPEN));
        ContiguousSetTest.assertEquals((Object)Range.all(), (Object)ContiguousSet.create((Range)Range.all(), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.OPEN, BoundType.OPEN));
        ContiguousSetTest.assertEquals((Object)Range.atMost((Comparable)Integer.valueOf(Integer.MAX_VALUE)), (Object)ContiguousSet.create((Range)Range.all(), (DiscreteDomain)DiscreteDomain.integers()).range(BoundType.OPEN, BoundType.CLOSED));
    }

    public void testIntersection_empty() {
        ContiguousSet set = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers());
        ContiguousSet emptySet = ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(2)), (DiscreteDomain)DiscreteDomain.integers());
        ContiguousSetTest.assertEquals((Object)ImmutableSet.of(), (Object)set.intersection(emptySet));
        ContiguousSetTest.assertEquals((Object)ImmutableSet.of(), (Object)emptySet.intersection(set));
        ContiguousSetTest.assertEquals((Object)ImmutableSet.of(), (Object)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(-5), (Comparable)Integer.valueOf(-1)), (DiscreteDomain)DiscreteDomain.integers()).intersection(ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(64)), (DiscreteDomain)DiscreteDomain.integers())));
    }

    public void testIntersection() {
        ContiguousSet set = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (DiscreteDomain)DiscreteDomain.integers());
        ContiguousSetTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)2, (Object)3), (Object)ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers()).intersection(set));
        ContiguousSetTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)2, (Object)3), (Object)set.intersection(ContiguousSet.create((Range)Range.open((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(4)), (DiscreteDomain)DiscreteDomain.integers())));
    }

    @GwtIncompatible(value="suite")
    public static class BuiltTests
    extends TestCase {
        public static Test suite() {
            TestSuite suite = new TestSuite();
            suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ContiguousSetGenerator()).named("Range.asSet")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionFeature.NON_STANDARD_TOSTRING, CollectionFeature.RESTRICTS_ELEMENTS})).suppressing(NavigableSetNavigationTester.getHoleMethods())).createTestSuite());
            suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ContiguousSetHeadsetGenerator()).named("Range.asSet, headset")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionFeature.NON_STANDARD_TOSTRING, CollectionFeature.RESTRICTS_ELEMENTS})).suppressing(NavigableSetNavigationTester.getHoleMethods())).createTestSuite());
            suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ContiguousSetTailsetGenerator()).named("Range.asSet, tailset")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionFeature.NON_STANDARD_TOSTRING, CollectionFeature.RESTRICTS_ELEMENTS})).suppressing(NavigableSetNavigationTester.getHoleMethods())).createTestSuite());
            suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ContiguousSetSubsetGenerator()).named("Range.asSet, subset")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionFeature.NON_STANDARD_TOSTRING, CollectionFeature.RESTRICTS_ELEMENTS})).suppressing(NavigableSetNavigationTester.getHoleMethods())).createTestSuite());
            suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ContiguousSetDescendingGenerator()).named("Range.asSet.descendingSet")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionFeature.NON_STANDARD_TOSTRING, CollectionFeature.RESTRICTS_ELEMENTS})).suppressing(NavigableSetNavigationTester.getHoleMethods())).createTestSuite());
            return suite;
        }
    }
}

