/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingDeque;
import com.google.common.collect.ForwardingTestCase;
import java.util.Collections;
import java.util.Deque;

public class ForwardingDequeTest
extends ForwardingTestCase {
    private Deque<String> forward;

    protected void setUp() throws Exception {
        super.setUp();
        final Deque deque = this.createProxyInstance(Deque.class);
        this.forward = new ForwardingDeque<String>(){

            protected Deque<String> delegate() {
                return deque;
            }
        };
    }

    public void testAdd_T() {
        this.forward.add("asdf");
        ForwardingDequeTest.assertEquals((String)"[add(Object)]", (String)this.getCalls());
    }

    public void testAddFirst_T() {
        this.forward.addFirst("asdf");
        ForwardingDequeTest.assertEquals((String)"[addFirst(Object)]", (String)this.getCalls());
    }

    public void testAddLast_T() {
        this.forward.addLast("asdf");
        ForwardingDequeTest.assertEquals((String)"[addLast(Object)]", (String)this.getCalls());
    }

    public void testAddAll_Collection() {
        this.forward.addAll(Collections.singleton("asdf"));
        ForwardingDequeTest.assertEquals((String)"[addAll(Collection)]", (String)this.getCalls());
    }

    public void testClear() {
        this.forward.clear();
        ForwardingDequeTest.assertEquals((String)"[clear]", (String)this.getCalls());
    }

    public void testContains_T() {
        this.forward.contains("asdf");
        ForwardingDequeTest.assertEquals((String)"[contains(Object)]", (String)this.getCalls());
    }

    public void testContainsAll_Collection() {
        this.forward.containsAll(Collections.singleton("asdf"));
        ForwardingDequeTest.assertEquals((String)"[containsAll(Collection)]", (String)this.getCalls());
    }

    public void testDescendingIterator() {
        this.forward.descendingIterator();
        ForwardingDequeTest.assertEquals((String)"[descendingIterator]", (String)this.getCalls());
    }

    public void testElement() {
        this.forward.element();
        ForwardingDequeTest.assertEquals((String)"[element]", (String)this.getCalls());
    }

    public void testGetFirst() {
        this.forward.getFirst();
        ForwardingDequeTest.assertEquals((String)"[getFirst]", (String)this.getCalls());
    }

    public void testGetLast() {
        this.forward.getLast();
        ForwardingDequeTest.assertEquals((String)"[getLast]", (String)this.getCalls());
    }

    public void testIterator() {
        this.forward.iterator();
        ForwardingDequeTest.assertEquals((String)"[iterator]", (String)this.getCalls());
    }

    public void testIsEmpty() {
        this.forward.isEmpty();
        ForwardingDequeTest.assertEquals((String)"[isEmpty]", (String)this.getCalls());
    }

    public void testOffer_T() {
        this.forward.offer("asdf");
        ForwardingDequeTest.assertEquals((String)"[offer(Object)]", (String)this.getCalls());
    }

    public void testOfferFirst_T() {
        this.forward.offerFirst("asdf");
        ForwardingDequeTest.assertEquals((String)"[offerFirst(Object)]", (String)this.getCalls());
    }

    public void testOfferLast_T() {
        this.forward.offerLast("asdf");
        ForwardingDequeTest.assertEquals((String)"[offerLast(Object)]", (String)this.getCalls());
    }

    public void testPeek() {
        this.forward.peek();
        ForwardingDequeTest.assertEquals((String)"[peek]", (String)this.getCalls());
    }

    public void testPeekFirst() {
        this.forward.peekFirst();
        ForwardingDequeTest.assertEquals((String)"[peekFirst]", (String)this.getCalls());
    }

    public void testPeekLast() {
        this.forward.peekLast();
        ForwardingDequeTest.assertEquals((String)"[peekLast]", (String)this.getCalls());
    }

    public void testPoll() {
        this.forward.poll();
        ForwardingDequeTest.assertEquals((String)"[poll]", (String)this.getCalls());
    }

    public void testPollFirst() {
        this.forward.pollFirst();
        ForwardingDequeTest.assertEquals((String)"[pollFirst]", (String)this.getCalls());
    }

    public void testPollLast() {
        this.forward.pollLast();
        ForwardingDequeTest.assertEquals((String)"[pollLast]", (String)this.getCalls());
    }

    public void testPop() {
        this.forward.pop();
        ForwardingDequeTest.assertEquals((String)"[pop]", (String)this.getCalls());
    }

    public void testPush_Object() {
        this.forward.push("asdf");
        ForwardingDequeTest.assertEquals((String)"[push(Object)]", (String)this.getCalls());
    }

    public void testRemove() {
        this.forward.remove();
        ForwardingDequeTest.assertEquals((String)"[remove]", (String)this.getCalls());
    }

    public void testRemoveFirst() {
        this.forward.removeFirst();
        ForwardingDequeTest.assertEquals((String)"[removeFirst]", (String)this.getCalls());
    }

    public void testRemoveLast() {
        this.forward.removeLast();
        ForwardingDequeTest.assertEquals((String)"[removeLast]", (String)this.getCalls());
    }

    public void testRemove_Object() {
        this.forward.remove(Object.class);
        ForwardingDequeTest.assertEquals((String)"[remove(Object)]", (String)this.getCalls());
    }

    public void testRemoveFirstOccurrence_Object() {
        this.forward.removeFirstOccurrence(Object.class);
        ForwardingDequeTest.assertEquals((String)"[removeFirstOccurrence(Object)]", (String)this.getCalls());
    }

    public void testRemoveLastOccurrence_Object() {
        this.forward.removeLastOccurrence(Object.class);
        ForwardingDequeTest.assertEquals((String)"[removeLastOccurrence(Object)]", (String)this.getCalls());
    }

    public void testRemoveAll_Collection() {
        this.forward.removeAll(Collections.singleton("asdf"));
        ForwardingDequeTest.assertEquals((String)"[removeAll(Collection)]", (String)this.getCalls());
    }

    public void testRetainAll_Collection() {
        this.forward.retainAll(Collections.singleton("asdf"));
        ForwardingDequeTest.assertEquals((String)"[retainAll(Collection)]", (String)this.getCalls());
    }

    public void testSize() {
        this.forward.size();
        ForwardingDequeTest.assertEquals((String)"[size]", (String)this.getCalls());
    }

    public void testToArray() {
        this.forward.toArray();
        ForwardingDequeTest.assertEquals((String)"[toArray]", (String)this.getCalls());
    }

    public void testToArray_TArray() {
        this.forward.toArray(new String[0]);
        ForwardingDequeTest.assertEquals((String)"[toArray(Object[])]", (String)this.getCalls());
    }

    public void testToString() {
        this.forward.toString();
        ForwardingDequeTest.assertEquals((String)"[toString]", (String)this.getCalls());
    }
}

