/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingQueue;
import com.google.common.collect.ForwardingTestCase;
import com.google.common.collect.Lists;
import com.google.common.collect.testing.QueueTestSuiteBuilder;
import com.google.common.collect.testing.TestQueueGenerator;
import com.google.common.collect.testing.TestStringQueueGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ForwardingQueueTest
extends ForwardingTestCase {
    private Queue<String> forward;
    private Queue<String> queue;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingQueueTest.class);
        suite.addTest((Test)((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)QueueTestSuiteBuilder.using((TestQueueGenerator)new TestStringQueueGenerator(){

            protected Queue<String> create(String[] elements) {
                return new StandardImplForwardingQueue(Lists.newLinkedList(Arrays.asList(elements)));
            }
        }).named("ForwardingQueue[LinkedList] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.GENERAL_PURPOSE})).createTestSuite());
        return suite;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.queue = this.createProxyInstance(Queue.class);
        this.forward = new ForwardingQueue<String>(){

            protected Queue<String> delegate() {
                return ForwardingQueueTest.this.queue;
            }
        };
    }

    public void testAdd_T() {
        this.forward.add("asdf");
        ForwardingQueueTest.assertEquals((String)"[add(Object)]", (String)this.getCalls());
    }

    public void testAddAll_Collection() {
        this.forward.addAll(Collections.singleton("asdf"));
        ForwardingQueueTest.assertEquals((String)"[addAll(Collection)]", (String)this.getCalls());
    }

    public void testClear() {
        this.forward.clear();
        ForwardingQueueTest.assertEquals((String)"[clear]", (String)this.getCalls());
    }

    public void testContains_T() {
        this.forward.contains("asdf");
        ForwardingQueueTest.assertEquals((String)"[contains(Object)]", (String)this.getCalls());
    }

    public void testContainsAll_Collection() {
        this.forward.containsAll(Collections.singleton("asdf"));
        ForwardingQueueTest.assertEquals((String)"[containsAll(Collection)]", (String)this.getCalls());
    }

    public void testElement() {
        this.forward.element();
        ForwardingQueueTest.assertEquals((String)"[element]", (String)this.getCalls());
    }

    public void testIterator() {
        this.forward.iterator();
        ForwardingQueueTest.assertEquals((String)"[iterator]", (String)this.getCalls());
    }

    public void testIsEmpty() {
        this.forward.isEmpty();
        ForwardingQueueTest.assertEquals((String)"[isEmpty]", (String)this.getCalls());
    }

    public void testOffer_T() {
        this.forward.offer("asdf");
        ForwardingQueueTest.assertEquals((String)"[offer(Object)]", (String)this.getCalls());
    }

    public void testPeek() {
        this.forward.peek();
        ForwardingQueueTest.assertEquals((String)"[peek]", (String)this.getCalls());
    }

    public void testPoll() {
        this.forward.poll();
        ForwardingQueueTest.assertEquals((String)"[poll]", (String)this.getCalls());
    }

    public void testRemove() {
        this.forward.remove();
        ForwardingQueueTest.assertEquals((String)"[remove]", (String)this.getCalls());
    }

    public void testRemove_Object() {
        this.forward.remove(Object.class);
        ForwardingQueueTest.assertEquals((String)"[remove(Object)]", (String)this.getCalls());
    }

    public void testRemoveAll_Collection() {
        this.forward.removeAll(Collections.singleton("asdf"));
        ForwardingQueueTest.assertEquals((String)"[removeAll(Collection)]", (String)this.getCalls());
    }

    public void testRetainAll_Collection() {
        this.forward.retainAll(Collections.singleton("asdf"));
        ForwardingQueueTest.assertEquals((String)"[retainAll(Collection)]", (String)this.getCalls());
    }

    public void testSize() {
        this.forward.size();
        ForwardingQueueTest.assertEquals((String)"[size]", (String)this.getCalls());
    }

    public void testToArray() {
        this.forward.toArray();
        ForwardingQueueTest.assertEquals((String)"[toArray]", (String)this.getCalls());
    }

    public void testToArray_TArray() {
        this.forward.toArray(new String[0]);
        ForwardingQueueTest.assertEquals((String)"[toArray(Object[])]", (String)this.getCalls());
    }

    public void testToString() {
        this.forward.toString();
        ForwardingQueueTest.assertEquals((String)"[toString]", (String)this.getCalls());
    }

    static final class StandardImplForwardingQueue<T>
    extends ForwardingQueue<T> {
        private final Queue<T> backingQueue;

        StandardImplForwardingQueue(Queue<T> backingQueue) {
            this.backingQueue = backingQueue;
        }

        protected Queue<T> delegate() {
            return this.backingQueue;
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean remove(Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }

        public boolean offer(T o) {
            return this.standardOffer(o);
        }

        public T peek() {
            return (T)this.standardPeek();
        }

        public T poll() {
            return (T)this.standardPoll();
        }
    }
}

