/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.SampleElements;
import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import java.util.Map;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class ImmutableMultimapTest
extends TestCase {
    public void testBuilder_withImmutableEntry() {
        ImmutableMultimap multimap = new ImmutableMultimap.Builder().put(Maps.immutableEntry((Object)"one", (Object)1)).build();
        ImmutableMultimapTest.assertEquals(Arrays.asList(1), (Object)multimap.get((Object)"one"));
    }

    public void testBuilder_withImmutableEntryAndNullContents() {
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        try {
            builder.put(Maps.immutableEntry((Object)"one", (Object)null));
            ImmutableMultimapTest.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            builder.put(Maps.immutableEntry((Object)null, (Object)1));
            ImmutableMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilder_withMutableEntry() {
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        final StringHolder holder = new StringHolder();
        holder.string = "one";
        AbstractMapEntry<String, Integer> entry = new AbstractMapEntry<String, Integer>(){

            public String getKey() {
                return holder.string;
            }

            public Integer getValue() {
                return 1;
            }
        };
        builder.put((Map.Entry)entry);
        holder.string = "two";
        ImmutableMultimapTest.assertEquals(Arrays.asList(1), (Object)builder.build().get((Object)"one"));
    }

    public void testCopyOf() {
        ImmutableSetMultimap setMultimap = ImmutableSetMultimap.of((Object)"k1", (Object)"v1");
        ImmutableMultimap setMultimapCopy = ImmutableMultimap.copyOf((Multimap)setMultimap);
        ImmutableMultimapTest.assertSame((String)"copyOf(ImmutableSetMultimap) should not create a new instance", (Object)setMultimap, (Object)setMultimapCopy);
        ImmutableListMultimap listMultimap = ImmutableListMultimap.of((Object)"k1", (Object)"v1");
        ImmutableMultimap listMultimapCopy = ImmutableMultimap.copyOf((Multimap)listMultimap);
        ImmutableMultimapTest.assertSame((String)"copyOf(ImmutableListMultimap) should not create a new instance", (Object)listMultimap, (Object)listMultimapCopy);
    }

    public void testUnhashableSingletonValue() {
        SampleElements.Unhashables unhashables = new SampleElements.Unhashables();
        ImmutableMultimap multimap = ImmutableMultimap.of((Object)0, (Object)unhashables.e0);
        ImmutableMultimapTest.assertEquals((int)1, (int)multimap.get((Object)0).size());
        ImmutableMultimapTest.assertTrue((boolean)multimap.get((Object)0).contains(unhashables.e0));
    }

    public void testUnhashableMixedValues() {
        SampleElements.Unhashables unhashables = new SampleElements.Unhashables();
        ImmutableMultimap multimap = ImmutableMultimap.of((Object)0, (Object)unhashables.e0, (Object)2, (Object)"hey you", (Object)0, (Object)unhashables.e1);
        ImmutableMultimapTest.assertEquals((int)2, (int)multimap.get((Object)0).size());
        ImmutableMultimapTest.assertTrue((boolean)multimap.get((Object)0).contains(unhashables.e0));
        ImmutableMultimapTest.assertTrue((boolean)multimap.get((Object)0).contains(unhashables.e1));
        ImmutableMultimapTest.assertTrue((boolean)multimap.get((Object)2).contains("hey you"));
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{ImmutableMultimap.of(), ImmutableMultimap.of()}).addEqualityGroup(new Object[]{ImmutableMultimap.of((Object)1, (Object)"a"), ImmutableMultimap.of((Object)1, (Object)"a")}).addEqualityGroup(new Object[]{ImmutableMultimap.of((Object)1, (Object)"a", (Object)2, (Object)"b"), ImmutableMultimap.of((Object)2, (Object)"b", (Object)1, (Object)"a")}).testEquals();
    }

    private static class StringHolder {
        String string;

        private StringHolder() {
        }
    }
}

