/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Joiner;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.NavigableMapTestSuiteBuilder;
import com.google.common.collect.testing.SortedMapInterfaceTest;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestSortedMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.SortedMapGenerators;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.truth0.Truth;

@GwtCompatible(emulated=true)
public class ImmutableSortedMapTest
extends TestCase {
    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ImmutableSortedMapTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestSortedMapGenerator)new SortedMapGenerators.ImmutableSortedMapGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS, CollectionFeature.KNOWN_ORDER, MapFeature.REJECTS_DUPLICATES_AT_CREATION, MapFeature.ALLOWS_ANY_NULL_QUERIES})).named("ImmutableSortedMap")).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new SortedMapGenerators.ImmutableSortedMapEntryListGenerator()).named("ImmutableSortedMap.entrySet.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new SortedMapGenerators.ImmutableSortedMapKeyListGenerator()).named("ImmutableSortedMap.keySet.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new SortedMapGenerators.ImmutableSortedMapValueListGenerator()).named("ImmutableSortedMap.values.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    public void testNullGet() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1);
        ImmutableSortedMapTest.assertNull((Object)map.get(null));
    }

    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(ImmutableSortedMap.class);
        tester.testAllPublicInstanceMethods((Object)ImmutableSortedMap.naturalOrder());
        tester.testAllPublicInstanceMethods((Object)ImmutableSortedMap.of());
        tester.testAllPublicInstanceMethods((Object)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1));
        tester.testAllPublicInstanceMethods((Object)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3));
    }

    private static <K, V> void assertMapEquals(Map<K, V> map, Object ... alternatingKeysAndValues) {
        ImmutableSortedMapTest.assertEquals((int)map.size(), (int)(alternatingKeysAndValues.length / 2));
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            ImmutableSortedMapTest.assertEquals((Object)alternatingKeysAndValues[i++], entry.getKey());
            ImmutableSortedMapTest.assertEquals((Object)alternatingKeysAndValues[i++], entry.getValue());
        }
    }

    public void testMutableValues() {
        IntHolder holderA = new IntHolder(1);
        IntHolder holderB = new IntHolder(2);
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)holderA, (Comparable)((Object)"b"), (Object)holderB);
        holderA.value = 3;
        ImmutableSortedMapTest.assertTrue((boolean)map.entrySet().contains(Maps.immutableEntry((Object)"a", (Object)new IntHolder(3))));
        ImmutableSortedMap intMap = ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)3, (Comparable)((Object)"b"), (Object)2);
        ImmutableSortedMapTest.assertEquals((int)intMap.hashCode(), (int)map.entrySet().hashCode());
        ImmutableSortedMapTest.assertEquals((int)intMap.hashCode(), (int)map.hashCode());
    }

    @GwtIncompatible(value="SerializableTester")
    public void testViewSerialization() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3);
        SerializableTester.reserializeAndAssert(map.entrySet());
        SerializableTester.reserializeAndAssert(map.keySet());
        ImmutableSortedMapTest.assertEquals((Object)Lists.newArrayList(map.values()), (Object)Lists.newArrayList((Iterable)((Iterable)SerializableTester.reserialize(map.values()))));
    }

    public void testHeadMapInclusive() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3).headMap((Object)"three", true);
        Truth.ASSERT.that(map.entrySet()).has().exactly((Object)Maps.immutableEntry((Object)"one", (Object)1), (Object)Maps.immutableEntry((Object)"three", (Object)3), (Object[])new Map.Entry[0]).inOrder();
    }

    public void testHeadMapExclusive() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3).headMap((Object)"three", false);
        Truth.ASSERT.that(map.entrySet()).has().exactly((Object)Maps.immutableEntry((Object)"one", (Object)1)).inOrder();
    }

    public void testTailMapInclusive() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3).tailMap((Object)"three", true);
        Truth.ASSERT.that(map.entrySet()).has().exactly((Object)Maps.immutableEntry((Object)"three", (Object)3), (Object)Maps.immutableEntry((Object)"two", (Object)2), (Object[])new Map.Entry[0]).inOrder();
    }

    public void testTailMapExclusive() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3).tailMap((Object)"three", false);
        Truth.ASSERT.that(map.entrySet()).has().exactly((Object)Maps.immutableEntry((Object)"two", (Object)2)).inOrder();
    }

    public void testSubMapExclusiveExclusive() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3).subMap((Object)"one", false, (Object)"two", false);
        Truth.ASSERT.that(map.entrySet()).has().exactly((Object)Maps.immutableEntry((Object)"three", (Object)3)).inOrder();
    }

    public void testSubMapInclusiveExclusive() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3).subMap((Object)"one", true, (Object)"two", false);
        Truth.ASSERT.that(map.entrySet()).has().exactly((Object)Maps.immutableEntry((Object)"one", (Object)1), (Object)Maps.immutableEntry((Object)"three", (Object)3), (Object[])new Map.Entry[0]).inOrder();
    }

    public void testSubMapExclusiveInclusive() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3).subMap((Object)"one", false, (Object)"two", true);
        Truth.ASSERT.that(map.entrySet()).has().exactly((Object)Maps.immutableEntry((Object)"three", (Object)3), (Object)Maps.immutableEntry((Object)"two", (Object)2), (Object[])new Map.Entry[0]).inOrder();
    }

    public void testSubMapInclusiveInclusive() {
        ImmutableSortedMap map = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3).subMap((Object)"one", true, (Object)"two", true);
        Truth.ASSERT.that(map.entrySet()).has().exactly((Object)Maps.immutableEntry((Object)"one", (Object)1), (Object)Maps.immutableEntry((Object)"three", (Object)3), (Object[])new Map.Entry[]{Maps.immutableEntry((Object)"two", (Object)2)}).inOrder();
    }

    public void testBuilderGenerics_SelfComparable() {
        ImmutableSortedMap.Builder natural = ImmutableSortedMap.naturalOrder();
        ImmutableSortedMap.Builder reverse = ImmutableSortedMap.reverseOrder();
    }

    public void testBuilderGenerics_SuperComparable() {
        ImmutableSortedMap.Builder natural = ImmutableSortedMap.naturalOrder();
        ImmutableSortedMap.Builder reverse = ImmutableSortedMap.reverseOrder();
    }

    private static class SuperComparableExample
    extends SelfComparableExample {
        private SuperComparableExample() {
        }
    }

    private static class SelfComparableExample
    implements Comparable<SelfComparableExample> {
        private SelfComparableExample() {
        }

        @Override
        public int compareTo(SelfComparableExample o) {
            return 0;
        }
    }

    private static class IntHolder
    implements Serializable {
        public int value;
        private static final long serialVersionUID = 5L;

        public IntHolder(int value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            return o instanceof IntHolder && ((IntHolder)o).value == this.value;
        }

        public int hashCode() {
            return this.value;
        }
    }

    public static class CreationTests
    extends TestCase {
        public void testEmptyBuilder() {
            ImmutableSortedMap map = ImmutableSortedMap.naturalOrder().build();
            CreationTests.assertEquals(Collections.emptyMap(), (Object)map);
        }

        public void testSingletonBuilder() {
            ImmutableSortedMap map = ImmutableSortedMap.naturalOrder().put((Object)"one", (Object)1).build();
            ImmutableSortedMapTest.assertMapEquals((Map)map, new Object[]{"one", 1});
        }

        public void testBuilder() {
            ImmutableSortedMap map = ImmutableSortedMap.naturalOrder().put((Object)"one", (Object)1).put((Object)"two", (Object)2).put((Object)"three", (Object)3).put((Object)"four", (Object)4).put((Object)"five", (Object)5).build();
            ImmutableSortedMapTest.assertMapEquals((Map)map, new Object[]{"five", 5, "four", 4, "one", 1, "three", 3, "two", 2});
        }

        public void testBuilder_withImmutableEntry() {
            ImmutableSortedMap map = ImmutableSortedMap.naturalOrder().put(Maps.immutableEntry((Object)"one", (Object)1)).build();
            ImmutableSortedMapTest.assertMapEquals((Map)map, new Object[]{"one", 1});
        }

        public void testBuilder_withImmutableEntryAndNullContents() {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            try {
                builder.put(Maps.immutableEntry((Object)"one", (Object)null));
                CreationTests.fail();
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            try {
                builder.put(Maps.immutableEntry((Object)null, (Object)1));
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testBuilder_withMutableEntry() {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            final StringHolder holder = new StringHolder();
            holder.string = "one";
            AbstractMapEntry<String, Integer> entry = new AbstractMapEntry<String, Integer>(){

                public String getKey() {
                    return holder.string;
                }

                public Integer getValue() {
                    return 1;
                }
            };
            builder.put((Map.Entry)entry);
            holder.string = "two";
            ImmutableSortedMapTest.assertMapEquals((Map)builder.build(), new Object[]{"one", 1});
        }

        public void testBuilderPutAllWithEmptyMap() {
            ImmutableSortedMap map = ImmutableSortedMap.naturalOrder().putAll(Collections.emptyMap()).build();
            CreationTests.assertEquals(Collections.emptyMap(), (Object)map);
        }

        public void testBuilderPutAll() {
            LinkedHashMap<String, Integer> toPut = new LinkedHashMap<String, Integer>();
            toPut.put("one", 1);
            toPut.put("two", 2);
            toPut.put("three", 3);
            LinkedHashMap<String, Integer> moreToPut = new LinkedHashMap<String, Integer>();
            moreToPut.put("four", 4);
            moreToPut.put("five", 5);
            ImmutableSortedMap map = ImmutableSortedMap.naturalOrder().putAll(toPut).putAll(moreToPut).build();
            ImmutableSortedMapTest.assertMapEquals((Map)map, new Object[]{"five", 5, "four", 4, "one", 1, "three", 3, "two", 2});
        }

        public void testBuilderReuse() {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            ImmutableSortedMap mapOne = builder.put((Object)"one", (Object)1).put((Object)"two", (Object)2).build();
            ImmutableSortedMap mapTwo = builder.put((Object)"three", (Object)3).put((Object)"four", (Object)4).build();
            ImmutableSortedMapTest.assertMapEquals((Map)mapOne, new Object[]{"one", 1, "two", 2});
            ImmutableSortedMapTest.assertMapEquals((Map)mapTwo, new Object[]{"four", 4, "one", 1, "three", 3, "two", 2});
        }

        public void testBuilderPutNullKey() {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            try {
                builder.put(null, (Object)1);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testBuilderPutNullValue() {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            try {
                builder.put((Object)"one", null);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testBuilderPutNullKeyViaPutAll() {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            try {
                builder.putAll(Collections.singletonMap(null, 1));
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testBuilderPutNullValueViaPutAll() {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            try {
                builder.putAll(Collections.singletonMap("one", null));
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testPuttingTheSameKeyTwiceThrowsOnBuild() {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder().put((Object)"one", (Object)1).put((Object)"one", (Object)2);
            try {
                builder.build();
                CreationTests.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void testOf() {
            ImmutableSortedMapTest.assertMapEquals((Map)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1), new Object[]{"one", 1});
            ImmutableSortedMapTest.assertMapEquals((Map)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2), new Object[]{"one", 1, "two", 2});
            ImmutableSortedMapTest.assertMapEquals((Map)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3), new Object[]{"one", 1, "three", 3, "two", 2});
            ImmutableSortedMapTest.assertMapEquals((Map)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3, (Comparable)((Object)"four"), (Object)4), new Object[]{"four", 4, "one", 1, "three", 3, "two", 2});
            ImmutableSortedMapTest.assertMapEquals((Map)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3, (Comparable)((Object)"four"), (Object)4, (Comparable)((Object)"five"), (Object)5), new Object[]{"five", 5, "four", 4, "one", 1, "three", 3, "two", 2});
        }

        public void testOfNullKey() {
            Comparable n = null;
            try {
                ImmutableSortedMap.of(n, (Object)1);
                CreationTests.fail();
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            try {
                ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, null, (Object)2);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testOfNullValue() {
            try {
                ImmutableSortedMap.of((Comparable)((Object)"one"), null);
                CreationTests.fail();
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            try {
                ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), null);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testOfWithDuplicateKey() {
            try {
                ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"one"), (Object)1);
                CreationTests.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void testCopyOfEmptyMap() {
            ImmutableSortedMap copy = ImmutableSortedMap.copyOf(Collections.emptyMap());
            CreationTests.assertEquals(Collections.emptyMap(), (Object)copy);
            CreationTests.assertSame((Object)copy, (Object)ImmutableSortedMap.copyOf((Map)copy));
            CreationTests.assertSame((Object)Ordering.natural(), (Object)copy.comparator());
        }

        public void testCopyOfSingletonMap() {
            ImmutableSortedMap copy = ImmutableSortedMap.copyOf(Collections.singletonMap("one", 1));
            ImmutableSortedMapTest.assertMapEquals((Map)copy, new Object[]{"one", 1});
            CreationTests.assertSame((Object)copy, (Object)ImmutableSortedMap.copyOf((Map)copy));
            CreationTests.assertSame((Object)Ordering.natural(), (Object)copy.comparator());
        }

        public void testCopyOf() {
            LinkedHashMap<String, Integer> original = new LinkedHashMap<String, Integer>();
            original.put("one", 1);
            original.put("two", 2);
            original.put("three", 3);
            ImmutableSortedMap copy = ImmutableSortedMap.copyOf(original);
            ImmutableSortedMapTest.assertMapEquals((Map)copy, new Object[]{"one", 1, "three", 3, "two", 2});
            CreationTests.assertSame((Object)copy, (Object)ImmutableSortedMap.copyOf((Map)copy));
            CreationTests.assertSame((Object)Ordering.natural(), (Object)copy.comparator());
        }

        public void testCopyOfExplicitComparator() {
            Ordering comparator = Ordering.natural().reverse();
            LinkedHashMap<String, Integer> original = new LinkedHashMap<String, Integer>();
            original.put("one", 1);
            original.put("two", 2);
            original.put("three", 3);
            ImmutableSortedMap copy = ImmutableSortedMap.copyOf(original, (Comparator)comparator);
            ImmutableSortedMapTest.assertMapEquals((Map)copy, new Object[]{"two", 2, "three", 3, "one", 1});
            CreationTests.assertSame((Object)copy, (Object)ImmutableSortedMap.copyOf((Map)copy, (Comparator)comparator));
            CreationTests.assertSame((Object)comparator, (Object)copy.comparator());
        }

        public void testCopyOfImmutableSortedSetDifferentComparator() {
            Ordering comparator = Ordering.natural().reverse();
            ImmutableSortedMap original = ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3);
            ImmutableSortedMap copy = ImmutableSortedMap.copyOf((Map)original, (Comparator)comparator);
            ImmutableSortedMapTest.assertMapEquals((Map)copy, new Object[]{"two", 2, "three", 3, "one", 1});
            CreationTests.assertSame((Object)copy, (Object)ImmutableSortedMap.copyOf((Map)copy, (Comparator)comparator));
            CreationTests.assertSame((Object)comparator, (Object)copy.comparator());
        }

        public void testCopyOfSortedNatural() {
            TreeMap original = Maps.newTreeMap();
            original.put("one", 1);
            original.put("two", 2);
            original.put("three", 3);
            ImmutableSortedMap copy = ImmutableSortedMap.copyOfSorted((SortedMap)original);
            ImmutableSortedMapTest.assertMapEquals((Map)copy, new Object[]{"one", 1, "three", 3, "two", 2});
            CreationTests.assertSame((Object)copy, (Object)ImmutableSortedMap.copyOfSorted((SortedMap)copy));
            CreationTests.assertSame((Object)Ordering.natural(), (Object)copy.comparator());
        }

        public void testCopyOfSortedExplicit() {
            Ordering comparator = Ordering.natural().reverse();
            TreeMap original = Maps.newTreeMap((Comparator)comparator);
            original.put("one", 1);
            original.put("two", 2);
            original.put("three", 3);
            ImmutableSortedMap copy = ImmutableSortedMap.copyOfSorted((SortedMap)original);
            ImmutableSortedMapTest.assertMapEquals((Map)copy, new Object[]{"two", 2, "three", 3, "one", 1});
            CreationTests.assertSame((Object)copy, (Object)ImmutableSortedMap.copyOfSorted((SortedMap)copy));
            CreationTests.assertSame((Object)comparator, (Object)copy.comparator());
        }

        public void testCopyOfDuplicateKey() {
            ImmutableMap original = ImmutableMap.of((Object)new IntegerDiv10(3), (Object)"three", (Object)new IntegerDiv10(20), (Object)"twenty", (Object)new IntegerDiv10(11), (Object)"eleven", (Object)new IntegerDiv10(35), (Object)"thirty five", (Object)new IntegerDiv10(12), (Object)"twelve");
            try {
                ImmutableSortedMap.copyOf((Map)original);
                CreationTests.fail((String)"Expected IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void testImmutableMapCopyOfImmutableSortedMap() {
            IntegerDiv10 three = new IntegerDiv10(3);
            IntegerDiv10 eleven = new IntegerDiv10(11);
            IntegerDiv10 twelve = new IntegerDiv10(12);
            IntegerDiv10 twenty = new IntegerDiv10(20);
            ImmutableSortedMap original = ImmutableSortedMap.of((Comparable)three, (Object)"three", (Comparable)eleven, (Object)"eleven", (Comparable)twenty, (Object)"twenty");
            ImmutableMap copy = ImmutableMap.copyOf((Map)original);
            CreationTests.assertTrue((boolean)original.containsKey(twelve));
            CreationTests.assertFalse((boolean)copy.containsKey(twelve));
        }

        public void testBuilderReverseOrder() {
            ImmutableSortedMap map = ImmutableSortedMap.reverseOrder().put((Object)"one", (Object)1).put((Object)"two", (Object)2).put((Object)"three", (Object)3).put((Object)"four", (Object)4).put((Object)"five", (Object)5).build();
            ImmutableSortedMapTest.assertMapEquals((Map)map, new Object[]{"two", 2, "three", 3, "one", 1, "four", 4, "five", 5});
            CreationTests.assertEquals((Object)Ordering.natural().reverse(), (Object)map.comparator());
        }

        public void testBuilderComparator() {
            Ordering comparator = Ordering.natural().reverse();
            ImmutableSortedMap map = new ImmutableSortedMap.Builder((Comparator)comparator).put((Object)"one", (Object)1).put((Object)"two", (Object)2).put((Object)"three", (Object)3).put((Object)"four", (Object)4).put((Object)"five", (Object)5).build();
            ImmutableSortedMapTest.assertMapEquals((Map)map, new Object[]{"two", 2, "three", 3, "one", 1, "four", 4, "five", 5});
            CreationTests.assertSame((Object)comparator, (Object)map.comparator());
        }

        private static class IntegerDiv10
        implements Comparable<IntegerDiv10> {
            final int value;

            IntegerDiv10(int value) {
                this.value = value;
            }

            @Override
            public int compareTo(IntegerDiv10 o) {
                return this.value / 10 - o.value / 10;
            }

            public String toString() {
                return Integer.toString(this.value);
            }
        }

        private static class StringHolder {
            String string;

            private StringHolder() {
            }
        }
    }

    public static class SubMapTests
    extends AbstractMapTests<String, Integer> {
        protected SortedMap<String, Integer> makePopulatedMap() {
            return ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)1, (Comparable)((Object)"b"), (Object)2, (Comparable)((Object)"c"), (Object)3, (Comparable)((Object)"d"), (Object)4, (Comparable)((Object)"e"), (Object)5).subMap((Object)"b", (Object)"d");
        }

        protected String getKeyNotInPopulatedMap() {
            return "a";
        }

        protected Integer getValueNotInPopulatedMap() {
            return 4;
        }
    }

    public static class TailExclusiveMapTests
    extends AbstractMapTests<String, Integer> {
        protected SortedMap<String, Integer> makePopulatedMap() {
            return ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)1, (Comparable)((Object)"b"), (Object)2, (Comparable)((Object)"c"), (Object)3, (Comparable)((Object)"d"), (Object)4, (Comparable)((Object)"e"), (Object)5).tailMap((Object)"a", false);
        }

        protected String getKeyNotInPopulatedMap() {
            return "a";
        }

        protected Integer getValueNotInPopulatedMap() {
            return 1;
        }
    }

    public static class TailMapTests
    extends AbstractMapTests<String, Integer> {
        protected SortedMap<String, Integer> makePopulatedMap() {
            return ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)1, (Comparable)((Object)"b"), (Object)2, (Comparable)((Object)"c"), (Object)3, (Comparable)((Object)"d"), (Object)4, (Comparable)((Object)"e"), (Object)5).tailMap((Object)"b");
        }

        protected String getKeyNotInPopulatedMap() {
            return "a";
        }

        protected Integer getValueNotInPopulatedMap() {
            return 1;
        }
    }

    public static class HeadMapInclusiveTests
    extends AbstractMapTests<String, Integer> {
        protected SortedMap<String, Integer> makePopulatedMap() {
            return ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)1, (Comparable)((Object)"b"), (Object)2, (Comparable)((Object)"c"), (Object)3, (Comparable)((Object)"d"), (Object)4, (Comparable)((Object)"e"), (Object)5).headMap((Object)"c", true);
        }

        protected String getKeyNotInPopulatedMap() {
            return "d";
        }

        protected Integer getValueNotInPopulatedMap() {
            return 4;
        }
    }

    public static class HeadMapTests
    extends AbstractMapTests<String, Integer> {
        protected SortedMap<String, Integer> makePopulatedMap() {
            return ImmutableSortedMap.of((Comparable)((Object)"a"), (Object)1, (Comparable)((Object)"b"), (Object)2, (Comparable)((Object)"c"), (Object)3, (Comparable)((Object)"d"), (Object)4, (Comparable)((Object)"e"), (Object)5).headMap((Object)"d");
        }

        protected String getKeyNotInPopulatedMap() {
            return "d";
        }

        protected Integer getValueNotInPopulatedMap() {
            return 4;
        }
    }

    @GwtIncompatible(value="SerializableTester")
    public static class ReserializedMapTests
    extends AbstractMapTests<String, Integer> {
        protected SortedMap<String, Integer> makePopulatedMap() {
            return (SortedMap)SerializableTester.reserialize((Object)ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3));
        }

        protected String getKeyNotInPopulatedMap() {
            return "minus one";
        }

        protected Integer getValueNotInPopulatedMap() {
            return -1;
        }
    }

    public static class SingletonMapTests
    extends AbstractMapTests<String, Integer> {
        protected SortedMap<String, Integer> makePopulatedMap() {
            return ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1);
        }

        protected String getKeyNotInPopulatedMap() {
            return "minus one";
        }

        protected Integer getValueNotInPopulatedMap() {
            return -1;
        }
    }

    public static class MapTests
    extends AbstractMapTests<String, Integer> {
        @Override
        protected SortedMap<String, Integer> makeEmptyMap() {
            return ImmutableSortedMap.of();
        }

        protected SortedMap<String, Integer> makePopulatedMap() {
            return ImmutableSortedMap.of((Comparable)((Object)"one"), (Object)1, (Comparable)((Object)"two"), (Object)2, (Comparable)((Object)"three"), (Object)3);
        }

        protected String getKeyNotInPopulatedMap() {
            return "minus one";
        }

        protected Integer getValueNotInPopulatedMap() {
            return -1;
        }
    }

    public static abstract class AbstractMapTests<K, V>
    extends SortedMapInterfaceTest<K, V> {
        private static final Joiner joiner = Joiner.on((String)", ");

        public AbstractMapTests() {
            super(false, false, false, false, false);
        }

        protected SortedMap<K, V> makeEmptyMap() {
            throw new UnsupportedOperationException();
        }

        protected void assertMoreInvariants(Map<K, V> map) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                AbstractMapTests.assertEquals((String)(entry.getKey() + "=" + entry.getValue()), (String)entry.toString());
            }
            AbstractMapTests.assertEquals((String)("{" + joiner.join(map.entrySet()) + "}"), (String)map.toString());
            AbstractMapTests.assertEquals((String)("[" + joiner.join(map.entrySet()) + "]"), (String)map.entrySet().toString());
            AbstractMapTests.assertEquals((String)("[" + joiner.join(map.keySet()) + "]"), (String)map.keySet().toString());
            AbstractMapTests.assertEquals((String)("[" + joiner.join(map.values()) + "]"), (String)map.values().toString());
            AbstractMapTests.assertEquals((Object)Sets.newHashSet(map.entrySet()), map.entrySet());
            AbstractMapTests.assertEquals((Object)Sets.newHashSet(map.keySet()), map.keySet());
        }
    }
}

