/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.testing.GcFinalization;
import com.google.common.testing.NullPointerTester;
import java.lang.ref.WeakReference;
import junit.framework.TestCase;

public class InternersTest
extends TestCase {
    public void testStrong_simplistic() {
        String canonical = "a";
        String not = new String("a");
        Interner pool = Interners.newStrongInterner();
        InternersTest.assertSame((Object)canonical, (Object)pool.intern((Object)canonical));
        InternersTest.assertSame((Object)canonical, (Object)pool.intern((Object)not));
    }

    public void testStrong_null() {
        Interner pool = Interners.newStrongInterner();
        try {
            pool.intern(null);
            InternersTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWeak_simplistic() {
        String canonical = "a";
        String not = new String("a");
        Interner pool = Interners.newWeakInterner();
        InternersTest.assertSame((Object)canonical, (Object)pool.intern((Object)canonical));
        InternersTest.assertSame((Object)canonical, (Object)pool.intern((Object)not));
    }

    public void testWeak_null() {
        Interner pool = Interners.newWeakInterner();
        try {
            pool.intern(null);
            InternersTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWeak_afterGC() throws InterruptedException {
        Integer canonical = new Integer(5);
        Integer not = new Integer(5);
        Interner pool = Interners.newWeakInterner();
        InternersTest.assertSame((Object)canonical, (Object)pool.intern((Object)canonical));
        WeakReference<Integer> signal = new WeakReference<Integer>(canonical);
        canonical = null;
        GcFinalization.awaitClear(signal);
        InternersTest.assertSame((Object)not, (Object)pool.intern((Object)not));
    }

    public void testAsFunction_simplistic() {
        String canonical = "a";
        String not = new String("a");
        Function internerFunction = Interners.asFunction((Interner)Interners.newStrongInterner());
        InternersTest.assertSame((Object)canonical, (Object)internerFunction.apply((Object)canonical));
        InternersTest.assertSame((Object)canonical, (Object)internerFunction.apply((Object)not));
    }

    public void testNullPointerExceptions() {
        new NullPointerTester().testAllPublicStaticMethods(Interners.class);
    }
}

