/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.testing.SerializableTester;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.SortedSet;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class MultimapBuilderTest
extends TestCase {
    @GwtIncompatible(value="doesn't build without explicit type parameters on build() methods")
    public void testGenerics() {
        ListMultimap a = MultimapBuilder.hashKeys().arrayListValues().build();
        SortedSetMultimap b = MultimapBuilder.linkedHashKeys().treeSetValues().build();
        SetMultimap c = MultimapBuilder.treeKeys((Comparator)String.CASE_INSENSITIVE_ORDER).hashSetValues().build();
    }

    public void testGenerics_gwtCompatible() {
        ListMultimap a = MultimapBuilder.hashKeys().arrayListValues().build();
        SortedSetMultimap b = MultimapBuilder.linkedHashKeys().treeSetValues().build();
        SetMultimap c = MultimapBuilder.treeKeys((Comparator)String.CASE_INSENSITIVE_ORDER).hashSetValues().build();
    }

    @GwtIncompatible(value="doesn't build without explicit type parameters on build() methods")
    public void testTreeKeys() {
        ListMultimap multimap = MultimapBuilder.treeKeys().arrayListValues().build();
        MultimapBuilderTest.assertTrue((boolean)(multimap.keySet() instanceof SortedSet));
        MultimapBuilderTest.assertTrue((boolean)(multimap.asMap() instanceof SortedMap));
    }

    public void testTreeKeys_gwtCompatible() {
        ListMultimap multimap = MultimapBuilder.treeKeys().arrayListValues().build();
        MultimapBuilderTest.assertTrue((boolean)(multimap.keySet() instanceof SortedSet));
        MultimapBuilderTest.assertTrue((boolean)(multimap.asMap() instanceof SortedMap));
    }

    public void testSerialization() {
        for (MultimapBuilder.MultimapBuilderWithKeys builderWithKeys : ImmutableList.of((Object)MultimapBuilder.hashKeys(), (Object)MultimapBuilder.linkedHashKeys(), (Object)MultimapBuilder.treeKeys(), (Object)MultimapBuilder.enumKeys(RoundingMode.class))) {
            for (MultimapBuilder builder : ImmutableList.of((Object)builderWithKeys.arrayListValues(), (Object)builderWithKeys.linkedListValues(), (Object)builderWithKeys.hashSetValues(), (Object)builderWithKeys.linkedHashSetValues(), (Object)builderWithKeys.treeSetValues(), (Object)builderWithKeys.enumSetValues(RoundingMode.class))) {
                SerializableTester.reserializeAndAssert((Object)builder.build());
            }
        }
    }
}

