/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.testing.NullPointerTester;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.truth0.Truth;

@GwtCompatible(emulated=true)
public class ObjectArraysTest
extends TestCase {
    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(ObjectArrays.class);
    }

    @GwtIncompatible(value="ObjectArrays.newArray(Class, int)")
    public void testNewArray_fromClass_Empty() {
        String[] empty = (String[])ObjectArrays.newArray(String.class, (int)0);
        ObjectArraysTest.assertEquals(String[].class, empty.getClass());
        ObjectArraysTest.assertEquals((int)0, (int)empty.length);
    }

    @GwtIncompatible(value="ObjectArrays.newArray(Class, int)")
    public void testNewArray_fromClass_Nonempty() {
        String[] array = (String[])ObjectArrays.newArray(String.class, (int)2);
        ObjectArraysTest.assertEquals(String[].class, array.getClass());
        ObjectArraysTest.assertEquals((int)2, (int)array.length);
        ObjectArraysTest.assertNull((Object)array[0]);
    }

    @GwtIncompatible(value="ObjectArrays.newArray(Class, int)")
    public void testNewArray_fromClass_OfArray() {
        String[][] array = (String[][])ObjectArrays.newArray(String[].class, (int)1);
        ObjectArraysTest.assertEquals(String[][].class, array.getClass());
        ObjectArraysTest.assertEquals((int)1, (int)array.length);
        ObjectArraysTest.assertNull((Object)array[0]);
    }

    public void testNewArray_fromArray_Empty() {
        Object[] in = new String[]{};
        String[] empty = (String[])ObjectArrays.newArray((Object[])in, (int)0);
        ObjectArraysTest.assertEquals((int)0, (int)empty.length);
    }

    public void testNewArray_fromArray_Nonempty() {
        String[] array = (String[])ObjectArrays.newArray((Object[])new String[0], (int)2);
        ObjectArraysTest.assertEquals(String[].class, array.getClass());
        ObjectArraysTest.assertEquals((int)2, (int)array.length);
        ObjectArraysTest.assertNull((Object)array[0]);
    }

    public void testNewArray_fromArray_OfArray() {
        String[][] array = (String[][])ObjectArrays.newArray((Object[])new String[0][0], (int)1);
        ObjectArraysTest.assertEquals(String[][].class, array.getClass());
        ObjectArraysTest.assertEquals((int)1, (int)array.length);
        ObjectArraysTest.assertNull((Object)array[0]);
    }

    @GwtIncompatible(value="ObjectArrays.concat(Object[], Object[], Class)")
    public void testConcatEmptyEmpty() {
        String[] result = (String[])ObjectArrays.concat((Object[])new String[0], (Object[])new String[0], String.class);
        ObjectArraysTest.assertEquals(String[].class, result.getClass());
        ObjectArraysTest.assertEquals((int)0, (int)result.length);
    }

    @GwtIncompatible(value="ObjectArrays.concat(Object[], Object[], Class)")
    public void testConcatEmptyNonempty() {
        Object[] result = (String[])ObjectArrays.concat((Object[])new String[0], (Object[])new String[]{"a", "b"}, String.class);
        ObjectArraysTest.assertEquals(String[].class, result.getClass());
        Truth.ASSERT.that(result).has().exactly((Object)"a", (Object)"b", (Object[])new String[0]).inOrder();
    }

    @GwtIncompatible(value="ObjectArrays.concat(Object[], Object[], Class)")
    public void testConcatNonemptyEmpty() {
        Object[] result = (String[])ObjectArrays.concat((Object[])new String[]{"a", "b"}, (Object[])new String[0], String.class);
        ObjectArraysTest.assertEquals(String[].class, result.getClass());
        Truth.ASSERT.that(result).has().exactly((Object)"a", (Object)"b", (Object[])new String[0]).inOrder();
    }

    @GwtIncompatible(value="ObjectArrays.concat(Object[], Object[], Class)")
    public void testConcatBasic() {
        Object[] result = (String[])ObjectArrays.concat((Object[])new String[]{"a", "b"}, (Object[])new String[]{"c", "d"}, String.class);
        ObjectArraysTest.assertEquals(String[].class, result.getClass());
        Truth.ASSERT.that(result).has().exactly((Object)"a", (Object)"b", (Object[])new String[]{"c", "d"}).inOrder();
    }

    @GwtIncompatible(value="ObjectArrays.concat(Object[], Object[], Class)")
    public void testConcatWithMoreGeneralType() {
        Serializable[] result = (Serializable[])ObjectArrays.concat((Object[])new String[0], (Object[])new String[0], Serializable.class);
        ObjectArraysTest.assertEquals(Serializable[].class, result.getClass());
    }

    public void testToArrayImpl1() {
        this.doTestToArrayImpl1(Lists.newArrayList());
        this.doTestToArrayImpl1(Lists.newArrayList((Object[])new Integer[]{1}));
        this.doTestToArrayImpl1(Lists.newArrayList((Object[])new Integer[]{1, null, 3}));
    }

    private void doTestToArrayImpl1(List<Integer> list) {
        Object[] reference = list.toArray();
        Object[] target = ObjectArrays.toArrayImpl(list);
        ObjectArraysTest.assertEquals(reference.getClass(), target.getClass());
        ObjectArraysTest.assertTrue((boolean)Arrays.equals(reference, target));
    }

    public void testToArrayImpl2() {
        this.doTestToArrayImpl2(Lists.newArrayList(), new Integer[0], false);
        this.doTestToArrayImpl2(Lists.newArrayList(), new Integer[1], true);
        this.doTestToArrayImpl2(Lists.newArrayList((Object[])new Integer[]{1}), new Integer[0], false);
        this.doTestToArrayImpl2(Lists.newArrayList((Object[])new Integer[]{1}), new Integer[1], true);
        this.doTestToArrayImpl2(Lists.newArrayList((Object[])new Integer[]{1}), new Integer[]{2, 3}, true);
        this.doTestToArrayImpl2(Lists.newArrayList((Object[])new Integer[]{1, null, 3}), new Integer[0], false);
        this.doTestToArrayImpl2(Lists.newArrayList((Object[])new Integer[]{1, null, 3}), new Integer[2], false);
        this.doTestToArrayImpl2(Lists.newArrayList((Object[])new Integer[]{1, null, 3}), new Integer[3], true);
    }

    private void doTestToArrayImpl2(List<Integer> list, Integer[] array1, boolean expectModify) {
        Integer[] starting = (Integer[])ObjectArrays.arraysCopyOf((Object[])array1, (int)array1.length);
        Object[] array2 = (Integer[])ObjectArrays.arraysCopyOf((Object[])array1, (int)array1.length);
        Object[] reference = list.toArray(array1);
        Object[] target = ObjectArrays.toArrayImpl(list, (Object[])array2);
        ObjectArraysTest.assertEquals(reference.getClass(), target.getClass());
        ObjectArraysTest.assertTrue((boolean)Arrays.equals(reference, target));
        ObjectArraysTest.assertTrue((boolean)Arrays.equals(reference, target));
        Object[] expectedArray1 = expectModify ? reference : starting;
        Object[] expectedArray2 = expectModify ? target : starting;
        ObjectArraysTest.assertTrue((boolean)Arrays.equals(expectedArray1, (Object[])array1));
        ObjectArraysTest.assertTrue((boolean)Arrays.equals(expectedArray2, array2));
    }

    public void testPrependZeroElements() {
        Object[] result = (String[])ObjectArrays.concat((Object)"foo", (Object[])new String[0]);
        Truth.ASSERT.that(result).has().item((Object)"foo");
    }

    public void testPrependOneElement() {
        Object[] result = (String[])ObjectArrays.concat((Object)"foo", (Object[])new String[]{"bar"});
        Truth.ASSERT.that(result).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[0]).inOrder();
    }

    public void testPrependTwoElements() {
        Object[] result = (String[])ObjectArrays.concat((Object)"foo", (Object[])new String[]{"bar", "baz"});
        Truth.ASSERT.that(result).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{"baz"}).inOrder();
    }

    public void testAppendZeroElements() {
        Object[] result = (String[])ObjectArrays.concat((Object[])new String[0], (Object)"foo");
        Truth.ASSERT.that(result).has().item((Object)"foo");
    }

    public void testAppendOneElement() {
        Object[] result = (String[])ObjectArrays.concat((Object[])new String[]{"foo"}, (Object)"bar");
        Truth.ASSERT.that(result).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[0]).inOrder();
    }

    public void testAppendTwoElements() {
        Object[] result = (String[])ObjectArrays.concat((Object[])new String[]{"foo", "bar"}, (Object)"baz");
        Truth.ASSERT.that(result).has().exactly((Object)"foo", (Object)"bar", (Object[])new String[]{"baz"}).inOrder();
    }

    public void testEmptyArrayToEmpty() {
        ObjectArraysTest.doTestNewArrayEquals(new Object[0], 0);
    }

    public void testEmptyArrayToNonEmpty() {
        ObjectArraysTest.checkArrayEquals(new Long[5], ObjectArrays.newArray((Object[])new Long[0], (int)5));
    }

    public void testNonEmptyToShorter() {
        ObjectArraysTest.checkArrayEquals(new String[9], ObjectArrays.newArray((Object[])new String[10], (int)9));
    }

    public void testNonEmptyToSameLength() {
        ObjectArraysTest.doTestNewArrayEquals(new String[10], 10);
    }

    public void testNonEmptyToLonger() {
        ObjectArraysTest.checkArrayEquals(new String[10], ObjectArrays.newArray((Object[])new String[]{"a", "b", "c", "d", "e"}, (int)10));
    }

    private static void checkArrayEquals(Object[] expected, Object[] actual) {
        ObjectArraysTest.assertTrue((String)("expected(" + expected.getClass() + "): " + Arrays.toString(expected) + " actual(" + actual.getClass() + "): " + Arrays.toString(actual)), (boolean)ObjectArraysTest.arrayEquals(expected, actual));
    }

    private static boolean arrayEquals(Object[] array1, Object[] array2) {
        ObjectArraysTest.assertSame(array1.getClass(), array2.getClass());
        return Arrays.equals(array1, array2);
    }

    private static void doTestNewArrayEquals(Object[] expected, int length) {
        ObjectArraysTest.checkArrayEquals(expected, ObjectArrays.newArray((Object[])expected, (int)length));
    }
}

