/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.google.TestStringMultisetGenerator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class SimpleAbstractMultisetTest
extends TestCase {
    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(SimpleAbstractMultisetTest.class);
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                NoRemoveMultiset ms = new NoRemoveMultiset();
                Collections.addAll(ms, elements);
                return ms;
            }
        }).named("NoRemoveMultiset")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.SUPPORTS_ADD})).createTestSuite());
        return suite;
    }

    public void testFastAddAllMultiset() {
        final AtomicInteger addCalls = new AtomicInteger();
        NoRemoveMultiset<String> multiset = new NoRemoveMultiset<String>(){

            @Override
            public int add(String element, int occurrences) {
                addCalls.incrementAndGet();
                return super.add(element, occurrences);
            }
        };
        ImmutableMultiset adds = new ImmutableMultiset.Builder().addCopies((Object)"x", 10).build();
        multiset.addAll((Collection)adds);
        SimpleAbstractMultisetTest.assertEquals((int)addCalls.get(), (int)1);
    }

    public void testRemoveUnsupported() {
        NoRemoveMultiset multiset = new NoRemoveMultiset();
        multiset.add("a");
        try {
            multiset.remove("a");
            SimpleAbstractMultisetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        SimpleAbstractMultisetTest.assertTrue((boolean)multiset.contains("a"));
    }

    private static class NoRemoveMultiset<E>
    extends AbstractMultiset<E>
    implements Serializable {
        final Map<E, Integer> backingMap = Maps.newHashMap();

        private NoRemoveMultiset() {
        }

        public int add(@Nullable E element, int occurrences) {
            Preconditions.checkArgument((occurrences >= 0 ? 1 : 0) != 0);
            Integer frequency = this.backingMap.get(element);
            if (frequency == null) {
                frequency = 0;
            }
            if (occurrences == 0) {
                return frequency;
            }
            Preconditions.checkArgument((occurrences <= Integer.MAX_VALUE - frequency ? 1 : 0) != 0);
            this.backingMap.put(element, frequency + occurrences);
            return frequency;
        }

        Iterator<Multiset.Entry<E>> entryIterator() {
            final Iterator<Map.Entry<E, Integer>> backingEntries = this.backingMap.entrySet().iterator();
            return new UnmodifiableIterator<Multiset.Entry<E>>(){

                public boolean hasNext() {
                    return backingEntries.hasNext();
                }

                public Multiset.Entry<E> next() {
                    final Map.Entry mapEntry = (Map.Entry)backingEntries.next();
                    return new Multisets.AbstractEntry<E>(){

                        public E getElement() {
                            return mapEntry.getKey();
                        }

                        public int getCount() {
                            Integer frequency = NoRemoveMultiset.this.backingMap.get(this.getElement());
                            return frequency == null ? 0 : frequency;
                        }
                    };
                }
            };
        }

        int distinctElements() {
            return this.backingMap.size();
        }
    }
}

