/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.testing.CollectionTestSuiteBuilder;
import com.google.common.collect.testing.MapInterfaceTest;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.SortedSetTestSuiteBuilder;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestSortedSetGenerator;
import com.google.common.collect.testing.TestStringCollectionGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.TestStringSortedSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class TableCollectionTest
extends TestCase {
    private static final Feature<?>[] COLLECTION_FEATURES = new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_QUERIES};
    private static final Feature<?>[] COLLECTION_FEATURES_ORDER = new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES};
    private static final Feature<?>[] COLLECTION_FEATURES_REMOVE = new Feature[]{CollectionSize.ANY, CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_QUERIES};
    private static final Feature<?>[] COLLECTION_FEATURES_REMOVE_ORDER = new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.ALLOWS_NULL_QUERIES};
    private static final Function<Integer, Integer> DIVIDE_BY_2 = new Function<Integer, Integer>(){

        public Integer apply(Integer input) {
            return input == null ? null : Integer.valueOf(input / 2);
        }
    };
    private static final Function<String, Character> FIRST_CHARACTER = new Function<String, Character>(){

        public Character apply(String input) {
            return input == null ? null : Character.valueOf(input.charAt(0));
        }
    };

    @GwtIncompatible(value="suite")
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ArrayRowTests.class);
        suite.addTestSuite(HashRowTests.class);
        suite.addTestSuite(TreeRowTests.class);
        suite.addTestSuite(TransposeRowTests.class);
        suite.addTestSuite(TransformValueRowTests.class);
        suite.addTestSuite(UnmodifiableHashRowTests.class);
        suite.addTestSuite(UnmodifiableTreeRowTests.class);
        suite.addTestSuite(ArrayColumnTests.class);
        suite.addTestSuite(HashColumnTests.class);
        suite.addTestSuite(TreeColumnTests.class);
        suite.addTestSuite(TransposeColumnTests.class);
        suite.addTestSuite(TransformValueColumnTests.class);
        suite.addTestSuite(UnmodifiableHashColumnTests.class);
        suite.addTestSuite(UnmodifiableTreeColumnTests.class);
        suite.addTestSuite(ArrayRowMapTests.class);
        suite.addTestSuite(HashRowMapTests.class);
        suite.addTestSuite(TreeRowMapTests.class);
        suite.addTestSuite(TreeRowMapHeadMapTests.class);
        suite.addTestSuite(TreeRowMapTailMapTests.class);
        suite.addTestSuite(TreeRowMapSubMapTests.class);
        suite.addTestSuite(TransformValueRowMapTests.class);
        suite.addTestSuite(UnmodifiableHashRowMapTests.class);
        suite.addTestSuite(UnmodifiableTreeRowMapTests.class);
        suite.addTestSuite(ArrayColumnMapTests.class);
        suite.addTestSuite(HashColumnMapTests.class);
        suite.addTestSuite(TreeColumnMapTests.class);
        suite.addTestSuite(TransformValueColumnMapTests.class);
        suite.addTestSuite(UnmodifiableHashColumnMapTests.class);
        suite.addTestSuite(UnmodifiableTreeColumnMapTests.class);
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                ArrayTable table = ArrayTable.create((Iterable)ImmutableList.copyOf((Object[])elements), (Iterable)ImmutableList.of((Object)1, (Object)2));
                TableCollectionTest.populateForRowKeySet((Table<String, Integer, Character>)((Table)table), elements);
                return table.rowKeySet();
            }
        }).named("ArrayTable.rowKeySet")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.KNOWN_ORDER, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                HashBasedTable table = HashBasedTable.create();
                TableCollectionTest.populateForRowKeySet((Table<String, Integer, Character>)((Table)table), elements);
                return table.rowKeySet();
            }
        }).named("HashBasedTable.rowKeySet")).withFeatures(COLLECTION_FEATURES_REMOVE)).withFeatures(new Feature[]{CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SortedSetTestSuiteBuilder.using((TestSortedSetGenerator)new TestStringSortedSetGenerator(){

            protected SortedSet<String> create(String[] elements) {
                TreeBasedTable table = TreeBasedTable.create();
                TableCollectionTest.populateForRowKeySet((Table<String, Integer, Character>)((Table)table), elements);
                return table.rowKeySet();
            }

            public List<String> order(List<String> insertionOrder) {
                Collections.sort(insertionOrder);
                return insertionOrder;
            }
        }).named("TreeBasedTable.rowKeySet")).withFeatures(COLLECTION_FEATURES_REMOVE_ORDER)).withFeatures(new Feature[]{CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                HashBasedTable table = HashBasedTable.create();
                TableCollectionTest.populateForRowKeySet((Table<String, Integer, Character>)((Table)table), elements);
                return Tables.unmodifiableTable((Table)table).rowKeySet();
            }
        }).named("unmodifiableTable[HashBasedTable].rowKeySet")).withFeatures(COLLECTION_FEATURES)).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                TreeBasedTable table = TreeBasedTable.create();
                TableCollectionTest.populateForRowKeySet((Table<String, Integer, Character>)((Table)table), elements);
                return Tables.unmodifiableRowSortedTable((RowSortedTable)table).rowKeySet();
            }

            public List<String> order(List<String> insertionOrder) {
                Collections.sort(insertionOrder);
                return insertionOrder;
            }
        }).named("unmodifiableRowSortedTable[TreeBasedTable].rowKeySet")).withFeatures(COLLECTION_FEATURES_ORDER)).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                ArrayTable table = ArrayTable.create((Iterable)ImmutableList.of((Object)1, (Object)2), (Iterable)ImmutableList.copyOf((Object[])elements));
                TableCollectionTest.populateForColumnKeySet((Table<Integer, String, Character>)((Table)table), elements);
                return table.columnKeySet();
            }
        }).named("ArrayTable.columnKeySet")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.KNOWN_ORDER, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                HashBasedTable table = HashBasedTable.create();
                TableCollectionTest.populateForColumnKeySet((Table<Integer, String, Character>)((Table)table), elements);
                return table.columnKeySet();
            }
        }).named("HashBasedTable.columnKeySet")).withFeatures(COLLECTION_FEATURES_REMOVE)).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                TreeBasedTable table = TreeBasedTable.create();
                TableCollectionTest.populateForColumnKeySet((Table<Integer, String, Character>)((Table)table), elements);
                return table.columnKeySet();
            }

            public List<String> order(List<String> insertionOrder) {
                Collections.sort(insertionOrder);
                return insertionOrder;
            }
        }).named("TreeBasedTable.columnKeySet")).withFeatures(COLLECTION_FEATURES_REMOVE_ORDER)).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                HashBasedTable table = HashBasedTable.create();
                TableCollectionTest.populateForColumnKeySet((Table<Integer, String, Character>)((Table)table), elements);
                return Tables.unmodifiableTable((Table)table).columnKeySet();
            }
        }).named("unmodifiableTable[HashBasedTable].columnKeySet")).withFeatures(COLLECTION_FEATURES)).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                TreeBasedTable table = TreeBasedTable.create();
                TableCollectionTest.populateForColumnKeySet((Table<Integer, String, Character>)((Table)table), elements);
                return Tables.unmodifiableRowSortedTable((RowSortedTable)table).columnKeySet();
            }

            public List<String> order(List<String> insertionOrder) {
                Collections.sort(insertionOrder);
                return insertionOrder;
            }
        }).named("unmodifiableRowSortedTable[TreeBasedTable].columnKeySet")).withFeatures(COLLECTION_FEATURES_ORDER)).createTestSuite());
        suite.addTest((Test)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            protected Collection<String> create(String[] elements) {
                ArrayList rowKeys = Lists.newArrayList();
                for (int i = 0; i < elements.length; ++i) {
                    rowKeys.add(i);
                }
                ArrayTable table = ArrayTable.create((Iterable)rowKeys, (Iterable)ImmutableList.of((Object)Character.valueOf('a')));
                TableCollectionTest.populateForValues((Table<Integer, Character, String>)((Table)table), elements);
                return table.values();
            }
        }).named("ArrayTable.values")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER})).createTestSuite());
        suite.addTest((Test)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            protected Collection<String> create(String[] elements) {
                HashBasedTable table = HashBasedTable.create();
                table.put((Object)1, (Object)Character.valueOf('a'), (Object)"foo");
                table.clear();
                TableCollectionTest.populateForValues((Table<Integer, Character, String>)((Table)table), elements);
                return table.values();
            }
        }).named("HashBasedTable.values")).withFeatures(COLLECTION_FEATURES_REMOVE)).withFeatures(new Feature[]{CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            protected Collection<String> create(String[] elements) {
                TreeBasedTable table = TreeBasedTable.create();
                table.put((Object)1, (Object)Character.valueOf('a'), (Object)"foo");
                table.clear();
                TableCollectionTest.populateForValues((Table<Integer, Character, String>)((Table)table), elements);
                return table.values();
            }
        }).named("TreeBasedTable.values")).withFeatures(COLLECTION_FEATURES_REMOVE_ORDER)).withFeatures(new Feature[]{CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        Function<String, String> removeFirstCharacter = new Function<String, String>(){

            public String apply(String input) {
                return input.substring(1);
            }
        };
        suite.addTest((Test)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator((Function)removeFirstCharacter){
            final /* synthetic */ Function val$removeFirstCharacter;
            {
                this.val$removeFirstCharacter = function;
            }

            protected Collection<String> create(String[] elements) {
                HashBasedTable table = HashBasedTable.create();
                for (int i = 0; i < elements.length; ++i) {
                    table.put((Object)i, (Object)Character.valueOf('a'), (Object)("x" + (String)Preconditions.checkNotNull((Object)elements[i])));
                }
                return Tables.transformValues((Table)table, (Function)this.val$removeFirstCharacter).values();
            }
        }).named("TransformValues.values")).withFeatures(COLLECTION_FEATURES_REMOVE)).withFeatures(new Feature[]{CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            protected Collection<String> create(String[] elements) {
                HashBasedTable table = HashBasedTable.create();
                table.put((Object)1, (Object)Character.valueOf('a'), (Object)"foo");
                table.clear();
                TableCollectionTest.populateForValues((Table<Integer, Character, String>)((Table)table), elements);
                return Tables.unmodifiableTable((Table)table).values();
            }
        }).named("unmodifiableTable[HashBasedTable].values")).withFeatures(COLLECTION_FEATURES)).createTestSuite());
        suite.addTest((Test)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            protected Collection<String> create(String[] elements) {
                TreeBasedTable table = TreeBasedTable.create();
                table.put((Object)1, (Object)Character.valueOf('a'), (Object)"foo");
                table.clear();
                TableCollectionTest.populateForValues((Table<Integer, Character, String>)((Table)table), elements);
                return Tables.unmodifiableRowSortedTable((RowSortedTable)table).values();
            }
        }).named("unmodifiableTable[TreeBasedTable].values")).withFeatures(COLLECTION_FEATURES_ORDER)).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestCellSetGenerator(){

            @Override
            public SampleElements<Table.Cell<String, Integer, Character>> samples() {
                return new SampleElements((Object)Tables.immutableCell((Object)"bar", (Object)1, (Object)Character.valueOf('a')), (Object)Tables.immutableCell((Object)"bar", (Object)2, (Object)Character.valueOf('b')), (Object)Tables.immutableCell((Object)"bar", (Object)3, (Object)null), (Object)Tables.immutableCell((Object)"bar", (Object)4, (Object)Character.valueOf('b')), (Object)Tables.immutableCell((Object)"bar", (Object)5, (Object)Character.valueOf('b')));
            }

            @Override
            public Set<Table.Cell<String, Integer, Character>> create(Object ... elements) {
                ArrayList columnKeys = Lists.newArrayList();
                for (Object element : elements) {
                    Table.Cell cell = (Table.Cell)element;
                    columnKeys.add(cell.getColumnKey());
                }
                ArrayTable table = ArrayTable.create((Iterable)ImmutableList.of((Object)"bar"), (Iterable)columnKeys);
                for (Object element : elements) {
                    Table.Cell cell = (Table.Cell)element;
                    table.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
                }
                return table.cellSet();
            }

            @Override
            Table<String, Integer, Character> createTable() {
                throw new UnsupportedOperationException();
            }
        }).named("ArrayTable.cellSet")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.KNOWN_ORDER, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestCellSetGenerator(){

            @Override
            Table<String, Integer, Character> createTable() {
                return HashBasedTable.create();
            }
        }).named("HashBasedTable.cellSet")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REMOVE_OPERATIONS, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestCellSetGenerator(){

            @Override
            Table<String, Integer, Character> createTable() {
                return TreeBasedTable.create();
            }
        }).named("TreeBasedTable.cellSet")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REMOVE_OPERATIONS, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestCellSetGenerator(){

            @Override
            Table<String, Integer, Character> createTable() {
                TreeBasedTable original = TreeBasedTable.create();
                return Tables.transpose((Table)original);
            }
        }).named("TransposedTable.cellSet")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REMOVE_OPERATIONS, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestCellSetGenerator(){

            @Override
            Table<String, Integer, Character> createTable() {
                return HashBasedTable.create();
            }

            @Override
            public Set<Table.Cell<String, Integer, Character>> create(Object ... elements) {
                Table<String, Integer, Character> table = this.createTable();
                for (Object element : elements) {
                    Table.Cell cell = (Table.Cell)element;
                    table.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
                }
                return Tables.transformValues(table, (Function)Functions.identity()).cellSet();
            }
        }).named("TransformValues.cellSet")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_QUERIES, CollectionFeature.REMOVE_OPERATIONS})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestCellSetGenerator(){

            @Override
            Table<String, Integer, Character> createTable() {
                return Tables.unmodifiableTable((Table)HashBasedTable.create());
            }

            @Override
            public Set<Table.Cell<String, Integer, Character>> create(Object ... elements) {
                HashBasedTable table = HashBasedTable.create();
                for (Object element : elements) {
                    Table.Cell cell = (Table.Cell)element;
                    table.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
                }
                return Tables.unmodifiableTable((Table)table).cellSet();
            }
        }).named("unmodifiableTable[HashBasedTable].cellSet")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestCellSetGenerator(){

            RowSortedTable<String, Integer, Character> createTable() {
                return Tables.unmodifiableRowSortedTable((RowSortedTable)TreeBasedTable.create());
            }

            @Override
            public Set<Table.Cell<String, Integer, Character>> create(Object ... elements) {
                TreeBasedTable table = TreeBasedTable.create();
                for (Object element : elements) {
                    Table.Cell cell = (Table.Cell)element;
                    table.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
                }
                return Tables.unmodifiableRowSortedTable((RowSortedTable)table).cellSet();
            }
        }).named("unmodifiableRowSortedTable[TreeBasedTable].cellSet")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                ImmutableSet rowKeys = ImmutableSet.copyOf((Object[])elements);
                ImmutableList columnKeys = ImmutableList.of((Object)1, (Object)2, (Object)3);
                ArrayTable table = ArrayTable.create((Iterable)rowKeys, (Iterable)columnKeys);
                TableCollectionTest.populateForRowKeySet((Table<String, Integer, Character>)((Table)table), elements);
                return table.column((Object)1).keySet();
            }
        }).named("ArrayTable.column.keySet")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                HashBasedTable table = HashBasedTable.create();
                TableCollectionTest.populateForRowKeySet((Table<String, Integer, Character>)((Table)table), elements);
                return table.column((Object)1).keySet();
            }
        }).named("HashBasedTable.column.keySet")).withFeatures(COLLECTION_FEATURES_REMOVE)).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                TreeBasedTable table = TreeBasedTable.create();
                TableCollectionTest.populateForRowKeySet((Table<String, Integer, Character>)((Table)table), elements);
                return table.column((Object)1).keySet();
            }

            public List<String> order(List<String> insertionOrder) {
                Collections.sort(insertionOrder);
                return insertionOrder;
            }
        }).named("TreeBasedTable.column.keySet")).withFeatures(COLLECTION_FEATURES_REMOVE_ORDER)).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                HashBasedTable table = HashBasedTable.create();
                TableCollectionTest.populateForRowKeySet((Table<String, Integer, Character>)((Table)table), elements);
                return Tables.transformValues((Table)table, (Function)Functions.toStringFunction()).column((Object)1).keySet();
            }
        }).named("TransformValues.column.keySet")).withFeatures(COLLECTION_FEATURES_REMOVE)).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                HashBasedTable table = HashBasedTable.create();
                TableCollectionTest.populateForRowKeySet((Table<String, Integer, Character>)((Table)table), elements);
                return Tables.unmodifiableTable((Table)table).column((Object)1).keySet();
            }
        }).named("unmodifiableTable[HashBasedTable].column.keySet")).withFeatures(COLLECTION_FEATURES)).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                TreeBasedTable table = TreeBasedTable.create();
                TableCollectionTest.populateForRowKeySet((Table<String, Integer, Character>)((Table)table), elements);
                return Tables.unmodifiableRowSortedTable((RowSortedTable)table).column((Object)1).keySet();
            }

            public List<String> order(List<String> insertionOrder) {
                Collections.sort(insertionOrder);
                return insertionOrder;
            }
        }).named("unmodifiableRowSortedTable[TreeBasedTable].column.keySet")).withFeatures(COLLECTION_FEATURES_ORDER)).createTestSuite());
        return suite;
    }

    private static void populateForRowKeySet(Table<String, Integer, Character> table, String[] elements) {
        for (String row : elements) {
            table.put((Object)row, (Object)1, (Object)Character.valueOf('a'));
            table.put((Object)row, (Object)2, (Object)Character.valueOf('b'));
        }
    }

    private static void populateForColumnKeySet(Table<Integer, String, Character> table, String[] elements) {
        for (String column : elements) {
            table.put((Object)1, (Object)column, (Object)Character.valueOf('a'));
            table.put((Object)2, (Object)column, (Object)Character.valueOf('b'));
        }
    }

    private static void populateForValues(Table<Integer, Character, String> table, String[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            table.put((Object)i, (Object)Character.valueOf('a'), (Object)elements[i]);
        }
    }

    public static class UnmodifiableTreeColumnMapTests
    extends ColumnMapTests {
        public UnmodifiableTreeColumnMapTests() {
            super(false, false, false, false);
        }

        @Override
        Table<Integer, String, Character> makeTable() {
            TreeBasedTable original = TreeBasedTable.create();
            return Tables.unmodifiableRowSortedTable((RowSortedTable)original);
        }

        @Override
        protected Map<String, Map<Integer, Character>> makePopulatedMap() {
            TreeBasedTable table = TreeBasedTable.create();
            table.put((Object)1, (Object)"foo", (Object)Character.valueOf('a'));
            table.put((Object)1, (Object)"bar", (Object)Character.valueOf('b'));
            table.put((Object)3, (Object)"foo", (Object)Character.valueOf('c'));
            return Tables.unmodifiableRowSortedTable((RowSortedTable)table).columnMap();
        }
    }

    public static class UnmodifiableHashColumnMapTests
    extends ColumnMapTests {
        public UnmodifiableHashColumnMapTests() {
            super(false, false, false, false);
        }

        @Override
        Table<Integer, String, Character> makeTable() {
            HashBasedTable original = HashBasedTable.create();
            return Tables.unmodifiableTable((Table)original);
        }

        @Override
        protected Map<String, Map<Integer, Character>> makePopulatedMap() {
            HashBasedTable table = HashBasedTable.create();
            table.put((Object)1, (Object)"foo", (Object)Character.valueOf('a'));
            table.put((Object)1, (Object)"bar", (Object)Character.valueOf('b'));
            table.put((Object)3, (Object)"foo", (Object)Character.valueOf('c'));
            return Tables.unmodifiableTable((Table)table).columnMap();
        }
    }

    public static class TransformValueColumnMapTests
    extends ColumnMapTests {
        public TransformValueColumnMapTests() {
            super(false, true, true, false);
        }

        @Override
        Table<Integer, String, Character> makeTable() {
            HashBasedTable original = HashBasedTable.create();
            return Tables.transformValues((Table)original, (Function)FIRST_CHARACTER);
        }

        @Override
        protected Map<String, Map<Integer, Character>> makePopulatedMap() {
            HashBasedTable table = HashBasedTable.create();
            table.put((Object)1, (Object)"foo", (Object)"apple");
            table.put((Object)1, (Object)"bar", (Object)"banana");
            table.put((Object)3, (Object)"foo", (Object)"cat");
            return Tables.transformValues((Table)table, (Function)FIRST_CHARACTER).columnMap();
        }
    }

    public static class TreeColumnMapTests
    extends ColumnMapTests {
        public TreeColumnMapTests() {
            super(false, true, true, false);
        }

        @Override
        Table<Integer, String, Character> makeTable() {
            return TreeBasedTable.create();
        }
    }

    public static class HashColumnMapTests
    extends ColumnMapTests {
        public HashColumnMapTests() {
            super(false, true, true, false);
        }

        @Override
        Table<Integer, String, Character> makeTable() {
            return HashBasedTable.create();
        }
    }

    @GwtIncompatible(value="TODO(hhchan): ArrayTable")
    public static class ArrayColumnMapTests
    extends ColumnMapTests {
        public ArrayColumnMapTests() {
            super(true, false, false, false);
        }

        @Override
        Table<Integer, String, Character> makeTable() {
            return ArrayTable.create(Arrays.asList(1, 2, 3), Arrays.asList("foo", "bar", "dog"));
        }

        @Override
        protected Map<String, Map<Integer, Character>> makeEmptyMap() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class ColumnMapTests
    extends MapMapTests {
        ColumnMapTests(boolean allowsNullValues, boolean supportsRemove, boolean supportsClear, boolean supportsIteratorRemove) {
            super(allowsNullValues, supportsRemove, supportsClear, supportsIteratorRemove);
        }

        abstract Table<Integer, String, Character> makeTable();

        protected Map<String, Map<Integer, Character>> makePopulatedMap() {
            Table<Integer, String, Character> table = this.makeTable();
            table.put((Object)1, (Object)"foo", (Object)Character.valueOf('a'));
            table.put((Object)1, (Object)"bar", (Object)Character.valueOf('b'));
            table.put((Object)3, (Object)"foo", (Object)Character.valueOf('c'));
            return table.columnMap();
        }

        protected Map<String, Map<Integer, Character>> makeEmptyMap() {
            return this.makeTable().columnMap();
        }
    }

    public static class UnmodifiableTreeRowMapTests
    extends RowMapTests {
        public UnmodifiableTreeRowMapTests() {
            super(false, false, false, false);
        }

        RowSortedTable<String, Integer, Character> makeTable() {
            TreeBasedTable original = TreeBasedTable.create();
            return Tables.unmodifiableRowSortedTable((RowSortedTable)original);
        }

        protected SortedMap<String, Map<Integer, Character>> makePopulatedMap() {
            TreeBasedTable table = TreeBasedTable.create();
            table.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
            table.put((Object)"bar", (Object)1, (Object)Character.valueOf('b'));
            table.put((Object)"foo", (Object)3, (Object)Character.valueOf('c'));
            return Tables.unmodifiableRowSortedTable((RowSortedTable)table).rowMap();
        }
    }

    public static class UnmodifiableHashRowMapTests
    extends RowMapTests {
        public UnmodifiableHashRowMapTests() {
            super(false, false, false, false);
        }

        @Override
        Table<String, Integer, Character> makeTable() {
            HashBasedTable original = HashBasedTable.create();
            return Tables.unmodifiableTable((Table)original);
        }

        @Override
        protected Map<String, Map<Integer, Character>> makePopulatedMap() {
            HashBasedTable table = HashBasedTable.create();
            table.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
            table.put((Object)"bar", (Object)1, (Object)Character.valueOf('b'));
            table.put((Object)"foo", (Object)3, (Object)Character.valueOf('c'));
            return Tables.unmodifiableTable((Table)table).rowMap();
        }
    }

    public static class TransformValueRowMapTests
    extends RowMapTests {
        public TransformValueRowMapTests() {
            super(false, true, true, true);
        }

        @Override
        Table<String, Integer, Character> makeTable() {
            HashBasedTable original = HashBasedTable.create();
            return Tables.transformValues((Table)original, (Function)FIRST_CHARACTER);
        }

        @Override
        protected Map<String, Map<Integer, Character>> makePopulatedMap() {
            HashBasedTable table = HashBasedTable.create();
            table.put((Object)"foo", (Object)1, (Object)"apple");
            table.put((Object)"bar", (Object)1, (Object)"banana");
            table.put((Object)"foo", (Object)3, (Object)"cat");
            return Tables.transformValues((Table)table, (Function)FIRST_CHARACTER).rowMap();
        }
    }

    public static class TreeRowMapSubMapTests
    extends RowMapTests {
        public TreeRowMapSubMapTests() {
            super(false, true, true, true);
        }

        TreeBasedTable<String, Integer, Character> makeTable() {
            TreeBasedTable table = TreeBasedTable.create();
            table.put((Object)"a", (Object)1, (Object)Character.valueOf('a'));
            table.put((Object)"z", (Object)1, (Object)Character.valueOf('a'));
            return table;
        }

        @Override
        protected Map<String, Map<Integer, Character>> makePopulatedMap() {
            TreeBasedTable<String, Integer, Character> table = this.makeTable();
            this.populateTable((Table<String, Integer, Character>)table);
            return table.rowMap().subMap("b", "x");
        }

        @Override
        protected Map<String, Map<Integer, Character>> makeEmptyMap() {
            return this.makeTable().rowMap().subMap("b", "x");
        }

        @Override
        protected String getKeyNotInPopulatedMap() {
            return "z";
        }
    }

    public static class TreeRowMapTailMapTests
    extends RowMapTests {
        public TreeRowMapTailMapTests() {
            super(false, true, true, true);
        }

        TreeBasedTable<String, Integer, Character> makeTable() {
            TreeBasedTable table = TreeBasedTable.create();
            table.put((Object)"a", (Object)1, (Object)Character.valueOf('a'));
            return table;
        }

        @Override
        protected Map<String, Map<Integer, Character>> makePopulatedMap() {
            TreeBasedTable<String, Integer, Character> table = this.makeTable();
            this.populateTable((Table<String, Integer, Character>)table);
            return table.rowMap().tailMap("b");
        }

        @Override
        protected Map<String, Map<Integer, Character>> makeEmptyMap() {
            return this.makeTable().rowMap().tailMap("b");
        }

        @Override
        protected String getKeyNotInPopulatedMap() {
            return "a";
        }
    }

    public static class TreeRowMapHeadMapTests
    extends RowMapTests {
        public TreeRowMapHeadMapTests() {
            super(false, true, true, true);
        }

        TreeBasedTable<String, Integer, Character> makeTable() {
            TreeBasedTable table = TreeBasedTable.create();
            table.put((Object)"z", (Object)1, (Object)Character.valueOf('a'));
            return table;
        }

        @Override
        protected Map<String, Map<Integer, Character>> makePopulatedMap() {
            TreeBasedTable<String, Integer, Character> table = this.makeTable();
            this.populateTable((Table<String, Integer, Character>)table);
            return table.rowMap().headMap("x");
        }

        @Override
        protected Map<String, Map<Integer, Character>> makeEmptyMap() {
            return this.makeTable().rowMap().headMap("x");
        }

        @Override
        protected String getKeyNotInPopulatedMap() {
            return "z";
        }
    }

    public static class TreeRowMapTests
    extends RowMapTests {
        public TreeRowMapTests() {
            super(false, true, true, true);
        }

        @Override
        Table<String, Integer, Character> makeTable() {
            return TreeBasedTable.create();
        }
    }

    public static class HashRowMapTests
    extends RowMapTests {
        public HashRowMapTests() {
            super(false, true, true, true);
        }

        @Override
        Table<String, Integer, Character> makeTable() {
            return HashBasedTable.create();
        }
    }

    @GwtIncompatible(value="TODO(hhchan): ArrayTable")
    public static class ArrayRowMapTests
    extends RowMapTests {
        public ArrayRowMapTests() {
            super(true, false, false, false);
        }

        @Override
        Table<String, Integer, Character> makeTable() {
            return ArrayTable.create(Arrays.asList("foo", "bar", "dog"), Arrays.asList(1, 2, 3));
        }

        @Override
        protected Map<String, Map<Integer, Character>> makeEmptyMap() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class RowMapTests
    extends MapMapTests {
        RowMapTests(boolean allowsNullValues, boolean supportsRemove, boolean supportsClear, boolean supportsIteratorRemove) {
            super(allowsNullValues, supportsRemove, supportsClear, supportsIteratorRemove);
        }

        abstract Table<String, Integer, Character> makeTable();

        protected Map<String, Map<Integer, Character>> makePopulatedMap() {
            Table<String, Integer, Character> table = this.makeTable();
            this.populateTable(table);
            return table.rowMap();
        }

        void populateTable(Table<String, Integer, Character> table) {
            table.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
            table.put((Object)"bar", (Object)1, (Object)Character.valueOf('b'));
            table.put((Object)"foo", (Object)3, (Object)Character.valueOf('c'));
        }

        protected Map<String, Map<Integer, Character>> makeEmptyMap() {
            return this.makeTable().rowMap();
        }
    }

    private static abstract class MapMapTests
    extends MapInterfaceTest<String, Map<Integer, Character>> {
        MapMapTests(boolean allowsNullValues, boolean supportsRemove, boolean supportsClear, boolean supportsIteratorRemove) {
            super(false, allowsNullValues, false, supportsRemove, supportsClear, supportsIteratorRemove);
        }

        protected String getKeyNotInPopulatedMap() {
            return "cat";
        }

        protected Map<Integer, Character> getValueNotInPopulatedMap() {
            return ImmutableMap.of();
        }

        public void testRemove() {
            Map map;
            try {
                map = this.makePopulatedMap();
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            String keyToRemove = (String)map.keySet().iterator().next();
            if (this.supportsRemove) {
                int initialSize = map.size();
                map.get(keyToRemove);
                map.remove(keyToRemove);
                MapMapTests.assertFalse((boolean)map.containsKey(keyToRemove));
                MapMapTests.assertEquals((int)(initialSize - 1), (int)map.size());
            } else {
                try {
                    map.remove(keyToRemove);
                    MapMapTests.fail((String)"Expected UnsupportedOperationException.");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            this.assertInvariants(map);
        }
    }

    public static class UnmodifiableTreeColumnTests
    extends ColumnTests {
        public UnmodifiableTreeColumnTests() {
            super(false, false, false, false, false);
        }

        @Override
        Table<String, Character, Integer> makeTable() {
            TreeBasedTable table = TreeBasedTable.create();
            return Tables.unmodifiableRowSortedTable((RowSortedTable)table);
        }

        @Override
        protected Map<String, Integer> makePopulatedMap() {
            TreeBasedTable table = TreeBasedTable.create();
            table.put((Object)"one", (Object)Character.valueOf('a'), (Object)1);
            table.put((Object)"two", (Object)Character.valueOf('a'), (Object)2);
            table.put((Object)"three", (Object)Character.valueOf('a'), (Object)3);
            table.put((Object)"four", (Object)Character.valueOf('b'), (Object)4);
            return Tables.unmodifiableRowSortedTable((RowSortedTable)table).column((Object)Character.valueOf('a'));
        }
    }

    public static class UnmodifiableHashColumnTests
    extends ColumnTests {
        public UnmodifiableHashColumnTests() {
            super(false, false, false, false, false);
        }

        @Override
        Table<String, Character, Integer> makeTable() {
            HashBasedTable table = HashBasedTable.create();
            return Tables.unmodifiableTable((Table)table);
        }

        @Override
        protected Map<String, Integer> makePopulatedMap() {
            HashBasedTable table = HashBasedTable.create();
            table.put((Object)"one", (Object)Character.valueOf('a'), (Object)1);
            table.put((Object)"two", (Object)Character.valueOf('a'), (Object)2);
            table.put((Object)"three", (Object)Character.valueOf('a'), (Object)3);
            table.put((Object)"four", (Object)Character.valueOf('b'), (Object)4);
            return Tables.unmodifiableTable((Table)table).column((Object)Character.valueOf('a'));
        }
    }

    public static class TransformValueColumnTests
    extends ColumnTests {
        public TransformValueColumnTests() {
            super(false, false, true, true, false);
        }

        @Override
        Table<String, Character, Integer> makeTable() {
            HashBasedTable table = HashBasedTable.create();
            return Tables.transformValues((Table)table, (Function)DIVIDE_BY_2);
        }

        @Override
        protected Map<String, Integer> makePopulatedMap() {
            HashBasedTable table = HashBasedTable.create();
            table.put((Object)"one", (Object)Character.valueOf('a'), (Object)1);
            table.put((Object)"two", (Object)Character.valueOf('a'), (Object)2);
            table.put((Object)"three", (Object)Character.valueOf('a'), (Object)3);
            table.put((Object)"four", (Object)Character.valueOf('b'), (Object)4);
            return Tables.transformValues((Table)table, (Function)DIVIDE_BY_2).column((Object)Character.valueOf('a'));
        }
    }

    public static class TransposeColumnTests
    extends ColumnTests {
        public TransposeColumnTests() {
            super(false, true, true, true, true);
        }

        @Override
        Table<String, Character, Integer> makeTable() {
            TreeBasedTable original = TreeBasedTable.create();
            return Tables.transpose((Table)original);
        }
    }

    public static class TreeColumnTests
    extends ColumnTests {
        public TreeColumnTests() {
            super(false, true, true, true, false);
        }

        @Override
        Table<String, Character, Integer> makeTable() {
            return TreeBasedTable.create();
        }
    }

    public static class HashColumnTests
    extends ColumnTests {
        public HashColumnTests() {
            super(false, true, true, true, false);
        }

        @Override
        Table<String, Character, Integer> makeTable() {
            return HashBasedTable.create();
        }
    }

    @GwtIncompatible(value="TODO(hhchan): ArrayTable")
    public static class ArrayColumnTests
    extends ColumnTests {
        public ArrayColumnTests() {
            super(true, true, false, false, false);
        }

        @Override
        protected String getKeyNotInPopulatedMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Map<String, Integer> makeEmptyMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        Table<String, Character, Integer> makeTable() {
            return ArrayTable.create(Arrays.asList("one", "two", "three", "four"), Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')));
        }
    }

    private static abstract class ColumnTests
    extends MapTests {
        ColumnTests(boolean allowsNullValues, boolean supportsPut, boolean supportsRemove, boolean supportsClear, boolean supportsIteratorRemove) {
            super(allowsNullValues, supportsPut, supportsRemove, supportsClear, supportsIteratorRemove);
        }

        abstract Table<String, Character, Integer> makeTable();

        protected Map<String, Integer> makeEmptyMap() {
            return this.makeTable().column((Object)Character.valueOf('a'));
        }

        protected Map<String, Integer> makePopulatedMap() {
            Table<String, Character, Integer> table = this.makeTable();
            table.put((Object)"one", (Object)Character.valueOf('a'), (Object)1);
            table.put((Object)"two", (Object)Character.valueOf('a'), (Object)2);
            table.put((Object)"three", (Object)Character.valueOf('a'), (Object)3);
            table.put((Object)"four", (Object)Character.valueOf('b'), (Object)4);
            return table.column((Object)Character.valueOf('a'));
        }
    }

    public static class UnmodifiableTreeRowTests
    extends RowTests {
        public UnmodifiableTreeRowTests() {
            super(false, false, false, false, false);
        }

        @Override
        Table<Character, String, Integer> makeTable() {
            TreeBasedTable table = TreeBasedTable.create();
            return Tables.unmodifiableRowSortedTable((RowSortedTable)table);
        }

        @Override
        protected Map<String, Integer> makePopulatedMap() {
            TreeBasedTable table = TreeBasedTable.create();
            table.put((Object)Character.valueOf('a'), (Object)"one", (Object)1);
            table.put((Object)Character.valueOf('a'), (Object)"two", (Object)2);
            table.put((Object)Character.valueOf('a'), (Object)"three", (Object)3);
            table.put((Object)Character.valueOf('b'), (Object)"four", (Object)4);
            return Tables.unmodifiableRowSortedTable((RowSortedTable)table).row((Object)Character.valueOf('a'));
        }
    }

    public static class UnmodifiableHashRowTests
    extends RowTests {
        public UnmodifiableHashRowTests() {
            super(false, false, false, false, false);
        }

        @Override
        Table<Character, String, Integer> makeTable() {
            HashBasedTable table = HashBasedTable.create();
            return Tables.unmodifiableTable((Table)table);
        }

        @Override
        protected Map<String, Integer> makePopulatedMap() {
            HashBasedTable table = HashBasedTable.create();
            table.put((Object)Character.valueOf('a'), (Object)"one", (Object)1);
            table.put((Object)Character.valueOf('a'), (Object)"two", (Object)2);
            table.put((Object)Character.valueOf('a'), (Object)"three", (Object)3);
            table.put((Object)Character.valueOf('b'), (Object)"four", (Object)4);
            return Tables.unmodifiableTable((Table)table).row((Object)Character.valueOf('a'));
        }
    }

    public static class TransformValueRowTests
    extends RowTests {
        public TransformValueRowTests() {
            super(false, false, true, true, true);
        }

        @Override
        Table<Character, String, Integer> makeTable() {
            HashBasedTable table = HashBasedTable.create();
            return Tables.transformValues((Table)table, (Function)DIVIDE_BY_2);
        }

        @Override
        protected Map<String, Integer> makePopulatedMap() {
            HashBasedTable table = HashBasedTable.create();
            table.put((Object)Character.valueOf('a'), (Object)"one", (Object)2);
            table.put((Object)Character.valueOf('a'), (Object)"two", (Object)4);
            table.put((Object)Character.valueOf('a'), (Object)"three", (Object)6);
            table.put((Object)Character.valueOf('b'), (Object)"four", (Object)8);
            return Tables.transformValues((Table)table, (Function)DIVIDE_BY_2).row((Object)Character.valueOf('a'));
        }
    }

    public static class TransposeRowTests
    extends RowTests {
        public TransposeRowTests() {
            super(false, true, true, true, false);
        }

        @Override
        Table<Character, String, Integer> makeTable() {
            TreeBasedTable original = TreeBasedTable.create();
            return Tables.transpose((Table)original);
        }
    }

    public static class TreeRowTests
    extends RowTests {
        public TreeRowTests() {
            super(false, true, true, true, true);
        }

        @Override
        Table<Character, String, Integer> makeTable() {
            return TreeBasedTable.create();
        }
    }

    public static class HashRowTests
    extends RowTests {
        public HashRowTests() {
            super(false, true, true, true, true);
        }

        @Override
        Table<Character, String, Integer> makeTable() {
            return HashBasedTable.create();
        }
    }

    @GwtIncompatible(value="TODO(hhchan): ArrayTable")
    public static class ArrayRowTests
    extends RowTests {
        public ArrayRowTests() {
            super(true, true, false, false, false);
        }

        @Override
        protected String getKeyNotInPopulatedMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Map<String, Integer> makeEmptyMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Table<Character, String, Integer> makeTable() {
            return ArrayTable.create(Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')), Arrays.asList("one", "two", "three", "four"));
        }
    }

    private static abstract class RowTests
    extends MapTests {
        RowTests(boolean allowsNullValues, boolean supportsPut, boolean supportsRemove, boolean supportsClear, boolean supportsIteratorRemove) {
            super(allowsNullValues, supportsPut, supportsRemove, supportsClear, supportsIteratorRemove);
        }

        abstract Table<Character, String, Integer> makeTable();

        protected Map<String, Integer> makeEmptyMap() {
            return this.makeTable().row((Object)Character.valueOf('a'));
        }

        protected Map<String, Integer> makePopulatedMap() {
            Table<Character, String, Integer> table = this.makeTable();
            table.put((Object)Character.valueOf('a'), (Object)"one", (Object)1);
            table.put((Object)Character.valueOf('a'), (Object)"two", (Object)2);
            table.put((Object)Character.valueOf('a'), (Object)"three", (Object)3);
            table.put((Object)Character.valueOf('b'), (Object)"four", (Object)4);
            return table.row((Object)Character.valueOf('a'));
        }
    }

    private static abstract class MapTests
    extends MapInterfaceTest<String, Integer> {
        MapTests(boolean allowsNullValues, boolean supportsPut, boolean supportsRemove, boolean supportsClear, boolean supportsIteratorRemove) {
            super(false, allowsNullValues, supportsPut, supportsRemove, supportsClear, supportsIteratorRemove);
        }

        protected String getKeyNotInPopulatedMap() {
            return "four";
        }

        protected Integer getValueNotInPopulatedMap() {
            return 4;
        }
    }

    private static abstract class TestCellSetGenerator
    implements TestSetGenerator<Table.Cell<String, Integer, Character>> {
        private TestCellSetGenerator() {
        }

        public SampleElements<Table.Cell<String, Integer, Character>> samples() {
            return new SampleElements((Object)Tables.immutableCell((Object)"bar", (Object)1, (Object)Character.valueOf('a')), (Object)Tables.immutableCell((Object)"bar", (Object)2, (Object)Character.valueOf('b')), (Object)Tables.immutableCell((Object)"foo", (Object)3, (Object)Character.valueOf('c')), (Object)Tables.immutableCell((Object)"bar", (Object)1, (Object)Character.valueOf('b')), (Object)Tables.immutableCell((Object)"cat", (Object)2, (Object)Character.valueOf('b')));
        }

        public Set<Table.Cell<String, Integer, Character>> create(Object ... elements) {
            Table<String, Integer, Character> table = this.createTable();
            for (Object element : elements) {
                Table.Cell cell = (Table.Cell)element;
                table.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
            }
            return table.cellSet();
        }

        abstract Table<String, Integer, Character> createTable();

        public Table.Cell<String, Integer, Character>[] createArray(int length) {
            return new Table.Cell[length];
        }

        public List<Table.Cell<String, Integer, Character>> order(List<Table.Cell<String, Integer, Character>> insertionOrder) {
            return insertionOrder;
        }
    }
}

