/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractTableTest;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;

@GwtCompatible(emulated=true)
public class TablesTransformValuesTest
extends AbstractTableTest {
    private static final Function<String, Character> FIRST_CHARACTER = new Function<String, Character>(){

        public Character apply(String input) {
            return input == null ? null : Character.valueOf(input.charAt(0));
        }
    };

    @Override
    protected Table<String, Integer, Character> create(Object ... data) {
        HashBasedTable table = HashBasedTable.create();
        Preconditions.checkArgument((data.length % 3 == 0 ? 1 : 0) != 0);
        for (int i = 0; i < data.length; i += 3) {
            String value = data[i + 2] == null ? null : data[i + 2] + "transformed";
            table.put((Object)((String)data[i]), (Object)((Integer)data[i + 1]), (Object)value);
        }
        return Tables.transformValues((Table)table, FIRST_CHARACTER);
    }

    @Override
    @GwtIncompatible(value="NullPointerTester")
    public void testNullPointerInstance() {
    }

    @Override
    public void testPut() {
        try {
            this.table.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
            TablesTransformValuesTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.assertSize(0);
    }

    @Override
    public void testPutAllTable() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        HashBasedTable other = HashBasedTable.create();
        other.put((Object)"foo", (Object)1, (Object)Character.valueOf('d'));
        other.put((Object)"bar", (Object)2, (Object)Character.valueOf('e'));
        other.put((Object)"cat", (Object)2, (Object)Character.valueOf('f'));
        try {
            this.table.putAll((Table)other);
            TablesTransformValuesTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        TablesTransformValuesTest.assertEquals((Object)Character.valueOf('a'), (Object)this.table.get((Object)"foo", (Object)1));
        TablesTransformValuesTest.assertEquals((Object)Character.valueOf('b'), (Object)this.table.get((Object)"bar", (Object)1));
        TablesTransformValuesTest.assertEquals((Object)Character.valueOf('c'), (Object)this.table.get((Object)"foo", (Object)3));
        this.assertSize(3);
    }

    @Override
    public void testPutNull() {
    }

    @Override
    public void testPutNullReplace() {
    }

    @Override
    public void testRowClearAndPut() {
    }
}

