/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractTableTest;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;

@GwtCompatible
public class TransposedTableTest
extends AbstractTableTest {
    @Override
    protected Table<String, Integer, Character> create(Object ... data) {
        HashBasedTable original = HashBasedTable.create();
        Table table = Tables.transpose((Table)original);
        table.clear();
        this.populate((Table<String, Integer, Character>)table, data);
        return table;
    }

    public void testTransposeTransposed() {
        HashBasedTable original = HashBasedTable.create();
        TransposedTableTest.assertSame((Object)original, (Object)Tables.transpose((Table)Tables.transpose((Table)original)));
    }

    public void testPutOriginalModifiesTranspose() {
        HashBasedTable original = HashBasedTable.create();
        Table transpose = Tables.transpose((Table)original);
        original.put((Object)1, (Object)"foo", (Object)Character.valueOf('a'));
        TransposedTableTest.assertEquals((Object)Character.valueOf('a'), (Object)transpose.get((Object)"foo", (Object)1));
    }

    public void testPutTransposeModifiesOriginal() {
        HashBasedTable original = HashBasedTable.create();
        Table transpose = Tables.transpose((Table)original);
        transpose.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        TransposedTableTest.assertEquals((Object)Character.valueOf('a'), (Object)original.get((Object)1, (Object)"foo"));
    }

    public void testTransposedViews() {
        HashBasedTable original = HashBasedTable.create();
        Table transpose = Tables.transpose((Table)original);
        original.put((Object)1, (Object)"foo", (Object)Character.valueOf('a'));
        TransposedTableTest.assertSame((Object)original.columnKeySet(), (Object)transpose.rowKeySet());
        TransposedTableTest.assertSame((Object)original.rowKeySet(), (Object)transpose.columnKeySet());
        TransposedTableTest.assertSame((Object)original.columnMap(), (Object)transpose.rowMap());
        TransposedTableTest.assertSame((Object)original.rowMap(), (Object)transpose.columnMap());
        TransposedTableTest.assertSame((Object)original.values(), (Object)transpose.values());
        TransposedTableTest.assertEquals((Object)original.row((Object)1), (Object)transpose.column((Object)1));
        TransposedTableTest.assertEquals((Object)original.row((Object)2), (Object)transpose.column((Object)2));
        TransposedTableTest.assertEquals((Object)original.column((Object)"foo"), (Object)transpose.row((Object)"foo"));
        TransposedTableTest.assertEquals((Object)original.column((Object)"bar"), (Object)transpose.row((Object)"bar"));
    }
}

