/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.eventbus.EventSubscriber;
import com.google.common.testing.EqualsTester;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;

public class EventSubscriberTest
extends TestCase {
    private static final Object FIXTURE_ARGUMENT = new Object();
    private boolean methodCalled;
    private Object methodArgument;

    protected void setUp() throws Exception {
        super.setUp();
        this.methodCalled = false;
        this.methodArgument = null;
    }

    public void testBasicMethodCall() throws Exception {
        Method method = this.getRecordingMethod();
        EventSubscriber subscriber = new EventSubscriber((Object)this, method);
        subscriber.handleEvent(FIXTURE_ARGUMENT);
        EventSubscriberTest.assertTrue((String)"Subscriber must call provided method.", (boolean)this.methodCalled);
        EventSubscriberTest.assertTrue((String)"Subscriber argument must be *exactly* the provided object.", (this.methodArgument == FIXTURE_ARGUMENT ? 1 : 0) != 0);
    }

    public void testExceptionWrapping() {
        Method method = this.getExceptionThrowingMethod();
        EventSubscriber subscriber = new EventSubscriber((Object)this, method);
        try {
            subscriber.handleEvent(new Object());
            EventSubscriberTest.fail((String)"Subscribers whose methods throw must throw InvocationTargetException");
        }
        catch (InvocationTargetException e) {
            EventSubscriberTest.assertTrue((String)"Expected exception must be wrapped.", (boolean)(e.getCause() instanceof IntentionalException));
        }
    }

    public void testErrorPassthrough() throws InvocationTargetException {
        Method method = this.getErrorThrowingMethod();
        EventSubscriber subscriber = new EventSubscriber((Object)this, method);
        try {
            subscriber.handleEvent(new Object());
            EventSubscriberTest.fail((String)"Subscribers whose methods throw Errors must rethrow them");
        }
        catch (JudgmentError judgmentError) {
            // empty catch block
        }
    }

    public void testEquals() throws Exception {
        Method charAt = String.class.getMethod("charAt", Integer.TYPE);
        Method concat = String.class.getMethod("concat", String.class);
        new EqualsTester().addEqualityGroup(new Object[]{new EventSubscriber((Object)"foo", charAt), new EventSubscriber((Object)"foo", charAt)}).addEqualityGroup(new Object[]{new EventSubscriber((Object)"bar", charAt)}).addEqualityGroup(new Object[]{new EventSubscriber((Object)"foo", concat)}).testEquals();
    }

    private Method getRecordingMethod() {
        Method method;
        try {
            method = ((Object)((Object)this)).getClass().getMethod("recordingMethod", Object.class);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("This test needs access to reflection.");
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)"Someone changed EventSubscriberTest#recordingMethod's visibility, signature, or removed it entirely.  (Must be public.)");
        }
        return method;
    }

    private Method getExceptionThrowingMethod() {
        Method method;
        try {
            method = ((Object)((Object)this)).getClass().getMethod("exceptionThrowingMethod", Object.class);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("This test needs access to reflection.");
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)"Someone changed EventSubscriberTest#exceptionThrowingMethod's visibility, signature, or removed it entirely.  (Must be public.)");
        }
        return method;
    }

    private Method getErrorThrowingMethod() {
        Method method;
        try {
            method = ((Object)((Object)this)).getClass().getMethod("errorThrowingMethod", Object.class);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("This test needs access to reflection.");
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)"Someone changed EventSubscriberTest#errorThrowingMethod's visibility, signature, or removed it entirely.  (Must be public.)");
        }
        return method;
    }

    public void recordingMethod(Object arg) {
        EventSubscriberTest.assertFalse((boolean)this.methodCalled);
        this.methodCalled = true;
        this.methodArgument = arg;
    }

    public void exceptionThrowingMethod(Object arg) throws Exception {
        throw new IntentionalException();
    }

    public void errorThrowingMethod(Object arg) {
        throw new JudgmentError();
    }

    class JudgmentError
    extends Error {
        private static final long serialVersionUID = 634248373797713373L;

        JudgmentError() {
        }
    }

    class IntentionalException
    extends Exception {
        private static final long serialVersionUID = -2500191180248181379L;

        IntentionalException() {
        }
    }
}

