/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.common.testing.NullPointerTester;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.easymock.EasyMock;

public class HashingOutputStreamTest
extends TestCase {
    private Hasher hasher;
    private HashFunction hashFunction;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    protected void setUp() throws Exception {
        super.setUp();
        this.hasher = (Hasher)EasyMock.createMock(Hasher.class);
        this.hashFunction = (HashFunction)EasyMock.createMock(HashFunction.class);
        EasyMock.expect((Object)this.hashFunction.newHasher()).andReturn((Object)this.hasher).once();
        EasyMock.replay((Object[])new Object[]{this.hashFunction});
    }

    public void testWrite_putSingleByte() throws Exception {
        int b = 113;
        EasyMock.expect((Object)this.hasher.putByte((byte)b)).andReturn((Object)this.hasher).once();
        EasyMock.replay((Object[])new Object[]{this.hasher});
        HashingOutputStream out = new HashingOutputStream(this.hashFunction, (OutputStream)this.buffer);
        out.write(b);
        EasyMock.verify((Object[])new Object[]{this.hashFunction});
        EasyMock.verify((Object[])new Object[]{this.hasher});
    }

    public void testWrite_putByteArray() throws Exception {
        byte[] buf = new byte[]{121, 97, 109, 115};
        EasyMock.expect((Object)this.hasher.putBytes(buf, 0, buf.length)).andReturn((Object)this.hasher).once();
        EasyMock.replay((Object[])new Object[]{this.hasher});
        HashingOutputStream out = new HashingOutputStream(this.hashFunction, (OutputStream)this.buffer);
        out.write(buf);
        EasyMock.verify((Object[])new Object[]{this.hashFunction});
        EasyMock.verify((Object[])new Object[]{this.hasher});
    }

    public void testWrite_putByteArrayAtPos() throws Exception {
        byte[] buf = new byte[]{121, 97, 109, 115};
        EasyMock.expect((Object)this.hasher.putBytes(buf, 0, 3)).andReturn((Object)this.hasher).once();
        EasyMock.replay((Object[])new Object[]{this.hasher});
        HashingOutputStream out = new HashingOutputStream(this.hashFunction, (OutputStream)this.buffer);
        out.write(buf, 0, 3);
        EasyMock.verify((Object[])new Object[]{this.hashFunction});
        EasyMock.verify((Object[])new Object[]{this.hasher});
    }

    public void testHash_hashesCorrectly() throws Exception {
        byte[] buf = new byte[]{121, 97, 109, 115};
        HashCode expectedHash = Hashing.md5().hashBytes(buf);
        HashingOutputStream out = new HashingOutputStream(Hashing.md5(), (OutputStream)this.buffer);
        out.write(buf);
        HashingOutputStreamTest.assertEquals((Object)expectedHash, (Object)out.hash());
    }

    public void testChecksForNull() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)new HashingOutputStream(Hashing.md5(), (OutputStream)new ByteArrayOutputStream()));
        tester.testAllPublicStaticMethods(HashingOutputStream.class);
        tester.testAllPublicConstructors(HashingOutputStream.class);
    }
}

